/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.cache.CacheServiceFactory;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.AdminServiceImpl;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.KeepClientAlive;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroDataServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroImageServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataServiceImpl;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.views.DataViewsFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogin;
import pojos.ExperimenterData;
import pojos.GroupData;

public class DataServicesFactory {
    private static final String FS_CONFIG_FILE = "fs.config";
    private static DataServicesFactory singleton;
    private Container container;
    private static Registry registry;
    private static OMEROGateway omeroGateway;
    private OmeroDataService ds;
    private OmeroImageService is;
    private OmeroMetadataService ms;
    private AdminService admin;
    private ScheduledThreadPoolExecutor executor;
    private Properties fsConfig;

    public static DataServicesFactory getInstance(Container c) throws DSOutOfServiceException {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            singleton = new DataServicesFactory(c);
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadConfig(String file) {
        Properties config = new Properties();
        InputStream fis = null;
        try {
            fis = IOUtil.readConfigFile(file);
            config.load(fis);
        }
        catch (Exception e) {
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {}
        }
        return config;
    }

    private DataServicesFactory(Container c) throws DSOutOfServiceException {
        registry = c.getRegistry();
        this.container = c;
        OMEROInfo omeroInfo = (OMEROInfo)registry.lookup("/services/OMERODS");
        omeroGateway = new OMEROGateway(omeroInfo.getPortSSL(), this);
        this.ds = new OmeroDataServiceImpl(omeroGateway, registry);
        this.is = new OmeroImageServiceImpl(omeroGateway, registry);
        this.ms = new OmeroMetadataServiceImpl(omeroGateway, registry);
        this.admin = new AdminServiceImpl(omeroGateway, registry);
        this.fsConfig = DataServicesFactory.loadConfig(c.resolveFilePath(FS_CONFIG_FILE, "config"));
        DataViewsFactory.initialize(c);
        if (omeroGateway.isUpgradeRequired()) {
            // empty if block
        }
    }

    private float determineCompression(int connectionSpeed) {
        switch (connectionSpeed) {
            case 0: 
            case 1: {
                Float value = (Float)registry.lookup("/services/RE/compressionMedium");
                return value.floatValue();
            }
        }
        Float value = (Float)registry.lookup("/services/RE/compressionLow");
        return value.floatValue();
    }

    private int isFastConnection(int connectionSpeed) {
        switch (connectionSpeed) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    private boolean checkClientServerCompatibility(String server, String client) {
        return true;
    }

    private void notifyIncompatibility(String clientVersion, String hostname) {
        UserNotifier un = registry.getUserNotifier();
        String message = "The client version (" + clientVersion + ") is not " + "compatible with the following server:\n" + hostname + ".\nThe application will exit. ";
        un.notifyInfo("Client Server not compatible", message);
        this.exitApplication();
    }

    void sessionExpiredExit(int index) {
        UserNotifier un = registry.getUserNotifier();
        switch (index) {
            case 0: {
                String message = "The connection has been lost. \nDo you want to reconnect? If no, the application will exit.";
                MessageBox box = new MessageBox(registry.getTaskBar().getFrame(), "Lost Connection", message);
                int v = box.centerMsgBox();
                if (v == 0) {
                    this.exitApplication();
                    break;
                }
                if (v != 1) break;
                UserCredentials uc = (UserCredentials)registry.lookup("/user/credentials");
                boolean b = omeroGateway.reconnect(uc.getUserName(), uc.getPassword());
                if (b) {
                    message = "You are reconnected to the server.";
                    un.notifyInfo("Reconnection Success", message);
                    break;
                }
                message = "A failure occurred while attempting to reconnect.\nThe application will exit.";
                un.notifyInfo("Reconnection Failure", message);
                this.exitApplication();
                break;
            }
            case 1: {
                String message = "The server is no longer running. \nPlease contact your system administrator.\nThe application will exit.";
                un.notifyInfo("Connection Refused", message);
                this.exitApplication();
            }
        }
    }

    public OmeroDataService getOS() {
        return this.ds;
    }

    public OmeroImageService getIS() {
        return this.is;
    }

    public OmeroMetadataService getMS() {
        return this.ms;
    }

    public AdminService getAdmin() {
        return this.admin;
    }

    public LoginService getLoginService() {
        return (LoginService)registry.lookup("/services/Login");
    }

    public void connect(UserCredentials uc) throws DSOutOfServiceException {
        HashSet<GroupData> available;
        String version;
        if (uc == null) {
            throw new NullPointerException("No user credentials.");
        }
        omeroGateway.setPort(uc.getPort());
        ExperimenterData exp = omeroGateway.login(uc.getUserName(), uc.getPassword(), uc.getHostName(), this.determineCompression(uc.getSpeedLevel()), uc.getGroup(), uc.isEncrypted());
        Object v = this.container.getRegistry().lookup("Version");
        String clientVersion = "";
        if (v != null && v instanceof String) {
            clientVersion = (String)v;
        }
        if ((version = omeroGateway.getServerVersion()) == null) {
            this.notifyIncompatibility(clientVersion, uc.getHostName());
            return;
        }
        if (!this.checkClientServerCompatibility(version, clientVersion)) {
            this.notifyIncompatibility(clientVersion, uc.getHostName());
            return;
        }
        KeepClientAlive kca = new KeepClientAlive(this.container, omeroGateway);
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.scheduleWithFixedDelay(kca, 60L, 60L, TimeUnit.SECONDS);
        String ldap = omeroGateway.lookupLdapAuthExperimenter(exp.getId());
        registry.bind("/user/authentication", ldap);
        registry.bind("/current_user/details", exp);
        registry.bind("/connection/speed", this.isFastConnection(uc.getSpeedLevel()));
        ArrayList<ExperimenterData> exps = new ArrayList<ExperimenterData>();
        try {
            Set<GroupData> groups = omeroGateway.getAvailableGroups(exp);
            Iterator<Object> i = groups.iterator();
            available = new HashSet<GroupData>();
            while (i.hasNext()) {
                GroupData g = i.next();
                if (!omeroGateway.isSystemGroup(g.asGroup())) {
                    available.add(g);
                    continue;
                }
                if (!"system".equals(g.getName())) continue;
                available.add(g);
                uc.setAdministrator(true);
            }
            registry.bind("/userGroup/details", available);
            ArrayList<Long> ids = new ArrayList<Long>();
            for (GroupData g : available) {
                Set set = g.getExperimenters();
                for (ExperimenterData e : set) {
                    if (ids.contains(e.getId())) continue;
                    ids.add(e.getId());
                    exps.add(e);
                }
            }
            registry.bind("/users/details", exps);
            registry.bind("/users/administrator", uc.isAdministrator());
        }
        catch (DSAccessException e) {
            throw new DSOutOfServiceException("Cannot retrieve groups", e);
        }
        List agents = (List)registry.lookup("/agents");
        Iterator i = agents.iterator();
        Boolean b = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        while (i.hasNext()) {
            AgentInfo agentInfo = (AgentInfo)i.next();
            if (!agentInfo.isActive()) continue;
            Registry reg = agentInfo.getRegistry();
            reg.bind("/user/authentication", ldap);
            reg.bind("/current_user/details", exp);
            reg.bind("/userGroup/details", available);
            reg.bind("/users/details", exps);
            reg.bind("/users/administrator", uc.isAdministrator());
            reg.bind("/connection/speed", this.isFastConnection(uc.getSpeedLevel()));
            reg.bind("/services/SERVER/BinaryAvailable", b);
        }
    }

    public boolean isConnected() {
        return omeroGateway.isConnected();
    }

    public void shutdown() {
        Set groups = (Set)registry.lookup("/userGroup/details");
        if (groups != null && groups.size() > 0) {
            ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
            GroupData group = exp.getDefaultGroup();
            Iterator i = groups.iterator();
            LinkedHashMap<Long, String> names = new LinkedHashMap<Long, String>();
            while (i.hasNext()) {
                GroupData g = (GroupData)i.next();
                if (g.getId() == group.getId() || omeroGateway.isSystemGroup(g.asGroup())) continue;
                names.put(g.getId(), g.getName());
            }
            if (!omeroGateway.isSystemGroup(group.asGroup())) {
                names.put(group.getId(), group.getName());
            }
            if (names.size() == 0) {
                names = null;
            }
            ScreenLogin.registerGroup(names);
        } else {
            ScreenLogin.registerGroup(null);
        }
        CacheServiceFactory.shutdown(this.container);
        ((OmeroImageServiceImpl)this.is).shutDown();
        omeroGateway.logout();
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    public void exitApplication() {
        this.shutdown();
        this.container.exit();
    }
}

