/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import omero.grid.FileSet;
import omero.grid.RepositoryListConfig;
import omero.grid.RepositoryPrx;
import omero.model.Image;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.rtypes;
import org.openmicroscopy.shoola.env.data.FSAccessException;
import pojos.DataObject;
import pojos.FileData;
import pojos.ImageData;
import pojos.MultiImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSFileSystemView {
    private static final String NO_NAME = "NO_NAME_SET";
    private Map<FileData, RepositoryPrx> repositories;
    private long userID;
    private RepositoryListConfig config;

    private Map.Entry getRepository(DataObject file) {
        block4: {
            block3: {
                if (!(file instanceof ImageData)) break block3;
                ImageData img = (ImageData)file;
                String refPath = img.getPathToFile();
                if (img.getIndex() >= 0) {
                    refPath = img.getParentFilePath();
                }
                for (Map.Entry<FileData, RepositoryPrx> entry : this.repositories.entrySet()) {
                    FileData data = entry.getKey();
                    String path = data.getAbsolutePath();
                    if (!refPath.startsWith(path)) continue;
                    return entry;
                }
                break block4;
            }
            if (!(file instanceof FileData)) break block4;
            FileData f = (FileData)file;
            String refPath = f.getAbsolutePath();
            for (Map.Entry<FileData, RepositoryPrx> entry : this.repositories.entrySet()) {
                FileData data = entry.getKey();
                String path = data.getAbsolutePath();
                if (!refPath.startsWith(path)) continue;
                return entry;
            }
        }
        return null;
    }

    private void populate(FileData root, Vector<DataObject> files, List<FileSet> elements) {
        if (elements == null) {
            return;
        }
        Iterator<FileSet> i = elements.iterator();
        int count = 0;
        OriginalFile file = null;
        while (i.hasNext()) {
            ImageData image;
            FileData data;
            FileSet fs = i.next();
            boolean dir = fs.dir;
            file = fs.parentFile;
            String name = fs.fileName;
            count = fs.imageCount;
            if (count == 0) {
                if (file == null) {
                    OriginalFileI of = new OriginalFileI();
                    of.setName(rtypes.rstring((String)name));
                    file = of;
                }
                data = new FileData(file, dir);
                data.setRepositoryPath(root.getAbsolutePath());
                files.addElement((DataObject)data);
                continue;
            }
            List images = fs.imageList;
            count = images.size();
            if (count == 1) {
                image = new ImageData((Image)images.get(0));
                data = new FileData(file);
                data.setRepositoryPath(root.getAbsolutePath());
                if (image.getId() < 0L) {
                    image.setName(data.getName());
                }
                image.setPathToFile(data.getAbsolutePath());
                image.setReference(file);
                files.addElement((DataObject)image);
                continue;
            }
            if (count <= 1) continue;
            MultiImageData multiImg = new MultiImageData(file);
            multiImg.setRepositoryPath(root.getAbsolutePath());
            String parentName = multiImg.getName();
            Iterator j = images.iterator();
            ArrayList<ImageData> components = new ArrayList<ImageData>();
            int index = 0;
            while (j.hasNext()) {
                image = new ImageData((Image)j.next());
                image.setParentFilePath(multiImg.getAbsolutePath(), index);
                name = image.getName();
                if (name == null || name.length() == 0 || name.equals(NO_NAME)) {
                    image.setName(parentName + "_" + index);
                }
                components.add(image);
                ++index;
            }
            multiImg.setComponents(components);
            files.addElement((DataObject)multiImg);
        }
    }

    private void sortImageByIndex(List<ImageData> images) {
        if (images == null || images.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                int i1 = ((ImageData)o1).getIndex();
                int i2 = ((ImageData)o2).getIndex();
                int v = 0;
                if (i1 < i2) {
                    v = -1;
                } else if (i1 > i2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(images, c);
    }

    FSFileSystemView(long userID, Map<FileData, RepositoryPrx> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException("No repositories specified.");
        }
        this.userID = userID;
        this.repositories = repositories;
        this.config = new RepositoryListConfig(1, true, true, false, true, false);
    }

    public long getUserID() {
        return this.userID;
    }

    public boolean isRoot(FileData f) {
        if (f == null) {
            return false;
        }
        for (Map.Entry<FileData, RepositoryPrx> entry : this.repositories.entrySet()) {
            FileData data = entry.getKey();
            String path = data.getAbsolutePath();
            if (!path.equals(f.getAbsolutePath()) || data.getId() != f.getId()) continue;
            return true;
        }
        return false;
    }

    public FileData[] getRoots() {
        FileData[] files = new FileData[this.repositories.size()];
        Iterator<Map.Entry<FileData, RepositoryPrx>> i = this.repositories.entrySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            Map.Entry<FileData, RepositoryPrx> entry = i.next();
            files[index] = entry.getKey();
            ++index;
        }
        return files;
    }

    public DataObject register(DataObject file) throws FSAccessException {
        if (file == null) {
            return null;
        }
        if (!(file instanceof FileData) && !(file instanceof ImageData)) {
            return null;
        }
        if (file.getId() > 0L) {
            return file;
        }
        Map.Entry entry = this.getRepository(file);
        if (entry == null) {
            return null;
        }
        RepositoryPrx proxy = (RepositoryPrx)entry.getValue();
        if (file instanceof ImageData) {
            ImageData img = (ImageData)file;
            try {
                ArrayList<Image> images = new ArrayList<Image>();
                images.add(img.asImage());
                List objects = proxy.registerFileSet(img.getReference(), images);
                if (objects != null && objects.size() > 1) {
                    img.setRegisteredFile((Image)objects.get(1));
                }
                return img;
            }
            catch (Exception e) {
                new FSAccessException("Cannot register the image: " + img.getName(), e);
            }
        } else if (file instanceof MultiImageData) {
            MultiImageData mi = (MultiImageData)file;
            OriginalFile of = (OriginalFile)mi.asIObject();
            List files = mi.getComponents();
            this.sortImageByIndex(files);
            ArrayList<Image> images = new ArrayList<Image>();
            Iterator i = files.iterator();
            while (i.hasNext()) {
                images.add(((ImageData)i.next()).asImage());
            }
            try {
                int index = 0;
                List objects = proxy.registerFileSet(of, images);
                mi.setRegisteredFile((OriginalFile)objects.get(index));
                i = files.iterator();
                ++index;
                while (i.hasNext()) {
                    ImageData data = (ImageData)i.next();
                    data.setRegisteredFile((Image)objects.get(index));
                    ++index;
                }
                return mi;
            }
            catch (Exception e) {
                new FSAccessException("Cannot register the multi-images file: " + mi.getName(), e);
            }
        } else if (file instanceof FileData) {
            FileData f = (FileData)file;
            OriginalFile of = (OriginalFile)file.asIObject();
            try {
                OriginalFile r = proxy.registerOriginalFile(of);
                f.setRegisteredFile(r);
                return f;
            }
            catch (Exception e) {
                new FSAccessException("Cannot register the file: " + f.getAbsolutePath(), e);
            }
        }
        return null;
    }

    public String getThumbnail(DataObject object) throws FSAccessException {
        if (object == null) {
            return null;
        }
        if (object instanceof ImageData) {
            Map.Entry entry;
            ImageData img = (ImageData)object;
            String name = img.getPathToFile();
            int index = img.getIndex();
            if (index >= 0) {
                name = img.getParentFilePath();
            }
            if ((entry = this.getRepository(object)) == null) {
                return null;
            }
            RepositoryPrx proxy = (RepositoryPrx)entry.getValue();
            try {
                if (index >= 0) {
                    return proxy.getThumbnailByIndex(name, index);
                }
                return proxy.getThumbnail(name);
            }
            catch (Exception e) {
                new FSAccessException("Cannot retrieve the thumbnail for: " + name, e);
            }
        }
        return null;
    }

    public DataObject[] getFiles(FileData dir, boolean useFileHiding) throws FSAccessException {
        if (dir == null) {
            return null;
        }
        if (!dir.isDirectory()) {
            return null;
        }
        Map.Entry entry = this.getRepository((DataObject)dir);
        if (entry == null) {
            return null;
        }
        Vector<DataObject> files = new Vector<DataObject>();
        try {
            String s = dir.getAbsolutePath();
            FileData root = (FileData)entry.getKey();
            RepositoryPrx proxy = (RepositoryPrx)entry.getValue();
            this.populate(root, files, proxy.listFileSets(s, this.config));
        }
        catch (Exception e) {
            new FSAccessException("Cannot retrieves the files contained in: " + dir.getAbsolutePath(), e);
        }
        return files.toArray(new DataObject[files.size()]);
    }

    public boolean isHiddenFile(FileData f) {
        return f.isHidden();
    }
}

