/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import loci.formats.FormatException;
import ome.conditions.ResourceError;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.system.UpgradeCheck;
import omero.ApiUsageException;
import omero.AuthenticationException;
import omero.InternalException;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RType;
import omero.SecurityViolation;
import omero.ServerError;
import omero.SessionException;
import omero.api.ExporterPrx;
import omero.api.IAdminPrx;
import omero.api.IContainerPrx;
import omero.api.IDeletePrx;
import omero.api.IMetadataPrx;
import omero.api.IPixelsPrx;
import omero.api.IProjectionPrx;
import omero.api.IQueryPrx;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRepositoryInfoPrx;
import omero.api.IRoiPrx;
import omero.api.IScriptPrx;
import omero.api.ISessionPrx;
import omero.api.ITimelinePrx;
import omero.api.IUpdatePrx;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.RoiOptions;
import omero.api.RoiResult;
import omero.api.SearchPrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceInterfacePrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.ThumbnailStorePrx;
import omero.api.delete.DeleteCommand;
import omero.api.delete.DeleteHandlePrx;
import omero.client;
import omero.constants.projection.ProjectionType;
import omero.grid.BoolColumn;
import omero.grid.Column;
import omero.grid.Data;
import omero.grid.DoubleColumn;
import omero.grid.ImageColumn;
import omero.grid.LongColumn;
import omero.grid.RepositoryMap;
import omero.grid.RepositoryPrx;
import omero.grid.RoiColumn;
import omero.grid.ScriptProcessPrx;
import omero.grid.SharedResourcesPrx;
import omero.grid.StringColumn;
import omero.grid.TablePrx;
import omero.grid.WellColumn;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLink;
import omero.model.Arc;
import omero.model.BooleanAnnotation;
import omero.model.BooleanAnnotationI;
import omero.model.CommentAnnotation;
import omero.model.CommentAnnotationI;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.DetailsI;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.ExperimenterGroupI;
import omero.model.Filament;
import omero.model.FileAnnotation;
import omero.model.FileAnnotationI;
import omero.model.GroupExperimenterMap;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.Instrument;
import omero.model.Laser;
import omero.model.LightEmittingDiode;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.LongAnnotation;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.Permissions;
import omero.model.Pixels;
import omero.model.PixelsI;
import omero.model.PixelsType;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.PlateAcquisitionI;
import omero.model.PlateI;
import omero.model.Project;
import omero.model.ProjectI;
import omero.model.RenderingDef;
import omero.model.Roi;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.model.Shape;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.model.TermAnnotation;
import omero.model.TermAnnotationI;
import omero.model.TimestampAnnotation;
import omero.model.TimestampAnnotationI;
import omero.model.Well;
import omero.model.WellSample;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.DeleteCallback;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.ScriptCallback;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.model.ROIResult;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.model.TableParameters;
import org.openmicroscopy.shoola.env.data.model.TableResult;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import org.openmicroscopy.shoola.env.data.util.SearchDataContext;
import org.openmicroscopy.shoola.env.data.util.StatusLabel;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.BooleanAnnotationData;
import pojos.ChannelAcquisitionData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.GroupData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.InstrumentData;
import pojos.LongAnnotationData;
import pojos.MultiImageData;
import pojos.PixelsData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ROICoordinate;
import pojos.ROIData;
import pojos.RatingAnnotationData;
import pojos.ScreenData;
import pojos.ShapeData;
import pojos.TagAnnotationData;
import pojos.TermAnnotationData;
import pojos.TextualAnnotationData;
import pojos.TimeAnnotationData;
import pojos.WellData;
import pojos.WellSampleData;
import pojos.WorkflowData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OMEROGateway {
    static final int LOST_CONNECTION = 0;
    static final int SERVER_OUT_OF_SERVICE = 1;
    private static final String REF_IMAGE = "/Image";
    private static final String REF_DATASET = "/Dataset";
    private static final String REF_PROJECT = "/Project";
    private static final String REF_SCREEN = "/Screen";
    private static final String REF_PLATE = "/Plate";
    private static final String REF_ROI = "/Roi";
    private static final String REF_PLATE_ACQUISITION = "/PlateAcquisition";
    private static final String REF_WELL = "/Well";
    private static final String REF_ANNOTATION = "/Annotation";
    private static final String REF_TAG = "/TagAnnotation";
    private static final String REF_TERM = "/TermAnnotation";
    private static final String REF_FILE = "/FileAnnotation";
    static final String KEEP = "KEEP";
    private static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private static final String OVERLAYS = "Overlays";
    private static final int INC = 262144;
    private static final int MAX_BYTES = 1024;
    private static final int MAX_RETRIEVAL = 100;
    private static final int MAX_TABLE_ROW_RETRIEVAL = 100000;
    private static final List<Character> SUPPORTED_SPECIAL_CHAR = new ArrayList<Character>();
    private static final List<String> WILD_CARDS;
    private static final String AGENT = "OMERO.insight";
    private static final List<String> SYSTEM_GROUPS;
    private static final List<String> SCRIPTS_UI_AVAILABLE;
    private static final List<String> SCRIPTS_NOT_AVAILABLE_TO_USER;
    private int thumbRetrieval;
    private ServiceFactoryPrx entryEncrypted;
    private ServiceFactoryPrx entryUnencrypted;
    private ThumbnailStorePrx thumbnailService;
    private RawFileStorePrx fileStore;
    private RawPixelsStorePrx pixelsStore;
    private IProjectionPrx projService;
    private SearchPrx searchService;
    private IAdminPrx adminService;
    private IQueryPrx queryService;
    private IRenderingSettingsPrx rndSettingsService;
    private IRepositoryInfoPrx repInfoService;
    private IDeletePrx deleteService;
    private IPixelsPrx pixelsService;
    private IContainerPrx pojosService;
    private IUpdatePrx updateService;
    private IMetadataPrx metadataService;
    private IScriptPrx scriptService;
    private IRoiPrx roiService;
    private ExporterPrx exporterService;
    private ITimelinePrx timeService;
    private SharedResourcesPrx sharedResources;
    private boolean connected;
    private DataServicesFactory dsFactory;
    private float compression;
    private int port;
    private String hostName;
    private client secureClient;
    private client unsecureClient;
    private Map<String, List<EnumerationObject>> enumerations;
    private List<ServiceInterfacePrx> services;
    private Map<Long, StatefulServiceInterfacePrx> reServices;
    private List<String> monitorIDs;
    private OMEROMetadataStoreClient importStore;
    private List<ExperimenterGroup> systemGroups;
    private Map<Long, FSFileSystemView> fsViews;

    private void isSessionAlive() {
    }

    private ScriptCallback runScript(long scriptID, Map<String, RType> parameters) throws ProcessException {
        ScriptCallback cb = null;
        try {
            IScriptPrx svc = this.getScriptService();
            ScriptProcessPrx prx = svc.runScript(scriptID, parameters, null);
            cb = new ScriptCallback(scriptID, this.secureClient, prx);
        }
        catch (Exception e) {
            if (cb != null) {
                cb.close();
            }
            throw new ProcessException("Cannot run script with ID:" + scriptID, e);
        }
        return cb;
    }

    private List<ExperimenterGroup> getSystemGroups() throws DSOutOfServiceException, DSAccessException {
        if (this.systemGroups != null) {
            return this.systemGroups;
        }
        this.isSessionAlive();
        try {
            ArrayList<RString> names = new ArrayList<RString>();
            Iterator<String> j = SYSTEM_GROUPS.iterator();
            while (j.hasNext()) {
                names.add(rtypes.rstring((String)j.next()));
            }
            this.systemGroups = new ArrayList<ExperimenterGroup>();
            ParametersI params = new ParametersI();
            params.map.put("names", rtypes.rlist(names));
            String sql = "select g from ExperimenterGroup as g ";
            sql = sql + "where g.name in (:names)";
            List l = this.getQueryService().findAllByQuery(sql, (Parameters)params);
            for (ExperimenterGroup group : l) {
                String name = group.getName().getValue();
                if (!SYSTEM_GROUPS.contains(name)) continue;
                this.systemGroups.add(group);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the system groups.");
        }
        return this.systemGroups;
    }

    private ExperimenterGroup getSystemGroup(String name) throws DSOutOfServiceException, DSAccessException {
        this.getSystemGroups();
        Iterator<ExperimenterGroup> i = this.systemGroups.iterator();
        ExperimenterGroup g = null;
        while (i.hasNext()) {
            g = i.next();
            if (g.getName() == null || !name.equals(g.getName().getValue())) continue;
            return g;
        }
        return g;
    }

    private TableResult createOverlay(long imageID, TablePrx table) throws DSAccessException {
        if (table == null) {
            return null;
        }
        try {
            Column[] cols = table.getHeaders();
            int imageIndex = -1;
            int roiIndex = -1;
            int colorIndex = -1;
            int size = 0;
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] instanceof ImageColumn) {
                    imageIndex = i;
                    ++size;
                    continue;
                }
                if (cols[i] instanceof RoiColumn) {
                    roiIndex = i;
                    ++size;
                    continue;
                }
                if (!(cols[i] instanceof LongColumn) || !"Color".equals(cols[i].name)) continue;
                colorIndex = i;
                ++size;
            }
            if (imageIndex == -1 || roiIndex == -1) {
                return null;
            }
            String[] headers = new String[size];
            String[] headersDescriptions = new String[size];
            headers[0] = cols[imageIndex].name;
            headersDescriptions[0] = cols[imageIndex].description;
            headers[1] = cols[roiIndex].name;
            headersDescriptions[1] = cols[roiIndex].description;
            headers[1] = cols[roiIndex].name;
            headersDescriptions[1] = cols[roiIndex].description;
            int n = (int)table.getNumberOfRows();
            long[] a = new long[]{imageIndex, roiIndex, colorIndex};
            long[] b = new long[]{};
            Data d = table.slice(a, b);
            ArrayList<Integer> rows = new ArrayList<Integer>();
            Column column = d.columns[imageIndex];
            if (column instanceof ImageColumn) {
                for (int j = 0; j < n; ++j) {
                    Long value = ((ImageColumn)column).values[j];
                    if (value != imageID) continue;
                    rows.add(j);
                }
            }
            Object[][] data = new Object[rows.size()][size];
            int k = 0;
            Iterator r = rows.iterator();
            column = d.columns[roiIndex];
            Column columnColor = null;
            if (colorIndex != -1) {
                columnColor = d.columns[colorIndex];
            }
            while (r.hasNext()) {
                Integer row = (Integer)r.next();
                data[k][0] = row;
                data[k][1] = ((RoiColumn)column).values[row];
                if (columnColor != null) {
                    data[k][2] = ((LongColumn)columnColor).values[row];
                }
                ++k;
            }
            table.close();
            return new TableResult(data, headers);
        }
        catch (Exception e) {
            try {
                if (table != null) {
                    table.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            new DSAccessException("Unable to read the table.");
            return null;
        }
    }

    private void translateTableResult(Data src, Object[][] dst, int offset, int length, Map<Integer, Integer> indexes) {
        Column[] cols = src.columns;
        for (int i = 0; i < cols.length; ++i) {
            int j;
            Column column = cols[i];
            if (column instanceof LongColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((LongColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof DoubleColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((DoubleColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof StringColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((StringColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof BoolColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((BoolColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof RoiColumn) {
                indexes.put(TableResult.ROI_COLUMN_INDEX, i);
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((RoiColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof ImageColumn) {
                indexes.put(TableResult.IMAGE_COLUMN_INDEX, i);
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((ImageColumn)column).values[j];
                }
                continue;
            }
            if (!(column instanceof WellColumn)) continue;
            indexes.put(TableResult.WELL_COLUMN_INDEX, i);
            for (j = 0; j < length; ++j) {
                dst[j + offset][i] = ((WellColumn)column).values[j];
            }
        }
    }

    private TableResult createTableResult(TablePrx table, long[] rows) throws DSAccessException {
        if (table == null || rows == null) {
            return null;
        }
        try {
            Column[] cols = table.getHeaders();
            String[] headers = new String[cols.length];
            String[] headersDescriptions = new String[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                headers[i] = cols[i].name;
                headersDescriptions[i] = cols[i].description;
            }
            int totalRowCount = rows.length;
            Object[][] data = new Object[totalRowCount][cols.length];
            long[] columns = new long[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                columns[i] = i;
            }
            int rowOffset = 0;
            int rowCount = 0;
            HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
            for (int rowsToGo = totalRowCount; rowsToGo > 0; rowsToGo -= rowCount) {
                rowCount = Math.min(100000, totalRowCount - rowOffset);
                long[] rowSubset = new long[rowCount];
                System.arraycopy(rows, rowOffset, rowSubset, 0, rowCount);
                Data d = table.slice(columns, rowSubset);
                for (int i = 0; i < cols.length; ++i) {
                    this.translateTableResult(d, data, rowOffset, rowCount, indexes);
                }
                rowOffset += rowCount;
            }
            table.close();
            TableResult tr = new TableResult(data, headers);
            tr.setIndexes(indexes);
            return tr;
        }
        catch (Exception e) {
            try {
                if (table != null) {
                    table.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            new DSAccessException("Unable to read the table.");
            return null;
        }
    }

    private TableResult createTableResult(TablePrx table, String key, long id) throws DSAccessException {
        if (table == null) {
            return null;
        }
        try {
            key = "(" + key + "==%d)";
            long totalRowCount = table.getNumberOfRows();
            long[] rows = table.getWhereList(String.format(key, id), null, 0L, totalRowCount, 1L);
            return this.createTableResult(table, rows);
        }
        catch (Exception e) {
            try {
                if (table != null) {
                    table.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new DSAccessException("Unable to read the table.");
        }
    }

    private void handleException(Throwable t, String message) throws DSOutOfServiceException, DSAccessException {
        Throwable cause = t.getCause();
        if (cause instanceof SecurityViolation) {
            String s = "For security reasons, cannot access data. \n";
            throw new DSAccessException(s + message, t);
        }
        if (cause instanceof SessionException) {
            String s = "Session is not valid. \n";
            throw new DSOutOfServiceException(s + message, t);
        }
        if (cause instanceof AuthenticationException) {
            String s = "Cannot initialize the session. \n";
            throw new DSOutOfServiceException(s + message, t);
        }
        if (cause instanceof ResourceError) {
            String s = "Fatal error. Please contact the administrator. \n";
            throw new DSOutOfServiceException(s + message, t);
        }
        if (cause instanceof ConnectionRefusedException || t instanceof ConnectionRefusedException) {
            this.connected = false;
            this.dsFactory.sessionExpiredExit(1);
            return;
        }
        if (cause instanceof ConnectionLostException || t instanceof ConnectionLostException) {
            this.connected = false;
            this.dsFactory.sessionExpiredExit(0);
            return;
        }
        throw new DSAccessException("Cannot access data. \n" + message, t);
    }

    private String getImportFailureMessage(Throwable t) {
        Throwable cause = t.getCause();
        if (cause instanceof FormatException) {
            String message = cause.getMessage();
            cause.printStackTrace();
            if (message == null) {
                return null;
            }
            if (message.contains("ome-xml.jar")) {
                return "Missing ome-xml.jar required to read OME-TIFF files";
            }
            String[] s = message.split(":");
            if (s.length > 0) {
                return s[0];
            }
        }
        return null;
    }

    private String printErrorText(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private Object handleSearchResult(String type, Collection r, SearchPrx svc) throws ServerError {
        boolean hasNext = false;
        try {
            hasNext = svc.hasNext();
        }
        catch (Exception e) {
            int size = 0;
            if (e instanceof InternalException) {
                size = -1;
            } else {
                svc.getBatchSize();
            }
            return new Integer(size);
        }
        if (!hasNext) {
            return r;
        }
        List l = svc.results();
        for (IObject object : l) {
            long id;
            if (!type.equals(object.getClass().getName()) || r.contains(id = object.getId().getValue())) continue;
            r.add(id);
        }
        return r;
    }

    private List<String> formatText(List<String> terms, String field) {
        if (terms == null || terms.size() == 0) {
            return null;
        }
        if (field == null || field.length() == 0) {
            return terms;
        }
        ArrayList<String> formatted = new ArrayList<String>(terms.size());
        Iterator<String> j = terms.iterator();
        while (j.hasNext()) {
            formatted.add(field + ":" + j.next());
        }
        return formatted;
    }

    private List<String> formatText(List<String> terms, String firstField, String sep, String secondField) {
        if (terms == null || terms.size() == 0) {
            return null;
        }
        ArrayList<String> formatted = new ArrayList<String>(terms.size());
        for (String v : terms) {
            String value = firstField + ":" + v + " " + sep + " ";
            value = value + secondField + ":" + v;
            formatted.add(value);
        }
        return formatted;
    }

    private String getTableForLink(Class klass) {
        String table = null;
        if (Dataset.class.equals((Object)klass)) {
            table = "DatasetImageLink";
        } else if (DatasetI.class.equals((Object)klass)) {
            table = "DatasetImageLink";
        } else if (Project.class.equals((Object)klass)) {
            table = "ProjectDatasetLink";
        } else if (ProjectI.class.equals((Object)klass)) {
            table = "ProjectDatasetLink";
        } else if (Screen.class.equals((Object)klass)) {
            table = "ScreenPlateLink";
        } else if (ScreenI.class.equals((Object)klass)) {
            table = "ScreenPlateLink";
        } else if (PlateAcquisitionData.class.equals((Object)klass)) {
            table = "PlateAcquisitionWellSampleLink";
        } else if (PlateAcquisitionI.class.equals((Object)klass)) {
            table = "PlateAcquisitionWellSampleLink";
        } else if (TagAnnotation.class.equals((Object)klass)) {
            table = "AnnotationAnnotationLink";
        } else if (TagAnnotationI.class.equals((Object)klass)) {
            table = "AnnotationAnnotationLink";
        }
        return table;
    }

    private String getAnnotationTableLink(Class klass) {
        String table = null;
        table = Dataset.class.equals((Object)klass) || DatasetData.class.equals((Object)klass) ? "DatasetAnnotationLink" : (Project.class.equals((Object)klass) || ProjectData.class.equals((Object)klass) ? "ProjectAnnotationLink" : (Image.class.equals((Object)klass) || ImageData.class.equals((Object)klass) ? "ImageAnnotationLink" : (Screen.class.equals((Object)klass) || ScreenData.class.equals((Object)klass) ? "ScreenAnnotationLink" : (Plate.class.equals((Object)klass) || PlateData.class.equals((Object)klass) ? "ScreenAnnotationLink" : (WellSample.class.equals((Object)klass) || WellSampleData.class.equals((Object)klass) ? "ScreenAnnotationLink" : "AnnotationAnnotationLink")))));
        return table;
    }

    private String getTableForAnnotationLink(String klass) {
        String table = null;
        if (klass == null) {
            return table;
        }
        if (klass.equals(Dataset.class.getName())) {
            table = "DatasetAnnotationLink";
        } else if (klass.equals(Project.class.getName())) {
            table = "ProjectAnnotationLink";
        } else if (klass.equals(Image.class.getName())) {
            table = "ImageAnnotationLink";
        } else if (klass.equals(Pixels.class.getName())) {
            table = "PixelAnnotationLink";
        } else if (klass.equals(Annotation.class.getName())) {
            table = "AnnotationAnnotationLink";
        } else if (klass.equals(DatasetData.class.getName())) {
            table = "DatasetAnnotationLink";
        } else if (klass.equals(ProjectData.class.getName())) {
            table = "ProjectAnnotationLink";
        } else if (klass.equals(ImageData.class.getName())) {
            table = "ImageAnnotationLink";
        } else if (klass.equals(PixelsData.class.getName())) {
            table = "PixelAnnotationLink";
        } else if (klass.equals(Screen.class.getName())) {
            table = "ScreenAnnotationLink";
        } else if (klass.equals(Plate.class.getName())) {
            table = "PlateAnnotationLink";
        } else if (klass.equals(ScreenData.class.getName())) {
            table = "ScreenAnnotationLink";
        } else if (klass.equals(PlateData.class.getName())) {
            table = "PlateAnnotationLink";
        } else if (klass.equals(DatasetI.class.getName())) {
            table = "DatasetAnnotationLink";
        } else if (klass.equals(ProjectI.class.getName())) {
            table = "ProjectAnnotationLink";
        } else if (klass.equals(ImageI.class.getName())) {
            table = "ImageAnnotationLink";
        } else if (klass.equals(PixelsI.class.getName())) {
            table = "PixelAnnotationLink";
        } else if (klass.equals(ScreenI.class.getName())) {
            table = "ScreenAnnotationLink";
        } else if (klass.equals(PlateI.class.getName())) {
            table = "PlateAnnotationLink";
        } else if (klass.equals(ScreenData.class.getName())) {
            table = "ScreenAnnotationLink";
        } else if (klass.equals(PlateData.class.getName())) {
            table = "PlateAnnotationLink";
        } else if (klass.equals(TagAnnotationData.class.getName())) {
            table = "AnnotationAnnotationLink";
        }
        return table;
    }

    private String getTableForClass(Class klass) {
        if (DatasetData.class.equals((Object)klass)) {
            return "Dataset";
        }
        if (ProjectData.class.equals((Object)klass)) {
            return "Project";
        }
        if (ImageData.class.equals((Object)klass)) {
            return "Image";
        }
        if (ScreenData.class.equals((Object)klass)) {
            return "Screen";
        }
        if (PlateData.class.equals((Object)klass)) {
            return "Plate";
        }
        return null;
    }

    private String convertProperty(Class nodeType, String property) {
        if (nodeType.equals(DatasetData.class)) {
            if (property.equals("images")) {
                return "ome.model.containers.Dataset_imageLinks";
            }
        } else {
            throw new IllegalArgumentException("NodeType or property not supported");
        }
        return null;
    }

    private List loadLinks(String table, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            if (table == null) {
                return new ArrayList();
            }
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)childID));
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link ");
            sb.append("left outer join fetch link.child as child ");
            sb.append("left outer join fetch link.parent parent ");
            if (childID >= 0L) {
                sb.append("where link.child.id = :id");
                param.addId(childID);
                if (userID >= 0L) {
                    sb.append(" and link.details.owner.id = :userID");
                    param.map.put("userID", rtypes.rlong((long)userID));
                }
            } else if (userID >= 0L) {
                sb.append("where link.details.owner.id = :userID");
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return this.getQueryService().findAllByQuery(sb.toString(), (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for child ID: " + childID);
            return new ArrayList();
        }
    }

    private ISessionPrx getSessionService() throws DSAccessException, DSOutOfServiceException {
        try {
            return this.entryEncrypted.getSessionService();
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Session service.");
            return null;
        }
    }

    private SharedResourcesPrx getSharedResources() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.sharedResources == null) {
                this.sharedResources = this.entryEncrypted.sharedResources();
            }
            return this.sharedResources;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot access the Shared Resources.");
            return null;
        }
    }

    private IRenderingSettingsPrx getRenderingSettingsService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.rndSettingsService == null) {
                this.rndSettingsService = this.entryEncrypted.getRenderingSettingsService();
                this.services.add((ServiceInterfacePrx)this.rndSettingsService);
            }
            return this.rndSettingsService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RenderingSettings service.");
            return null;
        }
    }

    private OMEROMetadataStoreClient getImportStore() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.importStore == null) {
                this.importStore = new OMEROMetadataStoreClient();
                this.importStore.initialize(this.entryEncrypted);
            }
            return this.importStore;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Import service.");
            return null;
        }
    }

    private IRepositoryInfoPrx getRepositoryService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.repInfoService == null) {
                this.repInfoService = this.entryEncrypted.getRepositoryInfoService();
                this.services.add((ServiceInterfacePrx)this.repInfoService);
            }
            return this.repInfoService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RepositoryInfo service.");
            return null;
        }
    }

    private IScriptPrx getScriptService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.scriptService == null) {
                this.scriptService = this.entryEncrypted.getScriptService();
                this.services.add((ServiceInterfacePrx)this.scriptService);
            }
            return this.scriptService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access the script service.");
            return null;
        }
    }

    private IContainerPrx getPojosService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.pojosService == null) {
                this.pojosService = this.entryEncrypted.getContainerService();
                this.services.add((ServiceInterfacePrx)this.pojosService);
            }
            return this.pojosService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access container service.");
            return null;
        }
    }

    private IQueryPrx getQueryService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.queryService == null) {
                this.queryService = this.entryEncrypted.getQueryService();
                this.services.add((ServiceInterfacePrx)this.queryService);
            }
            return this.queryService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Query service.");
            return null;
        }
    }

    private IUpdatePrx getUpdateService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.updateService == null) {
                this.updateService = this.entryEncrypted.getUpdateService();
                this.services.add((ServiceInterfacePrx)this.updateService);
            }
            return this.updateService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Update service.");
            return null;
        }
    }

    private IMetadataPrx getMetadataService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.metadataService == null) {
                this.metadataService = this.entryEncrypted.getMetadataService();
                this.services.add((ServiceInterfacePrx)this.metadataService);
            }
            return this.metadataService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Metadata service.");
            return null;
        }
    }

    private IRoiPrx getROIService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.roiService == null) {
                this.roiService = this.entryEncrypted.getRoiService();
                this.services.add((ServiceInterfacePrx)this.roiService);
            }
            return this.roiService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access ROI service.");
            return null;
        }
    }

    private IAdminPrx getAdminService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.adminService == null) {
                this.adminService = this.entryEncrypted.getAdminService();
                this.services.add((ServiceInterfacePrx)this.adminService);
            }
            return this.adminService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Admin service.");
            return null;
        }
    }

    private IDeletePrx getDeleteService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.deleteService == null) {
                this.deleteService = this.entryUnencrypted != null ? this.entryUnencrypted.getDeleteService() : this.entryEncrypted.getDeleteService();
                this.services.add((ServiceInterfacePrx)this.deleteService);
            }
            return this.deleteService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Delete service.");
            return null;
        }
    }

    private ITimelinePrx getTimeService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.timeService == null) {
                this.timeService = this.entryUnencrypted != null ? this.entryUnencrypted.getTimelineService() : this.entryEncrypted.getTimelineService();
                this.services.add((ServiceInterfacePrx)this.timeService);
            }
            return this.timeService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Time service.");
            return null;
        }
    }

    private ThumbnailStorePrx getThumbService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.thumbRetrieval == 100) {
                this.thumbRetrieval = 0;
                if (this.thumbnailService != null) {
                    this.thumbnailService.close();
                }
                this.services.remove(this.thumbnailService);
                this.thumbnailService = null;
            }
            if (this.thumbnailService == null) {
                this.thumbnailService = this.entryUnencrypted != null ? this.entryUnencrypted.createThumbnailStore() : this.entryEncrypted.createThumbnailStore();
                this.services.add((ServiceInterfacePrx)this.thumbnailService);
            }
            ++this.thumbRetrieval;
            return this.thumbnailService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Thumbnail service.");
            return null;
        }
    }

    private ExporterPrx getExporterService() throws DSAccessException, DSOutOfServiceException {
        try {
            ExporterPrx store = null;
            store = this.entryUnencrypted != null ? this.entryUnencrypted.createExporter() : this.entryEncrypted.createExporter();
            return store;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Exporter service.");
            return null;
        }
    }

    private RawFileStorePrx getRawFileService() throws DSAccessException, DSOutOfServiceException {
        try {
            this.fileStore = this.entryUnencrypted != null ? this.entryUnencrypted.createRawFileStore() : this.entryEncrypted.createRawFileStore();
            return this.fileStore;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RawFileStore service.");
            return null;
        }
    }

    private RenderingEnginePrx getRenderingService() throws DSAccessException, DSOutOfServiceException {
        try {
            RenderingEnginePrx engine = this.entryUnencrypted != null ? this.entryUnencrypted.createRenderingEngine() : this.entryEncrypted.createRenderingEngine();
            engine.setCompressionLevel(this.compression);
            return engine;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RawFileStore service.");
            return null;
        }
    }

    private RawPixelsStorePrx getPixelsStore() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.pixelsStore != null) {
                this.services.remove(this.pixelsStore);
                try {
                    this.pixelsStore.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.pixelsStore = this.entryUnencrypted != null ? this.entryUnencrypted.createRawPixelsStore() : this.entryEncrypted.createRawPixelsStore();
            this.services.add((ServiceInterfacePrx)this.pixelsStore);
            return this.pixelsStore;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RawPixelsStore service.");
            return null;
        }
    }

    private IPixelsPrx getPixelsService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.pixelsService == null) {
                this.pixelsService = this.entryUnencrypted != null ? this.entryUnencrypted.getPixelsService() : this.entryEncrypted.getPixelsService();
                this.services.add((ServiceInterfacePrx)this.pixelsService);
            }
            return this.pixelsService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Pixels service.");
            return null;
        }
    }

    private SearchPrx getSearchService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.entryUnencrypted != null) {
                return this.entryUnencrypted.createSearchService();
            }
            return this.entryEncrypted.createSearchService();
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Search service.");
            return this.searchService;
        }
    }

    private IProjectionPrx getProjectionService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.projService == null) {
                this.projService = this.entryUnencrypted != null ? this.entryEncrypted.getProjectionService() : this.entryUnencrypted.getProjectionService();
                this.services.add((ServiceInterfacePrx)this.projService);
            }
            return this.projService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Pixels service.");
            return null;
        }
    }

    private synchronized void needDefault(long pixelsID, RenderingEnginePrx re) throws DSAccessException, DSOutOfServiceException {
        try {
            if (re == null) {
                ThumbnailStorePrx service = this.getThumbService();
                if (!service.setPixelsId(pixelsID)) {
                    service.resetDefaults();
                    service.setPixelsId(pixelsID);
                }
            } else if (!re.lookupRenderingDef(pixelsID)) {
                re.resetDefaults();
                re.lookupRenderingDef(pixelsID);
            }
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot set RE defaults.");
        }
    }

    private List<String> prepareTextSearch(String[] terms, SearchPrx service) throws DSAccessException, DSOutOfServiceException {
        if (terms == null || terms.length == 0) {
            return null;
        }
        ArrayList<String> formattedTerms = new ArrayList<String>(terms.length);
        try {
            for (int j = 0; j < terms.length; ++j) {
                String value = terms[j];
                if (this.startWithWildCard(value)) {
                    service.setAllowLeadingWildcard(true);
                }
                int n = value.length();
                char[] arr = new char[n];
                String v = "";
                value.getChars(0, n, arr, 0);
                for (int i = 0; i < arr.length; ++i) {
                    v = SUPPORTED_SPECIAL_CHAR.contains(Character.valueOf(arr[i])) ? v + "\\" + arr[i] : v + arr[i];
                }
                String formatted = value.contains(" ") ? "\"" + v.toLowerCase() + "\"" : v.toLowerCase();
                formattedTerms.add(formatted);
            }
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot format text for search.");
        }
        return formattedTerms;
    }

    private List<String> prepareTextSearch(Collection<String> terms, SearchPrx service) throws DSAccessException, DSOutOfServiceException {
        if (terms == null || terms.size() == 0) {
            return null;
        }
        if (terms == null || terms.size() == 0) {
            return null;
        }
        String[] values = new String[terms.size()];
        Iterator<String> i = terms.iterator();
        int index = 0;
        while (i.hasNext()) {
            values[index] = i.next();
            ++index;
        }
        return this.prepareTextSearch(values, service);
    }

    private boolean startWithWildCard(String value) {
        if (value == null) {
            return false;
        }
        Iterator<String> i = WILD_CARDS.iterator();
        String card = null;
        while (i.hasNext()) {
            card = i.next();
            if (!value.startsWith(card)) continue;
            return true;
        }
        return false;
    }

    private String convertAnnotation(Class pojo) {
        if (TextualAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.CommentAnnotation";
        }
        if (TagAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.TagAnnotation";
        }
        if (RatingAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.LongAnnotation";
        }
        if (LongAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.LongAnnotation";
        }
        if (FileAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.FileAnnotation";
        }
        if (TermAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.UriAnnotation";
        }
        if (TimeAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.TimeAnnotation";
        }
        if (BooleanAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.BooleanAnnotation";
        }
        return null;
    }

    private void clear() {
        this.thumbnailService = null;
        this.fileStore = null;
        this.metadataService = null;
        this.pojosService = null;
        this.projService = null;
        this.searchService = null;
        this.adminService = null;
        this.queryService = null;
        this.rndSettingsService = null;
        this.repInfoService = null;
        this.deleteService = null;
        this.pixelsService = null;
        this.roiService = null;
        this.pixelsStore = null;
        this.updateService = null;
        this.scriptService = null;
        this.exporterService = null;
        this.timeService = null;
        this.sharedResources = null;
        this.services.clear();
        this.reServices.clear();
    }

    private String convertTypeForSearch(Class nodeType) {
        if (nodeType.equals(Image.class)) {
            return ImageI.class.getName();
        }
        if (nodeType.equals(TagAnnotation.class) || nodeType.equals(TagAnnotationData.class)) {
            return TagAnnotationI.class.getName();
        }
        if (nodeType.equals(BooleanAnnotation.class) || nodeType.equals(BooleanAnnotationData.class)) {
            return BooleanAnnotationI.class.getName();
        }
        if (nodeType.equals(TermAnnotation.class) || nodeType.equals(TermAnnotationData.class)) {
            return TermAnnotationI.class.getName();
        }
        if (nodeType.equals(FileAnnotation.class) || nodeType.equals(FileAnnotationData.class)) {
            return FileAnnotationI.class.getName();
        }
        if (nodeType.equals(CommentAnnotation.class) || nodeType.equals(TextualAnnotationData.class)) {
            return CommentAnnotationI.class.getName();
        }
        if (nodeType.equals(TimestampAnnotation.class) || nodeType.equals(TimeAnnotationData.class)) {
            return TimestampAnnotationI.class.getName();
        }
        throw new IllegalArgumentException("type not supported");
    }

    OMEROGateway(int port, DataServicesFactory dsFactory) {
        if (dsFactory == null) {
            throw new IllegalArgumentException("No Data service factory.");
        }
        this.dsFactory = dsFactory;
        this.port = port;
        this.thumbRetrieval = 0;
        this.enumerations = new HashMap<String, List<EnumerationObject>>();
        this.services = new ArrayList<ServiceInterfacePrx>();
        this.reServices = new HashMap<Long, StatefulServiceInterfacePrx>();
    }

    void setPort(int port) {
        if (this.port != port) {
            this.port = port;
        }
    }

    boolean isSystemGroup(ExperimenterGroup group) {
        String n = group.getName() == null ? null : group.getName().getValue();
        return SYSTEM_GROUPS.contains(n);
    }

    Class convertPojos(DataObject node) {
        if (node instanceof FileData || node instanceof MultiImageData) {
            return OriginalFile.class;
        }
        return this.convertPojos(node.getClass());
    }

    Class convertPojos(Class nodeType) {
        if (ProjectData.class.equals((Object)nodeType)) {
            return Project.class;
        }
        if (DatasetData.class.equals((Object)nodeType)) {
            return Dataset.class;
        }
        if (ImageData.class.equals((Object)nodeType)) {
            return Image.class;
        }
        if (BooleanAnnotationData.class.equals((Object)nodeType)) {
            return BooleanAnnotation.class;
        }
        if (RatingAnnotationData.class.equals((Object)nodeType) || LongAnnotationData.class.equals((Object)nodeType)) {
            return LongAnnotation.class;
        }
        if (TagAnnotationData.class.equals((Object)nodeType)) {
            return TagAnnotation.class;
        }
        if (TextualAnnotationData.class.equals((Object)nodeType)) {
            return CommentAnnotation.class;
        }
        if (FileAnnotationData.class.equals((Object)nodeType)) {
            return FileAnnotation.class;
        }
        if (TermAnnotationData.class.equals((Object)nodeType)) {
            return TermAnnotation.class;
        }
        if (ScreenData.class.equals((Object)nodeType)) {
            return Screen.class;
        }
        if (PlateData.class.equals((Object)nodeType)) {
            return Plate.class;
        }
        if (WellData.class.equals((Object)nodeType)) {
            return Well.class;
        }
        if (WellSampleData.class.equals((Object)nodeType)) {
            return WellSample.class;
        }
        if (PlateAcquisitionData.class.equals((Object)nodeType)) {
            return PlateAcquisition.class;
        }
        if (FileData.class.equals((Object)nodeType) || MultiImageData.class.equals((Object)nodeType)) {
            return OriginalFile.class;
        }
        if (GroupData.class.equals((Object)nodeType)) {
            return ExperimenterGroup.class;
        }
        if (ExperimenterData.class.equals((Object)nodeType)) {
            return Experimenter.class;
        }
        throw new IllegalArgumentException("NodeType not supported");
    }

    String createDeleteCommand(String data) {
        if (ImageData.class.getName().equals(data)) {
            return REF_IMAGE;
        }
        if (DatasetData.class.getName().equals(data)) {
            return REF_DATASET;
        }
        if (ProjectData.class.getName().equals(data)) {
            return REF_PROJECT;
        }
        if (ScreenData.class.getName().equals(data)) {
            return REF_SCREEN;
        }
        if (PlateData.class.getName().equals(data)) {
            return REF_PLATE;
        }
        if (ROIData.class.getName().equals(data)) {
            return REF_ROI;
        }
        if (PlateAcquisitionData.class.getName().equals(data)) {
            return REF_PLATE_ACQUISITION;
        }
        if (WellData.class.getName().equals(data)) {
            return REF_WELL;
        }
        if (PlateAcquisitionData.class.getName().equals(data)) {
            return REF_PLATE_ACQUISITION;
        }
        if (TagAnnotationData.class.getName().equals(data) || TermAnnotationData.class.getName().equals(data) || FileAnnotationData.class.getName().equals(data)) {
            return REF_ANNOTATION;
        }
        throw new IllegalArgumentException("Cannot delete the speficied type.");
    }

    String createDeleteOption(String data) {
        if (TagAnnotationData.class.getName().equals(data)) {
            return REF_TAG;
        }
        if (TermAnnotationData.class.getName().equals(data)) {
            return REF_TERM;
        }
        if (FileAnnotationData.class.getName().equals(data)) {
            return REF_FILE;
        }
        throw new IllegalArgumentException("Cannot delete the speficied type.");
    }

    boolean isConnected() {
        return this.connected;
    }

    ExperimenterData getUserDetails(String name) throws DSOutOfServiceException {
        try {
            IAdminPrx service = this.getAdminService();
            return (ExperimenterData)PojoMapper.asDataObject((IObject)service.lookupExperimenter(name));
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Cannot retrieve user's data " + this.printErrorText(e), e);
        }
    }

    boolean isUpgradeRequired() {
        ResourceBundle bundle = ResourceBundle.getBundle("omero");
        String version = bundle.getString("omero.version");
        String url = bundle.getString("omero.upgrades.url");
        UpgradeCheck check = new UpgradeCheck(url, version, "insight");
        check.run();
        return check.isUpgradeNeeded();
    }

    ExperimenterData login(String userName, String password, String hostName, float compressionLevel, long groupID, boolean encrypted) throws DSOutOfServiceException {
        try {
            this.compression = compressionLevel;
            this.hostName = hostName;
            this.secureClient = this.port > 0 ? new client(hostName, this.port) : new client(hostName);
            this.entryEncrypted = this.secureClient.createSession(userName, password);
            this.secureClient.setAgent(AGENT);
            if (!encrypted) {
                this.unsecureClient = this.secureClient.createClient(false);
                this.entryUnencrypted = this.unsecureClient.getSession();
            }
            this.connected = true;
            ExperimenterData exp = this.getUserDetails(userName);
            if (groupID >= 0L) {
                long defaultID = exp.getDefaultGroup().getId();
                if (defaultID == groupID) {
                    return exp;
                }
                try {
                    this.changeCurrentGroup(exp, groupID);
                    exp = this.getUserDetails(userName);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return exp;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.connected = false;
            String s = "Can't connect to OMERO. OMERO info not valid.\n\n";
            s = s + this.printErrorText(e);
            throw new DSOutOfServiceException(s, e);
        }
    }

    FSFileSystemView getFSRepositories(long userID) throws DSOutOfServiceException, DSAccessException {
        if (this.fsViews == null) {
            this.fsViews = new HashMap<Long, FSFileSystemView>();
        }
        if (this.fsViews.containsKey(userID)) {
            return this.fsViews.get(userID);
        }
        FSFileSystemView view = null;
        try {
            RepositoryMap m = this.getSharedResources().repositories();
            List proxys = m.proxies;
            List names = m.descriptions;
            Iterator i = names.iterator();
            int index = 0;
            HashMap<FileData, RepositoryPrx> repositories = new HashMap<FileData, RepositoryPrx>();
            while (i.hasNext()) {
                FileData f = new FileData((OriginalFile)i.next(), true);
                if (!f.getName().contains("Tmp")) {
                    RepositoryPrx proxy = (RepositoryPrx)proxys.get(index);
                    repositories.put(f, proxy);
                }
                ++index;
            }
            view = new FSFileSystemView(userID, repositories);
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot load the repositories");
        }
        if (view != null) {
            this.fsViews.put(userID, view);
        }
        return view;
    }

    void changeCurrentGroup(ExperimenterData exp, long groupID) throws DSOutOfServiceException, DSAccessException {
        List groups = exp.getGroups();
        Iterator i = groups.iterator();
        GroupData group = null;
        boolean in = false;
        while (i.hasNext()) {
            group = (GroupData)i.next();
            if (group.getId() != groupID) continue;
            in = true;
            break;
        }
        String s = "Can't modify the current group.\n\n";
        if (!in) {
            throw new DSOutOfServiceException(s);
        }
        try {
            this.shutDownServices(true);
            this.clear();
            this.getAdminService().setDefaultGroup(exp.asExperimenter(), group.asGroup());
            this.entryEncrypted.setSecurityContext((IObject)new ExperimenterGroupI(groupID, false));
        }
        catch (Exception e) {
            this.handleException(e, s);
        }
    }

    String getServerVersion() throws DSOutOfServiceException {
        if (this.entryEncrypted == null) {
            return null;
        }
        try {
            return this.entryEncrypted.getConfigService().getVersion();
        }
        catch (Exception e) {
            String s = "Can't retrieve the server version.\n\n";
            s = s + this.printErrorText(e);
            throw new DSOutOfServiceException(s, e);
        }
    }

    String lookupLdapAuthExperimenter(long userID) throws DSOutOfServiceException {
        try {
            return this.getAdminService().lookupLdapAuthExperimenter(userID);
        }
        catch (Throwable e) {
            String s = "Can't find the LDAP information.\n\n";
            s = s + this.printErrorText(e);
            throw new DSOutOfServiceException(s, e);
        }
    }

    void startFS(Properties fsConfig) {
    }

    boolean reconnect(String userName, String password) {
        block4: {
            this.clear();
            try {
                this.secureClient.joinSession(this.secureClient.getSessionId());
                this.connected = true;
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                this.connected = false;
                if (!(cause instanceof ConnectionLostException) && !(t instanceof ConnectionLostException)) break block4;
                try {
                    this.secureClient.createSession(userName, password);
                }
                catch (Throwable e) {
                    this.connected = false;
                }
            }
        }
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logout() {
        this.connected = false;
        try {
            this.clear();
            this.secureClient.closeSession();
            this.secureClient = null;
            this.entryEncrypted = null;
        }
        catch (Exception e) {
        }
        finally {
            this.secureClient = null;
            this.entryEncrypted = null;
        }
        try {
            if (this.unsecureClient != null) {
                this.secureClient.closeSession();
            }
            this.unsecureClient = null;
            this.entryUnencrypted = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.unsecureClient = null;
            this.entryUnencrypted = null;
        }
    }

    Set loadContainerHierarchy(Class rootType, List rootIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            Set values = PojoMapper.asDataObjects(service.loadContainerHierarchy(this.convertPojos(rootType).getName(), rootIDs, options));
            if (ScreenData.class.equals((Object)rootType)) {
                for (Object object : values) {
                    if (!(object instanceof ScreenData)) continue;
                    ScreenData screen = (ScreenData)object;
                    HashSet list = new HashSet();
                }
            }
            return values;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot load hierarchy for " + rootType + ".");
            return new HashSet();
        }
    }

    Set findContainerHierarchy(Class rootNodeType, List leavesIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            return PojoMapper.asDataObjects(service.findContainerHierarchies(this.convertPojos(rootNodeType).getName(), leavesIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find hierarchy for " + rootNodeType + ".");
            return new HashSet();
        }
    }

    Map loadAnnotations(Class nodeType, List nodeIDs, List<Class> annotationTypes, List annotatorIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<String> types = new ArrayList<String>();
        if (annotationTypes != null && annotationTypes.size() > 0) {
            types = new ArrayList(annotationTypes.size());
            Iterator<Class> i = annotationTypes.iterator();
            while (i.hasNext()) {
                String k = this.convertAnnotation(i.next());
                if (k == null) continue;
                types.add(k);
            }
        }
        try {
            IMetadataPrx service = this.getMetadataService();
            return PojoMapper.asDataObjects(service.loadAnnotations(this.convertPojos(nodeType).getName(), nodeIDs, types, annotatorIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find annotations for " + nodeType + ".");
            return new HashMap();
        }
    }

    Set<DataObject> loadAnnotation(List<Long> annotationIds) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        if (annotationIds == null || annotationIds.size() == 0) {
            return new HashSet<DataObject>();
        }
        try {
            IMetadataPrx service = this.getMetadataService();
            return PojoMapper.asDataObjects(service.loadAnnotation(annotationIds));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find the annotations.");
            return new HashSet<DataObject>();
        }
    }

    Collection findAllAnnotations(Class type, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            String table = this.getTableForAnnotationLink(type.getName());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link";
            sql = sql + " left outer join link.child as child";
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("uid", rtypes.rlong((long)userID));
            sql = sql + " where link.details.owner.id = :uid";
            return service.findAllByQuery(sql, (Parameters)p);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for userID: " + userID);
            return new ArrayList();
        }
    }

    Set getContainerImages(Class nodeType, List nodeIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            return PojoMapper.asDataObjects(service.getImages(this.convertPojos(nodeType).getName(), nodeIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find images for " + nodeType + ".");
            return new HashSet();
        }
    }

    Set getUserImages(Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            return PojoMapper.asDataObjects(service.getUserImages(options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find user images.");
            return new HashSet();
        }
    }

    Map getCollectionCount(Class rootNodeType, String property, List ids, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            if (TagAnnotationData.class.equals((Object)rootNodeType)) {
                return this.getMetadataService().getTaggedObjectsCount(ids, options);
            }
            IContainerPrx service = this.getPojosService();
            String p = this.convertProperty(rootNodeType, property);
            if (p == null) {
                return null;
            }
            return PojoMapper.asDataObjects(service.getCollectionCount(this.convertPojos(rootNodeType).getName(), p, ids, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the collection.");
            return new HashMap();
        }
    }

    IObject createObject(IObject object) throws DSOutOfServiceException, DSAccessException {
        try {
            this.isSessionAlive();
            return this.saveAndReturnObject(object, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> createObjects(List<IObject> objects) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.saveAndReturnObject(objects, null);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot create the objects.");
            return new ArrayList<IObject>();
        }
    }

    void deleteObject(IObject object) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            if (object instanceof Plate) {
                IDeletePrx service = this.getDeleteService();
                service.deletePlate(object.getId().getValue());
            } else {
                IUpdatePrx service = this.getUpdateService();
                service.deleteObject(object);
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot delete the object.");
        }
    }

    void deleteObjects(List<IObject> objects) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IUpdatePrx service = this.getUpdateService();
            Iterator<IObject> i = objects.iterator();
            while (i.hasNext()) {
                service.deleteObject(i.next());
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot delete the object.");
        }
    }

    IObject saveAndReturnObject(IObject object, Map options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IUpdatePrx service = this.getUpdateService();
            if (options == null) {
                return service.saveAndReturnObject(object);
            }
            return service.saveAndReturnObject(object, options);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> saveAndReturnObject(List<IObject> objects, Map options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IUpdatePrx service = this.getUpdateService();
            return service.saveAndReturnArray(objects);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return new ArrayList<IObject>();
        }
    }

    IObject updateObject(IObject object, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            IObject r = service.updateDataObject(object, options);
            return this.findIObject(r);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> updateObjects(List<IObject> objects, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            List l = service.updateDataObjects(objects, options);
            if (l == null) {
                return l;
            }
            Iterator i = l.iterator();
            ArrayList<IObject> r = new ArrayList<IObject>(l.size());
            while (i.hasNext()) {
                IObject io = this.findIObject((IObject)i.next());
                if (io == null) continue;
                r.add(io);
            }
            return r;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return new ArrayList<IObject>();
        }
    }

    Pixels getPixels(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IPixelsPrx service = this.getPixelsService();
            return service.retrievePixDescription(pixelsID);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the pixels set of the pixels set.");
            return null;
        }
    }

    synchronized byte[] getThumbnail(long pixelsID, int sizeX, int sizeY, long userID) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            RenderingDef def;
            ThumbnailStorePrx service = this.getThumbService();
            this.needDefault(pixelsID, null);
            if (userID >= 0L && (def = this.getRenderingDef(pixelsID, userID)) != null) {
                service.setRenderingDefId(def.getId().getValue());
            }
            return service.getThumbnail(rtypes.rint((int)sizeX), rtypes.rint((int)sizeY));
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (this.thumbnailService != null) {
                try {
                    this.thumbnailService.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.thumbnailService = null;
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
    }

    synchronized byte[] getThumbnailByLongestSide(long pixelsID, int maxLength) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            ThumbnailStorePrx service = this.getThumbService();
            this.needDefault(pixelsID, null);
            return service.getThumbnailByLongestSide(rtypes.rint((int)maxLength));
        }
        catch (Throwable t) {
            if (this.thumbnailService != null) {
                try {
                    this.thumbnailService.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.thumbnailService = null;
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
    }

    synchronized Map getThumbnailSet(List<Long> pixelsID, int maxLength, boolean reset) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            if (reset) {
                this.thumbRetrieval = 100;
            }
            ThumbnailStorePrx service = this.getThumbService();
            return service.getThumbnailByLongestSideSet(rtypes.rint((int)maxLength), pixelsID);
        }
        catch (Throwable t) {
            if (this.thumbnailService != null) {
                try {
                    this.thumbnailService.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.thumbnailService = null;
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
    }

    synchronized RenderingEnginePrx createRenderingEngine(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            RenderingEnginePrx service = this.getRenderingService();
            this.reServices.put(pixelsID, (StatefulServiceInterfacePrx)service);
            service.lookupPixels(pixelsID);
            this.needDefault(pixelsID, service);
            service.load();
            return service;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.handleException(t, "Cannot start the Rendering Engine.");
            return null;
        }
    }

    IObject findAnnotationLink(Class type, long parentID, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            String table = this.getTableForAnnotationLink(type.getName());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where " + "link.parent.id = :parentID and link.details.owner.id = :userID";
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("parentID", rtypes.rlong((long)parentID));
            p.map.put("userID", rtypes.rlong((long)userID));
            if (childID >= 0L) {
                sql = sql + " and link.child.id = :childID";
                p.map.put("childID", rtypes.rlong((long)childID));
            }
            return service.findByQuery(sql, (Parameters)p);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parentID + " and child " + "ID: " + childID);
            return null;
        }
    }

    List findAnnotationLinks(String parentType, long parentID, List<Long> children) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            String table = this.getTableForAnnotationLink(parentType);
            if (table == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link");
            sb.append(" left outer join fetch link.details.owner as owner");
            sb.append(" left outer join fetch link.child as child");
            sb.append(" left outer join fetch link.parent as parent");
            ParametersI p = new ParametersI();
            if (parentID > 0L) {
                sb.append(" where link.parent.id = :parentID");
                if (children != null && children.size() > 0) {
                    sb.append(" and link.child.id in (:childIDs)");
                    p.addLongs("childIDs", children);
                }
                p.map.put("parentID", rtypes.rlong((long)parentID));
            } else if (children != null && children.size() > 0) {
                sb.append(" where link.child.id in (:childIDs)");
                p.addLongs("childIDs", children);
            }
            return service.findAllByQuery(sb.toString(), (Parameters)p);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the annotation links for parent ID: " + parentID);
            return new ArrayList();
        }
    }

    IObject findLink(IObject parent, IObject child) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String table = this.getTableForLink(parent.getClass());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where " + "link.parent.id = :parentID and link.child.id = :childID";
            ParametersI param = new ParametersI();
            param.map = new HashMap();
            param.map.put("parentID", parent.getId());
            param.map.put("childID", child.getId());
            return this.getQueryService().findByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parent.getId() + " and child " + "ID: " + child.getId());
            return null;
        }
    }

    List findLinks(IObject parent, List children) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String table = this.getTableForLink(parent.getClass());
            if (table == null) {
                return null;
            }
            ParametersI param = new ParametersI();
            param.map.put("parentID", parent.getId());
            String sql = "select link from " + table + " as link where " + "link.parent.id = :parentID";
            if (children != null && children.size() > 0) {
                sql = sql + " and link.child.id in (:childIDs)";
                param.addLongs("childIDs", (Collection)children);
            }
            return this.getQueryService().findAllByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parent.getId());
            return new ArrayList();
        }
    }

    List findLinks(Class parentClass, List children, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String table = this.getTableForLink(parentClass);
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where " + "link.child.id in (:childIDs)";
            ParametersI param = new ParametersI();
            param.addLongs("childIDs", (Collection)children);
            if (userID >= 0L) {
                sql = sql + " and link.details.owner.id = :userID";
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return this.getQueryService().findAllByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for the specified children");
            return new ArrayList();
        }
    }

    List findAnnotationLinks(Class node, long nodeID, List children, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String table = this.getAnnotationTableLink(node);
            if (table == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link ");
            sb.append("left outer join fetch link.child child ");
            sb.append("left outer join fetch child.details.owner ");
            sb.append("left outer join fetch link.details.owner ");
            sb.append("where link.child.id in (:childIDs)");
            ParametersI param = new ParametersI();
            param.addLongs("childIDs", (Collection)children);
            if (nodeID > 0L) {
                sb.append(" and link.parent.id = :parentID");
                param.map.put("parentID", rtypes.rlong((long)nodeID));
            }
            if (userID >= 0L) {
                sb.append(" and link.details.owner.id = :userID");
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return this.getQueryService().findAllByQuery(sb.toString(), (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for the specified children");
            return new ArrayList();
        }
    }

    List findLinks(Class parentClass, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        if (FileAnnotation.class.equals((Object)parentClass)) {
            ArrayList results = new ArrayList();
            results.addAll(this.loadLinks("ProjectAnnotationLink", childID, userID));
            results.addAll(this.loadLinks("DatasetAnnotationLink", childID, userID));
            results.addAll(this.loadLinks("ImageAnnotationLink", childID, userID));
            return results;
        }
        return this.loadLinks(this.getTableForLink(parentClass), childID, userID);
    }

    IObject findIObject(IObject o) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.getQueryService().find(o.getClass().getName(), o.getId().getValue());
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested object with object ID: " + o.getId());
            return null;
        }
    }

    IObject findIObject(String klassName, long id) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.getQueryService().find(klassName, id);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested object with object ID: " + id);
            return null;
        }
    }

    Set<GroupData> getAvailableGroups(ExperimenterData user) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        HashSet<GroupData> pojos = new HashSet<GroupData>();
        try {
            ParametersI p = new ParametersI();
            p.addId(user.getId());
            List groups = this.getQueryService().findAllByQuery("select distinct g from ExperimenterGroup as g join fetch g.groupExperimenterMap as map join fetch map.parent e left outer join fetch map.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent p where g.id in   (select m.parent from GroupExperimenterMap m   where m.child.id = :id )", (Parameters)p);
            for (ExperimenterGroup group : groups) {
                pojos.add((GroupData)PojoMapper.asDataObject((IObject)group));
            }
            return pojos;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the available groups ");
            return pojos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<Boolean, Object> getArchivedFiles(String path, long pixelsID) throws DSAccessException, DSOutOfServiceException {
        this.isSessionAlive();
        IQueryPrx service = this.getQueryService();
        List files = null;
        try {
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)pixelsID));
            files = service.findAllByQuery("select ofile from OriginalFile as ofile left join ofile.pixelsFileMaps as pfm left join pfm.child as child where child.id = :id", (Parameters)param);
        }
        catch (Exception e) {
            throw new DSAccessException("Cannot retrieve original file", e);
        }
        HashMap<Boolean, Object> result = new HashMap<Boolean, Object>();
        if (files == null || files.size() == 0) {
            return result;
        }
        Iterator i = files.iterator();
        FileOutputStream stream = null;
        long offset = 0L;
        ArrayList<String> notDownloaded = new ArrayList<String>();
        while (i.hasNext()) {
            OriginalFile of = (OriginalFile)i.next();
            RawFileStorePrx store = this.getRawFileService();
            try {
                store.setFileId(of.getId().getValue());
            }
            catch (Exception e) {
                this.handleException(e, "Cannot set the file's id.");
            }
            String fullPath = path + of.getName().getValue();
            File f = new File(fullPath);
            try {
                stream = new FileOutputStream(f);
                long size = of.getSize().getValue();
                try {
                    try {
                        offset = 0L;
                        while (offset + 262144L < size) {
                            stream.write(store.read(offset, 262144));
                            offset += 262144L;
                        }
                    }
                    finally {
                        stream.write(store.read(offset, (int)(size - offset)));
                        stream.close();
                    }
                }
                catch (Exception e) {
                    if (stream != null) {
                        stream.close();
                    }
                    if (f != null) {
                        f.delete();
                    }
                    notDownloaded.add(of.getName().getValue());
                    this.closeService((StatefulServiceInterfacePrx)store);
                }
            }
            catch (IOException e) {
                if (f != null) {
                    f.delete();
                }
                notDownloaded.add(of.getName().getValue());
                this.closeService((StatefulServiceInterfacePrx)store);
                throw new DSAccessException("Cannot create file with path " + fullPath, e);
            }
            this.closeService((StatefulServiceInterfacePrx)store);
        }
        result.put(true, files);
        result.put(false, notDownloaded);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized File downloadFile(File file, long fileID, long size) throws DSAccessException, DSOutOfServiceException {
        OriginalFile of;
        this.isSessionAlive();
        if (size <= 0L && (of = this.getOriginalFile(fileID)) != null) {
            size = of.getSize().getValue();
        }
        RawFileStorePrx store = this.getRawFileService();
        try {
            store.setFileId(fileID);
        }
        catch (Throwable e) {
            this.closeService((StatefulServiceInterfacePrx)store);
            this.handleException(e, "Cannot set the file's id.");
        }
        String path = file.getAbsolutePath();
        int offset = 0;
        int length = (int)size;
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                try {
                    offset = 0;
                    while ((long)(offset + 262144) < size) {
                        stream.write(store.read((long)offset, 262144));
                        offset += 262144;
                    }
                }
                finally {
                    stream.write(store.read((long)offset, length - offset));
                    stream.close();
                }
            }
            catch (Exception e) {
                if (stream != null) {
                    stream.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
        }
        catch (IOException e) {
            if (file != null) {
                file.delete();
            }
            this.closeService((StatefulServiceInterfacePrx)store);
            throw new DSAccessException("Cannot create file  " + path, e);
        }
        this.closeService((StatefulServiceInterfacePrx)store);
        return file;
    }

    private void closeService(StatefulServiceInterfacePrx svc) {
        try {
            svc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void shutDownServices(boolean rendering) {
        Collection<StatefulServiceInterfacePrx> l;
        if (this.thumbnailService != null) {
            this.closeService((StatefulServiceInterfacePrx)this.thumbnailService);
        }
        if (this.pixelsStore != null) {
            this.closeService((StatefulServiceInterfacePrx)this.pixelsStore);
        }
        if (this.fileStore != null) {
            this.closeService((StatefulServiceInterfacePrx)this.fileStore);
        }
        if (this.searchService != null) {
            this.closeService((StatefulServiceInterfacePrx)this.searchService);
        }
        if ((l = this.reServices.values()) != null && rendering) {
            Iterator<StatefulServiceInterfacePrx> i = l.iterator();
            while (i.hasNext()) {
                this.closeService(i.next());
            }
            this.reServices.clear();
        }
        this.thumbnailService = null;
        this.pixelsStore = null;
        this.searchService = null;
        this.fileStore = null;
    }

    OriginalFile getOriginalFile(long id) throws DSAccessException, DSOutOfServiceException {
        this.isSessionAlive();
        OriginalFile of = null;
        try {
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)id));
            of = (OriginalFile)this.getQueryService().findByQuery("select p from OriginalFile as p where p.id = :id", (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve original file");
        }
        return of;
    }

    List getOriginalFiles(long pixelsID) throws DSAccessException, DSOutOfServiceException {
        this.isSessionAlive();
        List files = null;
        try {
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)pixelsID));
            files = this.getQueryService().findAllByQuery("select ofile from OriginalFile as ofile left join ofile.pixelsFileMaps as pfm left join pfm.child as child where child.id = :id", (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve original file");
        }
        return files;
    }

    synchronized OriginalFile uploadFile(File file, String mimeType, long originalFileID) throws DSAccessException, DSOutOfServiceException {
        if (file == null) {
            throw new IllegalArgumentException("No file to upload");
        }
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = DEFAULT_MIMETYPE;
        }
        this.isSessionAlive();
        RawFileStorePrx store = null;
        OriginalFile save = null;
        boolean fileCreated = false;
        try {
            OriginalFileI oFile;
            store = this.getRawFileService();
            if (originalFileID <= 0L) {
                oFile = new OriginalFileI();
                String name = file.getName();
                oFile.setName(rtypes.rstring((String)name));
                String absolutePath = file.getAbsolutePath();
                String path = absolutePath.substring(0, absolutePath.length() - name.length());
                oFile.setPath(rtypes.rstring((String)path));
                oFile.setSize(rtypes.rlong((long)file.length()));
                oFile.setSha1(rtypes.rstring((String)"pending"));
                oFile.setMimetype(rtypes.rstring((String)mimeType));
                save = (OriginalFile)this.getUpdateService().saveAndReturnObject((IObject)oFile);
                store.setFileId(save.getId().getValue());
                fileCreated = true;
            } else {
                oFile = (OriginalFile)this.findIObject(OriginalFile.class.getName(), originalFileID);
                OriginalFileI newFile = new OriginalFileI();
                newFile.setId(rtypes.rlong((long)originalFileID));
                newFile.setName(rtypes.rstring((String)file.getName()));
                newFile.setPath(rtypes.rstring((String)file.getAbsolutePath()));
                newFile.setSize(rtypes.rlong((long)file.length()));
                newFile.setSha1(rtypes.rstring((String)"pending"));
                oFile.setMimetype(oFile.getMimetype());
                save = (OriginalFile)this.getUpdateService().saveAndReturnObject((IObject)newFile);
                store.setFileId(save.getId().getValue());
            }
        }
        catch (Exception e) {
            this.closeService((StatefulServiceInterfacePrx)store);
            this.handleException(e, "Cannot set the file's id.");
        }
        byte[] buf = new byte[262144];
        FileInputStream stream = null;
        try {
            int rlen;
            stream = new FileInputStream(file);
            long pos = 0L;
            while ((rlen = stream.read(buf)) > 0) {
                store.write(buf, pos, rlen);
                pos += (long)rlen;
                ByteBuffer bbuf = ByteBuffer.wrap(buf);
                bbuf.limit(rlen);
            }
            stream.close();
            save = store.save();
            this.closeService((StatefulServiceInterfacePrx)store);
        }
        catch (Exception e) {
            try {
                if (fileCreated) {
                    this.deleteObject((IObject)save);
                }
                if (stream != null) {
                    stream.close();
                }
                this.closeService((StatefulServiceInterfacePrx)store);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new DSAccessException("Cannot upload the file with path " + file.getAbsolutePath(), e);
        }
        return save;
    }

    void changePassword(String password, String oldPassword) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            this.getAdminService().changePasswordWithOldPassword(rtypes.rstring((String)oldPassword), rtypes.rstring((String)password));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify password. ");
        }
    }

    void updateExperimenter(Experimenter exp, long currentUserID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            if (exp == null) {
                return;
            }
            if (exp.getId().getValue() == currentUserID) {
                this.getAdminService().updateSelf(exp);
            } else {
                this.getAdminService().updateExperimenter(exp);
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the user. ");
        }
    }

    GroupData updateGroup(ExperimenterGroup group, Permissions permissions) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            this.getAdminService().updateGroup(group);
            if (permissions != null) {
                this.getAdminService().changePermissions(this.findIObject((IObject)group), permissions);
            }
            return (GroupData)PojoMapper.asDataObject((IObject)((ExperimenterGroup)this.findIObject((IObject)group)));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the group. ");
            return null;
        }
    }

    void modifyExperimentersRoles(boolean toAdd, List<ExperimenterData> experimenters, String systemGroup) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IAdminPrx svc = this.getAdminService();
            if (toAdd) {
                Iterator<ExperimenterData> i = experimenters.iterator();
                boolean added = false;
                ExperimenterGroup gs = svc.lookupGroup(systemGroup);
                while (i.hasNext()) {
                    ExperimenterData exp = i.next();
                    List list = exp.getGroups();
                    for (GroupData group : list) {
                        if (!group.getName().equals(systemGroup)) continue;
                        added = true;
                    }
                    if (added) continue;
                    ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
                    groups.add(gs);
                    svc.addGroups(exp.asExperimenter(), groups);
                }
            } else {
                for (ExperimenterData exp : experimenters) {
                    List list = exp.getGroups();
                    ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
                    for (GroupData group : list) {
                        if (!group.getName().equals(systemGroup)) continue;
                        groups.add(group.asGroup());
                    }
                    if (groups.size() <= 0) continue;
                    svc.removeGroups(exp.asExperimenter(), groups);
                }
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify the roles of the experimenters.");
        }
    }

    void handleGroupOwners(boolean toAdd, ExperimenterGroup group, List<Experimenter> experimenters) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IAdminPrx svc = this.getAdminService();
            if (toAdd) {
                svc.addGroupOwners(group, experimenters);
            } else {
                svc.removeGroupOwners(group, experimenters);
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot handle the group ownership. ");
        }
    }

    synchronized byte[] getPlane(long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        RawPixelsStorePrx service = this.getPixelsStore();
        try {
            service.setPixelsId(pixelsID, false);
            return service.getPlane(z, c, t);
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the plane (z=" + z + ", t=" + t + ", c=" + c + ") for pixelsID: " + pixelsID);
            return null;
        }
    }

    long getFreeSpace() throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.getRepositoryService().getFreeSpaceInKilobytes();
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the free space");
            return -1L;
        }
    }

    long getUsedSpace(long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            if (userID < 0L) {
                return this.getRepositoryService().getUsedSpaceInKilobytes();
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("select f from OriginalFile as f ");
            buffer.append("left outer join fetch f.details.owner as o ");
            buffer.append("where o.id = :userID");
            ParametersI param = new ParametersI();
            param.addLong("userID", userID);
            List result = this.getQueryService().findAllByQuery(buffer.toString(), (Parameters)param);
            if (result == null) {
                return -1L;
            }
            Iterator i = result.iterator();
            long count = 0L;
            while (i.hasNext()) {
                OriginalFile f = (OriginalFile)i.next();
                if (f.getSize() == null) continue;
                count += f.getSize().getValue();
            }
            return count;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the free space");
            return -1L;
        }
    }

    Collection getImages(Parameters map, boolean asDataObject) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            List result = service.getImagesByOptions(map);
            if (asDataObject) {
                return PojoMapper.asDataObjects(result);
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the images imported during the specified period.");
            return new HashSet();
        }
    }

    Map resetRenderingSettings(Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        ArrayList failure = new ArrayList();
        this.isSessionAlive();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            String klass = this.convertPojos(rootNodeType).getName();
            if (klass.equals(Image.class)) {
                failure.addAll(nodes);
            }
            if (klass.equals(Image.class.getName()) || klass.equals(Dataset.class.getName()) || klass.equals(Plate.class.getName())) {
                success = service.resetDefaultsInSet(klass, nodes);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering settings.");
        }
        for (Long id : success) {
            if (!failure.contains(id)) continue;
            failure.remove(id);
        }
        HashMap result = new HashMap(2);
        result.put(Boolean.TRUE, success);
        result.put(Boolean.FALSE, failure);
        return result;
    }

    Map setMinMaxSettings(Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        ArrayList failure = new ArrayList();
        this.isSessionAlive();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            String klass = this.convertPojos(rootNodeType).getName();
            if (klass.equals(Image.class)) {
                failure.addAll(nodes);
            }
            if (klass.equals(Image.class.getName()) || klass.equals(Dataset.class.getName()) || klass.equals(Plate.class.getName())) {
                success = service.resetMinMaxInSet(klass, nodes);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering settings.");
        }
        for (Long id : success) {
            if (!failure.contains(id)) continue;
            failure.remove(id);
        }
        HashMap result = new HashMap(2);
        result.put(Boolean.TRUE, success);
        result.put(Boolean.FALSE, failure);
        return result;
    }

    Map setOwnerRenderingSettings(Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        ArrayList failure = new ArrayList();
        this.isSessionAlive();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            String klass = this.convertPojos(rootNodeType).getName();
            if (klass.equals(Image.class)) {
                failure.addAll(nodes);
            }
            if (klass.equals(Image.class.getName()) || klass.equals(Dataset.class.getName()) || klass.equals(Plate.class.getName())) {
                success = service.resetDefaultsByOwnerInSet(klass, nodes);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering settings.");
        }
        for (Long id : success) {
            if (!failure.contains(id)) continue;
            failure.remove(id);
        }
        HashMap result = new HashMap(2);
        result.put(Boolean.TRUE, success);
        result.put(Boolean.FALSE, failure);
        return result;
    }

    Map pasteRenderingSettings(long pixelsID, Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        List failure = new ArrayList();
        this.isSessionAlive();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            Iterator i = nodes.iterator();
            if (DatasetData.class.equals((Object)rootNodeType) || PlateData.class.equals((Object)rootNodeType) || ProjectData.class.equals((Object)rootNodeType) || ScreenData.class.equals((Object)rootNodeType) || ImageData.class.equals((Object)rootNodeType)) {
                Map m = service.applySettingsToSet(pixelsID, this.convertPojos(rootNodeType).getName(), nodes);
                success = (List)m.get(true);
                failure = (List)m.get(false);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot paste the rendering settings.");
        }
        HashMap result = new HashMap(2);
        result.put(true, success);
        result.put(false, failure);
        return result;
    }

    Map getRenderingSettings(long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        HashMap<DataObject, RndProxyDef> map = new HashMap<DataObject, RndProxyDef>();
        this.isSessionAlive();
        try {
            IPixelsPrx service = this.getPixelsService();
            List results = service.retrieveAllRndSettings(pixelsID, userID);
            if (results == null || results.size() == 0) {
                return map;
            }
            for (RenderingDef rndDef : results) {
                Experimenter exp = rndDef.getDetails().getOwner();
                map.put(PojoMapper.asDataObject((IObject)exp), PixelsServicesFactory.convert(rndDef));
            }
            return map;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings for: " + pixelsID);
            return map;
        }
    }

    List getRenderingSettingsFor(long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        HashMap map = new HashMap();
        this.isSessionAlive();
        try {
            IPixelsPrx service = this.getPixelsService();
            List results = service.retrieveAllRndSettings(pixelsID, userID);
            if (results == null || results.size() == 0) {
                return new ArrayList();
            }
            ArrayList<RndProxyDef> l = new ArrayList<RndProxyDef>();
            Iterator i = results.iterator();
            while (i.hasNext()) {
                l.add(PixelsServicesFactory.convert((RenderingDef)i.next()));
            }
            return l;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings for: " + pixelsID);
            return new ArrayList();
        }
    }

    RenderingDef getRenderingDef(long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IPixelsPrx service = this.getPixelsService();
            return service.retrieveRndSettingsFor(pixelsID, userID);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings");
            return null;
        }
    }

    Set loadSpecificAnnotation(Class type, List<String> toInclude, List<String> toExclude, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            return PojoMapper.asDataObjects(service.loadSpecifiedAnnotations(this.convertPojos(type).getName(), toInclude, toExclude, options));
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotations");
            return new HashSet();
        }
    }

    long countSpecificAnnotation(Class type, List<String> toInclude, List<String> toExclude, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            RLong value = service.countSpecifiedAnnotations(this.convertPojos(type).getName(), toInclude, toExclude, options);
            if (value == null) {
                return -1L;
            }
            return value.getValue();
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotations");
            return -1L;
        }
    }

    long countAnnotationsUsedNotOwned(Class annotationType, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        long count = 0L;
        try {
            IMetadataPrx service = this.getMetadataService();
            RLong value = service.countAnnotationsUsedNotOwned(this.convertAnnotation(annotationType), userID);
            if (value != null) {
                count = value.getValue();
            }
            if (count < 0L) {
                count = 0L;
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot count the type of annotation used by the specified user");
        }
        return count;
    }

    Collection loadAnnotationsUsedNotOwned(Class annotationType, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        HashSet<TagAnnotationData> result = new HashSet<TagAnnotationData>();
        try {
            IMetadataPrx service = this.getMetadataService();
            List set = service.loadAnnotationsUsedNotOwned(this.convertAnnotation(annotationType), userID);
            for (IObject o : set) {
                if (!TagAnnotationData.class.equals((Object)annotationType)) continue;
                result.add(new TagAnnotationData((TagAnnotation)o));
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the Used Tags.");
            return result;
        }
    }

    Object searchByTime(SearchDataContext context) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ParametersI param = new ParametersI();
        param.map = new HashMap();
        StringBuffer buf = new StringBuffer();
        buf.append("select img from Image as img ");
        buf.append("left outer join fetch img.pixels as pix ");
        buf.append("left outer join fetch pix.pixelsType as pt ");
        buf.append("left outer join fetch img.details.owner as owner ");
        boolean condition = false;
        Timestamp start = context.getStart();
        Timestamp end = context.getEnd();
        switch (context.getTimeIndex()) {
            case 0: {
                if (start != null) {
                    condition = true;
                    buf.append("where img.acquisitionDate > :start ");
                    param.map.put("start", rtypes.rtime((long)start.getTime()));
                    if (end == null) break;
                    param.map.put("end", rtypes.rtime((long)end.getTime()));
                    buf.append("and img.acquisitionDate < :end ");
                    break;
                }
                if (end == null) break;
                condition = true;
                param.map.put("end", rtypes.rtime((long)end.getTime()));
                buf.append("where img.acquisitionDate < :end ");
                break;
            }
            case 1: {
                if (start != null) {
                    condition = true;
                    param.map.put("start", rtypes.rtime((long)start.getTime()));
                    buf.append("where img.details.creationEvent.time > :start ");
                    if (end == null) break;
                    param.map.put("end", rtypes.rtime((long)end.getTime()));
                    buf.append("and img.details.creationEvent.time < :end ");
                    break;
                }
                if (end == null) break;
                condition = true;
                param.map.put("end", rtypes.rtime((long)end.getTime()));
                buf.append("where img.details.creationEvent.time < :end ");
                break;
            }
        }
        try {
            List<ExperimenterData> l = context.getOwners();
            ArrayList<Long> ids = new ArrayList<Long>();
            if (l != null) {
                Iterator<ExperimenterData> i = l.iterator();
                while (i.hasNext()) {
                    ids.add(i.next().getId());
                }
            }
            param.addLongs("ids", ids);
            if (condition) {
                buf.append(" and owner.id in (:ids)");
            } else {
                buf.append("where owner.id in (:ids)");
            }
            IQueryPrx service = this.getQueryService();
            return PojoMapper.asDataObjects(service.findAllByQuery(buf.toString(), (Parameters)param));
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the images.");
            return new HashSet();
        }
    }

    Object performSearch(SearchDataContext context) throws DSOutOfServiceException, DSAccessException {
        HashMap<Integer, Object> results = new HashMap<Integer, Object>();
        List<Class> types = context.getTypes();
        List<Integer> scopes = context.getScope();
        if (types == null || types.size() == 0) {
            return new HashMap();
        }
        this.isSessionAlive();
        SearchPrx service = this.getSearchService();
        try {
            service.setAllowLeadingWildcard(true);
            service.setCaseSentivice(context.isCaseSensitive());
            Timestamp start = context.getStart();
            Timestamp end = context.getEnd();
            if (start != null || end != null) {
                switch (context.getTimeIndex()) {
                    case 0: {
                        service.onlyCreatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                        break;
                    }
                    case 1: {
                        service.onlyModifiedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                        break;
                    }
                    case 2: {
                        service.onlyAnnotatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                    }
                }
            }
            List<ExperimenterData> users = context.getOwners();
            ArrayList<DetailsI> owners = new ArrayList<DetailsI>();
            for (ExperimenterData exp : users) {
                DetailsI d = new DetailsI();
                d.setOwner(exp.asExperimenter());
                owners.add(d);
            }
            List<String> some = this.prepareTextSearch(context.getSome(), service);
            List<String> must = this.prepareTextSearch(context.getMust(), service);
            List<String> none = this.prepareTextSearch(context.getNone(), service);
            ArrayList<String> supportedTypes = new ArrayList<String>();
            Iterator<Object> i = types.iterator();
            while (i.hasNext()) {
                supportedTypes.add(this.convertPojos((Class)i.next()).getName());
            }
            i = scopes.iterator();
            while (i.hasNext()) {
                results.put((Integer)i.next(), new ArrayList());
            }
            i = scopes.iterator();
            List<String> fSome = null;
            List<String> fMust = null;
            List<String> fNone = null;
            List<String> fSomeSec = null;
            List<String> fMustSec = null;
            List<String> fNoneSec = null;
            service.onlyType(Image.class.getName());
            while (i.hasNext()) {
                Integer key = (Integer)i.next();
                List rType = (List)results.get(key);
                Object size = null;
                if (key == 1) {
                    fSome = this.formatText(some, "tag");
                    fMust = this.formatText(must, "tag");
                    fNone = this.formatText(none, "tag");
                } else if (key == 2) {
                    fSome = this.formatText(some, "name");
                    fMust = this.formatText(must, "name");
                    fNone = this.formatText(none, "name");
                } else if (key == 5) {
                    fSome = this.formatText(some, "description");
                    fMust = this.formatText(must, "description");
                    fNone = this.formatText(none, "description");
                } else if (key == 3) {
                    fSome = this.formatText(some, "file.name");
                    fMust = this.formatText(must, "file.name");
                    fNone = this.formatText(none, "file.name");
                    fSomeSec = this.formatText(some, "file.contents");
                    fMustSec = this.formatText(must, "file.contents");
                    fNoneSec = this.formatText(none, "file.contents");
                } else if (key == 0) {
                    fSome = this.formatText(some, "annotation", "NOT", "tag");
                    fMust = this.formatText(must, "annotation", "NOT", "tag");
                    fNone = this.formatText(none, "annotation", "NOT", "tag");
                } else if (key == 4) {
                    fSome = this.formatText(some, "url");
                    fMust = this.formatText(must, "url");
                    fNone = this.formatText(none, "url");
                } else if (key == 7) {
                    fSome = this.formatText(some, "");
                    fMust = this.formatText(must, "");
                    fNone = this.formatText(none, "");
                } else {
                    fSome = this.formatText(some, "");
                    fMust = this.formatText(must, "");
                    fNone = this.formatText(none, "");
                }
                Iterator owner = owners.iterator();
                service.bySomeMustNone(fSome, fMust, fNone);
                size = this.handleSearchResult(this.convertTypeForSearch(Image.class), rType, service);
                if (size instanceof Integer) {
                    results.put(key, size);
                }
                service.clearQueries();
                if (size instanceof Integer || fSomeSec == null || fSomeSec.size() <= 0) continue;
                service.bySomeMustNone(fSomeSec, fMustSec, fNoneSec);
                size = this.handleSearchResult(this.convertTypeForSearch(Image.class), rType, service);
                if (size instanceof Integer) {
                    results.put(key, size);
                }
                service.clearQueries();
            }
            service.close();
            return results;
        }
        catch (Throwable e) {
            try {
                service.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.handleException(e, "Cannot perform the search.");
            return null;
        }
    }

    List filterBy(Class annotationType, List<String> terms, Timestamp start, Timestamp end, ExperimenterData exp) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            SearchPrx service = this.getSearchService();
            if (start != null && end != null) {
                service.onlyAnnotatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
            }
            if (exp != null) {
                DetailsI d = new DetailsI();
                d.setOwner(exp.asExperimenter());
            }
            List<String> t = this.prepareTextSearch(terms, service);
            service.onlyType(this.convertPojos(annotationType).getName());
            ArrayList rType = new ArrayList();
            service.bySomeMustNone(t, null, null);
            Object size = this.handleSearchResult(this.convertTypeForSearch(annotationType), rType, service);
            if (size instanceof Integer) {
                rType = new ArrayList();
            }
            return rType;
        }
        catch (Exception e) {
            this.handleException(e, "Filtering by annotation not valid");
            return new ArrayList();
        }
    }

    Set fetchContainers(Class type, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("id", rtypes.rlong((long)userID));
            String table = this.getTableForClass(type);
            return PojoMapper.asDataObjects(service.findAllByQuery("from " + table + " as p where p.details.owner.id = :id", (Parameters)p));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the containers.");
            return new HashSet();
        }
    }

    Set getAnnotatedObjects(Class type, Set<Long> annotationIds, Set<Long> ownerIds) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            ParametersI param = new ParametersI();
            param.addLongs("ids", annotationIds);
            StringBuilder sb = new StringBuilder();
            if (type.equals(ImageData.class)) {
                sb.append("select img from Image as img ");
                sb.append("left outer join fetch img.annotationLinksCountPerOwner img_a_c ");
                sb.append("left outer join fetch img.annotationLinks ail ");
                sb.append("left outer join fetch img.pixels as pix ");
                sb.append("left outer join fetch pix.pixelsType as pt ");
                sb.append("where ail.child.id in (:ids)");
                if (ownerIds != null && ownerIds.size() > 0) {
                    sb.append(" and img.details.owner.id in (:ownerIds)");
                    param.addLongs("ownerIds", ownerIds);
                }
                return PojoMapper.asDataObjects(service.findAllByQuery(sb.toString(), (Parameters)param));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotated objects");
        }
        return new HashSet();
    }

    Map getDataObjectsTaggedCount(List rootNodeIDs) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            long r;
            Long value;
            List l;
            ParametersI param;
            IQueryPrx service = this.getQueryService();
            StringBuilder sb = new StringBuilder();
            sb.append("select img from Image as img ");
            sb.append("left outer join fetch img.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            Iterator i = rootNodeIDs.iterator();
            HashMap<Long, Long> m = new HashMap<Long, Long>();
            while (i.hasNext()) {
                Long id = (Long)i.next();
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l == null) continue;
                m.put(id, new Long(l.size()));
            }
            sb = new StringBuilder();
            sb.append("select d from Dataset as d ");
            sb.append("left outer join fetch d.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            for (Long id : rootNodeIDs) {
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                value = (Long)m.get(id);
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l != null) {
                    r = l.size();
                    value = value == null ? Long.valueOf(r) : Long.valueOf(value + r);
                }
                m.put(id, value);
            }
            sb = new StringBuilder();
            sb.append("select d from Project as d ");
            sb.append("left outer join fetch d.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            for (Long id : rootNodeIDs) {
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                value = (Long)m.get(id);
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l != null) {
                    r = l.size();
                    value = value == null ? Long.valueOf(r) : Long.valueOf(value + r);
                }
                m.put(id, value);
            }
            return m;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the collection.");
            return new HashMap();
        }
    }

    void removeTagDescription(long tagID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String type = "ome.model.annotations.TextAnnotation";
            IQueryPrx service = this.getQueryService();
            ParametersI param = new ParametersI();
            param.addLong("uid", userID);
            param.addLong("id", tagID);
            String sql = "select link from AnnotationAnnotationLink as link ";
            sql = sql + "where link.parent.id = :id";
            sql = sql + " and link.child member of " + type;
            sql = sql + " and link.details.owner.id = :uid";
            List l = service.findAllByQuery(sql, (Parameters)param);
            if (l != null) {
                for (AnnotationAnnotationLink link : l) {
                    Annotation child = link.getChild();
                    if (child instanceof TagAnnotation || child instanceof TermAnnotation) continue;
                    this.deleteObject((IObject)link);
                    this.deleteObject((IObject)child);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot remove the tag description.");
        }
    }

    void keepSessionAlive() {
        int n = this.services.size() + this.reServices.size();
        ServiceInterfacePrx[] entries = new ServiceInterfacePrx[n];
        Iterator<ServiceInterfacePrx> i = this.services.iterator();
        int index = 0;
        while (i.hasNext()) {
            entries[index] = i.next();
            ++index;
        }
        Iterator<Long> j = this.reServices.keySet().iterator();
        while (j.hasNext()) {
            entries[index] = (ServiceInterfacePrx)this.reServices.get(j.next());
            ++index;
        }
        try {
            this.entryEncrypted.keepAllAlive(entries);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.entryUnencrypted != null) {
                this.entryUnencrypted.keepAllAlive(entries);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    ImageData projectImage(long pixelsID, int startT, int endT, int startZ, int endZ, int stepping, ProjectionType algorithm, List<Integer> channels, String name, String pixType) throws DSOutOfServiceException, DSAccessException {
        try {
            IProjectionPrx service = this.getProjectionService();
            PixelsType type = null;
            if (pixType != null) {
                IQueryPrx svc = this.getQueryService();
                List l = svc.findAll(PixelsType.class.getName(), null);
                for (PixelsType pt : l) {
                    String value = pt.getValue().getValue();
                    if (!value.equals(pixType)) continue;
                    type = pt;
                    break;
                }
            }
            long imageID = service.projectPixels(pixelsID, type, algorithm, startT, endT, channels, stepping, startZ, endZ, name);
            return this.getImage(imageID, new Parameters());
        }
        catch (Exception e) {
            this.handleException(e, "Cannot project the image.");
            return null;
        }
    }

    ImageData getImage(long imageID, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            Iterator i;
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(imageID);
            Set result = this.getContainerImages(ImageData.class, ids, options);
            if (result != null && result.size() == 1 && (i = result.iterator()).hasNext()) {
                return (ImageData)i.next();
            }
            return null;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot project the image.");
            return null;
        }
    }

    RenderingDef createRenderingDef(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        try {
            IPixelsPrx svc = this.getPixelsService();
            Pixels pixels = svc.retrievePixDescription(pixelsID);
            if (pixels == null) {
                return null;
            }
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            return service.createNewRenderingDef(pixels);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create settings for: " + pixelsID);
            return null;
        }
    }

    Set loadPlateWells(long plateID, long acquisitionID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            List results = null;
            HashSet<WellData> wells = new HashSet<WellData>();
            IQueryPrx service = this.getQueryService();
            StringBuilder sb = new StringBuilder();
            ParametersI param = new ParametersI();
            param.addLong("plateID", plateID);
            sb.append("select well from Well as well ");
            sb.append("left outer join fetch well.plate as pt ");
            sb.append("left outer join fetch well.wellSamples as ws ");
            sb.append("left outer join fetch ws.plateAcquisition as pa ");
            sb.append("left outer join fetch ws.image as img ");
            sb.append("left outer join fetch img.pixels as pix ");
            sb.append("left outer join fetch pix.pixelsType as pt ");
            sb.append("where well.plate.id = :plateID");
            if (acquisitionID > 0L) {
                sb.append(" and pa.id = :acquisitionID");
                param.addLong("acquisitionID", acquisitionID);
            }
            results = service.findAllByQuery(sb.toString(), (Parameters)param);
            Iterator i = results.iterator();
            while (i.hasNext()) {
                wells.add((WellData)PojoMapper.asDataObject((IObject)((Well)i.next())));
            }
            return wells;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load plate");
            return new HashSet();
        }
    }

    Object loadImageAcquisitionData(long imageID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ParametersI po = new ParametersI();
        po.acquisitionData();
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(imageID);
        IContainerPrx service = this.getPojosService();
        try {
            List images = service.getImages(Image.class.getName(), ids, (Parameters)po);
            if (images != null && images.size() == 1) {
                return new ImageAcquisitionData((Image)images.get(0));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load image acquisition data.");
        }
        return null;
    }

    Object loadChannelAcquisitionData(long channelID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(channelID);
            List l = service.loadChannelAcquisitionData(ids);
            if (l != null && l.size() == 1) {
                LogicalChannel lc = (LogicalChannel)l.get(0);
                return new ChannelAcquisitionData(lc);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e, "Cannot load channel acquisition data.");
            return null;
        }
    }

    IObject getEnumeration(Class klass, String value) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            return service.findByString(klass.getName(), "value", value);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the enumeration's value.");
            return null;
        }
    }

    List<EnumerationObject> getEnumerations(String klassName) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            List<EnumerationObject> r = this.enumerations.get(klassName);
            if (r != null) {
                return r;
            }
            IPixelsPrx service = this.getPixelsService();
            List l = service.getAllEnumerations(klassName);
            r = new ArrayList<EnumerationObject>();
            if (l == null) {
                return r;
            }
            Iterator i = l.iterator();
            while (i.hasNext()) {
                r.add(new EnumerationObject(i.next()));
            }
            this.enumerations.put(klassName, r);
            return r;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the enumeration's value.");
            return new ArrayList<EnumerationObject>();
        }
    }

    Collection loadTags(Long id, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(id);
            Map m = service.loadTagContent(ids, options);
            if (m == null || m.size() == 0) {
                return new ArrayList();
            }
            return PojoMapper.asDataObjects((Collection)m.get(id));
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the Tags.");
            return new ArrayList();
        }
    }

    Collection loadTagSets(Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            ArrayList<TagAnnotationData> result = new ArrayList<TagAnnotationData>();
            IMetadataPrx service = this.getMetadataService();
            List list = service.loadTagSets(options);
            if (list == null) {
                return result;
            }
            Iterator i = list.iterator();
            HashMap<Long, TagAnnotationData> sets = new HashMap<Long, TagAnnotationData>();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                TagAnnotationData tagSet;
                IObject object = (IObject)i.next();
                if (object instanceof TagAnnotation) {
                    result.add(new TagAnnotationData((TagAnnotation)object));
                    continue;
                }
                if (!(object instanceof AnnotationAnnotationLink)) continue;
                AnnotationAnnotationLink link = (AnnotationAnnotationLink)object;
                Annotation parent = link.getParent();
                Annotation child = link.getChild();
                Long id = parent.getId().getValue();
                if (sets.get(id) == null) {
                    tagSet = new TagAnnotationData((TagAnnotation)parent);
                    sets.put(id, tagSet);
                    result.add(tagSet);
                    tagSet.setTags(new HashSet());
                } else {
                    tagSet = (TagAnnotationData)sets.get(parent.getId().getValue());
                }
                Set tags = tagSet.getTags();
                tags.add(new TagAnnotationData((TagAnnotation)child));
                ids.add(child.getId().getValue());
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the Tags.");
            return new ArrayList();
        }
    }

    List<IObject> loadPlaneInfo(long pixelsID, int z, int t, int channel) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IQueryPrx service = this.getQueryService();
        StringBuilder sb = new StringBuilder();
        ParametersI param = new ParametersI();
        sb.append("select info from PlaneInfo as info ");
        sb.append("where pixels.id = :id");
        param.addLong("id", pixelsID);
        if (z >= 0) {
            sb.append(" and info.theZ = :z");
            param.map.put("z", rtypes.rint((int)z));
        }
        if (t >= 0) {
            sb.append(" and info.theT = :t");
            param.map.put("t", rtypes.rint((int)t));
        }
        if (channel >= 0) {
            sb.append(" and info.theC = :c");
            param.map.put("c", rtypes.rint((int)channel));
        }
        try {
            return service.findAllByQuery(sb.toString(), (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the plane info for pixels: " + pixelsID);
            return new ArrayList<IObject>();
        }
    }

    void fillEnumerations() throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        this.getEnumerations(OmeroMetadataService.IMMERSION);
        this.getEnumerations(OmeroMetadataService.CORRECTION);
        this.getEnumerations(OmeroMetadataService.MEDIUM);
        this.getEnumerations(OmeroMetadataService.FORMAT);
        this.getEnumerations(OmeroMetadataService.DETECTOR_TYPE);
        this.getEnumerations(OmeroMetadataService.BINNING);
        this.getEnumerations(OmeroMetadataService.CONTRAST_METHOD);
        this.getEnumerations(OmeroMetadataService.ILLUMINATION_TYPE);
        this.getEnumerations(OmeroMetadataService.PHOTOMETRIC_INTERPRETATION);
        this.getEnumerations(OmeroMetadataService.ACQUISITION_MODE);
        this.getEnumerations(OmeroMetadataService.LASER_MEDIUM);
        this.getEnumerations(OmeroMetadataService.LASER_TYPE);
        this.getEnumerations(OmeroMetadataService.LASER_PULSE);
        this.getEnumerations(OmeroMetadataService.ARC_TYPE);
        this.getEnumerations(OmeroMetadataService.FILAMENT_TYPE);
        this.getEnumerations(OmeroMetadataService.FILTER_TYPE);
        this.getEnumerations(OmeroMetadataService.MICROSCOPE_TYPE);
    }

    List<IObject> removeObject(Class objectType, Long objectID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IDeletePrx service = this.getDeleteService();
            if (ImageData.class.equals((Object)objectType)) {
                List r = service.checkImageDelete(objectID.longValue(), false);
                if (r == null || r.size() == 0) {
                    service.deleteImage(objectID.longValue(), true);
                    return r;
                }
                return r;
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot delete: " + objectType + " " + objectID);
        }
        return new ArrayList<IObject>();
    }

    Object deleteImage(Image object) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IDeletePrx service = this.getDeleteService();
            service.deleteImage(object.getId().getValue(), true);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot delete the image: " + object.getId());
        }
        return new ArrayList();
    }

    List<IObject> checkImage(Image object) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IDeletePrx service = this.getDeleteService();
            return service.checkImageDelete(object.getId().getValue(), true);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot delete the image: " + object.getId());
            return new ArrayList<IObject>();
        }
    }

    ScriptCallback createMovie(long imageID, long pixelsID, long userID, List<Integer> channels, MovieExportParam param) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IScriptPrx svc = this.getScriptService();
            ArrayList<RLong> set = new ArrayList<RLong>(channels.size());
            Iterator<Integer> i = channels.iterator();
            while (i.hasNext()) {
                set.add(rtypes.rlong((long)i.next().intValue()));
            }
            long id = svc.getScriptID(param.getScriptName());
            if (id <= 0L) {
                return null;
            }
            RenderingDef def = null;
            int startZ = param.getStartZ();
            int endZ = param.getEndZ();
            if (!param.isZSectionSet()) {
                def = this.getRenderingDef(pixelsID, userID);
                startZ = def.getDefaultZ().getValue();
                endZ = def.getDefaultZ().getValue();
            }
            int startT = param.getStartT();
            int endT = param.getEndT();
            if (!param.isTimeIntervalSet()) {
                if (def == null) {
                    def = this.getRenderingDef(pixelsID, userID);
                }
                startT = def.getDefaultT().getValue();
                endT = def.getDefaultT().getValue();
            }
            HashMap<String, RType> map = new HashMap<String, RType>();
            map.put("Image_ID", (RType)rtypes.rlong((long)imageID));
            map.put("Movie_Name", (RType)rtypes.rstring((String)param.getName()));
            map.put("Z_Start", (RType)rtypes.rint((int)startZ));
            map.put("Z_End", (RType)rtypes.rint((int)endZ));
            map.put("T_Start", (RType)rtypes.rint((int)startT));
            map.put("T_End", (RType)rtypes.rint((int)endT));
            map.put("Channels", (RType)rtypes.rlist(set));
            map.put("FPS", (RType)rtypes.rint((int)param.getFps()));
            map.put("Show_Plane_Info", (RType)rtypes.rbool((boolean)param.isLabelVisible()));
            map.put("Show_Time", (RType)rtypes.rbool((boolean)param.isLabelVisible()));
            map.put("Split_View", (RType)rtypes.rbool((boolean)false));
            map.put("Scalebar", (RType)rtypes.rint((int)param.getScaleBar()));
            map.put("Format", (RType)rtypes.rstring((String)param.getFormatAsString()));
            if (param.getColor() != null) {
                map.put("Overlay_Colour", (RType)rtypes.rstring((String)param.getColor()));
            }
            return this.runScript(id, map);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create a movie for image: " + imageID);
            return null;
        }
    }

    List<ScriptObject> loadRunnableScripts() throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<ScriptObject> scripts = new ArrayList<ScriptObject>();
        try {
            ScriptObject script;
            RString value;
            IScriptPrx svc = this.getScriptService();
            List storedScripts = svc.getScripts();
            if (storedScripts == null || storedScripts.size() == 0) {
                return scripts;
            }
            Iterator j = storedScripts.iterator();
            String v = null;
            while (j.hasNext()) {
                OriginalFile of = (OriginalFile)j.next();
                value = of.getName();
                v = of.getPath().getValue() + value.getValue();
                if (SCRIPTS_NOT_AVAILABLE_TO_USER.contains(v)) continue;
                script = new ScriptObject(of.getId().getValue(), of.getPath().getValue(), of.getName().getValue());
                value = of.getMimetype();
                if (value != null) {
                    script.setMIMEType(value.getValue());
                }
                scripts.add(script);
            }
            storedScripts = svc.getUserScripts(new ArrayList());
            for (OriginalFile of : storedScripts) {
                value = of.getName();
                script = new ScriptObject(of.getId().getValue(), of.getPath().getValue(), of.getName().getValue());
                value = of.getMimetype();
                if (value != null) {
                    script.setMIMEType(value.getValue());
                }
                script.setOfficial(false);
                scripts.add(script);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the scripts. ");
        }
        return scripts;
    }

    List<ScriptObject> loadRunnableScriptsWithUI() throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<ScriptObject> scripts = new ArrayList<ScriptObject>();
        try {
            IScriptPrx svc = this.getScriptService();
            List storedScripts = svc.getScripts();
            if (storedScripts == null || storedScripts.size() == 0) {
                return scripts;
            }
            Iterator j = storedScripts.iterator();
            String v = null;
            while (j.hasNext()) {
                OriginalFile of = (OriginalFile)j.next();
                RString value = of.getName();
                v = of.getPath().getValue() + value.getValue();
                if (!SCRIPTS_UI_AVAILABLE.contains(v)) continue;
                ScriptObject script = new ScriptObject(of.getId().getValue(), of.getPath().getValue(), of.getName().getValue());
                value = of.getMimetype();
                if (value != null) {
                    script.setMIMEType(value.getValue());
                }
                scripts.add(script);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the scripts with UI. ");
        }
        return scripts;
    }

    ScriptObject loadScript(long scriptID) throws ProcessException {
        this.isSessionAlive();
        ScriptObject script = null;
        try {
            IScriptPrx svc = this.getScriptService();
            script = new ScriptObject(scriptID, "", "");
            script.setJobParams(svc.getParams(scriptID));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProcessException("Cannot load the script: " + scriptID, e);
        }
        return script;
    }

    Map<Long, String> getScriptsAsString() throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IScriptPrx svc = this.getScriptService();
            List scripts = svc.getScripts();
            HashMap<Long, String> m = new HashMap<Long, String>();
            if (scripts != null) {
                Iterator i = scripts.iterator();
                String name = null;
                while (i.hasNext()) {
                    OriginalFile of = (OriginalFile)i.next();
                    RString v = of.getName();
                    if (v != null) {
                        name = v.getValue();
                    }
                    if (name == null) continue;
                    m.put(of.getId().getValue(), name);
                }
            }
            return m;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the scripts. ");
            return new HashMap<Long, String>();
        }
    }

    private RType convertValue(Object value) {
        if (value instanceof String) {
            return rtypes.rstring((String)((String)value));
        }
        if (value instanceof Boolean) {
            return rtypes.rbool((boolean)((Boolean)value));
        }
        if (value instanceof Long) {
            return rtypes.rlong((long)((Long)value));
        }
        if (value instanceof Integer) {
            return rtypes.rint((int)((Integer)value));
        }
        if (value instanceof Float) {
            return rtypes.rfloat((float)((Float)value).floatValue());
        }
        if (value instanceof List) {
            List l = (List)value;
            Iterator i = l.iterator();
            ArrayList<RType> list = new ArrayList<RType>(l.size());
            while (i.hasNext()) {
                list.add(this.convertValue(i.next()));
            }
            return rtypes.rlist(list);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            HashMap<String, RType> m = new HashMap<String, RType>();
            for (Map.Entry entry : map.entrySet()) {
                m.put((String)entry.getKey(), this.convertValue(entry.getValue()));
            }
            return rtypes.rmap(m);
        }
        return null;
    }

    ScriptCallback createFigure(List<Long> objectIDs, Class type, FigureParam param, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            List<Integer> splitActive;
            IScriptPrx svc = this.getScriptService();
            String scriptName = param.getScriptName();
            int scriptIndex = param.getIndex();
            long id = svc.getScriptID(scriptName);
            if (id <= 0L) {
                return null;
            }
            ArrayList<RLong> ids = new ArrayList<RLong>(objectIDs.size());
            Iterator<Long> i = objectIDs.iterator();
            while (i.hasNext()) {
                ids.add(rtypes.rlong((long)i.next()));
            }
            HashMap<String, RType> map = new HashMap<String, RType>();
            if (scriptIndex == 2) {
                DataObject d = param.getAnchor();
                long parentID = -1L;
                if (d instanceof DatasetData || d instanceof ProjectData) {
                    parentID = d.getId();
                }
                if (ImageData.class.equals((Object)type)) {
                    map.put("Data_Type", (RType)rtypes.rstring((String)"Image"));
                    map.put("IDs", (RType)rtypes.rlist(ids));
                } else if (DatasetData.class.equals((Object)type)) {
                    map.put("Data_Type", (RType)rtypes.rstring((String)"Dataset"));
                    map.put("IDs", (RType)rtypes.rlist(ids));
                }
                List<Long> tags = param.getTags();
                if (tags != null && tags.size() > 0) {
                    ids = new ArrayList(tags.size());
                    i = tags.iterator();
                    while (i.hasNext()) {
                        ids.add(rtypes.rlong((long)i.next()));
                    }
                    map.put("Tag_IDs", (RType)rtypes.rlist(ids));
                }
                if (parentID > 0L) {
                    map.put("Parent_ID", (RType)rtypes.rlong((long)parentID));
                }
                map.put("Show_Untagged_Images", (RType)rtypes.rbool((boolean)param.isIncludeUntagged()));
                map.put("Thumbnail_Size", (RType)rtypes.rint((int)param.getWidth()));
                map.put("Max_Columns", (RType)rtypes.rint((int)param.getHeight()));
                map.put("Format", (RType)rtypes.rstring((String)param.getFormatAsString()));
                map.put("Figure_Name", (RType)rtypes.rstring((String)param.getName()));
                return this.runScript(id, map);
            }
            LinkedHashMap<String, RLong> merge = new LinkedHashMap<String, RLong>();
            Map<Integer, Integer> mergeChannels = param.getMergeChannels();
            if (mergeChannels != null) {
                for (Map.Entry<Integer, Integer> entry : mergeChannels.entrySet()) {
                    merge.put("" + entry.getKey(), rtypes.rlong((long)entry.getValue().intValue()));
                }
            }
            LinkedHashMap<String, RString> split = new LinkedHashMap<String, RString>();
            Map<Integer, String> splitChannels = param.getSplitChannels();
            if (splitChannels != null) {
                for (Map.Entry<Integer, Object> entry : splitChannels.entrySet()) {
                    split.put("" + entry.getKey(), rtypes.rstring((String)((String)entry.getValue())));
                }
            }
            if ((splitActive = param.getSplitActive()) != null && splitActive.size() > 0) {
                ArrayList<RInt> sa = new ArrayList<RInt>(splitActive.size());
                Iterator<Integer> k = splitActive.iterator();
                while (k.hasNext()) {
                    sa.add(rtypes.rint((int)k.next()));
                }
                map.put("Split_Indexes", (RType)rtypes.rlist(sa));
            }
            map.put("Merged_Names", (RType)rtypes.rbool((boolean)param.getMergedLabel()));
            map.put("Image_IDs", (RType)rtypes.rlist(ids));
            if (param.getStartZ() >= 0) {
                map.put("Z_Start", (RType)rtypes.rint((int)param.getStartZ()));
            }
            if (param.getEndZ() >= 0) {
                map.put("Z_End", (RType)rtypes.rint((int)param.getEndZ()));
            }
            if (split.size() > 0) {
                map.put("Channel_Names", (RType)rtypes.rmap(split));
            }
            if (merge.size() > 0) {
                map.put("Merged_Colours", (RType)rtypes.rmap(merge));
            }
            if (scriptIndex == 3) {
                List<Integer> times = param.getTimepoints();
                ArrayList<RInt> ts = new ArrayList<RInt>(objectIDs.size());
                Iterator<Integer> k = times.iterator();
                while (k.hasNext()) {
                    ts.add(rtypes.rint((int)k.next()));
                }
                map.put("T_Indexes", (RType)rtypes.rlist(ts));
                map.put("Time_Units", (RType)rtypes.rstring((String)param.getTimeAsString()));
            } else {
                map.put("Split_Panels_Grey", (RType)rtypes.rbool((boolean)param.isSplitGrey()));
            }
            if (param.getScaleBar() > 0) {
                map.put("Scalebar", (RType)rtypes.rint((int)param.getScaleBar()));
            }
            map.put("Overlay_Colour", (RType)rtypes.rstring((String)param.getColor()));
            map.put("Width", (RType)rtypes.rint((int)param.getWidth()));
            map.put("Height", (RType)rtypes.rint((int)param.getHeight()));
            map.put("Stepping", (RType)rtypes.rint((int)param.getStepping()));
            map.put("Format", (RType)rtypes.rstring((String)param.getFormatAsString()));
            map.put("Algorithm", (RType)rtypes.rstring((String)param.getProjectionTypeAsString()));
            map.put("Figure_Name", (RType)rtypes.rstring((String)param.getName()));
            map.put("Image_Labels", (RType)rtypes.rstring((String)param.getLabelAsString()));
            if (scriptIndex == 1) {
                map.put("ROI_Zoom", (RType)rtypes.rfloat((float)((float)param.getMagnificationFactor())));
            }
            return this.runScript(id, map);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create a figure for the specified images.");
            return null;
        }
    }

    Object importImage(DataObject container, File file, StatusLabel status, boolean archived, String name) throws ImportException {
        try {
            List<Pixels> pixels;
            ImportLibrary importLibrary = new ImportLibrary(this.getImportStore(), new OMEROWrapper(new ImportConfig()));
            importLibrary.addObserver(status);
            IObject object = null;
            if (container != null) {
                object = container.asIObject();
            }
            if (name != null && name.trim().length() == 0) {
                name = null;
            }
            if ((pixels = importLibrary.importImage(file, 0, 0, 1, name, null, archived, true, null, object)) != null && pixels.size() > 0) {
                Pixels p = pixels.get(0);
                long id = p.getImage().getId().getValue();
                return this.getImage(id, new Parameters());
            }
        }
        catch (Throwable e) {
            String message = this.getImportFailureMessage(e);
            throw new ImportException(message, e, this.getReaderType());
        }
        return null;
    }

    Object importFolder(DataObject container, File file, StatusLabel status, boolean archived, int depth) throws ImportException {
        try {
            ImportConfig config = new ImportConfig();
            OMEROWrapper reader = new OMEROWrapper(config);
            ImportLibrary library = new ImportLibrary(this.getImportStore(), reader);
            library.addObserver(status);
            String[] paths = new String[]{file.getAbsolutePath()};
            ImportCandidates candidates = new ImportCandidates(reader, paths, status);
            ArrayList<String> containers = new ArrayList<String>(candidates.getPaths());
            IObject object = null;
            if (container != null) {
                object = container.asIObject();
            }
            List<Pixels> pixels = null;
            HashMap<File, ImportException> results = new HashMap<File, ImportException>();
            if (containers != null && containers.size() > 0) {
                Iterator i = containers.iterator();
                int count = 0;
                int total = containers.size();
                while (i.hasNext()) {
                    String path = (String)i.next();
                    File f = new File(path);
                    String name = UIUtilities.getDisplayedFileName(f.getAbsolutePath(), depth);
                    try {
                        pixels = library.importImage(f, count, total - count, total, name, null, archived, true, null, object);
                        ++count;
                    }
                    catch (Throwable e) {
                        String message = this.getImportFailureMessage(e);
                        results.put(f, new ImportException(message, e, this.getReaderType()));
                    }
                }
            }
            return results;
        }
        catch (Throwable e) {
            String message = this.getImportFailureMessage(e);
            return null;
        }
    }

    String getReaderType() {
        try {
            String reader = this.getImportStore().getReader().getFormat();
            if (reader != null) {
                return reader;
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    void removeREService(long pixelsID) {
        this.reServices.remove(pixelsID);
    }

    DataObject loadFolder(String absolutePath) throws DSOutOfServiceException, DSAccessException {
        return null;
    }

    Object loadInstrument(long id) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service;
            Instrument instrument;
            StringBuilder sb = new StringBuilder();
            sb.append("select inst from Instrument as inst ");
            sb.append("left outer join fetch inst.microscope as m ");
            sb.append("left outer join fetch m.type ");
            sb.append("left outer join fetch inst.objective as o ");
            sb.append("left outer join fetch o.immersion ");
            sb.append("left outer join fetch o.correction ");
            sb.append("left outer join fetch inst.detector as d ");
            sb.append("left outer join fetch d.type ");
            sb.append("left outer join fetch inst.filter as f ");
            sb.append("left outer join fetch f.type ");
            sb.append("left outer join fetch f.transmittanceRange as trans ");
            sb.append("left outer join fetch inst.filterSet as fs ");
            sb.append("left outer join fetch fs.dichroic as dichroic ");
            sb.append("left outer join fetch inst.dichroic as di ");
            sb.append("left outer join fetch inst.otf as otf ");
            sb.append("left outer join fetch otf.pixelsType as type ");
            sb.append("left outer join fetch otf.objective as obj ");
            sb.append("left outer join fetch obj.immersion ");
            sb.append("left outer join fetch obj.correction ");
            sb.append("left outer join fetch otf.filterSet ");
            sb.append("left outer join fetch inst.lightSource as ls ");
            sb.append("where inst.id = :id ");
            ParametersI params = new ParametersI();
            params.addId(id);
            Instrument value = (Instrument)this.getQueryService().findByQuery(sb.toString(), (Parameters)params);
            if (value == null) {
                return null;
            }
            List ll = value.copyLightSource();
            if (ll != null) {
                Iterator i = ll.iterator();
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<LightSource> list = new ArrayList<LightSource>();
                while (i.hasNext()) {
                    LightSource ls = (LightSource)i.next();
                    String name = ls.getClass().getName();
                    if (ls instanceof LightEmittingDiode) {
                        list.add(ls);
                        continue;
                    }
                    if (names.contains(name)) continue;
                    names.add(name);
                    sb = this.createLightQuery(ls);
                    if (sb == null) continue;
                    params.addLong("instrumentId", id);
                    list.addAll(this.getQueryService().findAllByQuery(sb.toString(), (Parameters)params));
                }
                value.clearLightSource();
                ArrayList<LightSource> srcs = new ArrayList<LightSource>();
                Iterator j = list.iterator();
                while (j.hasNext()) {
                    srcs.add((LightSource)j.next());
                }
                value.addAllLightSourceSet(srcs);
            }
            if ((instrument = (service = this.getMetadataService()).loadInstrument(id)) == null) {
                return null;
            }
            return new InstrumentData(instrument);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the instrument: " + id);
            return null;
        }
    }

    List<TableResult> loadTabularData(TableParameters parameters, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        TablePrx tablePrx = null;
        long id2 = -1L;
        ArrayList<TableResult> results = new ArrayList<TableResult>();
        try {
            List<Long> ids;
            if (parameters.getNodeType() != null) {
                ArrayList<Long> objects = new ArrayList<Long>(1);
                objects.add(parameters.getNodeID());
                Map map = this.loadAnnotations(parameters.getNodeType(), objects, null, null, new Parameters());
                Collection list = (Collection)map.get(parameters.getNodeID());
                Iterator j = list.iterator();
                ids = new ArrayList<Long>();
                while (j.hasNext()) {
                    FileAnnotationData fa;
                    Object k = j.next();
                    if (!(k instanceof FileAnnotationData) || !"openmicroscopy.org/omero/bulk_annotations".equals((fa = (FileAnnotationData)k).getNameSpace())) continue;
                    ids.add(fa.getFileID());
                }
            } else {
                ids = parameters.getOriginalFileIDs();
            }
            if (ids != null && ids.size() > 0) {
                for (long id2 : ids) {
                    tablePrx = this.getSharedResources().openTable((OriginalFile)new OriginalFileI(id2, false));
                    if (tablePrx == null) continue;
                    long[] rows = new long[(int)tablePrx.getNumberOfRows()];
                    for (int j = 0; j < rows.length; ++j) {
                        rows[j] = j;
                    }
                    TableResult result = this.createTableResult(tablePrx, rows);
                    if (result == null) continue;
                    results.add(result);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the table: " + id2);
        }
        return results;
    }

    private StringBuilder createLightQuery(LightSource src) {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (src instanceof Laser) {
            sb.append("select l from Laser as l ");
            sb.append("left outer join fetch l.type ");
            sb.append("left outer join fetch l.laserMedium ");
            sb.append("left outer join fetch l.pulse as pulse ");
            sb.append("where l.instrument.id = :instrumentId");
        } else if (src instanceof Filament) {
            sb.append("select l from Filament as l ");
            sb.append("left outer join fetch l.type ");
            sb.append("where l.instrument.id = :instrumentId");
        } else if (src instanceof Arc) {
            sb.append("select l from Arc as l ");
            sb.append("left outer join fetch l.type ");
            sb.append("where l.instrument.id = :instrumentId");
        }
        return sb;
    }

    List<ROIResult> loadROI(long imageID, List<Long> measurements, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<ROIResult> results = new ArrayList<ROIResult>();
        try {
            IRoiPrx svc = this.getROIService();
            RoiOptions options = new RoiOptions();
            options.userId = rtypes.rlong((long)userID);
            if (measurements == null || measurements.size() == 0) {
                RoiResult r = svc.findByImage(imageID, new RoiOptions());
                if (r == null) {
                    return results;
                }
                results.add(new ROIResult(PojoMapper.asDataObjects(r.rois)));
            } else {
                Map map = svc.getMeasuredRoisMap(imageID, measurements, options);
                if (map == null) {
                    return results;
                }
                for (Long id : map.keySet()) {
                    RoiResult r = (RoiResult)map.get(id);
                    ROIResult result = new ROIResult(PojoMapper.asDataObjects(r.rois), id);
                    result.setResult(this.createTableResult(svc.getTable(id.longValue()), "Image", imageID));
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the ROI for image: " + imageID);
        }
        return results;
    }

    List<ROIData> saveROI(long imageID, long userID, List<ROIData> roiList) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IUpdatePrx updateService = this.getUpdateService();
            IRoiPrx svc = this.getROIService();
            RoiOptions options = new RoiOptions();
            options.userId = rtypes.rlong((long)userID);
            RoiResult serverReturn = svc.findByImage(imageID, new RoiOptions());
            HashMap<Long, ROIData> roiMap = new HashMap<Long, ROIData>();
            List serverRoiList = serverReturn.rois;
            HashMap<Long, ROIData> clientROIMap = new HashMap<Long, ROIData>();
            for (ROIData roi : roiList) {
                clientROIMap.put(roi.getId(), roi);
            }
            for (ROIData roi : serverRoiList) {
                if (!clientROIMap.containsKey(roi.getId().getValue())) {
                    if (roi.getDetails().getOwner().getId().getValue() != userID) continue;
                    for (int i = 0; i < roi.sizeOfShapes(); ++i) {
                        updateService.deleteObject((IObject)roi.getShape(i));
                    }
                    updateService.deleteObject((IObject)roi);
                    continue;
                }
                roiMap.put(roi.getId().getValue(), roi);
            }
            for (ROIData roi : roiList) {
                Shape s;
                ShapeData shape;
                if (!roiMap.containsKey(roi.getId())) {
                    updateService.saveAndReturnObject(roi.asIObject());
                    continue;
                }
                Roi serverRoi = (Roi)roiMap.get(roi.getId());
                Iterator shapeIterator = roi.getIterator();
                HashMap<ROICoordinate, ShapeData> clientCoordMap = new HashMap<ROICoordinate, ShapeData>();
                while (shapeIterator.hasNext()) {
                    List shapeList = (List)shapeIterator.next();
                    shape = (ShapeData)shapeList.get(0);
                    if (shape == null) continue;
                    clientCoordMap.put(shape.getROICoordinate(), shape);
                }
                HashMap<ROICoordinate, Shape> serverCoordMap = new HashMap<ROICoordinate, Shape>();
                for (int i = 0; i < serverRoi.sizeOfShapes(); ++i) {
                    s = serverRoi.getShape(i);
                    if (s == null) continue;
                    serverCoordMap.put(new ROICoordinate(s.getTheZ().getValue(), s.getTheT().getValue()), s);
                }
                for (ROICoordinate coord : serverCoordMap.keySet()) {
                    if (clientCoordMap.containsKey(coord)) continue;
                    s = (Shape)serverCoordMap.get(coord);
                    updateService.deleteObject((IObject)s);
                }
                long id = serverRoi.getId().getValue();
                RoiResult tempResults = svc.findByImage(imageID, new RoiOptions());
                for (Roi r : tempResults.rois) {
                    if (r.getId().getValue() != id) continue;
                    serverRoi = r;
                }
                for (ROICoordinate coord : clientCoordMap.keySet()) {
                    shape = (ShapeData)clientCoordMap.get(coord);
                    if (shape == null) continue;
                    if (!serverCoordMap.containsKey(coord)) {
                        serverRoi.addShape((Shape)shape.asIObject());
                        continue;
                    }
                    if (!shape.isDirty()) continue;
                    int shapeIndex = -1;
                    for (int j = 0; j < serverRoi.sizeOfShapes(); ++j) {
                        Shape serverShape;
                        if (serverRoi == null || (serverShape = serverRoi.getShape(j)) == null || serverShape.getId().getValue() != shape.getId()) continue;
                        shapeIndex = j;
                        break;
                    }
                    if (shapeIndex == -1) {
                        throw new Exception("serverRoi.shapeList is corrupted");
                    }
                    serverRoi.setShape(shapeIndex, (Shape)shape.asIObject());
                }
                serverRoi.setDescription(((Roi)roi.asIObject()).getDescription());
                serverRoi.setNamespaces(((Roi)roi.asIObject()).getNamespaces());
                serverRoi.setKeywords(((Roi)roi.asIObject()).getKeywords());
                updateService.saveAndReturnObject((IObject)serverRoi);
            }
            return roiList;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot Save the ROI for image: " + imageID);
            return new ArrayList<ROIData>();
        }
    }

    Collection loadROIMeasurements(long imageID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IRoiPrx svc = this.getROIService();
            RoiOptions options = new RoiOptions();
            options.userId = rtypes.rlong((long)userID);
            Set files = PojoMapper.asDataObjects(svc.getRoiMeasurements(imageID, options));
            ArrayList<TableResult> results = new ArrayList<TableResult>();
            if (files != null) {
                for (FileAnnotationData fa : files) {
                    if (OVERLAYS.equals(fa.getDescription())) {
                        long tableID = fa.getId();
                        TableResult table = this.createOverlay(imageID, svc.getTable(tableID));
                        if (table == null) continue;
                        table.setTableID(tableID);
                        results.add(table);
                        continue;
                    }
                    results.add((TableResult)fa);
                }
            }
            return results;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the ROI measurements for image: " + imageID);
            return new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File exportImageAsOMETiff(File f, long imageID) throws DSAccessException, DSOutOfServiceException {
        this.isSessionAlive();
        FileOutputStream stream = null;
        try {
            ExporterPrx store = null;
            stream = new FileOutputStream(f);
            try {
                Object object = new Object();
                synchronized (object) {
                    block23: {
                        store = this.getExporterService();
                        store.addImage(imageID);
                        long size = store.generateTiff();
                        int offset = 0;
                        int length = (int)size;
                        try {
                            try {
                                offset = 0;
                                while ((long)(offset + 262144) < size) {
                                    stream.write(store.read((long)offset, 262144));
                                    offset += 262144;
                                }
                            }
                            finally {
                                stream.write(store.read((long)offset, length - offset));
                                stream.close();
                            }
                        }
                        catch (Exception e) {
                            if (stream != null) {
                                stream.close();
                            }
                            if (f == null) break block23;
                            f.delete();
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 8] lbl33 : MonitorExitStatement: MONITOREXIT : var6_6
                }
            }
            finally {
                try {
                    if (store != null) {
                        store.close();
                    }
                }
                catch (Exception e) {}
                return f;
            }
        }
        catch (Throwable t) {
            this.exporterService = null;
            if (f != null) {
                f.delete();
            }
            try {
                this.exporterService.close();
                this.exporterService = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            this.handleException(t, "Cannot export the image as an OME-TIFF");
            return null;
        }
    }

    long analyseFRAP(List<Long> ids, Class objectType, Object param) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        return -1L;
    }

    ScriptCallback runScript(ScriptObject script) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            long id = script.getScriptID();
            if (id < 0L) {
                return null;
            }
            return this.runScript(id, script.getValueToPass());
        }
        catch (Exception e) {
            this.handleException(e, "Cannot run the script.");
            return null;
        }
    }

    Object uploadScript(ScriptObject script, boolean official) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IScriptPrx svc = this.getScriptService();
            FileInputStream stream = null;
            StringBuffer buf = new StringBuffer("");
            try {
                int c;
                File file = new File(script.getPath());
                stream = new FileInputStream(file);
                while ((c = stream.read()) != -1) {
                    buf.append((char)c);
                }
            }
            catch (Exception e) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.handleException(e, "Cannot upload the script: " + script.getName() + ".");
                return -1;
            }
            if (official) {
                return svc.uploadOfficialScript(script.getFolder(), buf.toString());
            }
            return svc.uploadScript(script.getFolder(), buf.toString());
        }
        catch (Exception e) {
            this.handleException(e, "Cannot upload the script: " + script.getName() + ".");
            return -1;
        }
    }

    List<ExperimenterData> createExperimenters(AdminObject object) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<ExperimenterData> results = new ArrayList<ExperimenterData>();
        try {
            IAdminPrx svc = this.getAdminService();
            Map<ExperimenterData, UserCredentials> m = object.getExperimenters();
            Iterator<Map.Entry<ExperimenterData, UserCredentials>> i = m.entrySet().iterator();
            List<GroupData> groups = object.getGroups();
            ExperimenterGroup g = null;
            ArrayList<ExperimenterGroup> l = new ArrayList<ExperimenterGroup>();
            if (groups != null && groups.size() >= 1) {
                g = groups.get(0).asGroup();
                Iterator<GroupData> j = groups.iterator();
                while (j.hasNext()) {
                    l.add(j.next().asGroup());
                }
            }
            boolean systemGroup = false;
            while (i.hasNext()) {
                Map.Entry<ExperimenterData, UserCredentials> entry = i.next();
                Experimenter exp = (Experimenter)ModelMapper.createIObject((DataObject)entry.getKey());
                UserCredentials uc = entry.getValue();
                Experimenter value = this.lookupExperimenter(uc.getUserName());
                if (value != null) continue;
                if (uc.isAdministrator().booleanValue()) {
                    l.add(this.getSystemGroup("user"));
                    l.add(this.getSystemGroup("system"));
                } else {
                    l.add(this.getSystemGroup("user"));
                }
                if (g == null) {
                    g = (ExperimenterGroup)l.get(0);
                    systemGroup = true;
                }
                exp.setOmeName(rtypes.rstring((String)uc.getUserName()));
                String password = uc.getPassword();
                long id = password != null && password.length() > 0 ? svc.createExperimenterWithPassword(exp, rtypes.rstring((String)password), g, l) : svc.createExperimenter(exp, g, l);
                exp = svc.getExperimenter(id);
                if (uc.isOwner().booleanValue() && !systemGroup) {
                    svc.setGroupOwner(g, exp);
                }
                results.add((ExperimenterData)PojoMapper.asDataObject((IObject)exp));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create the experimenters.");
        }
        return results;
    }

    GroupData createGroup(AdminObject object) throws DSOutOfServiceException, DSAccessException {
        IAdminPrx svc = this.getAdminService();
        try {
            Map<ExperimenterData, UserCredentials> m = object.getExperimenters();
            Iterator<Map.Entry<ExperimenterData, UserCredentials>> i = m.entrySet().iterator();
            GroupData groupData = object.getGroup();
            ExperimenterGroup g = this.lookupGroup(groupData.getName());
            if (g != null) {
                return null;
            }
            g = (ExperimenterGroup)ModelMapper.createIObject((DataObject)groupData);
            long groupID = svc.createGroup(g);
            g = svc.getGroup(groupID);
            int level = object.getPermissions();
            if (level != 100) {
                Permissions p = g.getDetails().getPermissions();
                this.setPermissionsLevel(p, level);
                this.getAdminService().changePermissions((IObject)g, p);
            }
            ArrayList<ExperimenterGroup> list = new ArrayList<ExperimenterGroup>();
            list.add(g);
            ArrayList<ExperimenterGroup> l = new ArrayList<ExperimenterGroup>();
            GroupData defaultGroup = null;
            while (i.hasNext()) {
                Experimenter exp;
                Map.Entry<ExperimenterData, UserCredentials> entry = i.next();
                UserCredentials uc = entry.getValue();
                Experimenter value = this.lookupExperimenter(uc.getUserName());
                if (value != null) {
                    exp = value;
                    ExperimenterData expData = new ExperimenterData(exp);
                    defaultGroup = expData.getDefaultGroup();
                    if (this.isSystemGroup(defaultGroup.asGroup())) {
                        defaultGroup = null;
                    }
                } else {
                    exp = (Experimenter)ModelMapper.createIObject((DataObject)entry.getKey());
                    if (uc.isAdministrator().booleanValue()) {
                        l.add(this.getSystemGroup("system"));
                        l.add(this.getSystemGroup("user"));
                    } else {
                        l.add(this.getSystemGroup("user"));
                    }
                    exp.setOmeName(rtypes.rstring((String)uc.getUserName()));
                    String password = uc.getPassword();
                    long id = password != null && password.length() > 0 ? svc.createExperimenterWithPassword(exp, rtypes.rstring((String)password), g, l) : svc.createExperimenter(exp, g, l);
                    exp = svc.getExperimenter(id);
                }
                svc.setGroupOwner(g, exp);
                if (defaultGroup != null) continue;
                svc.setDefaultGroup(exp, g);
            }
            return (GroupData)PojoMapper.asDataObject((IObject)g);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create group and owner.");
            return null;
        }
    }

    Map<Long, Long> countExperimenters(List<Long> groupIds) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        HashMap<Long, Long> r = new HashMap<Long, Long>();
        try {
            IQueryPrx svc = this.getQueryService();
            ParametersI p = new ParametersI();
            p.addLongs("gids", groupIds);
            List list = svc.findAllByQuery("select m from GroupExperimenterMap as m left outer join fetch m.parent where m.parent.id in (:gids)", (Parameters)p);
            for (GroupExperimenterMap g : list) {
                Long l;
                Long l2;
                Long count;
                long id;
                ExperimenterGroup group = g.getParent();
                if (!this.isSystemGroup(group)) {
                    id = group.getId().getValue();
                    groupIds.remove(id);
                    count = (Long)r.get(id);
                    if (count == null) {
                        count = 0L;
                    }
                    l2 = count;
                    l = count = Long.valueOf(count + 1L);
                    r.put(id, count);
                    continue;
                }
                if (!"system".equals(group.getName().getValue())) continue;
                id = group.getId().getValue();
                groupIds.remove(id);
                count = (Long)r.get(id);
                if (count == null) {
                    count = 0L;
                }
                l2 = count;
                l = count = Long.valueOf(count + 1L);
                r.put(id, count);
            }
            if (groupIds.size() > 0) {
                Iterator<Object> i = groupIds.iterator();
                while (i.hasNext()) {
                    r.put((Long)i.next(), 0L);
                }
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the experimenters.");
        }
        return r;
    }

    List<GroupData> getGroups(long experimenterID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<GroupData> pojos = new ArrayList<GroupData>();
        if (experimenterID < 0L) {
            return pojos;
        }
        try {
            IQueryPrx svc = this.getQueryService();
            List groups = null;
            ParametersI p = new ParametersI();
            p.addId(experimenterID);
            groups = svc.findAllByQuery("select distinct g from ExperimenterGroup g left outer join fetch g.groupExperimenterMap m left outer join fetch m.child u  where u.id = :id", (Parameters)p);
            for (ExperimenterGroup group : groups) {
                if (this.isSystemGroup(group)) continue;
                pojos.add((GroupData)PojoMapper.asDataObject((IObject)group));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return pojos;
    }

    List<GroupData> loadGroups(long id) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<GroupData> pojos = new ArrayList<GroupData>();
        try {
            IQueryPrx svc = this.getQueryService();
            List groups = null;
            if (id < 0L) {
                groups = svc.findAllByQuery("select distinct g from ExperimenterGroup g ", null);
            } else {
                ParametersI p = new ParametersI();
                p.addId(id);
                groups = svc.findAllByQuery("select distinct g from ExperimenterGroup g left outer join fetch g.groupExperimenterMap m left outer join fetch m.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent where g.id = :id", (Parameters)p);
            }
            for (ExperimenterGroup group : groups) {
                GroupData pojoGroup = (GroupData)PojoMapper.asDataObject((IObject)group);
                if (!this.isSystemGroup(group)) {
                    pojos.add(pojoGroup);
                    continue;
                }
                if (!"system".equals(pojoGroup.getName())) continue;
                pojos.add(pojoGroup);
            }
            return pojos;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the available groups ");
            return pojos;
        }
    }

    List<ExperimenterData> deleteExperimenters(List<ExperimenterData> experimenters) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<ExperimenterData> r = new ArrayList<ExperimenterData>();
        IAdminPrx svc = this.getAdminService();
        for (ExperimenterData exp : experimenters) {
            try {
                svc.deleteExperimenter(exp.asExperimenter());
            }
            catch (Exception e) {
                r.add(exp);
            }
        }
        return r;
    }

    List<ExperimenterData> copyExperimenters(GroupData group, Collection experimenters) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<ExperimenterData> r = new ArrayList<ExperimenterData>();
        IAdminPrx svc = this.getAdminService();
        Iterator i = experimenters.iterator();
        ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
        groups.add(group.asGroup());
        while (i.hasNext()) {
            ExperimenterData exp = (ExperimenterData)i.next();
            try {
                svc.addGroups(exp.asExperimenter(), groups);
            }
            catch (Exception e) {
                r.add(exp);
            }
        }
        return r;
    }

    List<ExperimenterData> removeExperimenters(GroupData group, Collection experimenters) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<ExperimenterData> r = new ArrayList<ExperimenterData>();
        IAdminPrx svc = this.getAdminService();
        Iterator i = experimenters.iterator();
        String name = group.getName();
        ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
        groups.add(group.asGroup());
        while (i.hasNext()) {
            ExperimenterData exp = (ExperimenterData)i.next();
            try {
                svc.removeGroups(exp.asExperimenter(), groups);
            }
            catch (Exception e) {
                r.add(exp);
            }
        }
        return r;
    }

    List<GroupData> deleteGroups(List<GroupData> groups) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<GroupData> r = new ArrayList<GroupData>();
        IAdminPrx svc = this.getAdminService();
        for (GroupData g : groups) {
            try {
                svc.deleteGroup(g.asGroup());
            }
            catch (Exception e) {
                r.add(g);
            }
        }
        return r;
    }

    void resetPassword(String userName, long userID, String password) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IAdminPrx svc = this.getAdminService();
        try {
            svc.changeUserPassword(userName, rtypes.rstring((String)password));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify the password for:" + userName);
        }
    }

    boolean resetUserName(String userName, ExperimenterData experimenter) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IAdminPrx svc = this.getAdminService();
        try {
            Experimenter value = this.lookupExperimenter(userName);
            if (value == null) {
                Experimenter exp = experimenter.asExperimenter();
                exp.setOmeName(rtypes.rstring((String)userName));
                this.getAdminService().updateExperimenter(exp);
                return true;
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify the loginName for:" + experimenter.getId());
        }
        return false;
    }

    void reportForgottenPassword(String userName, String email) throws DSOutOfServiceException, DSAccessException {
    }

    void setPermissionsLevel(Permissions p, int level) {
        switch (level) {
            case 101: {
                p.setGroupRead(true);
                break;
            }
            case 102: {
                p.setGroupRead(true);
                p.setGroupWrite(true);
                break;
            }
            case 103: {
                p.setWorldRead(true);
                break;
            }
            case 104: {
                p.setWorldRead(true);
                p.setWorldWrite(true);
            }
        }
    }

    ExperimenterGroup lookupGroup(String name) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IAdminPrx svc = this.getAdminService();
        try {
            return svc.lookupGroup(name);
        }
        catch (Exception e) {
            if (e instanceof ApiUsageException) {
                return null;
            }
            this.handleException(e, "Cannot loade the required group.");
            return null;
        }
    }

    Experimenter lookupExperimenter(String name) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IAdminPrx svc = this.getAdminService();
        try {
            return svc.lookupExperimenter(name);
        }
        catch (Exception e) {
            if (e instanceof ApiUsageException) {
                return null;
            }
            this.handleException(e, "Cannot load the required group.");
            return null;
        }
    }

    List<WorkflowData> retrieveWorkflows(long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IQueryPrx svc = this.getQueryService();
        try {
            ParametersI param = new ParametersI();
            param.map.put("userID", rtypes.rlong((long)userID));
            List serverWorkflows = svc.findAllByQuery("from Namespace as n", (Parameters)param);
            return PojoMapper.asDataObjectsAsList(serverWorkflows);
        }
        catch (Throwable t) {
            return new ArrayList<WorkflowData>();
        }
    }

    Object storeWorkflows(List<WorkflowData> workflows, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IUpdatePrx updateService = this.getUpdateService();
        for (WorkflowData workflow : workflows) {
            if (!workflow.isDirty()) continue;
            try {
                updateService.saveObject(workflow.asIObject());
            }
            catch (ServerError e) {
                this.handleException(e, "Unable to save Object : " + workflow);
            }
        }
        return new Boolean(true);
    }

    synchronized byte[] getUserPhoto(long fileID, long size) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        RawFileStorePrx store = this.getRawFileService();
        try {
            store.setFileId(fileID);
        }
        catch (Throwable e) {
            this.closeService((StatefulServiceInterfacePrx)store);
            this.handleException(e, "Cannot set the file's id.");
        }
        try {
            return store.read(0L, (int)size);
        }
        catch (Exception e) {
            this.closeService((StatefulServiceInterfacePrx)store);
            throw new DSAccessException("Cannot read the file" + fileID, e);
        }
    }

    long uploadExperimenterPhoto(File file, String format, long experimenterID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IAdminPrx svc = this.getAdminService();
        try {
            int offset;
            FileInputStream stream = new FileInputStream(file);
            long length = file.length();
            byte[] bytes = new byte[(int)length];
            int r = 0;
            for (offset = 0; offset < bytes.length && (r = stream.read(bytes, offset, bytes.length - offset)) >= 0; offset += r) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            stream.close();
            return svc.uploadMyUserPhoto(file.getName(), format, bytes);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot upload the photo.");
            return -1L;
        }
    }

    DeleteCallback deleteObject(DeleteCommand[] commands) throws ProcessException {
        DeleteCallback cb = null;
        this.shutDownServices(false);
        try {
            IDeletePrx svc = this.getDeleteService();
            DeleteHandlePrx prx = svc.queueDelete(commands);
            cb = new DeleteCallback(this.secureClient, prx);
        }
        catch (Exception e) {
            if (cb != null) {
                cb.close();
            }
            throw new ProcessException("Cannot delete the speficied objects.", e);
        }
        return cb;
    }

    static {
        SUPPORTED_SPECIAL_CHAR.add(new Character('-'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('+'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('['));
        SUPPORTED_SPECIAL_CHAR.add(new Character(']'));
        SUPPORTED_SPECIAL_CHAR.add(new Character(')'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('('));
        SUPPORTED_SPECIAL_CHAR.add(new Character(':'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('|'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('!'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('{'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('}'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('^'));
        WILD_CARDS = new ArrayList<String>();
        WILD_CARDS.add("*");
        WILD_CARDS.add("?");
        WILD_CARDS.add("~");
        SYSTEM_GROUPS = new ArrayList<String>();
        SYSTEM_GROUPS.add("system");
        SYSTEM_GROUPS.add("user");
        SYSTEM_GROUPS.add("guest");
        SCRIPTS_UI_AVAILABLE = new ArrayList<String>();
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/ROI_Split_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Thumbnail_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Movie_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Split_View_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/export_scripts/Make_Movie.py");
        SCRIPTS_NOT_AVAILABLE_TO_USER = new ArrayList<String>();
        SCRIPTS_NOT_AVAILABLE_TO_USER.add("/omero/setup_scripts/FLIM_initialise.py");
    }
}

