/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.views.AdminView;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.calls.AdminLoader;
import org.openmicroscopy.shoola.env.data.views.calls.AdminSaver;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.GroupData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdminViewImpl
implements AdminView {
    AdminViewImpl() {
    }

    @Override
    public CallHandle updateExperimenter(ExperimenterData exp, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(exp, 4);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle updateGroup(GroupData group, int permissions, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(group, permissions);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle changePassword(String oldPassword, String newPassword, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(oldPassword, newPassword);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getDiskSpace(long userID, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(userID, 0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createExperimenters(AdminObject object, AgentEventListener observer) {
        AdminSaver cmd = new AdminSaver(object);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createGroup(AdminObject object, AgentEventListener observer) {
        AdminSaver cmd = new AdminSaver(object);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadExperimenterGroups(long groupID, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(groupID, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadExperimenters(long groupID, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(groupID, 2);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle deleteObjects(List<DataObject> objects, AgentEventListener observer) {
        AdminSaver cmd = new AdminSaver(objects, 0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle updateExperimenters(GroupData group, Map<ExperimenterData, UserCredentials> experimenters, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(group, experimenters);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle resetExperimentersPassword(AdminObject object, AgentEventListener observer) {
        AdminSaver cmd = new AdminSaver(object);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadExperimenterPhoto(ExperimenterData experimenter, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(experimenter, 3);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle uploadExperimenterPhoto(ExperimenterData experimenter, File photo, String format, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(experimenter, photo, format);
        return cmd.exec(observer);
    }
}

