/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.calls.ChannelMetadataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ContainerCounterLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DMLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DMRefreshLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DataObjectRemover;
import org.openmicroscopy.shoola.env.data.views.calls.DataObjectSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ExistingObjectsSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ExperimenterImagesCounter;
import org.openmicroscopy.shoola.env.data.views.calls.FilesChecker;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.PlateWellsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.RepositoriesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.TagsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ThumbnailLoader;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import pojos.DataObject;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataManagerViewImpl
implements DataManagerView {
    DataManagerViewImpl() {
    }

    @Override
    public CallHandle loadContainerHierarchy(Class rootNodeType, List<Long> rootNodeIDs, boolean withLeaves, long userID, long groupID, AgentEventListener observer) {
        DMLoader cmd = new DMLoader(rootNodeType, rootNodeIDs, withLeaves, userID, groupID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadImages(long userID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getImages(Class nodeType, List nodeIDs, long userID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(nodeType, nodeIDs, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createDataObject(DataObject userObject, DataObject parent, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(userObject, parent, 0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle countContainerItems(Set rootIDs, AgentEventListener observer) {
        ContainerCounterLoader cmd = new ContainerCounterLoader(rootIDs);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadThumbnail(ImageData image, int maxWidth, int maxHeight, long userID, AgentEventListener observer) {
        ThumbnailLoader cmd = new ThumbnailLoader(image, maxWidth, maxHeight, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle addExistingObjects(Collection parents, Collection children, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(parents, children, false);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle addExistingObjects(Map toPaste, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(toPaste, null, false);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle cutAndPaste(Map toPaste, Map toCut, boolean admin, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(toPaste, toCut, admin);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadChannelsData(long pixelsID, long userID, AgentEventListener observer) {
        ChannelMetadataLoader cmd = new ChannelMetadataLoader(pixelsID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle refreshHierarchy(Class rootNodeType, Map<Long, List> m, AgentEventListener observer) {
        DMRefreshLoader cmd = new DMRefreshLoader(rootNodeType, m);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle countExperimenterImages(long userID, Map<Integer, TimeRefObject> m, AgentEventListener observer) {
        ExperimenterImagesCounter cmd = new ExperimenterImagesCounter(userID, m);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadTags(Long id, boolean dataObject, boolean topLevel, long userID, long groupID, AgentEventListener observer) {
        TagsLoader cmd = new TagsLoader(id, dataObject, topLevel, userID, groupID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadPlateWells(Map<Long, Long> ids, long userID, AgentEventListener observer) {
        PlateWellsLoader cmd = new PlateWellsLoader(ids, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle delete(Collection<DeletableObject> values, AgentEventListener observer) {
        DataObjectRemover cmd = new DataObjectRemover(values);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle delete(DeletableObject value, AgentEventListener observer) {
        DataObjectRemover cmd = new DataObjectRemover(value);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle checkFileFormat(List<File> list, AgentEventListener observer) {
        FilesChecker cmd = new FilesChecker(list);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadRepositories(long userID, AgentEventListener observer) {
        RepositoriesLoader cmd = new RepositoriesLoader(userID);
        return cmd.exec(observer);
    }
}

