/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.ImageData;

public class AcquisitionDataLoader
extends BatchCallTree {
    public static final int INSTRUMENT = 0;
    public static final int IMAGE = 1;
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final Object refObject) {
        return new BatchCall("Loading Acquisition data: "){

            public void doCall() throws Exception {
                OmeroMetadataService svc = AcquisitionDataLoader.this.context.getMetadataService();
                AcquisitionDataLoader.this.result = svc.loadAcquisitionData(refObject);
            }
        };
    }

    private BatchCall makeInstrumentBatchCall(final long id) {
        return new BatchCall("Loading Instrument data: "){

            public void doCall() throws Exception {
                OmeroMetadataService svc = AcquisitionDataLoader.this.context.getMetadataService();
                AcquisitionDataLoader.this.result = svc.loadInstrument(id);
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public AcquisitionDataLoader(Object refObject) {
        if (refObject == null) {
            throw new IllegalArgumentException("Ref Object cannot be null.");
        }
        this.loadCall = this.makeBatchCall(refObject);
    }

    public AcquisitionDataLoader(int type, long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Id not valid.");
        }
        switch (type) {
            case 0: {
                this.loadCall = this.makeInstrumentBatchCall(id);
                break;
            }
            case 1: {
                ImageData img = new ImageData();
                img.setId(id);
                this.loadCall = this.makeBatchCall(img);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported");
            }
        }
    }
}

