/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class RenderingControlLoader
extends BatchCallTree {
    public static final int LOAD = 0;
    public static final int RELOAD = 1;
    public static final int RESET = 2;
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final long pixelsID, final int index) {
        return new BatchCall("Loading rendering control: "){

            public void doCall() throws Exception {
                OmeroImageService rds = RenderingControlLoader.this.context.getImageService();
                switch (index) {
                    default: {
                        RenderingControlLoader.this.result = rds.loadRenderingControl(pixelsID);
                        break;
                    }
                    case 1: {
                        RenderingControlLoader.this.result = rds.reloadRenderingService(pixelsID);
                        break;
                    }
                    case 2: {
                        RenderingControlLoader.this.result = rds.resetRenderingService(pixelsID);
                    }
                }
                if (RenderingControlLoader.this.result == null) {
                    throw new DSOutOfServiceException("Cannot start the rendering engine for pixelsID " + pixelsID);
                }
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public RenderingControlLoader(long pixelsID, int index) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("ID not valid.");
        }
        this.loadCall = this.makeBatchCall(pixelsID, index);
    }
}

