/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.List;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredAnnotationLoader
extends BatchCallTree {
    public static final int RATING = 10;
    public static final int ROI_MEASUREMENT = 11;
    public static final int ALL = 1;
    public static final int SINGLE = 2;
    private Object result;
    private BatchCall loadCall;

    private BatchCall loadAnnotations(final Class annotationType, final long userID, final long groupID) {
        return new BatchCall("Loading Existing annotations"){

            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadAnnotations(annotationType, null, userID, groupID);
            }
        };
    }

    private BatchCall loadRatings(final Class type, final long id, final long userID) {
        return new BatchCall("Loading Ratings"){

            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadRatings(type, id, userID);
            }
        };
    }

    private BatchCall loadROIMeasurements(final Class type, final long id, final long userID) {
        return new BatchCall("Loading Measurements"){

            public void doCall() throws Exception {
                OmeroImageService os = StructuredAnnotationLoader.this.context.getImageService();
                StructuredAnnotationLoader.this.result = os.loadROIMeasurements(type, id, userID);
            }
        };
    }

    private BatchCall loadStructuredData(final Object object, final long userID) {
        return new BatchCall("Loading Ratings"){

            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadStructuredData(object, userID, true);
            }
        };
    }

    private BatchCall loadStructuredData(final List<DataObject> data, final long userID, final boolean viewed) {
        return new BatchCall("Loading Ratings"){

            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadStructuredData(data, userID, viewed);
            }
        };
    }

    private BatchCall loadAnnotation(final long annotationID) {
        return new BatchCall("Loading Ratings"){

            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadAnnotation(annotationID);
            }
        };
    }

    private BatchCall loadRatings(final Class type, final List<Long> ids, final long userID) {
        return new BatchCall("Loading Ratings"){

            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadRatings(type, ids, userID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public StructuredAnnotationLoader(int index, Class type, List<Long> ids, long userID) {
        switch (index) {
            case 10: {
                this.loadCall = this.loadRatings(type, ids, userID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    public StructuredAnnotationLoader(int index, List<DataObject> data, long userID, boolean viewed) {
        switch (index) {
            case 1: {
                this.loadCall = this.loadStructuredData(data, userID, viewed);
            }
        }
    }

    public StructuredAnnotationLoader(int index, Object object, long userID) {
        if (object == null) {
            throw new IllegalArgumentException("Object not defined.");
        }
        switch (index) {
            case 1: {
                this.loadCall = this.loadStructuredData(object, userID);
                break;
            }
            case 10: {
                if (!(object instanceof DataObject)) break;
                DataObject ho = (DataObject)object;
                this.loadCall = this.loadRatings(object.getClass(), ho.getId(), userID);
                break;
            }
            case 11: {
                DataObject ho = (DataObject)object;
                this.loadCall = this.loadROIMeasurements(object.getClass(), ho.getId(), userID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    public StructuredAnnotationLoader(Class annotationType, long userID, long groupID) {
        this.loadCall = this.loadAnnotations(annotationType, userID, groupID);
    }

    public StructuredAnnotationLoader(long annotationID) {
        this.loadCall = this.loadAnnotation(annotationID);
    }
}

