/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.ExperimenterData;

public class SwitchUserGroupLoader
extends BatchCallTree {
    private ExperimenterData experimenter;
    private long groupID;
    private Object result;

    private void switchUserGroup() {
        try {
            this.context.getAdminService().changeExperimenterGroup(this.experimenter, this.groupID);
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, "Cannot switch user's group: " + e.getMessage());
        }
        this.result = this.experimenter;
    }

    protected void buildTree() {
        String description = "Switching the user's group.";
        this.add(new BatchCall(description){

            public void doCall() {
                SwitchUserGroupLoader.this.switchUserGroup();
            }
        });
    }

    protected Object getPartialResult() {
        return this.result;
    }

    protected Object getResult() {
        return null;
    }

    public SwitchUserGroupLoader(ExperimenterData experimenter, long groupID) {
        if (experimenter == null) {
            throw new IllegalArgumentException();
        }
        this.experimenter = experimenter;
        this.groupID = groupID;
    }
}

