/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.List;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.WorkflowData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowHandler
extends BatchCallTree {
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeCall(final long userID) {
        return new BatchCall("Retrieve Workflows"){

            public void doCall() throws Exception {
                OmeroImageService os = WorkflowHandler.this.context.getImageService();
                WorkflowHandler.this.result = os.retrieveWorkflows(userID);
            }
        };
    }

    private BatchCall makeCall(final List<WorkflowData> workflows, final long userID) {
        return new BatchCall("Run the script"){

            public void doCall() throws Exception {
                OmeroImageService os = WorkflowHandler.this.context.getImageService();
                WorkflowHandler.this.result = os.storeWorkflows(workflows, userID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public WorkflowHandler(long userID) {
        if (userID < 0L) {
            throw new IllegalArgumentException("invalid userID specified.");
        }
        this.loadCall = this.makeCall(userID);
    }

    public WorkflowHandler(List<WorkflowData> workflows, long userID) {
        if (userID < 0L) {
            throw new IllegalArgumentException("invalid userID specified.");
        }
        if (workflows == null || workflows.size() == 0) {
            throw new IllegalArgumentException("Invalid workflows specified.");
        }
        this.loadCall = this.makeCall(workflows, userID);
    }
}

