/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import java.io.File;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;

public final class ContainerConfigInit
extends InitializationTask {
    String getName() {
        return "Loading Container configuration";
    }

    void configure() {
    }

    void execute() throws StartupException {
        String file = this.container.getConfigFile();
        Registry reg = this.container.getRegistry();
        try {
            File files;
            RegistryFactory.fillFromFile(file, reg);
            String name = (String)reg.lookup("/services/OMERO/home");
            String omeroDir = System.getProperty("user.home") + File.separator + name;
            reg.bind("/user/home/omero", omeroDir);
            String tmp = (String)reg.lookup("/services/OMERO/files/home");
            File home = new File(omeroDir);
            if (!home.exists()) {
                home.mkdir();
            }
            if (!(files = home.isDirectory() ? new File(home, tmp) : new File(this.container.getHomeDir(), tmp)).exists()) {
                files.mkdir();
                files.deleteOnExit();
            }
        }
        catch (ConfigException ce) {
            throw new StartupException("Unable to load Container configuration", ce);
        }
    }

    void rollback() {
    }
}

