/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import pojos.ImageData;

public class ArchivedLoader
extends UserNotifierLoader {
    private CallHandle handle;
    private ImageData image;
    private String folderPath;

    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to download the archived image", message, ex);
    }

    public ArchivedLoader(UserNotifier viewer, Registry registry, ImageData image, String folderPath, ActivityComponent activity) {
        super(viewer, registry, activity);
        if (image == null) {
            throw new IllegalArgumentException("Image not valid.");
        }
        this.image = image;
        this.folderPath = folderPath;
    }

    public void load() {
        long id = this.image.getDefaultPixels().getId();
        this.handle = this.mhView.loadArchivedImage(id, this.folderPath, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else {
            Map m = (Map)result;
            List l = (List)m.get(false);
            List files = (List)m.get(true);
            if (l != null && l.size() > 0) {
                this.onException("Missing " + l.size() + " out of " + files.size() + " " + "files composing the image", null);
            } else {
                this.activity.endActivity(files.size());
            }
        }
    }
}

