/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Component;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChangesDialog
extends JDialog {
    static final String DONE_PROPERTY = "Done";
    private static final String TITLE = "Saving data";
    private JLabel status;
    private JProgressBar progressBar;
    private int count = 0;
    private List<Object> nodes;

    private void setProperties() {
        this.setTitle(TITLE);
    }

    private void initComponents() {
        this.status = new JLabel("Saving...");
        this.progressBar = new JProgressBar(0, this.nodes.size());
        if (this.nodes.size() <= 1) {
            this.progressBar.setIndeterminate(true);
        }
        this.progressBar.setValue(0);
    }

    private void buildGUI() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.progressBar);
        p.add(UIUtilities.buildComponentPanel(this.status));
        this.getContentPane().add((Component)p, "Center");
    }

    ChangesDialog(JFrame owner, List<Object> nodes) {
        super(owner);
        this.nodes = nodes;
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.setSize(400, 300);
    }

    void setStatus(Object node) {
        this.nodes.remove(node);
        ++this.count;
        String text = "";
        if (node instanceof AgentSaveInfo) {
            text = "Saved " + ((AgentSaveInfo)node).getName();
        }
        if (this.nodes.size() == 0) {
            this.firePropertyChange(DONE_PROPERTY, (Object)false, (Object)true);
        } else {
            this.status.setText(text);
            this.progressBar.setValue(this.count);
        }
    }
}

