/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.DataObjectRemover;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteActivity
extends ActivityComponent {
    private static final String DESCRIPTION_START = "Deleting";
    private static final String DESCRIPTION_END = "Objects deleted";
    private static final String DESCRIPTION_ERROR = "Unable to delete";
    private static final String DESCRIPTION_CANCEL = "Deletion cancelled";
    private DeleteActivityParam parameters;

    private String createMessage() {
        List<DeletableObject> objects = this.parameters.getObjects();
        if (objects.size() == 1) {
            return objects.get(0).getMessage();
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<DeletableObject> i = objects.iterator();
        int index = 0;
        int n = 2;
        while (i.hasNext()) {
            DeletableObject o = i.next();
            if (index == n) break;
            buffer.append(o.getMessage());
            if (index < n - 1) {
                buffer.append(", ");
            }
            ++index;
        }
        if (objects.size() > n) {
            buffer.append(" and " + (objects.size() - 2) + " more");
        }
        return buffer.toString();
    }

    public DeleteActivity(UserNotifier viewer, Registry registry, DeleteActivityParam parameters) {
        super(viewer, registry, DESCRIPTION_START, parameters.getIcon());
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        this.messageLabel.setText(this.createMessage());
    }

    public List<Object> getNodes() {
        return this.parameters.getNodes();
    }

    public long getImageID() {
        return this.parameters.getImageID();
    }

    @Override
    protected UserNotifierLoader createLoader() {
        List<DeletableObject> objects = this.parameters.getObjects();
        this.loader = new DataObjectRemover(this.viewer, this.registry, objects, this);
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        Collection l = (Collection)this.result;
        if (l.size() > 0) {
            this.type.setText(DESCRIPTION_ERROR);
            this.notifyActivityError();
        } else {
            this.type.setText(DESCRIPTION_END);
        }
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
        Icon icon = this.parameters.getFailureIcon();
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        }
    }
}

