/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.FileLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.HTMLFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DownloadActivity
extends ActivityComponent {
    private static final String FILE = "file://";
    private static final String DESCRIPTION = "File downloaded";
    private static final String DESCRIPTION_CANCEL = "Download cancelled";
    public static final String LEGEND_TEXT = "_legend.txt";
    public static final String LEGEND_TEXT_CSV = "_legend.csv";
    private DownloadActivityParam parameters;
    private String fileName;
    private File file;
    private String localFileName;
    private static final List<CustomizedFileFilter> FILTERS = new ArrayList<CustomizedFileFilter>();

    private String getFileName() {
        File folder;
        File directory = folder = this.parameters.getFolder();
        if (this.parameters.getApplicationData() == null) {
            directory = folder.getParentFile();
        }
        File[] files = directory.listFiles();
        String dirPath = directory.getAbsolutePath() + File.separator;
        String value = folder.getName();
        if (this.parameters.getApplicationData() != null) {
            value = this.parameters.getOriginalFileName();
            return value;
        }
        if (this.parameters.getFileName() != null) {
            value = this.parameters.getFileName();
        }
        String extension = null;
        if (value != null && value.trim().length() > 0) {
            int lastDot = value.lastIndexOf(".");
            if (lastDot == -1) {
                String s = this.parameters.getOriginalFileName();
                if (s.endsWith("ome.tif") || s.endsWith("ome.tiff")) {
                    extension = "ome.tiff";
                } else {
                    lastDot = s.lastIndexOf(".");
                    if (lastDot != -1) {
                        extension = s.substring(lastDot, s.length());
                    }
                }
                if (extension != null) {
                    value = value + extension;
                }
            }
            return this.getFileName(files, value, value, dirPath, 1, extension);
        }
        value = this.parameters.getOriginalFileName();
        if (value == null || value.length() == 0) {
            return "";
        }
        return this.getFileName(files, value, value, dirPath, 1, null);
    }

    private boolean canOpenFile(String path) {
        for (CustomizedFileFilter filter : FILTERS) {
            if (!filter.accept(path)) continue;
            return true;
        }
        return false;
    }

    public DownloadActivity(UserNotifier viewer, Registry registry, DownloadActivityParam parameters) {
        super(viewer, registry, "Download", parameters.getIcon());
        File folder;
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        File directory = folder = parameters.getFolder();
        if (parameters.getApplicationData() == null) {
            directory = folder.getParentFile();
        }
        this.fileName = this.getFileName();
        this.localFileName = directory + File.separator + this.fileName;
        this.messageLabel.setText(this.localFileName);
    }

    protected UserNotifierLoader createLoader() {
        boolean b;
        File folder;
        OriginalFile f = this.parameters.getFile();
        File directory = folder = this.parameters.getFolder();
        boolean bl = b = this.parameters.getApplicationData() == null;
        if (b) {
            directory = folder.getParentFile();
        }
        this.file = new File(directory + File.separator + this.fileName);
        if (!b) {
            this.file.deleteOnExit();
        }
        boolean load = true;
        if (!b && this.file.exists()) {
            load = false;
        }
        switch (this.parameters.getIndex()) {
            case 0: 
            case 1: {
                this.loader = new FileLoader(this.viewer, this.registry, this.file, this.parameters.getId(), this.parameters.getIndex(), load, (ActivityComponent)this);
                break;
            }
            default: {
                this.loader = new FileLoader(this.viewer, this.registry, this.file, f.getId().getValue(), f.getSize().getValue(), load, (ActivityComponent)this);
            }
        }
        return this.loader;
    }

    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION);
        if (this.parameters.getResults() != null) {
            this.plotResult(this.file, this.parameters.getResults(), this.parameters.getOriginalFileName());
            return;
        }
        if (this.parameters.getApplicationData() != null) {
            this.viewer.openApplication(this.parameters.getApplicationData(), this.file.getAbsolutePath());
            return;
        }
        String name = null;
        String legend = this.parameters.getLegend();
        if (legend != null && legend.trim().length() > 0) {
            File folder = this.parameters.getFolder();
            File directory = folder.getParentFile();
            BufferedWriter out = null;
            String n = UIUtilities.removeFileExtension(this.fileName);
            String ext = LEGEND_TEXT;
            String le = this.parameters.getLegendExtension();
            if (le != null && le.length() > 0) {
                ext = le;
            }
            try {
                name = directory + File.separator + n;
                name = name + ext;
                out = new BufferedWriter(new FileWriter(name));
                out.write(legend);
                out.close();
            }
            catch (Exception e) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (this.localFileName == null) {
            return;
        }
        if (this.canOpenFile(this.localFileName)) {
            String url = UIUtilities.isMacOS() ? FILE + this.localFileName : "file:///" + this.localFileName;
            this.registry.getTaskBar().openURL(url);
        }
    }

    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    protected void notifyActivityError() {
    }

    static {
        FILTERS.add(new JPEGFilter());
        FILTERS.add(new PNGFilter());
        FILTERS.add(new HTMLFilter());
        FILTERS.add(new TIFFFilter());
    }
}

