/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.ui.FileTableNode;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;

class FileUploader
extends UserNotifierLoader {
    private CallHandle handle;
    private MessengerDetails details;
    private MessengerDialog src;
    private Map<File, FileTableNode> nodes;

    FileUploader(UserNotifier viewer, Registry reg, MessengerDialog src, MessengerDetails details) {
        super(viewer, reg, null);
        if (details == null) {
            throw new IllegalArgumentException("No files to upload.");
        }
        this.details = details;
        this.src = src;
        this.nodes = new HashMap<File, FileTableNode>();
        List l = (List)details.getObjectToSubmit();
        if (l != null) {
            for (FileTableNode node : l) {
                this.nodes.put(node.getFile(), node);
            }
        }
    }

    public void load() {
        this.handle = this.mhView.submitFile(this.details, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void update(DSCallFeedbackEvent fe) {
        File f = (File)fe.getPartialResult();
        if (f != null) {
            FileTableNode node = this.nodes.get(f);
            if (node != null) {
                node.setStatus(false);
            }
            this.nodes.remove(f);
        }
        if (this.nodes.size() == 0) {
            this.viewer.notifyInfo("Upload Files", "The files have been successfully upload.");
            if (this.src != null) {
                this.src.setVisible(false);
                this.src.dispose();
            }
        }
    }

    public void handleNullResult() {
    }

    public void handleException(Throwable exc) {
        String s = "File Upload Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("File Upload failure", s, exc);
    }
}

