/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ProcessCallback;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class ScriptRunner
extends UserNotifierLoader {
    private CallHandle handle;
    private ScriptObject script;
    private ProcessCallback callBack;

    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to run the script", message, ex);
    }

    public ScriptRunner(UserNotifier viewer, Registry registry, ScriptObject script, ActivityComponent activity) {
        super(viewer, registry, activity);
        if (script == null) {
            throw new IllegalArgumentException("No script to run.");
        }
        this.script = script;
    }

    public void load() {
        this.handle = this.ivView.runScript(this.script, this);
    }

    public void cancel() {
        try {
            if (this.callBack != null) {
                this.callBack.cancel();
                this.activity.onActivityCancelled();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onException("Unable to start the script.", null);
                }
            } else if (o instanceof ProcessCallback) {
                this.callBack = (ProcessCallback)o;
                this.callBack.setAdapter(this);
                this.activity.onCallBackSet();
            }
        }
    }

    public void handleResult(Object result) {
        if (result instanceof Boolean) {
            Boolean b = (Boolean)result;
            if (!b.booleanValue()) {
                this.onException("Unable to start the script.", null);
            }
        } else if (!(result instanceof Boolean)) {
            this.activity.endActivity(result);
        }
    }
}

