/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.proxy;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.proxy.AbstractProxy;
import org.openmicroscopy.shoola.svc.proxy.MessengerFileRequest;
import org.openmicroscopy.shoola.svc.proxy.MessengerReply;
import org.openmicroscopy.shoola.svc.proxy.MessengerRequest;
import org.openmicroscopy.shoola.svc.transport.HttpChannel;
import org.openmicroscopy.shoola.svc.transport.TransportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommunicatorProxy
extends AbstractProxy
implements Communicator {
    public CommunicatorProxy(HttpChannel channel) {
        super(channel);
    }

    @Override
    public void submitComment(String invoker, String email, String comment, String extra, String applicationName, String applicationVersion, StringBuilder reply) throws TransportException {
        MessengerRequest out = new MessengerRequest(email, comment, extra, null, applicationName, invoker, applicationVersion);
        MessengerReply in = new MessengerReply(reply);
        try {
            this.channel.exchange(out, in);
        }
        catch (IOException ioe) {
            throw new TransportException("Couldn't communicate with server (I/O error).", ioe);
        }
    }

    @Override
    public void submitError(String invoker, String email, String comment, String extra, String error, String applicationName, String applicationVersion, StringBuilder reply) throws TransportException {
        MessengerRequest out = new MessengerRequest(email, comment, extra, error, applicationName, invoker, applicationVersion);
        MessengerReply in = new MessengerReply(reply);
        try {
            this.channel.exchange(out, in);
        }
        catch (IOException ioe) {
            throw new TransportException("Couldn't communicate with server (I/O error).", ioe);
        }
    }

    @Override
    public void submitFiles(String token, Map<File, String> files, StringBuilder reply) throws TransportException {
        if (token == null) {
            throw new IllegalArgumentException("No token specified.");
        }
        if (files == null || files.size() == 0) {
            throw new IllegalArgumentException("No files to submit.");
        }
        MessengerReply in = new MessengerReply(reply);
        try {
            for (Map.Entry<File, String> entry : files.entrySet()) {
                MessengerFileRequest out = new MessengerFileRequest(token, entry.getKey(), entry.getValue());
                this.channel.exchange(out, in);
            }
        }
        catch (IOException ioe) {
            throw new TransportException("Couldn't communicate with server (I/O error).", ioe);
        }
    }

    @Override
    public void submitFile(String token, File file, String reader, StringBuilder reply) throws TransportException {
        if (token == null) {
            throw new IllegalArgumentException("No token specified.");
        }
        if (file == null) {
            throw new IllegalArgumentException("No file to submit.");
        }
        MessengerReply in = new MessengerReply(reply);
        try {
            MessengerFileRequest out = new MessengerFileRequest(token, file, reader);
            this.channel.exchange(out, in);
        }
        catch (IOException ioe) {
            throw new TransportException("Couldn't communicate with server (I/O error).", ioe);
        }
    }
}

