/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur.tasks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.util.concur.tasks.CmdProcessor;
import org.openmicroscopy.shoola.util.concur.tasks.ExecCommand;
import org.openmicroscopy.shoola.util.concur.tasks.UncaughtExcHandler;

public class AsyncProcessor
extends CmdProcessor {
    private final Map threadsMap;
    private final UncaughtExcHandler uncaughtExcHandler;
    private boolean terminated;

    private synchronized Thread createRunner(ExecCommand cmd) {
        if (this.terminated) {
            return null;
        }
        Runner r = new Runner(cmd);
        Thread t = new Thread(r);
        this.threadsMap.put(r, t);
        return t;
    }

    private synchronized void notifyExit(Runner r) {
        this.threadsMap.remove(r);
    }

    protected void doExec(Runnable cmd) {
        ExecCommand srv = (ExecCommand)cmd;
        Thread t = this.createRunner(srv);
        if (t == null) {
            srv.cancel();
        } else {
            t.start();
        }
    }

    public AsyncProcessor() {
        this.threadsMap = new HashMap();
        this.uncaughtExcHandler = null;
        this.terminated = false;
    }

    public AsyncProcessor(UncaughtExcHandler handler) {
        if (handler == null) {
            throw new NullPointerException("No handler.");
        }
        this.threadsMap = new HashMap();
        this.uncaughtExcHandler = handler;
        this.terminated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Runner[] runners;
        AsyncProcessor asyncProcessor = this;
        synchronized (asyncProcessor) {
            Set keys = this.threadsMap.keySet();
            runners = new Runner[keys.size()];
            keys.toArray(runners);
        }
        for (int i = 0; i < runners.length; ++i) {
            runners[i].cmd.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean terminate(long maxWait) {
        Thread[] runners;
        AsyncProcessor asyncProcessor = this;
        synchronized (asyncProcessor) {
            this.terminated = true;
            this.cancelAll();
            Collection values = this.threadsMap.values();
            runners = new Thread[values.size()];
            values.toArray(runners);
        }
        boolean anyThreadStillRunning = false;
        for (int i = 0; i < runners.length; ++i) {
            try {
                runners[i].join(maxWait);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!runners[i].isAlive()) continue;
            anyThreadStillRunning = true;
        }
        return !anyThreadStillRunning;
    }

    static /* synthetic */ UncaughtExcHandler access$000(AsyncProcessor x0) {
        return x0.uncaughtExcHandler;
    }

    static /* synthetic */ void access$100(AsyncProcessor x0, Runner x1) {
        x0.notifyExit(x1);
    }

    private class Runner
    implements Runnable {
        ExecCommand cmd;

        Runner(ExecCommand cmd) {
            this.cmd = cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.cmd.run();
            }
            catch (Throwable t) {
                if (AsyncProcessor.this.uncaughtExcHandler != null) {
                    AsyncProcessor.this.uncaughtExcHandler.handle(t);
                } else {
                    t.printStackTrace();
                }
            }
            finally {
                AsyncProcessor.this.notifyExit(this);
            }
        }
    }
}

