/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class PNGFilter
extends CustomizedFileFilter {
    public static final String MIMETYPE = "image/png";
    public static final String PNG = "png";
    public static final String[] extensions = new String[1];
    private static final String description;

    public String getMIMEType() {
        return MIMETYPE;
    }

    public String getExtension() {
        return PNG;
    }

    public String getDescription() {
        return description;
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        PNGFilter.extensions[0] = PNG;
        String s = "PNG (";
        for (int i = 0; i < extensions.length; ++i) {
            s = s + "*." + extensions[i];
            if (i >= extensions.length - 1) continue;
            s = s + ", ";
        }
        description = s = s + ")";
    }
}

