/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.openmicroscopy.shoola.util.ui.ClosablePopupMenu;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPane;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ClosableTabbedPaneUI
extends BasicTabbedPaneUI
implements MouseMotionListener {
    private static final Color COLOR_START = UIUtilities.SELECTED_BACKGROUND_COLOUR;
    private static final Color COLOR_END = new Color(200, 200, 255);
    private Image closeImage;
    private Image closeOverImage;
    private Map<Integer, Image> images;
    private Map<Integer, Rectangle> rectangles;
    private MouseAdapter handler;

    private void showMenu(Component invoker, int x, int y) {
        ClosablePopupMenu menu = new ClosablePopupMenu((ClosableTabbedPane)this.tabPane);
        menu.show(invoker, x, y);
    }

    private void initialize() {
        IconManager icons = IconManager.getInstance();
        ImageIcon icon = icons.getImageIcon(74);
        this.closeImage = icon.getImage();
        icon = icons.getImageIcon(75);
        this.closeOverImage = icon.getImage();
        this.images = new HashMap<Integer, Image>();
        this.rectangles = new HashMap<Integer, Rectangle>();
        this.handler = new BasicTabbedPaneUI.MouseHandler(){

            public void mouseReleased(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int tabIndex = -1;
                int tabCount = ClosableTabbedPaneUI.this.tabPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    if (!ClosableTabbedPaneUI.this.rects[i].contains(x, y)) continue;
                    tabIndex = i;
                    break;
                }
                if (tabIndex >= 0) {
                    if (e.isPopupTrigger()) {
                        Object source = e.getSource();
                        if (source instanceof Component) {
                            ClosableTabbedPaneUI.this.showMenu((Component)source, x, y);
                        }
                    } else {
                        Rectangle r = (Rectangle)ClosableTabbedPaneUI.this.rectangles.get(tabIndex);
                        if (r != null && r.contains(x, y)) {
                            ((ClosableTabbedPane)ClosableTabbedPaneUI.this.tabPane).remove(tabIndex);
                        }
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
                Object source;
                super.mousePressed(e);
                if (e.isPopupTrigger() && (source = e.getSource()) instanceof Component) {
                    ClosableTabbedPaneUI.this.showMenu((Component)source, e.getX(), e.getY());
                }
            }
        };
    }

    ClosableTabbedPaneUI() {
        this.initialize();
    }

    void resetDefault() {
        this.rectangles.clear();
        this.images.clear();
    }

    protected MouseListener createMouseListener() {
        return this.handler;
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean selected;
        Graphics2D g2D = (Graphics2D)g;
        Rectangle rect = rects[tabIndex];
        boolean bl = selected = this.tabPane.getSelectedIndex() == tabIndex;
        if (selected) {
            GradientPaint gradient = new GradientPaint(rect.x, rect.y, COLOR_START, rect.x + rect.width, rect.y + rect.height, COLOR_END, false);
            g2D.setPaint(gradient);
            g2D.fill(rect);
        } else {
            g2D.setColor(this.tabPane.getBackgroundAt(tabIndex));
        }
        this.paintTabBorder(g, tabPlacement, tabIndex, rect.x, rect.y, rect.width, rect.height, selected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = this.tabPane.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, rect, iconRect, textRect, selected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, selected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, selected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, selected);
        Component c = this.tabPane.getComponentAt(tabIndex);
        boolean closable = true;
        if (c instanceof ClosableTabbedPaneComponent) {
            closable = ((ClosableTabbedPaneComponent)c).isClosable();
        }
        if (!this.images.containsKey(tabIndex)) {
            this.images.put(tabIndex, this.closeImage);
        }
        int x = 2 + rect.x + rect.width - 19;
        int y = rect.y + 2;
        int w = 0;
        int h = 0;
        Image img = this.images.get(tabIndex);
        if (img != null && closable) {
            w = img.getWidth(null);
            h = img.getHeight(null);
            g2D.drawImage(img, x, y, w, h, null);
            Rectangle r = this.rectangles.get(tabIndex);
            if (r == null) {
                r = new Rectangle(x, y, w, h);
            } else {
                r.setBounds(x, y, w, h);
            }
            this.rectangles.put(tabIndex, r);
        }
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + 24;
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.rectangles == null || this.images == null) {
            return;
        }
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Rectangle r = this.rectangles.get(i);
            if (r != null && r.contains(x, y)) {
                this.images.put(i, this.closeOverImage);
                continue;
            }
            this.images.put(i, this.closeImage);
        }
        this.tabPane.repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    static /* synthetic */ JTabbedPane access$000(ClosableTabbedPaneUI x0) {
        return x0.tabPane;
    }

    static /* synthetic */ Rectangle[] access$100(ClosableTabbedPaneUI x0) {
        return x0.rects;
    }

    static /* synthetic */ void access$200(ClosableTabbedPaneUI x0, Component x1, int x2, int x3) {
        x0.showMenu(x1, x2, x3);
    }

    static /* synthetic */ Map access$300(ClosableTabbedPaneUI x0) {
        return x0.rectangles;
    }

    static /* synthetic */ JTabbedPane access$400(ClosableTabbedPaneUI x0) {
        return x0.tabPane;
    }
}

