/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXTaskPaneContainerSingle
extends JXTaskPaneContainer
implements PropertyChangeListener {
    public static final String SELECTED_TASKPANE_PROPERTY = "selectedTaskPane";
    private Map<JXTaskPane, Integer> panes;
    private boolean expandable;

    private void initialize() {
        this.expandable = true;
        this.panes = new HashMap<JXTaskPane, Integer>();
        if (this.getLayout() instanceof VerticalLayout) {
            VerticalLayout vl = (VerticalLayout)this.getLayout();
            vl.setGap(1);
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setBackground(UIUtilities.BACKGROUND);
    }

    public JXTaskPaneContainerSingle() {
        this.initialize();
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public boolean hasTaskPaneExpanded() {
        Component[] comps = this.getComponents();
        if (comps == null) {
            return false;
        }
        for (int i = 0; i < comps.length; ++i) {
            JXTaskPane pane;
            if (!(comps[i] instanceof JXTaskPane) || (pane = (JXTaskPane)comps[i]).isCollapsed()) continue;
            return true;
        }
        return false;
    }

    public List<JXTaskPane> getTaskPanes() {
        ArrayList<JXTaskPane> list = new ArrayList<JXTaskPane>();
        Iterator<JXTaskPane> iterator = this.panes.keySet().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public void add(JXTaskPane component) {
        int index = this.panes.size();
        super.add(component);
        this.panes.put(component, index);
        component.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JXTaskPane src = (JXTaskPane)evt.getSource();
        if (!this.expandable) {
            src.setCollapsed(true);
            return;
        }
        if (src.isCollapsed()) {
            if (this.hasTaskPaneExpanded()) {
                return;
            }
            this.firePropertyChange(SELECTED_TASKPANE_PROPERTY, null, src);
            return;
        }
        Container parent = src.getParent();
        Component[] comp = parent.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            JXTaskPane p;
            Component c = comp[i];
            if (!(c instanceof JXTaskPane) || (p = (JXTaskPane)c) == src) continue;
            p.setCollapsed(true);
            p.setSpecial(false);
        }
        src.setSpecial(true);
        this.firePropertyChange(SELECTED_TASKPANE_PROPERTY, null, src);
    }
}

