/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.creationtools;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JToolBar;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingToolBarButtonFactory {
    private static final String BASE_NAME = "org.jhotdraw.draw.Labels";

    private static Collection<Action> createDrawingActions(DrawingEditor edit) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new SelectAllAction());
        a.add(new SelectSameAction(edit));
        a.add(new DeleteAction());
        return a;
    }

    private static Collection<Action> createSelectionActions(DrawingEditor edit) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new DuplicateAction());
        a.add(null);
        a.add(new MoveToFrontAction(edit));
        a.add(new MoveToBackAction(edit));
        return a;
    }

    public static void addSelectionToolTo(JToolBar tb, DrawingEditor editor, boolean readOnly) {
        if (!readOnly) {
            ButtonFactory.addSelectionToolTo(tb, editor, DrawingToolBarButtonFactory.createDrawingActions(editor), DrawingToolBarButtonFactory.createSelectionActions(editor));
        } else {
            ButtonFactory.addSelectionToolTo(tb, editor, new LinkedList<Action>(), new LinkedList<Action>());
        }
    }

    public static void addToolTo(JToolBar tb, DrawingEditor editor, Tool tool, String labelKey) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle(BASE_NAME);
        ButtonFactory.addToolTo(tb, editor, tool, labelKey, labels);
    }

    public static JToolBar createDefaultBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.putClientProperty("toolButtonGroup", new ButtonGroup());
        return toolBar;
    }
}

