/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.geom.Insets2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointFigure
extends EllipseFigure {
    public static final double POINT_SIZE = 6.0;
    public static final double FIGURE_SIZE = 22.0;

    private void drawCrossHairs(Graphics2D g) {
        Ellipse2D.Double newEllipse = new Ellipse2D.Double(this.ellipse.getCenterX() - 6.0, this.ellipse.getCenterY() - 6.0, 12.0, 12.0);
        double cx = Math.floor(newEllipse.getCenterX());
        double cy = Math.floor(newEllipse.getCenterY());
        double x = Math.floor(newEllipse.getX());
        double y = Math.floor(newEllipse.getY());
        double width = 6.0;
        double height = 6.0;
        double loffset = 3.0;
        Line2D.Double lhline = new Line2D.Double(x - loffset * 2.0, cy, cx - loffset, cy);
        Line2D.Double rhline = new Line2D.Double(cx + loffset, cy, cx + width + loffset * 2.0, cy);
        Line2D.Double tvline = new Line2D.Double(cx, y - loffset * 2.0, cx, cy - loffset);
        Line2D.Double bvline = new Line2D.Double(cx, cy + loffset, cx, cy + height + loffset * 2.0);
        g.draw(lhline);
        g.draw(rhline);
        g.draw(tvline);
        g.draw(bvline);
    }

    public PointFigure(double x, double y) {
        super(x, y, 22.0, 22.0);
    }

    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    public Color getFillColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        Ellipse2D.Double newEllipse = new Ellipse2D.Double(this.ellipse.getCenterX() - 6.0, this.ellipse.getCenterY() - 6.0, 12.0, 12.0);
        g.draw(newEllipse);
        this.drawCrossHairs(g);
    }

    @Override
    protected void drawFill(Graphics2D g) {
        Ellipse2D.Double newEllipse = new Ellipse2D.Double(this.ellipse.getCenterX() - 6.0, this.ellipse.getCenterY() - 6.0, 12.0, 12.0);
        g.fill(newEllipse);
        this.drawText(g);
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new MoveHandle(this, RelativeLocator.northWest()));
            handles.add(new MoveHandle(this, RelativeLocator.northEast()));
            handles.add(new MoveHandle(this, RelativeLocator.southWest()));
            handles.add(new MoveHandle(this, RelativeLocator.southEast()));
        }
        return handles;
    }
}

