/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateEllipseFigure
extends AbstractAttributedFigure {
    protected Ellipse2D.Double ellipse;
    protected Shape cachedTransformedShape;

    public RotateEllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public RotateEllipseFigure(double x, double y, double width, double height) {
        this.ellipse = new Ellipse2D.Double(x, y, width, height);
        AffineTransform transform = new AffineTransform();
        transform.setToIdentity();
        AttributeKeys.TRANSFORM.set(this, transform);
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        if (key == AttributeKeys.TRANSFORM) {
            this.invalidate();
        }
        super.setAttribute(key, newValue);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return new Rectangle2D.Double(this.ellipse.getBounds2D().getX(), this.ellipse.getBounds2D().getY(), this.ellipse.getBounds2D().getWidth(), this.ellipse.getBounds2D().getHeight());
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D rx = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double r = rx instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
        AffineTransform object = AttributeKeys.TRANSFORM.get(this);
        if (object == null) {
            double g = SVGAttributeKeys.getPerpendicularHitGrowth(this) * 2.0;
            Geom.grow(r, g, g);
        } else {
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            Geom.grow(r, width *= Math.max(object.getScaleX(), object.getScaleY()), width);
        }
        return r;
    }

    public boolean containsMapped(double oX, double oY) {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        double x = oX - this.ellipse.getCenterX();
        double y = oY - this.ellipse.getCenterY();
        double[] matrix = new double[6];
        t.getMatrix(matrix);
        matrix[4] = 0.0;
        matrix[5] = 0.0;
        AffineTransform aT = new AffineTransform(matrix);
        Point2D.Double startPt = new Point2D.Double(1.0, 0.0);
        Point2D.Double a = (Point2D.Double)aT.transform(startPt, null);
        double thetaStart = Math.acos(startPt.y / Math.sqrt(startPt.x * startPt.x + startPt.y * startPt.y));
        double rotation = Math.acos(a.y / Math.sqrt(a.x * a.x + a.y * a.y));
        double theta = rotation - Math.floor(rotation / Math.PI) * Math.PI - thetaStart;
        AffineTransform newT = new AffineTransform();
        newT.setToRotation(theta);
        Point2D.Double rotatedPoint = new Point2D.Double();
        newT.transform(new Point2D.Double(x, y), rotatedPoint);
        return this.containsEllipseAlgorithm(((Point2D)rotatedPoint).getX(), ((Point2D)rotatedPoint).getY(), 0.0, 0.0, this.ellipse.getWidth(), this.ellipse.getHeight());
    }

    private boolean containsEllipseAlgorithm(double x, double y, double cx, double cy, double w, double h) {
        double xx = x - cx;
        double wr = w / 2.0;
        double yy = y - cy;
        double hr = h / 2.0;
        double dist = xx * xx / (wr * wr) + yy * yy / (hr * hr);
        return dist < 1.0;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        return this.getTransformedShape().contains(p);
    }

    public Ellipse2D.Double getTransformedEllipse() {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        if (t == null) {
            return this.ellipse;
        }
        Ellipse2D.Double e = new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0);
        Point2D.Double startW = (Point2D.Double)t.transform(new Point2D.Double(0.0, this.ellipse.getCenterY()), null);
        Point2D.Double endW = (Point2D.Double)t.transform(new Point2D.Double(this.ellipse.getWidth(), this.ellipse.getCenterY()), null);
        Point2D.Double startH = (Point2D.Double)t.transform(new Point2D.Double(this.ellipse.getCenterX(), 0.0), null);
        Point2D.Double endH = (Point2D.Double)t.transform(new Point2D.Double(this.ellipse.getCenterX(), this.ellipse.getHeight()), null);
        Point2D.Double lead = (Point2D.Double)t.transform(new Point2D.Double(0.0, 0.0), null);
        e.width = Math.round(startW.distance(endW));
        e.height = Math.round(startH.distance(endH));
        e.x = Math.round(lead.getX());
        e.y = Math.round(lead.getY());
        return e;
    }

    protected Shape getTransformedShape() {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        this.cachedTransformedShape = t == null ? this.ellipse : t.createTransformedShape(this.ellipse);
        return this.cachedTransformedShape;
    }

    protected Shape getTransformedShape(double i, double j) {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        if (t == null) {
            this.cachedTransformedShape = this.ellipse;
        } else {
            Ellipse2D.Double newEllipse = new Ellipse2D.Double(this.ellipse.x - i, this.ellipse.y - j, this.ellipse.width + i, this.ellipse.height + j);
            this.cachedTransformedShape = t.createTransformedShape(newEllipse);
        }
        return this.cachedTransformedShape;
    }

    public Ellipse2D.Double getEllipse() {
        return this.ellipse;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                ResizeHandleKit.addResizeHandles(this, handles);
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    public void setEllipse(double x, double y, double width, double height) {
        this.ellipse.x = x;
        this.ellipse.y = y;
        this.ellipse.width = width;
        this.ellipse.height = height;
        this.invalidate();
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.ellipse.x = Math.min(anchor.x, lead.x);
        this.ellipse.y = Math.min(anchor.y, lead.y);
        this.ellipse.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.ellipse.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
        this.invalidate();
    }

    public double getHeight() {
        return this.getTransformedEllipse().getHeight();
    }

    public double getWidth() {
        return this.getTransformedEllipse().getWidth();
    }

    public void setWidth(double newWidth) {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        if (t == null) {
            return;
        }
        double centreX = this.getCentreX();
        double centreY = this.getCentreY();
        double height = this.getHeight();
        double[] matrix = new double[6];
        t.getMatrix(matrix);
        matrix[4] = 0.0;
        matrix[5] = 0.0;
        AffineTransform aT = new AffineTransform(matrix);
        Point2D.Double a = (Point2D.Double)aT.transform(new Point2D.Double(1.0, 0.0), null);
        double theta = Math.asin(a.y / Math.sqrt(a.x * a.x + a.y * a.y));
        AffineTransform newT = new AffineTransform();
        newT.setToRotation(theta);
        Ellipse2D.Double newEllipse = new Ellipse2D.Double(0.0, 0.0, newWidth, height);
        Shape rotatedShape = newT.createTransformedShape(newEllipse);
        double rotatedShapeCentreX = rotatedShape.getBounds2D().getCenterX();
        double rotatedShapeCentreY = rotatedShape.getBounds2D().getCenterY();
        double diffX = centreX - rotatedShapeCentreX;
        double diffY = centreY - rotatedShapeCentreY;
        Point2D.Double lead = new Point2D.Double(diffX, diffY);
        AffineTransform rT = AffineTransform.getTranslateInstance(lead.x, lead.y);
        rT.concatenate(newT);
        this.ellipse = newEllipse;
        AttributeKeys.TRANSFORM.set(this, rT);
        this.invalidate();
    }

    public void setHeight(double newHeight) {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        if (t == null) {
            return;
        }
        double centreX = this.getCentreX();
        double centreY = this.getCentreY();
        double width = this.getWidth();
        double[] matrix = new double[6];
        t.getMatrix(matrix);
        matrix[4] = 0.0;
        matrix[5] = 0.0;
        AffineTransform aT = new AffineTransform(matrix);
        Point2D.Double a = (Point2D.Double)aT.transform(new Point2D.Double(1.0, 0.0), null);
        double theta = Math.asin(a.y / Math.sqrt(a.x * a.x + a.y * a.y));
        AffineTransform newT = new AffineTransform();
        newT.setToRotation(theta);
        Ellipse2D.Double newEllipse = new Ellipse2D.Double(0.0, 0.0, width, newHeight);
        Shape rotatedShape = newT.createTransformedShape(newEllipse);
        double rotatedShapeCentreX = rotatedShape.getBounds2D().getCenterX();
        double rotatedShapeCentreY = rotatedShape.getBounds2D().getCenterY();
        double diffX = centreX - rotatedShapeCentreX;
        double diffY = centreY - rotatedShapeCentreY;
        Point2D.Double lead = new Point2D.Double(diffX, diffY);
        AffineTransform rT = AffineTransform.getTranslateInstance(lead.x, lead.y);
        rT.concatenate(newT);
        this.ellipse = newEllipse;
        AttributeKeys.TRANSFORM.set(this, rT);
        this.invalidate();
    }

    public double getCentreX() {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        if (t == null) {
            return this.ellipse.getCenterX();
        }
        Point2D.Double src = new Point2D.Double(this.ellipse.getCenterX(), this.ellipse.getCenterY());
        Point2D.Double dest = new Point2D.Double();
        t.transform(src, dest);
        return ((Point2D)dest).getX();
    }

    public double getCentreY() {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        if (t == null) {
            return this.ellipse.getCenterY();
        }
        Point2D.Double src = new Point2D.Double(this.ellipse.getCenterX(), this.ellipse.getCenterY());
        Point2D.Double dest = new Point2D.Double();
        t.transform(src, dest);
        return ((Point2D)dest).getY();
    }

    @Override
    public void transform(AffineTransform tx) {
        if (AttributeKeys.TRANSFORM.get(this) == null) {
            AttributeKeys.TRANSFORM.basicSetClone(this, tx);
        } else {
            AffineTransform t = AttributeKeys.TRANSFORM.getClone(this);
            t.preConcatenate(tx);
            AttributeKeys.TRANSFORM.basicSet(this, t);
        }
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Object[] restoreData = (Object[])geometry;
        this.ellipse = (Ellipse2D.Double)((Ellipse2D.Double)restoreData[0]).clone();
        SVGAttributeKeys.TRANSFORM.basicSetClone(this, (AffineTransform)restoreData[1]);
        SVGAttributeKeys.FILL_GRADIENT.basicSetClone(this, (Gradient)restoreData[2]);
        SVGAttributeKeys.STROKE_GRADIENT.basicSetClone(this, (Gradient)restoreData[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.ellipse.clone(), SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public RotateEllipseFigure clone() {
        RotateEllipseFigure that = (RotateEllipseFigure)super.clone();
        that.ellipse = (Ellipse2D.Double)this.ellipse.clone();
        that.cachedTransformedShape = null;
        return that;
    }

    public boolean isEmpty() {
        Rectangle2D.Double b = this.getBounds();
        return b.width <= 0.0 || b.height <= 0.0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedTransformedShape = null;
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawFigure(g);
    }

    private void drawFigure(Graphics2D g) {
        Paint paint = SVGAttributeKeys.getFillPaint(this);
        if (paint != null) {
            g.setPaint(paint);
            this.drawFill(g);
        }
        if ((paint = SVGAttributeKeys.getStrokePaint(this)) != null && AttributeKeys.STROKE_WIDTH.get(this) > 0.0) {
            g.setPaint(paint);
            g.setStroke(AttributeKeys.getStroke(this));
            this.drawStroke(g);
        }
    }

    @Override
    protected void drawFill(Graphics2D g) {
        g.fill(this.getTransformedShape());
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        g.draw(this.getTransformedShape());
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }
}

