/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;
import org.openmicroscopy.shoola.util.ui.graphutils.ChartObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieChart
extends ChartObject {
    private List<Double> data;
    private DefaultPieDataset dataset;

    private void initialize() {
        this.data = new ArrayList<Double>();
        this.colours = new ArrayList();
        this.dataset = new DefaultPieDataset();
    }

    public PieChart() {
        super("");
        this.initialize();
    }

    public PieChart(String title, List<String> newLegends, List<Double> newData, List<Color> newColours) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addValue(newLegends.get(i), newData.get(i), newColours.get(i));
        }
    }

    public int addValue(String legend, double newData, Color color) {
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.dataset.setValue((Comparable)((Object)legend), newData);
        return this.dataset.getItemCount();
    }

    @Override
    void createChart() {
        this.chart = ChartFactory.createPieChart3D((String)this.title, (PieDataset)this.dataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot3D plot = (PiePlot3D)this.chart.getPlot();
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.55f);
    }
}

