/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.SeparatorPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchComponent;
import org.openmicroscopy.shoola.util.ui.search.SearchContext;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;
import org.openmicroscopy.shoola.util.ui.search.SearchUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchPanel
extends JPanel
implements ActionListener {
    private static final String ADVANCED_SEARCH_TITLE = "Advanced Search For Images";
    private static final String SEARCH_TITLE = "Search For Images";
    private static final String USER_TITLE = "Users";
    private static final String DATE_TITLE = "Date";
    private static final String SCOPE_TITLE = "Context";
    private static final String TYPE_TITLE = "Type";
    private static final String SEARCH_TIP = "<html><i>Tip: Use these options to look for an <br> exact phrase or to exclude certain words.</i></html>";
    private static final int TIP_FONT_TYPE = 2;
    private static final int TIP_FONT_SIZE = 10;
    private static final int AREA_COLUMNS = 12;
    private static final String ALL_WORDS = "<html><b>Must contain</b> the words</html>";
    private static final String AT_LEAST_WORDS = "<html><b>At least one</b> of the words</html>";
    private static final String WITHOUT_WORDS = "<html><b>Without</b> the words</html>";
    private static String[] dateOptions = new String[6];
    private static String[] numberOfResults;
    private static String[] fileFormats;
    private JCheckBox caseSensitive;
    private JButton ownerButton;
    private JButton annotatorButton;
    private JTextField usersAsOwner;
    private JTextField usersAsAnnotator;
    private JComboBox dates;
    private JTextField fullTextArea;
    private JTextField allTermsArea;
    private JTextField atLeastTermsArea;
    private JTextField withoutTermsArea;
    private JXDatePicker fromDate;
    private JXDatePicker toDate;
    private SearchComponent model;
    private Map<Integer, JCheckBox> scopes;
    private Map<Integer, JCheckBox> types;
    private JCheckBox currentUserAsOwner;
    private JCheckBox othersAsOwner;
    private JCheckBox currentUserAsAnnotator;
    private JCheckBox othersAsAnnotator;
    private Map<JTextField, JLabel> areas;
    private JButton helpBasicButton;
    private JButton helpAdvancedButton;
    private JButton searchAdvancedButton;
    private JButton searchBasicButton;
    private JRadioButton creationTime;
    private JRadioButton updatedTime;
    private JComboBox formats;
    private boolean advancedSearch;
    private Map<Long, String> otherOwners;
    private JPanel otherOwnersPanel;
    private JPanel basicSearchComp;
    private JPanel advancedSearchComp;
    private JPanel searchFor;
    private List<JButton> controls;

    private void initComponents() {
        int dateIndex;
        List<Integer> l;
        this.otherOwners = new LinkedHashMap<Long, String>();
        this.otherOwnersPanel = new JPanel();
        this.otherOwnersPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.advancedSearch = false;
        this.scopes = new HashMap<Integer, JCheckBox>(this.model.getNodes().size());
        this.types = new HashMap<Integer, JCheckBox>(this.model.getTypes().size());
        IconManager icons = IconManager.getInstance();
        this.fromDate = UIUtilities.createDatePicker(false);
        this.fromDate.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.toDate = UIUtilities.createDatePicker(false);
        this.toDate.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.fullTextArea = new JTextField(12);
        this.fullTextArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object source = e.getSource();
                if (source != SearchPanel.this.fullTextArea) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        SearchPanel.this.model.search();
                    }
                }
            }
        });
        this.allTermsArea = new JTextField(12);
        this.atLeastTermsArea = new JTextField(12);
        this.withoutTermsArea = new JTextField(12);
        this.usersAsOwner = new JTextField(12);
        this.usersAsAnnotator = new JTextField(12);
        this.usersAsAnnotator.setEditable(false);
        this.usersAsOwner.setEditable(false);
        this.dates = new JComboBox<String>(dateOptions);
        this.dates.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.dates.addActionListener(this.model);
        this.dates.setActionCommand("4");
        this.ownerButton = new JButton(icons.getIcon(42));
        this.ownerButton.setToolTipText("Select the owner of the objects.");
        this.ownerButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.ownerButton.addActionListener(this.model);
        this.ownerButton.setActionCommand("5");
        this.ownerButton.setEnabled(false);
        this.usersAsOwner.setEnabled(false);
        this.annotatorButton = new JButton(icons.getIcon(42));
        this.annotatorButton.setToolTipText("Select the users who annotated the objects.");
        this.annotatorButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.annotatorButton.setEnabled(false);
        this.usersAsAnnotator.setEnabled(false);
        UIUtilities.unifiedButtonLookAndFeel(this.annotatorButton);
        this.annotatorButton.addActionListener(this.model);
        this.annotatorButton.setActionCommand("6");
        this.currentUserAsOwner = new JCheckBox("Me");
        this.currentUserAsOwner.setSelected(true);
        this.currentUserAsOwner.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.currentUserAsAnnotator = new JCheckBox("Me");
        this.currentUserAsAnnotator.setSelected(true);
        this.currentUserAsAnnotator.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.othersAsOwner = new JCheckBox("Others");
        this.othersAsOwner.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.othersAsAnnotator = new JCheckBox("Others");
        this.othersAsAnnotator.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.othersAsOwner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SearchPanel.this.ownerButton.setEnabled(SearchPanel.this.othersAsOwner.isSelected());
                SearchPanel.this.usersAsOwner.setEnabled(SearchPanel.this.othersAsOwner.isSelected());
            }
        });
        this.othersAsAnnotator.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SearchPanel.this.annotatorButton.setEnabled(SearchPanel.this.othersAsAnnotator.isSelected());
                SearchPanel.this.usersAsAnnotator.setEnabled(SearchPanel.this.othersAsAnnotator.isSelected());
            }
        });
        this.caseSensitive = new JCheckBox("Case sensitive");
        this.areas = new LinkedHashMap<JTextField, JLabel>();
        this.areas.put(this.atLeastTermsArea, new JLabel(AT_LEAST_WORDS));
        this.areas.put(this.allTermsArea, new JLabel(ALL_WORDS));
        this.areas.put(this.withoutTermsArea, new JLabel(WITHOUT_WORDS));
        this.helpBasicButton = new JButton(icons.getIcon(76));
        this.helpBasicButton.setToolTipText("Search Tips.");
        this.helpBasicButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.helpBasicButton);
        this.helpBasicButton.addActionListener(this.model);
        this.helpBasicButton.setActionCommand("3");
        this.helpAdvancedButton = new JButton(icons.getIcon(76));
        this.helpAdvancedButton.setToolTipText("Advanced search Tips.");
        this.helpAdvancedButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.helpAdvancedButton);
        this.helpAdvancedButton.addActionListener(this.model);
        this.helpAdvancedButton.setActionCommand("3");
        this.searchBasicButton = new JButton(icons.getIcon(98));
        this.searchBasicButton.setToolTipText("Advanced search.");
        this.searchBasicButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.searchBasicButton);
        this.searchBasicButton.addActionListener(this.model);
        this.searchBasicButton.setActionCommand("7");
        this.searchAdvancedButton = new JButton(icons.getIcon(99));
        this.searchAdvancedButton.setToolTipText("Standard Search.");
        this.searchAdvancedButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.searchAdvancedButton);
        this.searchAdvancedButton.addActionListener(this.model);
        this.searchAdvancedButton.setActionCommand("8");
        this.formats = new JComboBox<String>(fileFormats);
        this.formats.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        this.creationTime = new JRadioButton("Created");
        this.creationTime.setSelected(true);
        this.creationTime.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.updatedTime = new JRadioButton("Updated");
        this.updatedTime.setBackground(UIUtilities.BACKGROUND_COLOR);
        group.add(this.creationTime);
        group.add(this.updatedTime);
        SearchContext ctx = this.model.getSearchContext();
        if (ctx == null) {
            return;
        }
        if (ctx.getTimeType() == 101) {
            this.updatedTime.setSelected(true);
        }
        if ((l = ctx.getOwnerSearchContext()) != null) {
            this.othersAsOwner.setSelected(l.contains(1));
            this.currentUserAsOwner.setSelected(l.contains(0));
        }
        if ((l = ctx.getAnnotatorSearchContext()) != null) {
            this.othersAsAnnotator.setSelected(l.contains(1));
            this.currentUserAsAnnotator.setSelected(l.contains(0));
        }
        if ((dateIndex = ctx.getDateIndex()) != -1) {
            this.dates.setSelectedIndex(dateIndex);
        }
        String[] none = ctx.getNone();
        String v = "";
        for (int i = 0; i < none.length; ++i) {
            v = v + "\"" + none[i] + "\"";
            if (i == none.length - 1) continue;
            v = v + " ";
        }
        this.withoutTermsArea.setText(v);
        String[] must = ctx.getMust();
        v = "";
        for (int i = 0; i < must.length; ++i) {
            v = v + "\"" + must[i] + "\"";
            if (i == none.length - 1) continue;
            v = v + " ";
        }
        this.allTermsArea.setText(v);
        String[] some = ctx.getSome();
        v = "";
        for (int i = 0; i < some.length; ++i) {
            v = v + "\"" + some[i] + "\"";
            if (i == none.length - 1) continue;
            v = v + " ";
        }
        this.atLeastTermsArea.setText(v);
        this.setDateIndex();
    }

    private void layoutOtherOwners() {
        this.otherOwnersPanel.removeAll();
        Iterator<Long> i = this.otherOwners.keySet().iterator();
        this.otherOwnersPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridy = 0;
        IconManager icons = IconManager.getInstance();
        Icon icon = icons.getIcon(74);
        while (i.hasNext()) {
            c.gridx = 0;
            c.weightx = 0.0;
            long id = i.next();
            JLabel label = new JLabel(this.otherOwners.get(id));
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.otherOwnersPanel.add((Component)label, c);
            c.gridx = 1;
            JButton button = new JButton(icon);
            button.setBackground(UIUtilities.BACKGROUND_COLOR);
            UIUtilities.unifiedButtonLookAndFeel(button);
            button.setToolTipText("Remove the user.");
            button.setActionCommand("" + id);
            button.addActionListener(this);
            JToolBar bar = new JToolBar();
            bar.setBackground(UIUtilities.BACKGROUND_COLOR);
            bar.setFloatable(false);
            bar.setRollover(true);
            bar.setBorder(null);
            bar.add(button);
            this.otherOwnersPanel.add((Component)bar, c);
            ++c.gridy;
        }
        this.otherOwnersPanel.validate();
        this.otherOwnersPanel.repaint();
    }

    private void setUserString(String name, JTextField field) {
        List<String> values = SearchUtil.splitTerms(field.getText(), "\"");
        String v = "";
        int n = values.size();
        if (n == 0) {
            v = "\"" + name + "\"";
        } else {
            Iterator<String> i = values.iterator();
            boolean exist = false;
            int index = 0;
            while (i.hasNext()) {
                String value = i.next();
                if (!value.equals(name)) {
                    v = v + "\"" + value;
                    v = v + "\"";
                    if (index < n) {
                        v = v + " ";
                    }
                }
                ++index;
            }
            if (!exist) {
                v = v + "\"" + name + "\"";
            }
        }
        field.setText(v);
    }

    private List<String> getExcludedUsers(JTextField field) {
        String text = field.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        if (!text.contains("-")) {
            return null;
        }
        List<String> l = SearchUtil.splitTerms(text, "\"");
        int index = 0;
        ArrayList<String> excluded = new ArrayList<String>();
        if (l != null) {
            for (String value : l) {
                String nextItem;
                if ("-".equals(value) && (nextItem = l.get(index + 1)) != null) {
                    excluded.add(nextItem);
                }
                ++index;
            }
        }
        return excluded;
    }

    private List<String> getUsers(JTextField field) {
        String text = field.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        List<String> l = SearchUtil.splitTerms(text, "\"");
        ArrayList<String> terms = new ArrayList<String>();
        if (l != null) {
            for (String value : l) {
                if ("-".equals(value)) continue;
                terms.add(value);
            }
        }
        return terms;
    }

    private JPanel buildTimeRange() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(UIUtilities.setTextFont("From: "));
        p.add((Component)this.fromDate);
        p.add(UIUtilities.setTextFont("To: "));
        p.add((Component)this.toDate);
        return p;
    }

    private JPanel buildScope() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        List<SearchObject> nodes = this.model.getNodes();
        int m = nodes.size();
        c.weightx = 1.0;
        List<Integer> ctxNodes = null;
        SearchContext ctx = this.model.getSearchContext();
        if (ctx != null) {
            ctxNodes = ctx.getContext();
        }
        if (ctxNodes == null) {
            for (int i = 0; i < m; ++i) {
                SearchObject n = nodes.get(i);
                JCheckBox box = new JCheckBox(n.getDescription());
                box.setBackground(UIUtilities.BACKGROUND_COLOR);
                if (i == 0) {
                    box.setSelected(true);
                }
                if (i % 2 == 0) {
                    ++c.gridy;
                }
                p.add((Component)box, c);
                this.scopes.put(n.getIndex(), box);
            }
        } else {
            for (int i = 0; i < m; ++i) {
                SearchObject n = nodes.get(i);
                JCheckBox box = new JCheckBox(n.getDescription());
                box.setBackground(UIUtilities.BACKGROUND_COLOR);
                box.setSelected(ctxNodes.contains(n.getIndex()));
                if (i % 2 == 0) {
                    ++c.gridy;
                }
                p.add((Component)box, c);
                this.scopes.put(n.getIndex(), box);
            }
        }
        return p;
    }

    private JPanel buildType() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        List<SearchObject> nodes = this.model.getTypes();
        List<Integer> ctxNodes = null;
        SearchContext ctx = this.model.getSearchContext();
        if (ctx != null) {
            ctxNodes = ctx.getType();
        }
        int m = nodes.size();
        c.weightx = 1.0;
        if (ctxNodes == null) {
            for (int i = 0; i < m; ++i) {
                SearchObject n = nodes.get(i);
                JCheckBox box = new JCheckBox(n.getDescription());
                box.setBackground(UIUtilities.BACKGROUND_COLOR);
                if (i == 0) {
                    box.setSelected(true);
                }
                p.add((Component)box, c);
                this.types.put(n.getIndex(), box);
            }
        } else {
            for (int i = 0; i < m; ++i) {
                SearchObject n = nodes.get(i);
                JCheckBox box = new JCheckBox(n.getDescription());
                box.setBackground(UIUtilities.BACKGROUND_COLOR);
                box.setSelected(ctxNodes.contains(n.getIndex()));
                p.add((Component)box, c);
                this.types.put(n.getIndex(), box);
            }
        }
        UIUtilities.setBoldTitledBorder(TYPE_TITLE, p);
        return p;
    }

    private JPanel buildBasicSearchComp() {
        this.basicSearchComp = new JPanel();
        this.basicSearchComp.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.setBoldTitledBorder(SEARCH_TITLE, this.basicSearchComp);
        this.basicSearchComp.setLayout(new BoxLayout(this.basicSearchComp, 1));
        this.basicSearchComp.add(this.fullTextArea);
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.helpBasicButton);
        bar.add(this.searchBasicButton);
        if (this.controls != null && this.controls.size() > 0) {
            Iterator<JButton> i = this.controls.iterator();
            while (i.hasNext()) {
                bar.add(i.next());
            }
        }
        JPanel p = UIUtilities.buildComponentPanel(bar);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.basicSearchComp.add(p);
        return this.basicSearchComp;
    }

    private JPanel buildAdvancedSearchComp() {
        this.advancedSearchComp = new JPanel();
        this.advancedSearchComp.setBackground(UIUtilities.BACKGROUND_COLOR);
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.setBoldTitledBorder(ADVANCED_SEARCH_TITLE, this.advancedSearchComp);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        Iterator<JTextField> i = this.areas.keySet().iterator();
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            JTextField area = i.next();
            area.setBackground(UIUtilities.BACKGROUND_COLOR);
            JLabel label = this.areas.get(area);
            c.gridwidth = -1;
            c.weightx = 0.0;
            p.add((Component)label, c);
            label.setLabelFor(area);
            ++c.gridy;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            p.add((Component)area, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)UIUtilities.setTextFont(SEARCH_TIP, 2, 10), c);
        this.advancedSearchComp.setLayout(new BoxLayout(this.advancedSearchComp, 1));
        this.advancedSearchComp.add(p);
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.helpAdvancedButton);
        bar.add(this.searchAdvancedButton);
        if (this.controls != null && this.controls.size() > 0) {
            Iterator<JButton> j = this.controls.iterator();
            while (j.hasNext()) {
                bar.add(j.next());
            }
        }
        JPanel comp = UIUtilities.buildComponentPanel(bar);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.advancedSearchComp.add(comp);
        return this.advancedSearchComp;
    }

    private JPanel buildSearchFor() {
        if (this.searchFor == null) {
            this.searchFor = new JPanel();
            this.searchFor.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.searchFor.setLayout(new BoxLayout(this.searchFor, 1));
        }
        this.searchFor.removeAll();
        if (this.advancedSearch) {
            this.searchFor.add(this.buildAdvancedSearchComp());
        } else {
            this.searchFor.add(this.buildBasicSearchComp());
        }
        return this.searchFor;
    }

    private JPanel buildOtherUserSelection(JCheckBox box, JComponent field, JButton button) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)box, c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setFloatable(false);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(button);
        ++c.gridx;
        p.add((Component)bar, c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridheight = 2;
        p.add((Component)field, c);
        return p;
    }

    private JPanel buildUsers() {
        JPanel usersPanel = new JPanel();
        usersPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        usersPanel.setLayout(new BoxLayout(usersPanel, 1));
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridy = 0;
        c.gridwidth = 2;
        content.add((Component)UIUtilities.setTextFont("Owned by "), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        content.add((Component)this.currentUserAsOwner, c);
        ++c.gridy;
        c.ipady = 10;
        content.add((Component)this.buildOtherUserSelection(this.othersAsOwner, this.otherOwnersPanel, this.ownerButton), c);
        JPanel p = UIUtilities.buildComponentPanel(content);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        usersPanel.add(p);
        content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        p = UIUtilities.buildComponentPanel(content);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        usersPanel.add(p);
        return usersPanel;
    }

    private JPanel buildDate() {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setLayout(new BoxLayout(content, 0));
        content.add(this.creationTime);
        content.add(this.updatedTime);
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.ipady = 10;
        p.add((Component)content, c);
        c.ipady = 0;
        ++c.gridy;
        p.add((Component)this.dates, c);
        ++c.gridy;
        p.add((Component)this.buildTimeRange(), c);
        JPanel panel = UIUtilities.buildComponentPanel(p);
        panel.setBackground(UIUtilities.BACKGROUND_COLOR);
        return panel;
    }

    private void buildGUI() {
        this.buildType();
        this.setBorder(null);
        double[][] size = new double[][]{{-1.0}, {-2.0, 5.0, -2.0, -2.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)this.buildSearchFor(), "0, 0");
        SeparatorPane sep = new SeparatorPane();
        sep.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)sep, "0, 1");
        JXTaskPane pane = UIUtilities.createTaskPane(SCOPE_TITLE, null);
        pane.setCollapsed(false);
        pane.add((Component)this.buildScope());
        this.add((Component)pane, "0, 2");
        pane = UIUtilities.createTaskPane(DATE_TITLE, null);
        pane.add((Component)this.buildDate());
        this.add((Component)pane, "0, 4");
        this.setDateIndex();
    }

    SearchPanel(SearchComponent model, List<JButton> controls) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.controls = controls;
        this.initComponents();
        this.buildGUI();
    }

    void setDateIndex() {
        int index = this.dates.getSelectedIndex();
        this.fromDate.setEnabled(index == 5);
        this.fromDate.getEditor().setEnabled(false);
        this.toDate.setEnabled(index == 5);
        this.toDate.getEditor().setEnabled(false);
    }

    int getSelectedDate() {
        return this.dates.getSelectedIndex();
    }

    boolean isCaseSensitive() {
        return this.caseSensitive.isSelected();
    }

    Timestamp getFromDate() {
        Date d = this.fromDate.getDate();
        if (d == null) {
            return null;
        }
        return new Timestamp(d.getTime());
    }

    Timestamp getToDate() {
        Date d = this.toDate.getDate();
        if (d == null) {
            return null;
        }
        return new Timestamp(d.getTime());
    }

    List<Integer> getScope() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer key : this.scopes.keySet()) {
            JCheckBox box = this.scopes.get(key);
            if (!box.isSelected()) continue;
            list.add(key);
        }
        return list;
    }

    List<Integer> getType() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer key : this.types.keySet()) {
            JCheckBox box = this.types.get(key);
            if (!box.isSelected()) continue;
            list.add(key);
        }
        return list;
    }

    void setSomeValues(List<String> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        String text = "";
        Iterator<String> i = values.iterator();
        if (text != null) {
            while (i.hasNext()) {
                text = text + i.next() + " ";
            }
        }
        if (!this.advancedSearch) {
            this.fullTextArea.setText(text);
        } else {
            this.atLeastTermsArea.setText(text);
        }
    }

    String[] getSome() {
        List<String> l;
        String text;
        if (!this.advancedSearch && (text = this.fullTextArea.getText()) != null && text.trim().length() > 0 && (l = SearchUtil.splitTerms(text)).size() > 0) {
            return l.toArray(new String[0]);
        }
        text = this.atLeastTermsArea.getText();
        l = SearchUtil.splitTerms(text);
        if (l.size() > 0) {
            return l.toArray(new String[0]);
        }
        return null;
    }

    String[] getMust() {
        String text = this.allTermsArea.getText();
        List<String> l = SearchUtil.splitTerms(text);
        if (l.size() > 0) {
            return l.toArray(new String[0]);
        }
        return null;
    }

    String[] getNone() {
        String text = this.withoutTermsArea.getText();
        List<String> l = SearchUtil.splitTerms(text);
        if (l.size() > 0) {
            return l.toArray(new String[0]);
        }
        return null;
    }

    List<Integer> getOwnerSearchContext() {
        ArrayList<Integer> context = new ArrayList<Integer>();
        if (this.currentUserAsOwner.isSelected()) {
            context.add(0);
        }
        if (this.othersAsOwner.isSelected()) {
            context.add(1);
        }
        return context;
    }

    List<Integer> getAnnotatorSearchContext() {
        ArrayList<Integer> context = new ArrayList<Integer>();
        if (this.currentUserAsAnnotator.isSelected()) {
            context.add(0);
        }
        if (this.othersAsAnnotator.isSelected()) {
            context.add(1);
        }
        return context;
    }

    List<Long> getOwners() {
        ArrayList<Long> users = new ArrayList<Long>();
        Iterator<Long> i = this.otherOwners.keySet().iterator();
        while (i.hasNext()) {
            users.add(i.next());
        }
        return users;
    }

    List<String> getAnnotators() {
        return this.getUsers(this.usersAsAnnotator);
    }

    void setFocusOnSearch() {
        Iterator<JTextField> i;
        if (this.areas != null && (i = this.areas.keySet().iterator()).hasNext()) {
            i.next().requestFocus();
        }
    }

    void setOwnerString(long userID, String name) {
        if (this.otherOwners.containsKey(userID)) {
            return;
        }
        this.otherOwners.put(userID, name);
        this.layoutOtherOwners();
        this.validate();
        this.repaint();
    }

    void setAnnotatorString(String name) {
        this.setUserString(name, this.usersAsAnnotator);
    }

    int getAttachment() {
        return this.formats.getSelectedIndex();
    }

    int getTimeIndex() {
        if (this.creationTime.isSelected()) {
            return 100;
        }
        if (this.updatedTime.isSelected()) {
            return 101;
        }
        return -1;
    }

    List<String> getExcludedAnnotators() {
        return this.getExcludedUsers(this.usersAsAnnotator);
    }

    List<String> getExcludedOwners() {
        return this.getExcludedUsers(this.usersAsOwner);
    }

    void advancedSearch(boolean advancedSearch) {
        this.advancedSearch = advancedSearch;
        if (advancedSearch) {
            this.fullTextArea.setEnabled(false);
        } else {
            this.fullTextArea.setEnabled(true);
        }
        this.buildSearchFor();
        if (advancedSearch) {
            this.atLeastTermsArea.requestFocus();
        } else {
            this.fullTextArea.requestFocus();
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        int index = Integer.parseInt(s);
        this.otherOwners.remove(new Long(index));
        this.layoutOtherOwners();
        this.validate();
        this.repaint();
    }

    static /* synthetic */ JTextField access$000(SearchPanel x0) {
        return x0.fullTextArea;
    }

    static /* synthetic */ SearchComponent access$100(SearchPanel x0) {
        return x0.model;
    }

    static /* synthetic */ JCheckBox access$200(SearchPanel x0) {
        return x0.othersAsOwner;
    }

    static /* synthetic */ JButton access$300(SearchPanel x0) {
        return x0.ownerButton;
    }

    static /* synthetic */ JTextField access$400(SearchPanel x0) {
        return x0.usersAsOwner;
    }

    static /* synthetic */ JCheckBox access$500(SearchPanel x0) {
        return x0.othersAsAnnotator;
    }

    static /* synthetic */ JButton access$600(SearchPanel x0) {
        return x0.annotatorButton;
    }

    static /* synthetic */ JTextField access$700(SearchPanel x0) {
        return x0.usersAsAnnotator;
    }

    static {
        SearchPanel.dateOptions[0] = "Any date";
        SearchPanel.dateOptions[1] = "Last two weeks";
        SearchPanel.dateOptions[2] = "Last 30 days";
        SearchPanel.dateOptions[3] = "Last 60 days";
        SearchPanel.dateOptions[4] = "1 year";
        SearchPanel.dateOptions[5] = "Specify date range (" + "yy/MM/dd".toUpperCase() + ")";
        numberOfResults = new String[4];
        SearchPanel.numberOfResults[0] = "50 results";
        SearchPanel.numberOfResults[1] = "100 results";
        SearchPanel.numberOfResults[2] = "250 results";
        SearchPanel.numberOfResults[3] = "500 results";
        fileFormats = new String[9];
        SearchPanel.fileFormats[0] = "All formats";
        SearchPanel.fileFormats[1] = "HTML (.htm, .html)";
        SearchPanel.fileFormats[2] = "Adobe PDF (.pdf)";
        SearchPanel.fileFormats[3] = "Microsoft Excel (.xls)";
        SearchPanel.fileFormats[4] = "Microsoft PowerPoint (.ppt)";
        SearchPanel.fileFormats[5] = "Microsoft Word (.doc)";
        SearchPanel.fileFormats[6] = "RSS/XML (.xml)";
        SearchPanel.fileFormats[7] = "Text Format (.txt)";
    }
}

