/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchUtil {
    public static final String MINUS_SEPARATOR = "-";
    public static final String COMMA_SEPARATOR = ",";
    public static final String SPACE_SEPARATOR = " ";
    public static final String QUOTE_SEPARATOR = "\"";
    static final String ALL = "All";

    public static List<String> splitTerms(String text, String pattern) {
        ArrayList<String> l = new ArrayList<String>();
        if (text == null) {
            return l;
        }
        text = text.trim();
        String[] r = text.split(pattern);
        for (int i = 0; i < r.length; ++i) {
            String value = r[i];
            if (value == null || (value = value.trim()).length() == 0 || value.equals(ALL)) continue;
            l.add(value);
        }
        return l;
    }

    public static List<String> splitTerms(String text) {
        ArrayList<String> l = new ArrayList<String>();
        if (text == null) {
            return l;
        }
        text = text.trim();
        String pattern = SPACE_SEPARATOR;
        if (text.contains(QUOTE_SEPARATOR)) {
            pattern = QUOTE_SEPARATOR;
        }
        String[] r = text.split(pattern);
        for (int i = 0; i < r.length; ++i) {
            String value = r[i];
            if (value == null || (value = value.trim()).length() == 0 || value.equals(ALL) || value.equals(COMMA_SEPARATOR)) continue;
            if (value.contains(COMMA_SEPARATOR)) {
                value = value.replace(COMMA_SEPARATOR, "");
            }
            l.add(value);
        }
        return l;
    }

    public static String formatString(String termToAdd, List<String> terms) {
        String value;
        if (terms == null) {
            return termToAdd;
        }
        int n = terms.size();
        if (n == 0) {
            return termToAdd;
        }
        String result = "";
        Iterator<String> i = terms.iterator();
        boolean exist = false;
        while (i.hasNext()) {
            value = i.next();
            if (value == null || !value.equals(termToAdd)) continue;
            exist = true;
        }
        if (exist) {
            i = terms.iterator();
            int index = 0;
            while (i.hasNext()) {
                value = i.next();
                result = result + value;
                if (index != n) {
                    result = result + ", ";
                }
                ++index;
            }
            return result;
        }
        i = terms.iterator();
        while (i.hasNext()) {
            result = result + i.next();
            result = result + ", ";
        }
        result = result + termToAdd;
        return result;
    }
}

