/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tdialog;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;

class BorderListener
implements MouseMotionListener {
    private static int THICKNESS = 10;
    private TinyDialog model;

    private void setModelBounds(Rectangle bounds) {
        this.model.setBounds(bounds);
        this.model.setRestoreSize(new Dimension(bounds.width, bounds.height));
        this.model.validate();
    }

    BorderListener(TinyDialog model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
    }

    public void mouseDragged(MouseEvent e) {
        Rectangle bounds = this.model.getBounds();
        Point p = e.getPoint();
        Dimension min = this.model.getMinimumSize();
        Dimension max = this.model.getMaximumSize();
        if (p.x < THICKNESS) {
            this.model.invalidate();
            SwingUtilities.convertPointToScreen(p, this.model.getContentPane());
            int diff = bounds.x - p.x;
            bounds.x = p.x;
            bounds.width += diff;
            if (bounds.width > min.width && bounds.width < max.width) {
                this.setModelBounds(bounds);
            }
        } else if (e.getX() > this.model.getWidth() - THICKNESS) {
            this.model.invalidate();
            bounds.width = p.x;
            if (bounds.width > min.width && bounds.width < max.width) {
                this.setModelBounds(bounds);
            }
        } else if (e.getY() < THICKNESS) {
            this.model.invalidate();
            SwingUtilities.convertPointToScreen(p, this.model.getContentPane());
            int diff = bounds.y - p.y;
            bounds.y = p.y;
            bounds.height += diff;
            if (bounds.height < max.height && bounds.height > min.height) {
                this.setModelBounds(bounds);
            }
        } else if (e.getY() > this.model.getHeight() - THICKNESS) {
            this.model.invalidate();
            bounds.height = p.y;
            if (bounds.height < max.height && bounds.height > min.height) {
                this.setModelBounds(bounds);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

