/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tdialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.tdialog.ScreenControl;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialogUI;

class DialogControl
implements PropertyChangeListener,
ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    static final int SIZE = 0;
    static final int CLOSE = 1;
    private TinyDialog model;
    private TinyDialogUI view;
    private ScreenControl sControl;

    DialogControl(TinyDialog model, TinyDialogUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.sControl = new ScreenControl(this);
        model.addPropertyChangeListener(this);
        view.attachActionListener(this);
        view.attachMouseListener(this);
        view.attachMouseMotionListener(this);
    }

    TinyDialog getModel() {
        return this.model;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propChanged = pce.getPropertyName();
        if ("title".equals(propChanged)) {
            this.view.updateTitleBar();
        } else if ("closedDialog".equals(propChanged)) {
            this.model.closeWindow();
        } else if ("collapsed".equals(propChanged)) {
            this.view.updateCollapsedState();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            int index = Integer.parseInt(ae.getActionCommand());
            switch (index) {
                case 0: {
                    this.model.setCollapsed(!this.model.isCollapsed());
                    break;
                }
                case 1: {
                    this.model.setClosed(!this.model.isClosed());
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + ae.getActionCommand(), nfe);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        float zoomFactor = this.model.getZoomFactor();
        zoomFactor -= 0.1f * (float)e.getWheelRotation();
        if ((zoomFactor = (float)Math.round(zoomFactor * 10.0f) / 10.0f) < 1.0f) {
            zoomFactor = 1.0f;
        }
        if (zoomFactor > 2.0f) {
            zoomFactor = 2.0f;
        }
        this.model.setZoomFactor(zoomFactor);
        BufferedImage img = Factory.magnifyImage(zoomFactor, this.model.getOriginalImage());
        this.view.setImage(img);
    }

    public void mousePressed(MouseEvent e) {
        this.sControl.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.sControl.mouseReleased(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.sControl.mouseDragged(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

