/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;

public class EPSReader
extends FormatReader {
    private int start;
    private boolean binary;
    private boolean isTiff;
    private IFDList ifds;

    public EPSReader() {
        super("Encapsulated PostScript", new String[]{"eps", "epsi", "ps"});
        this.domains = new String[]{"Graphics"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.isTiff) {
            long[] offsets = ((IFD)this.ifds.get(0)).getStripOffsets();
            this.in.seek(offsets[0]);
            int[] map = ((IFD)this.ifds.get(0)).getIFDIntArray(320);
            if (map == null) {
                this.readPlane(this.in, x, y, w, h, buf);
                return buf;
            }
            byte[] b = new byte[w * h];
            this.in.skipBytes(2 * y * this.getSizeX());
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * 2);
                for (int col = 0; col < w; ++col) {
                    b[row * w + col] = (byte)(this.in.readShort() & 0xFF);
                }
                this.in.skipBytes(2 * (this.getSizeX() - w - x));
            }
            for (int i = 0; i < b.length; ++i) {
                int ndx = b[i] & 0xFF;
                for (int j = 0; j < this.getSizeC(); ++j) {
                    buf[i * this.getSizeC() + j] = (byte)map[ndx + j * 256];
                }
            }
            return buf;
        }
        if (this.start == 0) {
            throw new FormatException("Vector data not supported.");
        }
        this.in.seek(0L);
        for (int line = 0; line <= this.start; ++line) {
            this.in.readLine();
        }
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        if (this.binary) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            String pix = this.in.readString((int)(this.in.length() - this.in.getFilePointer()));
            pix = pix.replaceAll("\n", "");
            pix = pix.replaceAll("\r", "");
            int ndx = this.getSizeC() * y * bytes * this.getSizeX();
            int destNdx = 0;
            for (int row = 0; row < h; ++row) {
                ndx += x * this.getSizeC() * bytes;
                for (int col = 0; col < w * this.getSizeC() * bytes; ++col) {
                    buf[destNdx++] = (byte)Integer.parseInt(pix.substring(2 * ndx, 2 * (ndx + 1)), 16);
                    ++ndx;
                }
                ndx += this.getSizeC() * bytes * (this.getSizeX() - w - x);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.start = 0;
            this.isTiff = false;
            this.binary = false;
            this.ifds = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Verifying EPS format");
        String line = this.in.readLine();
        if (!line.trim().startsWith("%!PS")) {
            this.isTiff = true;
            this.in.order(true);
            this.in.seek(20L);
            int offset = this.in.readInt();
            int len = this.in.readInt();
            byte[] b = new byte[len];
            this.in.seek(offset);
            this.in.read(b);
            this.in = new RandomAccessInputStream(b);
            TiffParser tp = new TiffParser(this.in);
            this.ifds = tp.getIFDs();
            IFD firstIFD = (IFD)this.ifds.get(0);
            this.core[0].sizeX = (int)firstIFD.getImageWidth();
            this.core[0].sizeY = (int)firstIFD.getImageLength();
            this.core[0].sizeZ = 1;
            this.core[0].sizeT = 1;
            this.core[0].sizeC = firstIFD.getSamplesPerPixel();
            this.core[0].littleEndian = firstIFD.isLittleEndian();
            this.core[0].interleaved = true;
            this.core[0].rgb = this.getSizeC() > 1;
            this.core[0].pixelType = firstIFD.getPixelType();
            this.core[0].imageCount = 1;
            this.core[0].dimensionOrder = "XYCZT";
            this.core[0].metadataComplete = true;
            this.core[0].indexed = false;
            this.core[0].falseColor = false;
            MetadataStore store = this.makeFilterMetadata();
            MetadataTools.populatePixels(store, this);
            MetadataTools.setDefaultCreationDate(store, id, 0);
            return;
        }
        LOGGER.info("Finding image data");
        this.binary = false;
        String image = "image";
        int lineNum = 1;
        line = this.in.readLine().trim();
        while (line != null && !line.equals("%%EOF")) {
            block12: {
                block10: {
                    block13: {
                        block11: {
                            if (line.endsWith(image)) {
                                if (!line.startsWith(image)) {
                                    if (line.indexOf("colorimage") != -1) {
                                        this.core[0].sizeC = 3;
                                    }
                                    String[] t = line.split(" ");
                                    try {
                                        this.core[0].sizeX = Integer.parseInt(t[0]);
                                        this.core[0].sizeY = Integer.parseInt(t[1]);
                                    }
                                    catch (NumberFormatException exc) {
                                        LOGGER.debug("Could not parse image dimensions", (Throwable)exc);
                                        this.core[0].sizeC = Integer.parseInt(t[3]);
                                    }
                                }
                                this.start = lineNum;
                                break;
                            }
                            if (!line.startsWith("%%")) break block10;
                            if (!line.startsWith("%%BoundingBox:")) break block11;
                            line = line.substring(14).trim();
                            String[] t = line.split(" ");
                            int originX = Integer.parseInt(t[0].trim());
                            int originY = Integer.parseInt(t[1].trim());
                            this.core[0].sizeX = Integer.parseInt(t[2].trim()) - originX;
                            this.core[0].sizeY = Integer.parseInt(t[3].trim()) - originY;
                            this.addGlobalMeta("X-coordinate of origin", originX);
                            this.addGlobalMeta("Y-coordinate of origin", originY);
                            break block12;
                        }
                        if (!line.startsWith("%%BeginBinary")) break block13;
                        this.binary = true;
                        break block12;
                    }
                    int ndx = line.indexOf(":");
                    if (ndx == -1) break block12;
                    String key = line.substring(0, ndx);
                    String value = line.substring(ndx + 1);
                    this.addGlobalMeta(key, value);
                    break block12;
                }
                if (line.startsWith("%ImageData:")) {
                    line = line.substring(11);
                    String[] t = line.split(" ");
                    this.core[0].sizeX = Integer.parseInt(t[0]);
                    this.core[0].sizeY = Integer.parseInt(t[1]);
                    this.core[0].sizeC = Integer.parseInt(t[3]);
                    for (int i = 4; i < t.length; ++i) {
                        image = t[i].trim();
                        if (image.length() <= 1) continue;
                        image = image.substring(1, image.length() - 1);
                    }
                }
            }
            ++lineNum;
            line = this.in.readLine().trim();
        }
        LOGGER.info("Populating metadata");
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = 1;
        this.core[0].rgb = this.getSizeC() == 3;
        this.core[0].interleaved = true;
        this.core[0].littleEndian = true;
        this.core[0].imageCount = 1;
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
    }
}

