/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import loci.common.ByteArrayHandle;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveInteger;

public class ICSReader
extends FormatReader {
    public static final String NL = "\r\n";
    public static final String[] DATE_FORMATS = new String[]{"EEEE, MMMM dd, yyyy HH:mm:ss", "EEE dd MMMM yyyy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EE dd MMM yyyy HH:mm:ss z"};
    private static final String[] CATEGORIES = new String[]{"ics_version", "filename", "source", "layout", "representation", "parameter", "sensor", "history", "document", "view.*", "end", "file", "offset", "parameters", "order", "sizes", "coordinates", "significant_bits", "format", "sign", "compression", "byte_order", "origin", "scale", "units", "labels", "SCIL_TYPE", "type", "model", "s_params", "gain.*", "dwell", "shutter.*", "pinhole", "laser.*", "version", "objective", "PassCount", "step.*", "date", "GMTdate", "label", "software", "author", "length", "Z (background)", "dimensions", "rep period", "image form", "extents", "offsets", "region", "expon. order", "a.*", "tau.*", "noiseval", "excitationfwhm", "created on", "text", "other text", "mode", "CFD limit low", "CFD limit high", "CFD zc level", "CFD holdoff", "SYNC zc level", "SYNC freq div", "SYNC holdoff", "TAC range", "TAC gain", "TAC offset", "TAC limit low", "ADC resolution", "Ext latch delay", "collection time", "repeat time", "stop on time", "stop on O'flow", "dither range", "count increment", "memory bank", "sync threshold", "dead time comp", "polarity", "line compressio", "scan flyback", "scan borders", "pixel time", "pixel clock", "trigger", "scan pixels x", "scan pixels y", "routing chan x", "routing chan y", "detector type", "channel.*", "filter.*", "wavelength.*", "black level.*", "ht.*", "scan resolution", "scan speed", "scan zoom", "scan pattern", "scan pos x", "scan pos y", "transmission", "x amplitude", "y amplitude", "x offset", "y offset", "x delay", "y delay", "beam zoom", "mirror .*", "direct turret", "desc exc turret", "desc emm turret", "cube", "stage_xyzum", "cube descriptio", "camera", "exposure", "bits/pixel", "binning", "left", "top", "cols", "rows", "significant_channels", "allowedlinemodes", "real_significant_bits", "sample_width", "range", "ch", "lower_limit", "higher_limit", "passcount", "detector", "dateGMT", "RefrInxMedium", "RefrInxLensMedium", "Channels", "PinholeRadius", "LambdaEx", "LambdaEm", "ExPhotonCnt", "RefInxMedium", "NumAperture", "RefInxLensMedium", "PinholeSpacing", "power", "name", "Type", "Magnification", "NA", "WorkingDistance", "Immersion", "Pinhole", "Channel .*", "Gain .*", "Shutter .*", "Position", "Size", "Port", "Cursor", "Color", "BlackLevel", "Saturation", "Gamma", "IntZoom", "Live", "Synchronize", "ShowIndex", "AutoResize", "UseUnits", "Zoom", "IgnoreAspect", "ShowCursor", "ShowAll", "Axis", "Order", "Tile", "DimViewOption", "channels", "pinholeradius", "refrinxmedium", "numaperture", "refrinxlensmedium"};
    private String currentIcsId;
    private String currentIdsId;
    private boolean versionTwo;
    private byte[] data;
    private long offset;
    private boolean gzip;
    private boolean invertY;
    private boolean lifetime;
    private Vector<Integer> channelLengths;
    private Vector<String> channelTypes;
    private int prevImage;
    private boolean hasInstrumentData = false;
    private boolean storedRGB = false;

    public ICSReader() {
        super("Image Cytometry Standard", new String[]{"ics", "ids"});
        this.domains = new String[]{"Light Microscopy", "Fluorescence-Lifetime Imaging", "Unknown"};
        this.hasCompanionFiles = true;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        RandomAccessInputStream f = new RandomAccessInputStream(id);
        boolean singleFile = f.readString(17).trim().equals("ics_version\t2.0");
        f.close();
        return singleFile;
    }

    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        String[] domain = new String[]{"Graphics"};
        if (this.getChannelDimLengths().length > 1) {
            domain[0] = "Fluorescence-Lifetime Imaging";
        } else if (this.hasInstrumentData) {
            domain[0] = "Light Microscopy";
        }
        return domain;
    }

    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.currentId, true, 1);
        int[] len = new int[this.channelLengths.size()];
        for (int i = 0; i < len.length; ++i) {
            len[i] = this.channelLengths.get(i);
        }
        return len;
    }

    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.channelTypes.toArray(new String[this.channelTypes.size()]);
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return subC == 0 && this.isRGB();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int row;
        int sizeC;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int len = FormatTools.getPlaneSize(this);
        int pixel = bpp * this.getRGBChannelCount();
        int rowLen = FormatTools.getPlaneSize(this, w, 1);
        int[] coordinates = this.getZCTCoords(no);
        int[] prevCoordinates = this.getZCTCoords(this.prevImage);
        if (!this.gzip) {
            this.in.seek(this.offset + (long)no * (long)len);
        }
        int n = sizeC = this.lifetime ? 1 : this.getSizeC();
        if (!this.isRGB() && sizeC > 4 && this.channelLengths.size() == 1 && this.storedRGB) {
            this.in.seek(this.offset + (long)len * (long)this.getIndex(coordinates[0], 0, coordinates[2]));
            if (!this.gzip && this.data == null) {
                this.data = new byte[len * this.getSizeC()];
                this.in.read(this.data);
            } else if (!(this.gzip || coordinates[0] == prevCoordinates[0] && coordinates[2] == prevCoordinates[2])) {
                this.in.read(this.data);
            }
            for (row = y; row < h + y; ++row) {
                for (int col = x; col < w + x; ++col) {
                    System.arraycopy(this.data, bpp * (no % this.getSizeC() + sizeC * (row * this.getSizeX() + col)), buf, bpp * (row * w + col), bpp);
                }
            }
        } else if (this.gzip) {
            if (x == 0 && this.getSizeX() == w) {
                System.arraycopy(this.data, len * no + y * rowLen, buf, 0, h * rowLen);
            } else {
                for (row = y; row < h + y; ++row) {
                    System.arraycopy(this.data, len * no + pixel * (row * this.getSizeX() + x), buf, row * rowLen, rowLen);
                }
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        if (this.invertY) {
            byte[] row2 = new byte[rowLen];
            for (int r = 0; r < h / 2; ++r) {
                int topOffset = r * rowLen;
                int bottomOffset = (h - r - 1) * rowLen;
                System.arraycopy(buf, topOffset, row2, 0, rowLen);
                System.arraycopy(buf, bottomOffset, buf, topOffset, rowLen);
                System.arraycopy(row2, 0, buf, bottomOffset, rowLen);
            }
        }
        this.prevImage = no;
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.versionTwo) {
            String[] stringArray2;
            if (noPixels) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = this.currentIcsId;
            }
            return stringArray2;
        }
        if (noPixels) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = this.currentIcsId;
        } else {
            String[] stringArray5 = new String[2];
            stringArray5[0] = this.currentIcsId;
            stringArray = stringArray5;
            stringArray5[1] = this.currentIdsId;
        }
        return stringArray;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.currentIcsId = null;
            this.currentIdsId = null;
            this.data = null;
            this.versionTwo = false;
            this.gzip = false;
            this.invertY = false;
            this.lifetime = false;
            this.prevImage = 0;
            this.hasInstrumentData = false;
            this.storedRGB = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        char[] c;
        String ext;
        super.initFile(id);
        LOGGER.info("Finding companion file");
        String icsId = id;
        String idsId = id;
        int dot = id.lastIndexOf(".");
        String string = ext = dot < 0 ? "" : id.substring(dot + 1).toLowerCase();
        if (ext.equals("ics")) {
            c = idsId.toCharArray();
            int n = c.length - 2;
            c[n] = (char)(c[n] + '\u0001');
            idsId = new String(c);
        } else if (ext.equals("ids")) {
            c = icsId.toCharArray();
            int n = c.length - 2;
            c[n] = (char)(c[n] - '\u0001');
            icsId = new String(c);
        }
        if (icsId == null) {
            throw new FormatException("No ICS file found.");
        }
        Location icsFile = new Location(icsId);
        if (!icsFile.exists()) {
            throw new FormatException("ICS file not found.");
        }
        LOGGER.info("Checking file version");
        RandomAccessInputStream f = new RandomAccessInputStream(icsId);
        if (f.readString(17).trim().equals("ics_version\t2.0")) {
            this.in = new RandomAccessInputStream(icsId);
            this.versionTwo = true;
        } else {
            if (idsId == null) {
                throw new FormatException("No IDS file found.");
            }
            Location idsFile = new Location(idsId);
            if (!idsFile.exists()) {
                throw new FormatException("IDS file not found.");
            }
            this.currentIdsId = idsId;
            this.in = new RandomAccessInputStream(this.currentIdsId);
        }
        f.close();
        this.currentIcsId = icsId;
        LOGGER.info("Reading metadata");
        Double[] pixelSizes = null;
        String[] axes = null;
        int[] axisLengths = null;
        String byteOrder = null;
        String rFormat = null;
        String compression = null;
        RandomAccessInputStream reader = new RandomAccessInputStream(icsId);
        reader.seek(0L);
        reader.readString(NL);
        String line = reader.readString(NL);
        boolean signed = false;
        StringBuffer textBlock = new StringBuffer();
        double[] sizes = null;
        Integer[] emWaves = null;
        Integer[] exWaves = null;
        Double[] stagePos = null;
        String imageName = null;
        String date = null;
        String description = null;
        Double magnification = null;
        Double lensNA = null;
        Double workingDistance = null;
        String objectiveModel = null;
        String immersion = null;
        String lastName = null;
        Hashtable<Integer, Double> gains = new Hashtable<Integer, Double>();
        Hashtable<Integer, Double> pinholes = new Hashtable<Integer, Double>();
        Hashtable<Integer, Integer> wavelengths = new Hashtable<Integer, Integer>();
        Hashtable<Integer, String> channelNames = new Hashtable<Integer, String>();
        while (line != null && !line.trim().equals("end") && reader.getFilePointer() < reader.length() - 1L) {
            String[] tokens = null;
            tokens = line.indexOf("\t") != -1 ? line.split("\t") : line.split(" ");
            StringBuffer key = new StringBuffer();
            for (int q = 0; q < tokens.length; ++q) {
                Integer n;
                String[] waves;
                StringTokenizer t;
                tokens[q] = tokens[q].trim();
                if (tokens[q].length() == 0) continue;
                boolean foundValue = true;
                for (int i = 0; i < CATEGORIES.length; ++i) {
                    if (!tokens[q].matches(CATEGORIES[i])) continue;
                    foundValue = false;
                    break;
                }
                if (!foundValue) {
                    key.append(tokens[q]);
                    key.append(" ");
                    continue;
                }
                StringBuffer value = new StringBuffer(tokens[q++]);
                while (q < tokens.length) {
                    value.append(" ");
                    value.append(tokens[q].trim());
                    ++q;
                }
                String k = key.toString().trim().replaceAll("\t", " ");
                String v = value.toString().trim();
                this.addGlobalMeta(k, v);
                Double doubleValue = null;
                try {
                    doubleValue = new Double(v);
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Could not parse double value '{}'", (Object)v, (Object)e);
                }
                if (k.equalsIgnoreCase("layout sizes")) {
                    t = new StringTokenizer(v);
                    axisLengths = new int[t.countTokens()];
                    for (int n2 = 0; n2 < axisLengths.length; ++n2) {
                        try {
                            axisLengths[n2] = Integer.parseInt(t.nextToken().trim());
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse axis length", (Throwable)e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("layout order")) {
                    t = new StringTokenizer(v);
                    axes = new String[t.countTokens()];
                    for (int n3 = 0; n3 < axes.length; ++n3) {
                        axes[n3] = t.nextToken().trim();
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("representation byte_order")) {
                    byteOrder = v;
                    continue;
                }
                if (k.equalsIgnoreCase("representation format")) {
                    rFormat = v;
                    continue;
                }
                if (k.equalsIgnoreCase("representation compression")) {
                    compression = v;
                    continue;
                }
                if (k.equalsIgnoreCase("parameter scale")) {
                    t = new StringTokenizer(v);
                    pixelSizes = new Double[t.countTokens()];
                    for (int n4 = 0; n4 < pixelSizes.length; ++n4) {
                        try {
                            pixelSizes[n4] = new Double(t.nextToken().trim());
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse pixel size", (Throwable)e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("representation sign")) {
                    signed = v.equals("signed");
                    continue;
                }
                if (k.equalsIgnoreCase("history software") && v.indexOf("SVI") != -1) {
                    this.invertY = true;
                    continue;
                }
                if (k.equalsIgnoreCase("filename")) {
                    imageName = v;
                    continue;
                }
                if (k.equalsIgnoreCase("history date") || k.equalsIgnoreCase("history created on")) {
                    if (v.indexOf(" ") == -1) continue;
                    date = v.substring(0, v.lastIndexOf(" "));
                    date = DateTools.formatDate(date, DATE_FORMATS);
                    continue;
                }
                if (k.equalsIgnoreCase("history type")) {
                    if (!v.equalsIgnoreCase("time resolved")) continue;
                    this.lifetime = true;
                    continue;
                }
                if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
                if (k.equalsIgnoreCase("sensor s_params LambdaEm")) {
                    waves = v.split(" ");
                    emWaves = new Integer[waves.length];
                    for (int n5 = 0; n5 < emWaves.length; ++n5) {
                        try {
                            emWaves[n5] = new Integer((int)Double.parseDouble(waves[n5]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse emission wavelength", (Throwable)e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("sensor s_params LambdaEx")) {
                    waves = v.split(" ");
                    exWaves = new Integer[waves.length];
                    for (int n6 = 0; n6 < exWaves.length; ++n6) {
                        try {
                            exWaves[n6] = new Integer((int)Double.parseDouble(waves[n6]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse excitation wavelength", (Throwable)e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history") || k.equalsIgnoreCase("history text")) {
                    textBlock.append(v);
                    textBlock.append("\n");
                    this.metadata.remove(k);
                    continue;
                }
                if (k.startsWith("history gain")) {
                    n = new Integer(0);
                    try {
                        n = new Integer(k.substring(12).trim());
                        n = new Integer(n - 1);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (doubleValue == null) continue;
                    gains.put(n, doubleValue);
                    continue;
                }
                if (k.startsWith("history laser") && k.endsWith("wavelength")) {
                    int laser = Integer.parseInt(k.substring(13, k.indexOf(" ", 13))) - 1;
                    v = v.replaceAll("nm", "").trim();
                    try {
                        wavelengths.put(new Integer(laser), new Integer(v));
                    }
                    catch (NumberFormatException e) {
                        LOGGER.debug("Could not parse wavelength", (Throwable)e);
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history objective type")) {
                    objectiveModel = v;
                    continue;
                }
                if (k.equalsIgnoreCase("history objective immersion")) {
                    immersion = v;
                    continue;
                }
                if (k.equalsIgnoreCase("history objective NA")) {
                    lensNA = doubleValue;
                    continue;
                }
                if (k.equalsIgnoreCase("history objective WorkingDistance")) {
                    workingDistance = doubleValue;
                    continue;
                }
                if (k.equalsIgnoreCase("history objective magnification")) {
                    magnification = doubleValue;
                    continue;
                }
                if (k.equalsIgnoreCase("sensor s_params PinholeRadius")) {
                    String[] pins = v.split(" ");
                    int channel = 0;
                    for (int n7 = 0; n7 < pins.length; ++n7) {
                        if (pins[n7].trim().equals("")) continue;
                        try {
                            pinholes.put(new Integer(channel++), new Double(pins[n7]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse pinhole", (Throwable)e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history author")) {
                    lastName = v;
                    continue;
                }
                if (k.equalsIgnoreCase("history extents")) {
                    String[] lengths = v.split(" ");
                    sizes = new double[lengths.length];
                    for (int n8 = 0; n8 < sizes.length; ++n8) {
                        try {
                            sizes[n8] = Double.parseDouble(lengths[n8].trim());
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse axis length", (Throwable)e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history stage_xyzum")) {
                    String[] positions = v.split(" ");
                    stagePos = new Double[positions.length];
                    for (int n9 = 0; n9 < stagePos.length; ++n9) {
                        try {
                            stagePos[n9] = new Double(positions[n9]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse stage position", (Throwable)e);
                        }
                    }
                    continue;
                }
                if (k.equalsIgnoreCase("history other text")) {
                    description = v;
                    continue;
                }
                if (k.startsWith("history step") && k.endsWith("name")) {
                    n = new Integer(k.substring(12, k.indexOf(" ", 12)));
                    channelNames.put(n, v);
                    continue;
                }
                if (!k.equalsIgnoreCase("parameter ch")) continue;
                String[] names = v.split(" ");
                for (int n10 = 0; n10 < names.length; ++n10) {
                    channelNames.put(new Integer(n10), names[n10].trim());
                }
            }
            line = reader.readString(NL);
        }
        reader.close();
        this.hasInstrumentData = emWaves != null || exWaves != null || lensNA != null || stagePos != null || magnification != null || workingDistance != null || objectiveModel != null || immersion != null;
        this.addGlobalMeta("history text", textBlock.toString());
        LOGGER.info("Populating core metadata");
        this.core[0].rgb = false;
        this.core[0].dimensionOrder = "XY";
        this.channelLengths = new Vector();
        this.channelTypes = new Vector();
        int bitsPerPixel = 0;
        for (int i = 0; i < axes.length && i < axisLengths.length; ++i) {
            if (axes[i].equals("bits")) {
                bitsPerPixel = axisLengths[i];
                while (bitsPerPixel % 8 != 0) {
                    ++bitsPerPixel;
                }
                if (bitsPerPixel != 24 && bitsPerPixel != 48) continue;
                bitsPerPixel /= 3;
                continue;
            }
            if (axes[i].equals("x")) {
                this.core[0].sizeX = axisLengths[i];
                continue;
            }
            if (axes[i].equals("y")) {
                this.core[0].sizeY = axisLengths[i];
                continue;
            }
            if (axes[i].equals("z")) {
                this.core[0].sizeZ = axisLengths[i];
                if (this.getDimensionOrder().indexOf("Z") != -1) continue;
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                continue;
            }
            if (axes[i].equals("t")) {
                this.core[0].sizeT = this.getSizeT() == 0 ? axisLengths[i] : (this.core[0].sizeT *= axisLengths[i]);
                if (this.getDimensionOrder().indexOf("T") != -1) continue;
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
                continue;
            }
            this.core[0].sizeC = this.core[0].sizeC == 0 ? axisLengths[i] : (this.core[0].sizeC *= axisLengths[i]);
            this.channelLengths.add(new Integer((int)axisLengths[i]));
            this.storedRGB = this.getSizeX() == 0;
            boolean bl = this.core[0].rgb = this.getSizeX() == 0 && this.getSizeC() <= 4 && this.getSizeC() > 1;
            if (this.getDimensionOrder().indexOf("C") == -1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
            }
            if (axes[i].startsWith("c")) {
                this.channelTypes.add("Channel");
                continue;
            }
            if (axes[i].equals("p")) {
                this.channelTypes.add("Phase");
                continue;
            }
            if (axes[i].equals("f")) {
                this.channelTypes.add("Frequency");
                continue;
            }
            this.channelTypes.add("");
        }
        if (this.channelLengths.size() == 0) {
            this.channelLengths.add(new Integer(1));
            this.channelTypes.add("Channel");
        }
        this.core[0].dimensionOrder = MetadataTools.makeSaneDimensionOrder(this.getDimensionOrder());
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].interleaved = this.isRGB();
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        if (!this.isRGB()) {
            this.core[0].imageCount *= this.getSizeC();
        }
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        this.core[0].littleEndian = true;
        if (this.lifetime) {
            int binCount = this.core[0].sizeZ;
            this.core[0].sizeZ = this.core[0].sizeC;
            this.core[0].sizeC = binCount;
            this.core[0].cLengths = new int[]{binCount};
            this.core[0].cTypes = new String[]{"Lifetime"};
            String newOrder = this.core[0].dimensionOrder.replace("Z", "x");
            newOrder = newOrder.replace("C", "Z");
            this.core[0].dimensionOrder = newOrder = newOrder.replace("x", "C");
        }
        if (byteOrder != null) {
            String firstByte = byteOrder.split(" ")[0];
            int first = Integer.parseInt(firstByte);
            this.core[0].littleEndian = rFormat.equals("real") ? first == 1 : first != 1;
        }
        boolean bl = this.gzip = compression == null ? false : compression.equals("gzip");
        if (this.versionTwo) {
            String s = this.in.readString(NL);
            while (!s.trim().equals("end")) {
                s = this.in.readString(NL);
            }
        }
        this.offset = this.in.getFilePointer();
        int bytes = bitsPerPixel / 8;
        if (this.gzip) {
            this.data = new byte[(int)(this.in.length() - this.in.getFilePointer())];
            LOGGER.info("Decompressing pixel data");
            this.in.read(this.data);
            byte[] buf = new byte[8192];
            int nBytes = this.getImageCount() * this.getSizeX() * this.getSizeY() * bytes;
            ByteArrayHandle v = new ByteArrayHandle(nBytes);
            try {
                GZIPInputStream r = new GZIPInputStream(new ByteArrayInputStream(this.data));
                int n = r.read(buf, 0, buf.length);
                while (n > 0) {
                    v.write(buf, 0, n);
                    n = r.read(buf, 0, buf.length);
                }
                r.close();
                this.data = v.getBytes();
                v.close();
            }
            catch (IOException dfe) {
                throw new FormatException("Error uncompressing gzip'ed data", dfe);
            }
            buf = null;
        }
        if (bitsPerPixel < 32) {
            this.core[0].littleEndian = !this.isLittleEndian();
        }
        boolean fp = rFormat.equals("real");
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bytes, signed, fp);
        LOGGER.info("Populating OME metadata");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName(imageName, 0);
        if (date != null) {
            store.setImageAcquiredDate(date, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(description, 0);
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            if (pixelSizes != null) {
                for (int i = 0; i < pixelSizes.length; ++i) {
                    if (axes[i].equals("x")) {
                        store.setPixelsPhysicalSizeX(pixelSizes[i], 0);
                        continue;
                    }
                    if (axes[i].equals("y")) {
                        store.setPixelsPhysicalSizeY(pixelSizes[i], 0);
                        continue;
                    }
                    if (axes[i].equals("z")) {
                        store.setPixelsPhysicalSizeZ(pixelSizes[i], 0);
                        continue;
                    }
                    if (!axes[i].equals("t")) continue;
                    store.setPixelsTimeIncrement(pixelSizes[i], 0);
                }
            } else if (sizes != null) {
                if (sizes.length > 0) {
                    store.setPixelsPhysicalSizeX(sizes[0], 0);
                }
                if (sizes.length > 1) {
                    sizes[1] = sizes[1] / (double)this.getSizeY();
                    store.setPixelsPhysicalSizeY(sizes[1], 0);
                }
            }
            for (int i = 0; i < this.getEffectiveSizeC(); ++i) {
                if (channelNames.containsKey(i)) {
                    store.setChannelName((String)channelNames.get(i), 0, i);
                }
                if (pinholes.containsKey(i)) {
                    store.setChannelPinholeSize((Double)pinholes.get(i), 0, i);
                }
                if (emWaves != null && i < emWaves.length && emWaves[i] > 0) {
                    store.setChannelEmissionWavelength(new PositiveInteger(emWaves[i]), 0, i);
                }
                if (exWaves == null || i >= exWaves.length || exWaves[i] <= 0) continue;
                store.setChannelExcitationWavelength(new PositiveInteger(exWaves[i]), 0, i);
            }
            Integer[] lasers = wavelengths.keySet().toArray(new Integer[0]);
            for (int i = 0; i < lasers.length; ++i) {
                store.setLaserID(MetadataTools.createLSID("LightSource", 0, i), 0, i);
                store.setLaserWavelength(new PositiveInteger((Integer)wavelengths.get(lasers[i])), 0, i);
                store.setLaserType(this.getLaserType("Other"), 0, i);
                store.setLaserLaserMedium(this.getLaserMedium("Other"), 0, i);
            }
            if (objectiveModel != null) {
                store.setObjectiveModel(objectiveModel, 0, 0);
            }
            if (immersion == null) {
                immersion = "Other";
            }
            store.setObjectiveImmersion(this.getImmersion(immersion), 0, 0);
            if (lensNA != null) {
                store.setObjectiveLensNA(lensNA, 0, 0);
            }
            if (workingDistance != null) {
                store.setObjectiveWorkingDistance(workingDistance, 0, 0);
            }
            if (magnification != null) {
                store.setObjectiveCalibratedMagnification(magnification, 0, 0);
            }
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setImageObjectiveSettingsID(objectiveID, 0);
            for (Integer key : gains.keySet()) {
                int index = key;
                if (index >= this.getEffectiveSizeC()) continue;
                store.setDetectorSettingsGain((Double)gains.get(key), 0, index);
                store.setDetectorType(this.getDetectorType("Other"), 0, index);
                String detectorID = MetadataTools.createLSID("Detector", 0, index);
                store.setDetectorID(detectorID, 0, index);
                store.setDetectorSettingsID(detectorID, 0, index);
            }
            if (lastName != null) {
                String experimenterID = MetadataTools.createLSID("Experimenter", 0);
                store.setExperimenterID(experimenterID, 0);
                store.setExperimenterLastName(lastName, 0);
                store.setExperimenterDisplayName(lastName, 0);
            }
            if (stagePos != null) {
                for (int i = 0; i < this.getImageCount(); ++i) {
                    if (stagePos.length > 0) {
                        store.setPlanePositionX(stagePos[0], 0, i);
                        this.addGlobalMeta("X position for position #1", stagePos[0]);
                    }
                    if (stagePos.length > 1) {
                        store.setPlanePositionY(stagePos[1], 0, i);
                        this.addGlobalMeta("Y position for position #1", stagePos[1]);
                    }
                    if (stagePos.length <= 2) continue;
                    store.setPlanePositionZ(stagePos[2], 0, i);
                    this.addGlobalMeta("Z position for position #1", stagePos[2]);
                }
            }
        }
    }
}

