/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveInteger;

public class SimplePCITiffReader
extends BaseTiffReader {
    private static final String MAGIC_STRING = "Created by Hamamatsu Inc.";
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private MinimalTiffReader delegate;
    private String date;
    private Integer magnification;
    private String immersion;
    private String cameraType;
    private String cameraName;
    private String binning;
    private ArrayList<Double> exposureTimes;
    private double scaling;

    public SimplePCITiffReader() {
        super("SimplePCI TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        String comment = tp.getComment();
        if (comment == null) {
            return false;
        }
        return comment.trim().startsWith(MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.getSizeC() == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        byte[] b = this.delegate.openBytes(no / this.getSizeC(), x, y, w, h);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int c = this.getZCTCoords(no)[1];
        ImageTools.splitChannels(b, buf, c, this.getSizeC(), bpp, false, this.isInterleaved());
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.delegate != null) {
            this.delegate.close(fileOnly);
        }
        if (!fileOnly) {
            this.delegate = null;
            this.date = null;
            this.magnification = null;
            this.immersion = null;
            this.cameraType = null;
            this.cameraName = null;
            this.binning = null;
            this.exposureTimes = null;
            this.scaling = 0.0;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.delegate = new MinimalTiffReader();
        this.delegate.setId(this.currentId);
        this.exposureTimes = new ArrayList();
        String data = ((IFD)this.ifds.get(0)).getComment();
        data = data.substring(data.indexOf("\n") + 1);
        this.date = data.substring(0, data.indexOf("\n"));
        data = data.substring(data.indexOf("\n") + 1);
        data = data.replaceAll("ReadFromDoc", "");
        IniParser parser = new IniParser();
        parser.setCommentDelimiter(";");
        IniList ini = parser.parseINI(new BufferedReader(new StringReader(data)));
        String objective = (String)ini.getTable(" MICROSCOPE ").get("Objective");
        int space = objective.indexOf(" ");
        if (space != -1) {
            this.magnification = new Integer(objective.substring(0, space - 1));
            this.immersion = objective.substring(space + 1);
        }
        IniTable cameraTable = ini.getTable(" CAPTURE DEVICE ");
        this.binning = (String)cameraTable.get("Binning") + "x" + (String)cameraTable.get("Binning");
        this.cameraType = (String)cameraTable.get("Camera Type");
        this.cameraName = (String)cameraTable.get("Camera Name");
        this.core[0].bitsPerPixel = Integer.parseInt((String)cameraTable.get("Display Depth"));
        IniTable captureTable = ini.getTable(" CAPTURE ");
        int index = 1;
        for (int i = 0; i < this.getSizeC(); ++i) {
            if (captureTable.get("c_Filter" + index) != null) {
                this.exposureTimes.add(new Double((String)captureTable.get("c_Expos" + index)));
            } else {
                --i;
            }
            ++index;
        }
        IniTable calibrationTable = ini.getTable(" CALIBRATION ");
        String units = (String)calibrationTable.get("units");
        this.scaling = Double.parseDouble((String)calibrationTable.get("factor"));
        this.core[0].imageCount *= this.getSizeC();
        this.core[0].rgb = false;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            HashMap<String, String> iniMap = ini.flattenIntoHashMap();
            this.metadata.putAll(iniMap);
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.date != null) {
            store.setImageAcquiredDate(DateTools.formatDate(this.date, DATE_FORMAT), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i;
            store.setImageDescription(MAGIC_STRING, 0);
            store.setPixelsPhysicalSizeX(this.scaling, 0);
            store.setPixelsPhysicalSizeY(this.scaling, 0);
            String instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            store.setImageInstrumentRef(instrument, 0);
            store.setObjectiveID(MetadataTools.createLSID("Objective", 0, 0), 0, 0);
            store.setObjectiveNominalMagnification(new PositiveInteger(this.magnification), 0, 0);
            store.setObjectiveImmersion(this.getImmersion(this.immersion), 0, 0);
            String detector = MetadataTools.createLSID("Detector", 0, 0);
            store.setDetectorID(detector, 0, 0);
            store.setDetectorModel(this.cameraType + " " + this.cameraName, 0, 0);
            store.setDetectorType(this.getDetectorType("CCD"), 0, 0);
            for (i = 0; i < this.getSizeC(); ++i) {
                store.setDetectorSettingsID(detector, 0, i);
                store.setDetectorSettingsBinning(this.getBinning(this.binning), 0, i);
            }
            for (i = 0; i < this.getImageCount(); ++i) {
                int[] zct = this.getZCTCoords(i);
                store.setPlaneExposureTime(this.exposureTimes.get(zct[1]) / 1000000.0, 0, i);
            }
        }
    }
}

