/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import java.util.List;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveInteger;

public class AggregateMetadata
implements IMetadata {
    private List delegates;

    public AggregateMetadata(List delegates) {
        this.delegates = delegates;
    }

    public void createRoot() {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            ((MetadataStore)o).createRoot();
        }
    }

    public Object getRoot() {
        throw new RuntimeException("Unsupported with AggregateMetadata. Use getDelegates() and getRoot().");
    }

    public void setRoot(Object root) {
        throw new RuntimeException("Unsupported with AggregateMetadata. Use getDelegates() and setRoot().");
    }

    public int getPixelsBinDataCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsBinDataCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public String getLightSourceType(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataRetrieve)) continue;
            MetadataRetrieve retrieve = (MetadataRetrieve)o;
            return retrieve.getLightSourceType(instrumentIndex, lightSourceIndex);
        }
        return null;
    }

    public int getROIAnnotationRefCount(int ROIIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIAnnotationRefCount(ROIIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlateAcquisitionAnnotationRefCount(int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionAnnotationRefCount(plateIndex, plateAcquisitionIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlateAnnotationRefCount(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAnnotationRefCount(plateIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getImageAnnotationRefCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageAnnotationRefCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getScreenAnnotationRefCount(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenAnnotationRefCount(screenIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getWellAnnotationRefCount(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellAnnotationRefCount(plateIndex, wellIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getDatasetAnnotationRefCount(int datasetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetAnnotationRefCount(datasetIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getProjectAnnotationRefCount(int projectIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectAnnotationRefCount(projectIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getReagentAnnotationRefCount(int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentAnnotationRefCount(screenIndex, reagentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlaneAnnotationRefCount(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneAnnotationRefCount(imageIndex, planeIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getExperimenterAnnotationRefCount(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterAnnotationRefCount(experimenterIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getWellSampleAnnotationRefCount(int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleAnnotationRefCount(plateIndex, wellIndex, wellSampleIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPixelsAnnotationRefCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsAnnotationRefCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getChannelAnnotationRefCount(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelAnnotationRefCount(imageIndex, channelIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getBooleanAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getBooleanAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getChannelCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getCommentAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getCommentAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getDatasetCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getDatasetRefCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetRefCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getDetectorCount(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getDichroicCount(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDichroicCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getDoubleAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDoubleAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getLightPathEmissionFilterRefCount(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightPathEmissionFilterRefCount(imageIndex, channelIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getFilterSetEmissionFilterRefCount(int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetEmissionFilterRefCount(instrumentIndex, filterSetIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getLightPathExcitationFilterRefCount(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightPathExcitationFilterRefCount(imageIndex, channelIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getFilterSetExcitationFilterRefCount(int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetExcitationFilterRefCount(instrumentIndex, filterSetIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getExperimentCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getExperimenterCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getFileAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFileAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getFilterCount(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getFilterSetCount(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getGroupCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getGroupCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getExperimenterGroupRefCount(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterGroupRefCount(experimenterIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getImageCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getInstrumentCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getInstrumentCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getLightSourceCount(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightSourceCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getMicrobeamManipulationLightSourceSettingsCount(int experimentIndex, int microbeamManipulationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationLightSourceSettingsCount(experimentIndex, microbeamManipulationIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getListAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getListAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getLongAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLongAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getMicrobeamManipulationCount(int experimentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationCount(experimentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getMicrobeamManipulationRefCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationRefCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getOTFCount(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getObjectiveCount(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveCount(instrumentIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlaneCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlateCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlateAcquisitionCount(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionCount(plateIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getPlateRefCount(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateRefCount(screenIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getProjectCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getProjectRefCount(int datasetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectRefCount(datasetIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getROICount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROICount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getImageROIRefCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageROIRefCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getMicrobeamManipulationROIRefCount(int experimentIndex, int microbeamManipulationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationROIRefCount(experimentIndex, microbeamManipulationIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getReagentCount(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentCount(screenIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getScreenCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getScreenRefCount(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenRefCount(plateIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getShapeCount(int ROIIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getShapeCount(ROIIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getTagAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTagAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getTermAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTermAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getTiffDataCount(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataCount(imageIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getTimestampAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTimestampAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public void setUUIDValue(String value, int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            ((MetadataStore)o).setUUIDValue(value, imageIndex, tiffDataIndex);
        }
    }

    public String getUUIDValue(int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = ((MetadataRetrieve)o).getUUIDValue(imageIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public int getWellCount(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellCount(plateIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getWellSampleCount(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleCount(plateIndex, wellIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getWellSampleRefCount(int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleRefCount(plateIndex, plateAcquisitionIndex)) < 0) continue;
            return result;
        }
        return -1;
    }

    public int getXMLAnnotationCount() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            int result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getXMLAnnotationCount()) < 0) continue;
            return result;
        }
        return -1;
    }

    public Boolean getPixelsBinDataBigEndian(int imageIndex, int binDataIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Boolean result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsBinDataBigEndian(imageIndex, binDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getUUID() {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getUUID()) == null) continue;
            return result;
        }
        return null;
    }

    public String getArcID(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getArcID(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getArcLotNumber(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getArcLotNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getArcManufacturer(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getArcManufacturer(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getArcModel(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getArcModel(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getArcPower(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getArcPower(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getArcSerialNumber(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getArcSerialNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public ArcType getArcType(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            ArcType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getArcType(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFileAnnotationBinaryFileFileName(int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFileAnnotationBinaryFileFileName(fileAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getOTFBinaryFileFileName(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFBinaryFileFileName(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFileAnnotationBinaryFileMIMEType(int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFileAnnotationBinaryFileMIMEType(fileAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getOTFBinaryFileMIMEType(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFBinaryFileMIMEType(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeLong getFileAnnotationBinaryFileSize(int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeLong result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFileAnnotationBinaryFileSize(fileAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeLong getOTFBinaryFileSize(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeLong result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFBinaryFileSize(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getBooleanAnnotationAnnotationRef(int booleanAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getBooleanAnnotationAnnotationRef(booleanAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getBooleanAnnotationDescription(int booleanAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getBooleanAnnotationDescription(booleanAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getBooleanAnnotationID(int booleanAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getBooleanAnnotationID(booleanAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getBooleanAnnotationNamespace(int booleanAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getBooleanAnnotationNamespace(booleanAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getBooleanAnnotationValue(int booleanAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Boolean result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getBooleanAnnotationValue(booleanAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public AcquisitionMode getChannelAcquisitionMode(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            AcquisitionMode result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelAcquisitionMode(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getChannelAnnotationRef(int imageIndex, int channelIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelAnnotationRef(imageIndex, channelIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getChannelColor(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelColor(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public ContrastMethod getChannelContrastMethod(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            ContrastMethod result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelContrastMethod(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getChannelEmissionWavelength(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelEmissionWavelength(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getChannelExcitationWavelength(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelExcitationWavelength(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getChannelFilterSetRef(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelFilterSetRef(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getChannelFluor(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelFluor(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getChannelID(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelID(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public IlluminationType getChannelIlluminationType(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            IlluminationType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelIlluminationType(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getChannelNDFilter(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelNDFilter(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getChannelName(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelName(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getChannelOTFRef(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelOTFRef(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getChannelPinholeSize(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelPinholeSize(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getChannelPockelCellSetting(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelPockelCellSetting(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getChannelSamplesPerPixel(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelSamplesPerPixel(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getCommentAnnotationAnnotationRef(int commentAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getCommentAnnotationAnnotationRef(commentAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getCommentAnnotationDescription(int commentAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getCommentAnnotationDescription(commentAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getCommentAnnotationID(int commentAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getCommentAnnotationID(commentAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getCommentAnnotationNamespace(int commentAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getCommentAnnotationNamespace(commentAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getCommentAnnotationValue(int commentAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getCommentAnnotationValue(commentAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDatasetAnnotationRef(int datasetIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetAnnotationRef(datasetIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDatasetDescription(int datasetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetDescription(datasetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDatasetExperimenterRef(int datasetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetExperimenterRef(datasetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDatasetGroupRef(int datasetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetGroupRef(datasetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDatasetID(int datasetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetID(datasetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDatasetName(int datasetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetName(datasetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDatasetProjectRef(int datasetIndex, int projectRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDatasetProjectRef(datasetIndex, projectRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorAmplificationGain(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorAmplificationGain(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorGain(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorGain(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorID(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorID(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorLotNumber(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorLotNumber(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorManufacturer(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorManufacturer(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorModel(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorModel(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorOffset(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorOffset(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorSerialNumber(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSerialNumber(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public DetectorType getDetectorType(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            DetectorType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorType(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorVoltage(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorVoltage(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorZoom(int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorZoom(instrumentIndex, detectorIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Binning getDetectorSettingsBinning(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Binning result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsBinning(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorSettingsGain(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsGain(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDetectorSettingsID(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsID(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorSettingsOffset(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsOffset(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorSettingsReadOutRate(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsReadOutRate(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDetectorSettingsVoltage(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDetectorSettingsVoltage(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDichroicID(int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDichroicID(instrumentIndex, dichroicIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDichroicLotNumber(int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDichroicLotNumber(instrumentIndex, dichroicIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDichroicManufacturer(int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDichroicManufacturer(instrumentIndex, dichroicIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDichroicModel(int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDichroicModel(instrumentIndex, dichroicIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDichroicSerialNumber(int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDichroicSerialNumber(instrumentIndex, dichroicIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDoubleAnnotationAnnotationRef(int doubleAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDoubleAnnotationAnnotationRef(doubleAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDoubleAnnotationDescription(int doubleAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDoubleAnnotationDescription(doubleAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDoubleAnnotationID(int doubleAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDoubleAnnotationID(doubleAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getDoubleAnnotationNamespace(int doubleAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDoubleAnnotationNamespace(doubleAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getDoubleAnnotationValue(int doubleAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getDoubleAnnotationValue(doubleAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getEllipseDescription(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseDescription(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getEllipseFill(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseFill(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getEllipseFontSize(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseFontSize(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getEllipseID(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseID(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getEllipseLabel(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseLabel(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getEllipseName(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseName(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getEllipseStroke(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseStroke(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getEllipseStrokeDashArray(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseStrokeDashArray(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getEllipseStrokeWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseStrokeWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getEllipseTheC(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseTheC(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getEllipseTheT(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseTheT(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getEllipseTheZ(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseTheZ(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getEllipseTransform(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseTransform(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getEllipseRadiusX(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseRadiusX(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getEllipseRadiusY(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseRadiusY(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getEllipseX(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseX(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getEllipseY(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getEllipseY(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimentDescription(int experimentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentDescription(experimentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimentExperimenterRef(int experimentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentExperimenterRef(experimentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimentID(int experimentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentID(experimentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public ExperimentType getExperimentType(int experimentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            ExperimentType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimentType(experimentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterAnnotationRef(int experimenterIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterAnnotationRef(experimenterIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterDisplayName(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterDisplayName(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterEmail(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterEmail(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterFirstName(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterFirstName(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterGroupRef(int experimenterIndex, int groupRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterGroupRef(experimenterIndex, groupRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterID(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterID(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterInstitution(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterInstitution(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterLastName(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterLastName(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterMiddleName(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterMiddleName(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getExperimenterUserName(int experimenterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getExperimenterUserName(experimenterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilamentID(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilamentID(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilamentLotNumber(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilamentLotNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilamentManufacturer(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilamentManufacturer(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilamentModel(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilamentModel(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getFilamentPower(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilamentPower(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilamentSerialNumber(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilamentSerialNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public FilamentType getFilamentType(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            FilamentType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilamentType(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFileAnnotationAnnotationRef(int fileAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFileAnnotationAnnotationRef(fileAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFileAnnotationDescription(int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFileAnnotationDescription(fileAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFileAnnotationID(int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFileAnnotationID(fileAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFileAnnotationNamespace(int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFileAnnotationNamespace(fileAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterFilterWheel(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterFilterWheel(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterID(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterID(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterLotNumber(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterLotNumber(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterManufacturer(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterManufacturer(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterModel(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterModel(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSerialNumber(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSerialNumber(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public FilterType getFilterType(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            FilterType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterType(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSetDichroicRef(int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetDichroicRef(instrumentIndex, filterSetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSetEmissionFilterRef(int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetEmissionFilterRef(instrumentIndex, filterSetIndex, emissionFilterRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSetExcitationFilterRef(int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetExcitationFilterRef(instrumentIndex, filterSetIndex, excitationFilterRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSetID(int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetID(instrumentIndex, filterSetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSetLotNumber(int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetLotNumber(instrumentIndex, filterSetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSetManufacturer(int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetManufacturer(instrumentIndex, filterSetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSetModel(int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetModel(instrumentIndex, filterSetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getFilterSetSerialNumber(int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getFilterSetSerialNumber(instrumentIndex, filterSetIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getGroupContact(int groupIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getGroupContact(groupIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getGroupDescription(int groupIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getGroupDescription(groupIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getGroupID(int groupIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getGroupID(groupIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getGroupLeader(int groupIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getGroupLeader(groupIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getGroupName(int groupIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getGroupName(groupIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageAcquiredDate(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageAcquiredDate(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageAnnotationRef(int imageIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageAnnotationRef(imageIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageDatasetRef(int imageIndex, int datasetRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageDatasetRef(imageIndex, datasetRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageDescription(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageDescription(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageExperimentRef(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageExperimentRef(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageExperimenterRef(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageExperimenterRef(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageGroupRef(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageGroupRef(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageID(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageID(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageInstrumentRef(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageInstrumentRef(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageMicrobeamManipulationRef(int imageIndex, int microbeamManipulationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageMicrobeamManipulationRef(imageIndex, microbeamManipulationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageName(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageName(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageROIRef(int imageIndex, int ROIRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageROIRef(imageIndex, ROIRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getImagingEnvironmentAirPressure(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImagingEnvironmentAirPressure(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PercentFraction getImagingEnvironmentCO2Percent(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PercentFraction result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImagingEnvironmentCO2Percent(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PercentFraction getImagingEnvironmentHumidity(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PercentFraction result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImagingEnvironmentHumidity(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getImagingEnvironmentTemperature(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImagingEnvironmentTemperature(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getInstrumentID(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getInstrumentID(instrumentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserID(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserID(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserLotNumber(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserLotNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserManufacturer(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserManufacturer(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserModel(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserModel(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getLaserPower(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserPower(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserSerialNumber(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserSerialNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getLaserFrequencyMultiplication(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserFrequencyMultiplication(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public LaserMedium getLaserLaserMedium(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            LaserMedium result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserLaserMedium(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getLaserPockelCell(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Boolean result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserPockelCell(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Pulse getLaserPulse(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Pulse result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserPulse(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLaserPump(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserPump(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getLaserRepetitionRate(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserRepetitionRate(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getLaserTuneable(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Boolean result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserTuneable(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public LaserType getLaserType(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            LaserType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserType(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getLaserWavelength(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLaserWavelength(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightEmittingDiodeID(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightEmittingDiodeID(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightEmittingDiodeLotNumber(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightEmittingDiodeLotNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightEmittingDiodeManufacturer(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightEmittingDiodeManufacturer(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightEmittingDiodeModel(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightEmittingDiodeModel(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getLightEmittingDiodePower(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightEmittingDiodePower(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightEmittingDiodeSerialNumber(int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightEmittingDiodeSerialNumber(instrumentIndex, lightSourceIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightPathDichroicRef(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightPathDichroicRef(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightPathEmissionFilterRef(int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightPathEmissionFilterRef(imageIndex, channelIndex, emissionFilterRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLightPathExcitationFilterRef(int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLightPathExcitationFilterRef(imageIndex, channelIndex, excitationFilterRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PercentFraction getChannelLightSourceSettingsAttenuation(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PercentFraction result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelLightSourceSettingsAttenuation(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PercentFraction getMicrobeamManipulationLightSourceSettingsAttenuation(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PercentFraction result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationLightSourceSettingsAttenuation(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getChannelLightSourceSettingsID(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelLightSourceSettingsID(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMicrobeamManipulationLightSourceSettingsID(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationLightSourceSettingsID(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getChannelLightSourceSettingsWavelength(int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getChannelLightSourceSettingsWavelength(imageIndex, channelIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getMicrobeamManipulationLightSourceSettingsWavelength(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationLightSourceSettingsWavelength(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLineDescription(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineDescription(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLineFill(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineFill(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getLineFontSize(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineFontSize(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLineID(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineID(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLineLabel(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineLabel(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLineName(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineName(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getLineStroke(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineStroke(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLineStrokeDashArray(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineStrokeDashArray(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getLineStrokeWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineStrokeWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getLineTheC(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineTheC(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getLineTheT(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineTheT(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getLineTheZ(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineTheZ(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLineTransform(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineTransform(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getLineX1(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineX1(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getLineX2(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineX2(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getLineY1(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineY1(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getLineY2(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLineY2(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getListAnnotationAnnotationRef(int listAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getListAnnotationAnnotationRef(listAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getListAnnotationDescription(int listAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getListAnnotationDescription(listAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getListAnnotationID(int listAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getListAnnotationID(listAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getListAnnotationNamespace(int listAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getListAnnotationNamespace(listAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLongAnnotationAnnotationRef(int longAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLongAnnotationAnnotationRef(longAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLongAnnotationDescription(int longAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLongAnnotationDescription(longAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLongAnnotationID(int longAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLongAnnotationID(longAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getLongAnnotationNamespace(int longAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLongAnnotationNamespace(longAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Long getLongAnnotationValue(int longAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Long result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getLongAnnotationValue(longAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMaskDescription(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskDescription(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getMaskFill(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskFill(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getMaskFontSize(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskFontSize(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMaskID(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskID(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMaskLabel(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskLabel(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMaskName(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskName(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getMaskStroke(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskStroke(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMaskStrokeDashArray(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskStrokeDashArray(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getMaskStrokeWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskStrokeWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getMaskTheC(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskTheC(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getMaskTheT(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskTheT(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getMaskTheZ(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskTheZ(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMaskTransform(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskTransform(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getMaskHeight(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskHeight(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getMaskWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getMaskX(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskX(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getMaskY(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMaskY(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMicrobeamManipulationExperimenterRef(int experimentIndex, int microbeamManipulationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationExperimenterRef(experimentIndex, microbeamManipulationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMicrobeamManipulationID(int experimentIndex, int microbeamManipulationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationID(experimentIndex, microbeamManipulationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMicrobeamManipulationROIRef(int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationROIRef(experimentIndex, microbeamManipulationIndex, ROIRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public MicrobeamManipulationType getMicrobeamManipulationType(int experimentIndex, int microbeamManipulationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            MicrobeamManipulationType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicrobeamManipulationType(experimentIndex, microbeamManipulationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMicroscopeLotNumber(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicroscopeLotNumber(instrumentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMicroscopeManufacturer(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicroscopeManufacturer(instrumentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMicroscopeModel(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicroscopeModel(instrumentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getMicroscopeSerialNumber(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicroscopeSerialNumber(instrumentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public MicroscopeType getMicroscopeType(int instrumentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            MicroscopeType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getMicroscopeType(instrumentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getOTFFilterSetRef(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFFilterSetRef(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getOTFID(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFID(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getOTFOpticalAxisAveraged(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Boolean result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFOpticalAxisAveraged(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getOTFSizeX(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFSizeX(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getOTFSizeY(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFSizeY(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PixelType getOTFType(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PixelType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFType(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getObjectiveCalibratedMagnification(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveCalibratedMagnification(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Correction getObjectiveCorrection(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Correction result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveCorrection(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveID(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveID(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Immersion getObjectiveImmersion(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Immersion result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveImmersion(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getObjectiveIris(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Boolean result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveIris(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getObjectiveLensNA(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveLensNA(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveLotNumber(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveLotNumber(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveManufacturer(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveManufacturer(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveModel(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveModel(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getObjectiveNominalMagnification(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveNominalMagnification(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getObjectiveSerialNumber(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveSerialNumber(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getObjectiveWorkingDistance(int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getObjectiveWorkingDistance(instrumentIndex, objectiveIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getImageObjectiveSettingsCorrectionCollar(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageObjectiveSettingsCorrectionCollar(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getOTFObjectiveSettingsCorrectionCollar(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFObjectiveSettingsCorrectionCollar(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getImageObjectiveSettingsID(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageObjectiveSettingsID(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getOTFObjectiveSettingsID(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFObjectiveSettingsID(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Medium getImageObjectiveSettingsMedium(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Medium result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageObjectiveSettingsMedium(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Medium getOTFObjectiveSettingsMedium(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Medium result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFObjectiveSettingsMedium(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getImageObjectiveSettingsRefractiveIndex(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getImageObjectiveSettingsRefractiveIndex(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getOTFObjectiveSettingsRefractiveIndex(int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getOTFObjectiveSettingsRefractiveIndex(instrumentIndex, OTFIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPathDescription(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathDescription(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPathFill(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathFill(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPathFontSize(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathFontSize(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPathID(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathID(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPathLabel(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathLabel(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPathName(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathName(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPathStroke(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathStroke(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPathStrokeDashArray(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathStrokeDashArray(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPathStrokeWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathStrokeWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPathTheC(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathTheC(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPathTheT(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathTheT(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPathTheZ(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathTheZ(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPathTransform(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathTransform(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPathDefinition(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPathDefinition(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPixelsAnnotationRef(int imageIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsAnnotationRef(imageIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public DimensionOrder getPixelsDimensionOrder(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            DimensionOrder result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsDimensionOrder(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPixelsID(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsID(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPixelsPhysicalSizeX(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsPhysicalSizeX(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPixelsPhysicalSizeY(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsPhysicalSizeY(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPixelsPhysicalSizeZ(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsPhysicalSizeZ(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getPixelsSizeC(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeC(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getPixelsSizeT(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeT(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getPixelsSizeX(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeX(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getPixelsSizeY(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeY(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getPixelsSizeZ(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsSizeZ(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPixelsTimeIncrement(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsTimeIncrement(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PixelType getPixelsType(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PixelType result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPixelsType(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlaneAnnotationRef(int imageIndex, int planeIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneAnnotationRef(imageIndex, planeIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPlaneDeltaT(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneDeltaT(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPlaneExposureTime(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneExposureTime(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlaneHashSHA1(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneHashSHA1(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPlanePositionX(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlanePositionX(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPlanePositionY(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlanePositionY(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPlanePositionZ(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlanePositionZ(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPlaneTheC(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneTheC(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPlaneTheT(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneTheT(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPlaneTheZ(int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlaneTheZ(imageIndex, planeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateAnnotationRef(int plateIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAnnotationRef(plateIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NamingConvention getPlateColumnNamingConvention(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NamingConvention result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateColumnNamingConvention(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getPlateColumns(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateColumns(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateDescription(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateDescription(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateExternalIdentifier(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateExternalIdentifier(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateID(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateID(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateName(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateName(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NamingConvention getPlateRowNamingConvention(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NamingConvention result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateRowNamingConvention(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getPlateRows(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateRows(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateScreenRef(int plateIndex, int screenRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateScreenRef(plateIndex, screenRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateStatus(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateStatus(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPlateWellOriginX(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateWellOriginX(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPlateWellOriginY(int plateIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateWellOriginY(plateIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateAcquisitionAnnotationRef(int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionAnnotationRef(plateIndex, plateAcquisitionIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateAcquisitionDescription(int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionDescription(plateIndex, plateAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateAcquisitionEndTime(int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionEndTime(plateIndex, plateAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateAcquisitionID(int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionID(plateIndex, plateAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getPlateAcquisitionMaximumFieldCount(int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionMaximumFieldCount(plateIndex, plateAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateAcquisitionName(int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionName(plateIndex, plateAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateAcquisitionStartTime(int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionStartTime(plateIndex, plateAcquisitionIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPlateAcquisitionWellSampleRef(int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPlateAcquisitionWellSampleRef(plateIndex, plateAcquisitionIndex, wellSampleRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPointDescription(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointDescription(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPointFill(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointFill(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPointFontSize(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointFontSize(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPointID(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointID(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPointLabel(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointLabel(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPointName(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointName(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPointStroke(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointStroke(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPointStrokeDashArray(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointStrokeDashArray(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPointStrokeWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointStrokeWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPointTheC(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointTheC(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPointTheT(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointTheT(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPointTheZ(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointTheZ(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPointTransform(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointTransform(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPointX(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointX(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPointY(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPointY(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPolylineDescription(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineDescription(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPolylineFill(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineFill(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPolylineFontSize(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineFontSize(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPolylineID(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineID(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPolylineLabel(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineLabel(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPolylineName(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineName(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getPolylineStroke(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineStroke(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPolylineStrokeDashArray(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineStrokeDashArray(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getPolylineStrokeWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineStrokeWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPolylineTheC(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineTheC(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPolylineTheT(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineTheT(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getPolylineTheZ(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineTheZ(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPolylineTransform(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineTransform(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getPolylineClosed(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Boolean result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylineClosed(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getPolylinePoints(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getPolylinePoints(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getProjectAnnotationRef(int projectIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectAnnotationRef(projectIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getProjectDescription(int projectIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectDescription(projectIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getProjectExperimenterRef(int projectIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectExperimenterRef(projectIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getProjectGroupRef(int projectIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectGroupRef(projectIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getProjectID(int projectIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectID(projectIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getProjectName(int projectIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getProjectName(projectIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getROIAnnotationRef(int ROIIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIAnnotationRef(ROIIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getROIDescription(int ROIIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIDescription(ROIIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getROIID(int ROIIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIID(ROIIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getROIName(int ROIIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROIName(ROIIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getROINamespace(int ROIIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getROINamespace(ROIIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentAnnotationRef(int screenIndex, int reagentIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentAnnotationRef(screenIndex, reagentIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentDescription(int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentDescription(screenIndex, reagentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentID(int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentID(screenIndex, reagentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentName(int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentName(screenIndex, reagentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getReagentReagentIdentifier(int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getReagentReagentIdentifier(screenIndex, reagentIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getRectangleDescription(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleDescription(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getRectangleFill(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleFill(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getRectangleFontSize(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleFontSize(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getRectangleID(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleID(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getRectangleLabel(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleLabel(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getRectangleName(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleName(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getRectangleStroke(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleStroke(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getRectangleStrokeDashArray(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleStrokeDashArray(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getRectangleStrokeWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleStrokeWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getRectangleTheC(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleTheC(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getRectangleTheT(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleTheT(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getRectangleTheZ(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleTheZ(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getRectangleTransform(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleTransform(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getRectangleHeight(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleHeight(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getRectangleWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getRectangleX(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleX(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getRectangleY(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getRectangleY(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenAnnotationRef(int screenIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenAnnotationRef(screenIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenDescription(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenDescription(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenID(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenID(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenName(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenName(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenPlateRef(int screenIndex, int plateRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenPlateRef(screenIndex, plateRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenProtocolDescription(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenProtocolDescription(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenProtocolIdentifier(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenProtocolIdentifier(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenReagentSetDescription(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenReagentSetDescription(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenReagentSetIdentifier(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenReagentSetIdentifier(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getScreenType(int screenIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getScreenType(screenIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getStageLabelName(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStageLabelName(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getStageLabelX(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStageLabelX(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getStageLabelY(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStageLabelY(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getStageLabelZ(int imageIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getStageLabelZ(imageIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTagAnnotationAnnotationRef(int tagAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTagAnnotationAnnotationRef(tagAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTagAnnotationDescription(int tagAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTagAnnotationDescription(tagAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTagAnnotationID(int tagAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTagAnnotationID(tagAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTagAnnotationNamespace(int tagAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTagAnnotationNamespace(tagAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTagAnnotationValue(int tagAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTagAnnotationValue(tagAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTermAnnotationAnnotationRef(int termAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTermAnnotationAnnotationRef(termAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTermAnnotationDescription(int termAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTermAnnotationDescription(termAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTermAnnotationID(int termAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTermAnnotationID(termAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTermAnnotationNamespace(int termAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTermAnnotationNamespace(termAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTermAnnotationValue(int termAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTermAnnotationValue(termAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTextDescription(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextDescription(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getTextFill(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextFill(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTextFontSize(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextFontSize(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTextID(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextID(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTextLabel(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextLabel(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTextName(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextName(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getTextStroke(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextStroke(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTextStrokeDashArray(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextStrokeDashArray(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getTextStrokeWidth(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextStrokeWidth(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTextTheC(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextTheC(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTextTheT(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextTheT(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTextTheZ(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextTheZ(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTextTransform(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextTransform(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTextValue(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextValue(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getTextX(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextX(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getTextY(int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTextY(ROIIndex, shapeIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTiffDataFirstC(int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataFirstC(imageIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTiffDataFirstT(int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataFirstT(imageIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTiffDataFirstZ(int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataFirstZ(imageIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTiffDataIFD(int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataIFD(imageIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTiffDataPlaneCount(int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTiffDataPlaneCount(imageIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTimestampAnnotationAnnotationRef(int timestampAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTimestampAnnotationAnnotationRef(timestampAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTimestampAnnotationDescription(int timestampAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTimestampAnnotationDescription(timestampAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTimestampAnnotationID(int timestampAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTimestampAnnotationID(timestampAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTimestampAnnotationNamespace(int timestampAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTimestampAnnotationNamespace(timestampAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getTimestampAnnotationValue(int timestampAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTimestampAnnotationValue(timestampAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getTransmittanceRangeCutIn(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTransmittanceRangeCutIn(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTransmittanceRangeCutInTolerance(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTransmittanceRangeCutInTolerance(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PositiveInteger getTransmittanceRangeCutOut(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PositiveInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTransmittanceRangeCutOut(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getTransmittanceRangeCutOutTolerance(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTransmittanceRangeCutOutTolerance(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public PercentFraction getTransmittanceRangeTransmittance(int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            PercentFraction result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getTransmittanceRangeTransmittance(instrumentIndex, filterIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getUUIDFileName(int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getUUIDFileName(imageIndex, tiffDataIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellAnnotationRef(int plateIndex, int wellIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellAnnotationRef(plateIndex, wellIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Integer getWellColor(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Integer result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellColor(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getWellColumn(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellColumn(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellExternalDescription(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellExternalDescription(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellExternalIdentifier(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellExternalIdentifier(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellID(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellID(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellReagentRef(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellReagentRef(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getWellRow(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellRow(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellStatus(int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellStatus(plateIndex, wellIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellSampleAnnotationRef(int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleAnnotationRef(plateIndex, wellIndex, wellSampleIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellSampleID(int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleID(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellSampleImageRef(int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleImageRef(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public NonNegativeInteger getWellSampleIndex(int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            NonNegativeInteger result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleIndex(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getWellSamplePositionX(int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSamplePositionX(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public Double getWellSamplePositionY(int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            Double result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSamplePositionY(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getWellSampleTimepoint(int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getWellSampleTimepoint(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getXMLAnnotationAnnotationRef(int XMLAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getXMLAnnotationAnnotationRef(XMLAnnotationIndex, annotationRefIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getXMLAnnotationDescription(int XMLAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getXMLAnnotationDescription(XMLAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getXMLAnnotationID(int XMLAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getXMLAnnotationID(XMLAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getXMLAnnotationNamespace(int XMLAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getXMLAnnotationNamespace(XMLAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public String getXMLAnnotationValue(int XMLAnnotationIndex) {
        for (Object o : this.delegates) {
            MetadataRetrieve retrieve;
            String result;
            if (!(o instanceof MetadataRetrieve) || (result = (retrieve = (MetadataRetrieve)o).getXMLAnnotationValue(XMLAnnotationIndex)) == null) continue;
            return result;
        }
        return null;
    }

    public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsBinDataBigEndian(bigEndian, imageIndex, binDataIndex);
        }
    }

    public void setMaskBinData(byte[] binData, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskBinData(binData, ROIIndex, shapeIndex);
        }
    }

    public void setUUID(String uuid) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            ((MetadataStore)o).setUUID(uuid);
        }
    }

    public void setArcID(String id, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setArcID(id, instrumentIndex, lightSourceIndex);
        }
    }

    public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setArcLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setArcManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
        }
    }

    public void setArcModel(String model, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setArcModel(model, instrumentIndex, lightSourceIndex);
        }
    }

    public void setArcPower(Double power, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setArcPower(power, instrumentIndex, lightSourceIndex);
        }
    }

    public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setArcSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setArcType(ArcType type, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setArcType(type, instrumentIndex, lightSourceIndex);
        }
    }

    public void setFileAnnotationBinaryFileFileName(String fileName, int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFileAnnotationBinaryFileFileName(fileName, fileAnnotationIndex);
        }
    }

    public void setOTFBinaryFileFileName(String fileName, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFBinaryFileFileName(fileName, instrumentIndex, OTFIndex);
        }
    }

    public void setFileAnnotationBinaryFileMIMEType(String mimetype, int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFileAnnotationBinaryFileMIMEType(mimetype, fileAnnotationIndex);
        }
    }

    public void setOTFBinaryFileMIMEType(String mimetype, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFBinaryFileMIMEType(mimetype, instrumentIndex, OTFIndex);
        }
    }

    public void setFileAnnotationBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFileAnnotationBinaryFileSize(size, fileAnnotationIndex);
        }
    }

    public void setOTFBinaryFileSize(NonNegativeLong size, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFBinaryFileSize(size, instrumentIndex, OTFIndex);
        }
    }

    public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setBooleanAnnotationAnnotationRef(annotation, booleanAnnotationIndex, annotationRefIndex);
        }
    }

    public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setBooleanAnnotationDescription(description, booleanAnnotationIndex);
        }
    }

    public void setBooleanAnnotationID(String id, int booleanAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setBooleanAnnotationID(id, booleanAnnotationIndex);
        }
    }

    public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setBooleanAnnotationNamespace(namespace, booleanAnnotationIndex);
        }
    }

    public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setBooleanAnnotationValue(value, booleanAnnotationIndex);
        }
    }

    public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelAcquisitionMode(acquisitionMode, imageIndex, channelIndex);
        }
    }

    public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelAnnotationRef(annotation, imageIndex, channelIndex, annotationRefIndex);
        }
    }

    public void setChannelColor(Integer color, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelColor(color, imageIndex, channelIndex);
        }
    }

    public void setChannelContrastMethod(ContrastMethod contrastMethod, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelContrastMethod(contrastMethod, imageIndex, channelIndex);
        }
    }

    public void setChannelEmissionWavelength(PositiveInteger emissionWavelength, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelEmissionWavelength(emissionWavelength, imageIndex, channelIndex);
        }
    }

    public void setChannelExcitationWavelength(PositiveInteger excitationWavelength, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelExcitationWavelength(excitationWavelength, imageIndex, channelIndex);
        }
    }

    public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelFilterSetRef(filterSet, imageIndex, channelIndex);
        }
    }

    public void setChannelFluor(String fluor, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelFluor(fluor, imageIndex, channelIndex);
        }
    }

    public void setChannelID(String id, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelID(id, imageIndex, channelIndex);
        }
    }

    public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelIlluminationType(illuminationType, imageIndex, channelIndex);
        }
    }

    public void setChannelNDFilter(Double ndfilter, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelNDFilter(ndfilter, imageIndex, channelIndex);
        }
    }

    public void setChannelName(String name, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelName(name, imageIndex, channelIndex);
        }
    }

    public void setChannelOTFRef(String otf, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelOTFRef(otf, imageIndex, channelIndex);
        }
    }

    public void setChannelPinholeSize(Double pinholeSize, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelPinholeSize(pinholeSize, imageIndex, channelIndex);
        }
    }

    public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelPockelCellSetting(pockelCellSetting, imageIndex, channelIndex);
        }
    }

    public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelSamplesPerPixel(samplesPerPixel, imageIndex, channelIndex);
        }
    }

    public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setCommentAnnotationAnnotationRef(annotation, commentAnnotationIndex, annotationRefIndex);
        }
    }

    public void setCommentAnnotationDescription(String description, int commentAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setCommentAnnotationDescription(description, commentAnnotationIndex);
        }
    }

    public void setCommentAnnotationID(String id, int commentAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setCommentAnnotationID(id, commentAnnotationIndex);
        }
    }

    public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setCommentAnnotationNamespace(namespace, commentAnnotationIndex);
        }
    }

    public void setCommentAnnotationValue(String value, int commentAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setCommentAnnotationValue(value, commentAnnotationIndex);
        }
    }

    public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDatasetAnnotationRef(annotation, datasetIndex, annotationRefIndex);
        }
    }

    public void setDatasetDescription(String description, int datasetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDatasetDescription(description, datasetIndex);
        }
    }

    public void setDatasetExperimenterRef(String experimenter, int datasetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDatasetExperimenterRef(experimenter, datasetIndex);
        }
    }

    public void setDatasetGroupRef(String group, int datasetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDatasetGroupRef(group, datasetIndex);
        }
    }

    public void setDatasetID(String id, int datasetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDatasetID(id, datasetIndex);
        }
    }

    public void setDatasetName(String name, int datasetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDatasetName(name, datasetIndex);
        }
    }

    public void setDatasetProjectRef(String project, int datasetIndex, int projectRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDatasetProjectRef(project, datasetIndex, projectRefIndex);
        }
    }

    public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorAmplificationGain(amplificationGain, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorGain(gain, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorID(id, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorLotNumber(lotNumber, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorManufacturer(manufacturer, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorModel(model, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorOffset(offset, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSerialNumber(serialNumber, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorType(type, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorVoltage(Double voltage, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorVoltage(voltage, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorZoom(zoom, instrumentIndex, detectorIndex);
        }
    }

    public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsBinning(binning, imageIndex, channelIndex);
        }
    }

    public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsGain(gain, imageIndex, channelIndex);
        }
    }

    public void setDetectorSettingsID(String id, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsID(id, imageIndex, channelIndex);
        }
    }

    public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsOffset(offset, imageIndex, channelIndex);
        }
    }

    public void setDetectorSettingsReadOutRate(Double readOutRate, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsReadOutRate(readOutRate, imageIndex, channelIndex);
        }
    }

    public void setDetectorSettingsVoltage(Double voltage, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDetectorSettingsVoltage(voltage, imageIndex, channelIndex);
        }
    }

    public void setDichroicID(String id, int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDichroicID(id, instrumentIndex, dichroicIndex);
        }
    }

    public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDichroicLotNumber(lotNumber, instrumentIndex, dichroicIndex);
        }
    }

    public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDichroicManufacturer(manufacturer, instrumentIndex, dichroicIndex);
        }
    }

    public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDichroicModel(model, instrumentIndex, dichroicIndex);
        }
    }

    public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDichroicSerialNumber(serialNumber, instrumentIndex, dichroicIndex);
        }
    }

    public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDoubleAnnotationAnnotationRef(annotation, doubleAnnotationIndex, annotationRefIndex);
        }
    }

    public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDoubleAnnotationDescription(description, doubleAnnotationIndex);
        }
    }

    public void setDoubleAnnotationID(String id, int doubleAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDoubleAnnotationID(id, doubleAnnotationIndex);
        }
    }

    public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDoubleAnnotationNamespace(namespace, doubleAnnotationIndex);
        }
    }

    public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setDoubleAnnotationValue(value, doubleAnnotationIndex);
        }
    }

    public void setEllipseDescription(String description, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseDescription(description, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseFill(Integer fill, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseFill(fill, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseFontSize(fontSize, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseID(String id, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseID(id, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseLabel(String label, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseLabel(label, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseName(String name, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseName(name, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseStroke(stroke, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseTheC(theC, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseTheT(theT, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseTheZ(theZ, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseTransform(String transform, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseTransform(transform, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseRadiusX(radiusX, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseRadiusY(radiusY, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseX(Double x, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseX(x, ROIIndex, shapeIndex);
        }
    }

    public void setEllipseY(Double y, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setEllipseY(y, ROIIndex, shapeIndex);
        }
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimentDescription(description, experimentIndex);
        }
    }

    public void setExperimentExperimenterRef(String experimenter, int experimentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimentExperimenterRef(experimenter, experimentIndex);
        }
    }

    public void setExperimentID(String id, int experimentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimentID(id, experimentIndex);
        }
    }

    public void setExperimentType(ExperimentType type, int experimentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimentType(type, experimentIndex);
        }
    }

    public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterAnnotationRef(annotation, experimenterIndex, annotationRefIndex);
        }
    }

    public void setExperimenterDisplayName(String displayName, int experimenterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterDisplayName(displayName, experimenterIndex);
        }
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterEmail(email, experimenterIndex);
        }
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterFirstName(firstName, experimenterIndex);
        }
    }

    public void setExperimenterGroupRef(String group, int experimenterIndex, int groupRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterGroupRef(group, experimenterIndex, groupRefIndex);
        }
    }

    public void setExperimenterID(String id, int experimenterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterID(id, experimenterIndex);
        }
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterInstitution(institution, experimenterIndex);
        }
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterLastName(lastName, experimenterIndex);
        }
    }

    public void setExperimenterMiddleName(String middleName, int experimenterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterMiddleName(middleName, experimenterIndex);
        }
    }

    public void setExperimenterUserName(String userName, int experimenterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setExperimenterUserName(userName, experimenterIndex);
        }
    }

    public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilamentID(id, instrumentIndex, lightSourceIndex);
        }
    }

    public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilamentLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilamentManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
        }
    }

    public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilamentModel(model, instrumentIndex, lightSourceIndex);
        }
    }

    public void setFilamentPower(Double power, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilamentPower(power, instrumentIndex, lightSourceIndex);
        }
    }

    public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilamentSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setFilamentType(FilamentType type, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilamentType(type, instrumentIndex, lightSourceIndex);
        }
    }

    public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFileAnnotationAnnotationRef(annotation, fileAnnotationIndex, annotationRefIndex);
        }
    }

    public void setFileAnnotationDescription(String description, int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFileAnnotationDescription(description, fileAnnotationIndex);
        }
    }

    public void setFileAnnotationID(String id, int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFileAnnotationID(id, fileAnnotationIndex);
        }
    }

    public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFileAnnotationNamespace(namespace, fileAnnotationIndex);
        }
    }

    public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterFilterWheel(filterWheel, instrumentIndex, filterIndex);
        }
    }

    public void setFilterID(String id, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterID(id, instrumentIndex, filterIndex);
        }
    }

    public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterLotNumber(lotNumber, instrumentIndex, filterIndex);
        }
    }

    public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterManufacturer(manufacturer, instrumentIndex, filterIndex);
        }
    }

    public void setFilterModel(String model, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterModel(model, instrumentIndex, filterIndex);
        }
    }

    public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSerialNumber(serialNumber, instrumentIndex, filterIndex);
        }
    }

    public void setFilterType(FilterType type, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterType(type, instrumentIndex, filterIndex);
        }
    }

    public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSetDichroicRef(dichroic, instrumentIndex, filterSetIndex);
        }
    }

    public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSetEmissionFilterRef(emissionFilter, instrumentIndex, filterSetIndex, emissionFilterRefIndex);
        }
    }

    public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSetExcitationFilterRef(excitationFilter, instrumentIndex, filterSetIndex, excitationFilterRefIndex);
        }
    }

    public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSetID(id, instrumentIndex, filterSetIndex);
        }
    }

    public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSetLotNumber(lotNumber, instrumentIndex, filterSetIndex);
        }
    }

    public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSetManufacturer(manufacturer, instrumentIndex, filterSetIndex);
        }
    }

    public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSetModel(model, instrumentIndex, filterSetIndex);
        }
    }

    public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setFilterSetSerialNumber(serialNumber, instrumentIndex, filterSetIndex);
        }
    }

    public void setGroupContact(String contact, int groupIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setGroupContact(contact, groupIndex);
        }
    }

    public void setGroupDescription(String description, int groupIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setGroupDescription(description, groupIndex);
        }
    }

    public void setGroupID(String id, int groupIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setGroupID(id, groupIndex);
        }
    }

    public void setGroupLeader(String leader, int groupIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setGroupLeader(leader, groupIndex);
        }
    }

    public void setGroupName(String name, int groupIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setGroupName(name, groupIndex);
        }
    }

    public void setImageAcquiredDate(String acquiredDate, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageAcquiredDate(acquiredDate, imageIndex);
        }
    }

    public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageAnnotationRef(annotation, imageIndex, annotationRefIndex);
        }
    }

    public void setImageDatasetRef(String dataset, int imageIndex, int datasetRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageDatasetRef(dataset, imageIndex, datasetRefIndex);
        }
    }

    public void setImageDescription(String description, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageDescription(description, imageIndex);
        }
    }

    public void setImageExperimentRef(String experiment, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageExperimentRef(experiment, imageIndex);
        }
    }

    public void setImageExperimenterRef(String experimenter, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageExperimenterRef(experimenter, imageIndex);
        }
    }

    public void setImageGroupRef(String group, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageGroupRef(group, imageIndex);
        }
    }

    public void setImageID(String id, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageID(id, imageIndex);
        }
    }

    public void setImageInstrumentRef(String instrument, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageInstrumentRef(instrument, imageIndex);
        }
    }

    public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageMicrobeamManipulationRef(microbeamManipulation, imageIndex, microbeamManipulationRefIndex);
        }
    }

    public void setImageName(String name, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageName(name, imageIndex);
        }
    }

    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageROIRef(roi, imageIndex, ROIRefIndex);
        }
    }

    public void setImagingEnvironmentAirPressure(Double airPressure, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImagingEnvironmentAirPressure(airPressure, imageIndex);
        }
    }

    public void setImagingEnvironmentCO2Percent(PercentFraction co2percent, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImagingEnvironmentCO2Percent(co2percent, imageIndex);
        }
    }

    public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImagingEnvironmentHumidity(humidity, imageIndex);
        }
    }

    public void setImagingEnvironmentTemperature(Double temperature, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImagingEnvironmentTemperature(temperature, imageIndex);
        }
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setInstrumentID(id, instrumentIndex);
        }
    }

    public void setLaserID(String id, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserID(id, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserModel(model, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserPower(Double power, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserPower(power, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserFrequencyMultiplication(frequencyMultiplication, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserLaserMedium(LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserLaserMedium(laserMedium, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserPockelCell(pockelCell, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserPulse(pulse, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserPump(pump, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserRepetitionRate(Double repetitionRate, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserRepetitionRate(repetitionRate, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserTuneable(tuneable, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserType(type, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLaserWavelength(PositiveInteger wavelength, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLaserWavelength(wavelength, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightEmittingDiodeID(id, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightEmittingDiodeLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightEmittingDiodeManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightEmittingDiodeModel(model, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightEmittingDiodePower(Double power, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightEmittingDiodePower(power, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightEmittingDiodeSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
        }
    }

    public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightPathDichroicRef(dichroic, imageIndex, channelIndex);
        }
    }

    public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightPathEmissionFilterRef(emissionFilter, imageIndex, channelIndex, emissionFilterRefIndex);
        }
    }

    public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLightPathExcitationFilterRef(excitationFilter, imageIndex, channelIndex, excitationFilterRefIndex);
        }
    }

    public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelLightSourceSettingsAttenuation(attenuation, imageIndex, channelIndex);
        }
    }

    public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicrobeamManipulationLightSourceSettingsAttenuation(attenuation, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        }
    }

    public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelLightSourceSettingsID(id, imageIndex, channelIndex);
        }
    }

    public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicrobeamManipulationLightSourceSettingsID(id, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        }
    }

    public void setChannelLightSourceSettingsWavelength(PositiveInteger wavelength, int imageIndex, int channelIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setChannelLightSourceSettingsWavelength(wavelength, imageIndex, channelIndex);
        }
    }

    public void setMicrobeamManipulationLightSourceSettingsWavelength(PositiveInteger wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicrobeamManipulationLightSourceSettingsWavelength(wavelength, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
        }
    }

    public void setLineDescription(String description, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineDescription(description, ROIIndex, shapeIndex);
        }
    }

    public void setLineFill(Integer fill, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineFill(fill, ROIIndex, shapeIndex);
        }
    }

    public void setLineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineFontSize(fontSize, ROIIndex, shapeIndex);
        }
    }

    public void setLineID(String id, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineID(id, ROIIndex, shapeIndex);
        }
    }

    public void setLineLabel(String label, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineLabel(label, ROIIndex, shapeIndex);
        }
    }

    public void setLineName(String name, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineName(name, ROIIndex, shapeIndex);
        }
    }

    public void setLineStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineStroke(stroke, ROIIndex, shapeIndex);
        }
    }

    public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
        }
    }

    public void setLineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
        }
    }

    public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineTheC(theC, ROIIndex, shapeIndex);
        }
    }

    public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineTheT(theT, ROIIndex, shapeIndex);
        }
    }

    public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineTheZ(theZ, ROIIndex, shapeIndex);
        }
    }

    public void setLineTransform(String transform, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineTransform(transform, ROIIndex, shapeIndex);
        }
    }

    public void setLineX1(Double x1, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineX1(x1, ROIIndex, shapeIndex);
        }
    }

    public void setLineX2(Double x2, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineX2(x2, ROIIndex, shapeIndex);
        }
    }

    public void setLineY1(Double y1, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineY1(y1, ROIIndex, shapeIndex);
        }
    }

    public void setLineY2(Double y2, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLineY2(y2, ROIIndex, shapeIndex);
        }
    }

    public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setListAnnotationAnnotationRef(annotation, listAnnotationIndex, annotationRefIndex);
        }
    }

    public void setListAnnotationDescription(String description, int listAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setListAnnotationDescription(description, listAnnotationIndex);
        }
    }

    public void setListAnnotationID(String id, int listAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setListAnnotationID(id, listAnnotationIndex);
        }
    }

    public void setListAnnotationNamespace(String namespace, int listAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setListAnnotationNamespace(namespace, listAnnotationIndex);
        }
    }

    public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLongAnnotationAnnotationRef(annotation, longAnnotationIndex, annotationRefIndex);
        }
    }

    public void setLongAnnotationDescription(String description, int longAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLongAnnotationDescription(description, longAnnotationIndex);
        }
    }

    public void setLongAnnotationID(String id, int longAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLongAnnotationID(id, longAnnotationIndex);
        }
    }

    public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLongAnnotationNamespace(namespace, longAnnotationIndex);
        }
    }

    public void setLongAnnotationValue(Long value, int longAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setLongAnnotationValue(value, longAnnotationIndex);
        }
    }

    public void setMaskDescription(String description, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskDescription(description, ROIIndex, shapeIndex);
        }
    }

    public void setMaskFill(Integer fill, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskFill(fill, ROIIndex, shapeIndex);
        }
    }

    public void setMaskFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskFontSize(fontSize, ROIIndex, shapeIndex);
        }
    }

    public void setMaskID(String id, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskID(id, ROIIndex, shapeIndex);
        }
    }

    public void setMaskLabel(String label, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskLabel(label, ROIIndex, shapeIndex);
        }
    }

    public void setMaskName(String name, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskName(name, ROIIndex, shapeIndex);
        }
    }

    public void setMaskStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskStroke(stroke, ROIIndex, shapeIndex);
        }
    }

    public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
        }
    }

    public void setMaskStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
        }
    }

    public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskTheC(theC, ROIIndex, shapeIndex);
        }
    }

    public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskTheT(theT, ROIIndex, shapeIndex);
        }
    }

    public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskTheZ(theZ, ROIIndex, shapeIndex);
        }
    }

    public void setMaskTransform(String transform, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskTransform(transform, ROIIndex, shapeIndex);
        }
    }

    public void setMaskHeight(Double height, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskHeight(height, ROIIndex, shapeIndex);
        }
    }

    public void setMaskWidth(Double width, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskWidth(width, ROIIndex, shapeIndex);
        }
    }

    public void setMaskX(Double x, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskX(x, ROIIndex, shapeIndex);
        }
    }

    public void setMaskY(Double y, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMaskY(y, ROIIndex, shapeIndex);
        }
    }

    public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicrobeamManipulationExperimenterRef(experimenter, experimentIndex, microbeamManipulationIndex);
        }
    }

    public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicrobeamManipulationID(id, experimentIndex, microbeamManipulationIndex);
        }
    }

    public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicrobeamManipulationROIRef(roi, experimentIndex, microbeamManipulationIndex, ROIRefIndex);
        }
    }

    public void setMicrobeamManipulationType(MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicrobeamManipulationType(type, experimentIndex, microbeamManipulationIndex);
        }
    }

    public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicroscopeLotNumber(lotNumber, instrumentIndex);
        }
    }

    public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicroscopeManufacturer(manufacturer, instrumentIndex);
        }
    }

    public void setMicroscopeModel(String model, int instrumentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicroscopeModel(model, instrumentIndex);
        }
    }

    public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicroscopeSerialNumber(serialNumber, instrumentIndex);
        }
    }

    public void setMicroscopeType(MicroscopeType type, int instrumentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setMicroscopeType(type, instrumentIndex);
        }
    }

    public void setOTFFilterSetRef(String filterSet, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFFilterSetRef(filterSet, instrumentIndex, OTFIndex);
        }
    }

    public void setOTFID(String id, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFID(id, instrumentIndex, OTFIndex);
        }
    }

    public void setOTFOpticalAxisAveraged(Boolean opticalAxisAveraged, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFOpticalAxisAveraged(opticalAxisAveraged, instrumentIndex, OTFIndex);
        }
    }

    public void setOTFSizeX(PositiveInteger sizeX, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFSizeX(sizeX, instrumentIndex, OTFIndex);
        }
    }

    public void setOTFSizeY(PositiveInteger sizeY, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFSizeY(sizeY, instrumentIndex, OTFIndex);
        }
    }

    public void setOTFType(PixelType type, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFType(type, instrumentIndex, OTFIndex);
        }
    }

    public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveCalibratedMagnification(calibratedMagnification, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveCorrection(correction, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveID(id, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveImmersion(Immersion immersion, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveImmersion(immersion, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveIris(iris, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveLensNA(lensNA, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveLotNumber(lotNumber, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveManufacturer(manufacturer, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveModel(model, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveNominalMagnification(PositiveInteger nominalMagnification, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveNominalMagnification(nominalMagnification, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveSerialNumber(serialNumber, instrumentIndex, objectiveIndex);
        }
    }

    public void setObjectiveWorkingDistance(Double workingDistance, int instrumentIndex, int objectiveIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setObjectiveWorkingDistance(workingDistance, instrumentIndex, objectiveIndex);
        }
    }

    public void setImageObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageObjectiveSettingsCorrectionCollar(correctionCollar, imageIndex);
        }
    }

    public void setOTFObjectiveSettingsCorrectionCollar(Double correctionCollar, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFObjectiveSettingsCorrectionCollar(correctionCollar, instrumentIndex, OTFIndex);
        }
    }

    public void setImageObjectiveSettingsID(String id, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageObjectiveSettingsID(id, imageIndex);
        }
    }

    public void setOTFObjectiveSettingsID(String id, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFObjectiveSettingsID(id, instrumentIndex, OTFIndex);
        }
    }

    public void setImageObjectiveSettingsMedium(Medium medium, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageObjectiveSettingsMedium(medium, imageIndex);
        }
    }

    public void setOTFObjectiveSettingsMedium(Medium medium, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFObjectiveSettingsMedium(medium, instrumentIndex, OTFIndex);
        }
    }

    public void setImageObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setImageObjectiveSettingsRefractiveIndex(refractiveIndex, imageIndex);
        }
    }

    public void setOTFObjectiveSettingsRefractiveIndex(Double refractiveIndex, int instrumentIndex, int OTFIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setOTFObjectiveSettingsRefractiveIndex(refractiveIndex, instrumentIndex, OTFIndex);
        }
    }

    public void setPathDescription(String description, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathDescription(description, ROIIndex, shapeIndex);
        }
    }

    public void setPathFill(Integer fill, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathFill(fill, ROIIndex, shapeIndex);
        }
    }

    public void setPathFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathFontSize(fontSize, ROIIndex, shapeIndex);
        }
    }

    public void setPathID(String id, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathID(id, ROIIndex, shapeIndex);
        }
    }

    public void setPathLabel(String label, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathLabel(label, ROIIndex, shapeIndex);
        }
    }

    public void setPathName(String name, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathName(name, ROIIndex, shapeIndex);
        }
    }

    public void setPathStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathStroke(stroke, ROIIndex, shapeIndex);
        }
    }

    public void setPathStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
        }
    }

    public void setPathStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
        }
    }

    public void setPathTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathTheC(theC, ROIIndex, shapeIndex);
        }
    }

    public void setPathTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathTheT(theT, ROIIndex, shapeIndex);
        }
    }

    public void setPathTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathTheZ(theZ, ROIIndex, shapeIndex);
        }
    }

    public void setPathTransform(String transform, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathTransform(transform, ROIIndex, shapeIndex);
        }
    }

    public void setPathDefinition(String definition, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPathDefinition(definition, ROIIndex, shapeIndex);
        }
    }

    public void setPixelsAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsAnnotationRef(annotation, imageIndex, annotationRefIndex);
        }
    }

    public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsDimensionOrder(dimensionOrder, imageIndex);
        }
    }

    public void setPixelsID(String id, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsID(id, imageIndex);
        }
    }

    public void setPixelsPhysicalSizeX(Double physicalSizeX, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsPhysicalSizeX(physicalSizeX, imageIndex);
        }
    }

    public void setPixelsPhysicalSizeY(Double physicalSizeY, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsPhysicalSizeY(physicalSizeY, imageIndex);
        }
    }

    public void setPixelsPhysicalSizeZ(Double physicalSizeZ, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsPhysicalSizeZ(physicalSizeZ, imageIndex);
        }
    }

    public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeC(sizeC, imageIndex);
        }
    }

    public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeT(sizeT, imageIndex);
        }
    }

    public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeX(sizeX, imageIndex);
        }
    }

    public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeY(sizeY, imageIndex);
        }
    }

    public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsSizeZ(sizeZ, imageIndex);
        }
    }

    public void setPixelsTimeIncrement(Double timeIncrement, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsTimeIncrement(timeIncrement, imageIndex);
        }
    }

    public void setPixelsType(PixelType type, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPixelsType(type, imageIndex);
        }
    }

    public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneAnnotationRef(annotation, imageIndex, planeIndex, annotationRefIndex);
        }
    }

    public void setPlaneDeltaT(Double deltaT, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneDeltaT(deltaT, imageIndex, planeIndex);
        }
    }

    public void setPlaneExposureTime(Double exposureTime, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneExposureTime(exposureTime, imageIndex, planeIndex);
        }
    }

    public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneHashSHA1(hashSHA1, imageIndex, planeIndex);
        }
    }

    public void setPlanePositionX(Double positionX, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlanePositionX(positionX, imageIndex, planeIndex);
        }
    }

    public void setPlanePositionY(Double positionY, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlanePositionY(positionY, imageIndex, planeIndex);
        }
    }

    public void setPlanePositionZ(Double positionZ, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlanePositionZ(positionZ, imageIndex, planeIndex);
        }
    }

    public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneTheC(theC, imageIndex, planeIndex);
        }
    }

    public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneTheT(theT, imageIndex, planeIndex);
        }
    }

    public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlaneTheZ(theZ, imageIndex, planeIndex);
        }
    }

    public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAnnotationRef(annotation, plateIndex, annotationRefIndex);
        }
    }

    public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateColumnNamingConvention(columnNamingConvention, plateIndex);
        }
    }

    public void setPlateColumns(PositiveInteger columns, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateColumns(columns, plateIndex);
        }
    }

    public void setPlateDescription(String description, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateDescription(description, plateIndex);
        }
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateExternalIdentifier(externalIdentifier, plateIndex);
        }
    }

    public void setPlateID(String id, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateID(id, plateIndex);
        }
    }

    public void setPlateName(String name, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateName(name, plateIndex);
        }
    }

    public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateRowNamingConvention(rowNamingConvention, plateIndex);
        }
    }

    public void setPlateRows(PositiveInteger rows, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateRows(rows, plateIndex);
        }
    }

    public void setPlateScreenRef(String screen, int plateIndex, int screenRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateScreenRef(screen, plateIndex, screenRefIndex);
        }
    }

    public void setPlateStatus(String status, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateStatus(status, plateIndex);
        }
    }

    public void setPlateWellOriginX(Double wellOriginX, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateWellOriginX(wellOriginX, plateIndex);
        }
    }

    public void setPlateWellOriginY(Double wellOriginY, int plateIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateWellOriginY(wellOriginY, plateIndex);
        }
    }

    public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAcquisitionAnnotationRef(annotation, plateIndex, plateAcquisitionIndex, annotationRefIndex);
        }
    }

    public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAcquisitionDescription(description, plateIndex, plateAcquisitionIndex);
        }
    }

    public void setPlateAcquisitionEndTime(String endTime, int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAcquisitionEndTime(endTime, plateIndex, plateAcquisitionIndex);
        }
    }

    public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAcquisitionID(id, plateIndex, plateAcquisitionIndex);
        }
    }

    public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAcquisitionMaximumFieldCount(maximumFieldCount, plateIndex, plateAcquisitionIndex);
        }
    }

    public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAcquisitionName(name, plateIndex, plateAcquisitionIndex);
        }
    }

    public void setPlateAcquisitionStartTime(String startTime, int plateIndex, int plateAcquisitionIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAcquisitionStartTime(startTime, plateIndex, plateAcquisitionIndex);
        }
    }

    public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPlateAcquisitionWellSampleRef(wellSample, plateIndex, plateAcquisitionIndex, wellSampleRefIndex);
        }
    }

    public void setPointDescription(String description, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointDescription(description, ROIIndex, shapeIndex);
        }
    }

    public void setPointFill(Integer fill, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointFill(fill, ROIIndex, shapeIndex);
        }
    }

    public void setPointFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointFontSize(fontSize, ROIIndex, shapeIndex);
        }
    }

    public void setPointID(String id, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointID(id, ROIIndex, shapeIndex);
        }
    }

    public void setPointLabel(String label, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointLabel(label, ROIIndex, shapeIndex);
        }
    }

    public void setPointName(String name, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointName(name, ROIIndex, shapeIndex);
        }
    }

    public void setPointStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointStroke(stroke, ROIIndex, shapeIndex);
        }
    }

    public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
        }
    }

    public void setPointStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
        }
    }

    public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointTheC(theC, ROIIndex, shapeIndex);
        }
    }

    public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointTheT(theT, ROIIndex, shapeIndex);
        }
    }

    public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointTheZ(theZ, ROIIndex, shapeIndex);
        }
    }

    public void setPointTransform(String transform, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointTransform(transform, ROIIndex, shapeIndex);
        }
    }

    public void setPointX(Double x, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointX(x, ROIIndex, shapeIndex);
        }
    }

    public void setPointY(Double y, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPointY(y, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineDescription(String description, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineDescription(description, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineFill(Integer fill, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineFill(fill, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineFontSize(fontSize, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineID(String id, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineID(id, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineLabel(String label, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineLabel(label, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineName(String name, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineName(name, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineStroke(stroke, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineTheC(theC, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineTheT(theT, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineTheZ(theZ, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineTransform(String transform, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineTransform(transform, ROIIndex, shapeIndex);
        }
    }

    public void setPolylineClosed(Boolean closed, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylineClosed(closed, ROIIndex, shapeIndex);
        }
    }

    public void setPolylinePoints(String points, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setPolylinePoints(points, ROIIndex, shapeIndex);
        }
    }

    public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setProjectAnnotationRef(annotation, projectIndex, annotationRefIndex);
        }
    }

    public void setProjectDescription(String description, int projectIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setProjectDescription(description, projectIndex);
        }
    }

    public void setProjectExperimenterRef(String experimenter, int projectIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setProjectExperimenterRef(experimenter, projectIndex);
        }
    }

    public void setProjectGroupRef(String group, int projectIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setProjectGroupRef(group, projectIndex);
        }
    }

    public void setProjectID(String id, int projectIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setProjectID(id, projectIndex);
        }
    }

    public void setProjectName(String name, int projectIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setProjectName(name, projectIndex);
        }
    }

    public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIAnnotationRef(annotation, ROIIndex, annotationRefIndex);
        }
    }

    public void setROIDescription(String description, int ROIIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIDescription(description, ROIIndex);
        }
    }

    public void setROIID(String id, int ROIIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIID(id, ROIIndex);
        }
    }

    public void setROIName(String name, int ROIIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROIName(name, ROIIndex);
        }
    }

    public void setROINamespace(String namespace, int ROIIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setROINamespace(namespace, ROIIndex);
        }
    }

    public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentAnnotationRef(annotation, screenIndex, reagentIndex, annotationRefIndex);
        }
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentDescription(description, screenIndex, reagentIndex);
        }
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentID(id, screenIndex, reagentIndex);
        }
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentName(name, screenIndex, reagentIndex);
        }
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setReagentReagentIdentifier(reagentIdentifier, screenIndex, reagentIndex);
        }
    }

    public void setRectangleDescription(String description, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleDescription(description, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleFill(Integer fill, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleFill(fill, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleFontSize(fontSize, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleID(String id, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleID(id, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleLabel(String label, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleLabel(label, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleName(String name, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleName(name, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleStroke(stroke, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleTheC(theC, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleTheT(theT, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleTheZ(theZ, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleTransform(String transform, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleTransform(transform, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleHeight(height, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleWidth(width, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleX(Double x, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleX(x, ROIIndex, shapeIndex);
        }
    }

    public void setRectangleY(Double y, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setRectangleY(y, ROIIndex, shapeIndex);
        }
    }

    public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenAnnotationRef(annotation, screenIndex, annotationRefIndex);
        }
    }

    public void setScreenDescription(String description, int screenIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenDescription(description, screenIndex);
        }
    }

    public void setScreenID(String id, int screenIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenID(id, screenIndex);
        }
    }

    public void setScreenName(String name, int screenIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenName(name, screenIndex);
        }
    }

    public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenPlateRef(plate, screenIndex, plateRefIndex);
        }
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenProtocolDescription(protocolDescription, screenIndex);
        }
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenProtocolIdentifier(protocolIdentifier, screenIndex);
        }
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenReagentSetDescription(reagentSetDescription, screenIndex);
        }
    }

    public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenReagentSetIdentifier(reagentSetIdentifier, screenIndex);
        }
    }

    public void setScreenType(String type, int screenIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setScreenType(type, screenIndex);
        }
    }

    public void setStageLabelName(String name, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStageLabelName(name, imageIndex);
        }
    }

    public void setStageLabelX(Double x, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStageLabelX(x, imageIndex);
        }
    }

    public void setStageLabelY(Double y, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStageLabelY(y, imageIndex);
        }
    }

    public void setStageLabelZ(Double z, int imageIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setStageLabelZ(z, imageIndex);
        }
    }

    public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTagAnnotationAnnotationRef(annotation, tagAnnotationIndex, annotationRefIndex);
        }
    }

    public void setTagAnnotationDescription(String description, int tagAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTagAnnotationDescription(description, tagAnnotationIndex);
        }
    }

    public void setTagAnnotationID(String id, int tagAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTagAnnotationID(id, tagAnnotationIndex);
        }
    }

    public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTagAnnotationNamespace(namespace, tagAnnotationIndex);
        }
    }

    public void setTagAnnotationValue(String value, int tagAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTagAnnotationValue(value, tagAnnotationIndex);
        }
    }

    public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTermAnnotationAnnotationRef(annotation, termAnnotationIndex, annotationRefIndex);
        }
    }

    public void setTermAnnotationDescription(String description, int termAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTermAnnotationDescription(description, termAnnotationIndex);
        }
    }

    public void setTermAnnotationID(String id, int termAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTermAnnotationID(id, termAnnotationIndex);
        }
    }

    public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTermAnnotationNamespace(namespace, termAnnotationIndex);
        }
    }

    public void setTermAnnotationValue(String value, int termAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTermAnnotationValue(value, termAnnotationIndex);
        }
    }

    public void setTextDescription(String description, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextDescription(description, ROIIndex, shapeIndex);
        }
    }

    public void setTextFill(Integer fill, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextFill(fill, ROIIndex, shapeIndex);
        }
    }

    public void setTextFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextFontSize(fontSize, ROIIndex, shapeIndex);
        }
    }

    public void setTextID(String id, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextID(id, ROIIndex, shapeIndex);
        }
    }

    public void setTextLabel(String label, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextLabel(label, ROIIndex, shapeIndex);
        }
    }

    public void setTextName(String name, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextName(name, ROIIndex, shapeIndex);
        }
    }

    public void setTextStroke(Integer stroke, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextStroke(stroke, ROIIndex, shapeIndex);
        }
    }

    public void setTextStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
        }
    }

    public void setTextStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
        }
    }

    public void setTextTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextTheC(theC, ROIIndex, shapeIndex);
        }
    }

    public void setTextTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextTheT(theT, ROIIndex, shapeIndex);
        }
    }

    public void setTextTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextTheZ(theZ, ROIIndex, shapeIndex);
        }
    }

    public void setTextTransform(String transform, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextTransform(transform, ROIIndex, shapeIndex);
        }
    }

    public void setTextValue(String value, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextValue(value, ROIIndex, shapeIndex);
        }
    }

    public void setTextX(Double x, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextX(x, ROIIndex, shapeIndex);
        }
    }

    public void setTextY(Double y, int ROIIndex, int shapeIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTextY(y, ROIIndex, shapeIndex);
        }
    }

    public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataFirstC(firstC, imageIndex, tiffDataIndex);
        }
    }

    public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataFirstT(firstT, imageIndex, tiffDataIndex);
        }
    }

    public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataFirstZ(firstZ, imageIndex, tiffDataIndex);
        }
    }

    public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataIFD(ifd, imageIndex, tiffDataIndex);
        }
    }

    public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTiffDataPlaneCount(planeCount, imageIndex, tiffDataIndex);
        }
    }

    public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTimestampAnnotationAnnotationRef(annotation, timestampAnnotationIndex, annotationRefIndex);
        }
    }

    public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTimestampAnnotationDescription(description, timestampAnnotationIndex);
        }
    }

    public void setTimestampAnnotationID(String id, int timestampAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTimestampAnnotationID(id, timestampAnnotationIndex);
        }
    }

    public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTimestampAnnotationNamespace(namespace, timestampAnnotationIndex);
        }
    }

    public void setTimestampAnnotationValue(String value, int timestampAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTimestampAnnotationValue(value, timestampAnnotationIndex);
        }
    }

    public void setTransmittanceRangeCutIn(PositiveInteger cutIn, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTransmittanceRangeCutIn(cutIn, instrumentIndex, filterIndex);
        }
    }

    public void setTransmittanceRangeCutInTolerance(NonNegativeInteger cutInTolerance, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTransmittanceRangeCutInTolerance(cutInTolerance, instrumentIndex, filterIndex);
        }
    }

    public void setTransmittanceRangeCutOut(PositiveInteger cutOut, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTransmittanceRangeCutOut(cutOut, instrumentIndex, filterIndex);
        }
    }

    public void setTransmittanceRangeCutOutTolerance(NonNegativeInteger cutOutTolerance, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTransmittanceRangeCutOutTolerance(cutOutTolerance, instrumentIndex, filterIndex);
        }
    }

    public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setTransmittanceRangeTransmittance(transmittance, instrumentIndex, filterIndex);
        }
    }

    public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setUUIDFileName(fileName, imageIndex, tiffDataIndex);
        }
    }

    public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellAnnotationRef(annotation, plateIndex, wellIndex, annotationRefIndex);
        }
    }

    public void setWellColor(Integer color, int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellColor(color, plateIndex, wellIndex);
        }
    }

    public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellColumn(column, plateIndex, wellIndex);
        }
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellExternalDescription(externalDescription, plateIndex, wellIndex);
        }
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellExternalIdentifier(externalIdentifier, plateIndex, wellIndex);
        }
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellID(id, plateIndex, wellIndex);
        }
    }

    public void setWellReagentRef(String reagent, int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellReagentRef(reagent, plateIndex, wellIndex);
        }
    }

    public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellRow(row, plateIndex, wellIndex);
        }
    }

    public void setWellStatus(String status, int plateIndex, int wellIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellStatus(status, plateIndex, wellIndex);
        }
    }

    public void setWellSampleAnnotationRef(String annotation, int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSampleAnnotationRef(annotation, plateIndex, wellIndex, wellSampleIndex, annotationRefIndex);
        }
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSampleID(id, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSampleImageRef(image, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSampleIndex(index, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSamplePositionX(Double positionX, int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSamplePositionX(positionX, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSamplePositionY(Double positionY, int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSamplePositionY(positionY, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setWellSampleTimepoint(String timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setWellSampleTimepoint(timepoint, plateIndex, wellIndex, wellSampleIndex);
        }
    }

    public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setXMLAnnotationAnnotationRef(annotation, XMLAnnotationIndex, annotationRefIndex);
        }
    }

    public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setXMLAnnotationDescription(description, XMLAnnotationIndex);
        }
    }

    public void setXMLAnnotationID(String id, int XMLAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setXMLAnnotationID(id, XMLAnnotationIndex);
        }
    }

    public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setXMLAnnotationNamespace(namespace, XMLAnnotationIndex);
        }
    }

    public void setXMLAnnotationValue(String value, int XMLAnnotationIndex) {
        for (Object o : this.delegates) {
            if (!(o instanceof MetadataStore)) continue;
            MetadataStore store = (MetadataStore)o;
            store.setXMLAnnotationValue(value, XMLAnnotationIndex);
        }
    }
}

