/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.ImageTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import loci.formats.tiff.TiffSaver;

public class TiffWriter
extends FormatWriter {
    public static final String COMPRESSION_UNCOMPRESSED = "Uncompressed";
    public static final String COMPRESSION_LZW = "LZW";
    public static final String COMPRESSION_J2K = "J2K";
    public static final String COMPRESSION_J2K_LOSSY = "J2K-Lossy";
    public static final String COMPRESSION_JPEG = "JPEG";
    protected boolean isBigTiff;
    protected boolean sequential;
    protected TiffSaver tiffSaver;
    private boolean checkParams = true;

    public TiffWriter() {
        this("Tagged Image File Format", new String[]{"tif", "tiff"});
    }

    public TiffWriter(String format, String[] exts) {
        super(format, exts);
        this.compressionTypes = new String[]{COMPRESSION_UNCOMPRESSED, COMPRESSION_LZW, COMPRESSION_J2K, COMPRESSION_J2K_LOSSY, COMPRESSION_JPEG};
        this.isBigTiff = false;
    }

    public void saveBytes(int no, byte[] buf, IFD ifd) throws IOException, FormatException {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int w = (Integer)r.getPixelsSizeX(this.series).getValue();
        int h = (Integer)r.getPixelsSizeY(this.series).getValue();
        this.saveBytes(no, buf, ifd, 0, 0, w, h);
    }

    public void saveBytes(int no, byte[] buf, IFD ifd, int x, int y, int w, int h) throws IOException, FormatException {
        int type;
        int bytesPerPixel;
        int c;
        int height;
        int width;
        int plane;
        MetadataRetrieve retrieve;
        Boolean bigEndian;
        if (this.checkParams) {
            this.checkParams(no, buf, x, y, w, h);
        }
        boolean littleEndian = (bigEndian = (retrieve = this.getMetadataRetrieve()).getPixelsBinDataBigEndian(this.series, 0)) == null ? false : bigEndian == false;
        this.tiffSaver = new TiffSaver(this.out);
        this.tiffSaver.setWritingSequentially(this.sequential);
        this.tiffSaver.setLittleEndian(littleEndian);
        this.tiffSaver.setBigTiff(this.isBigTiff);
        if (!this.initialized[this.series][no]) {
            this.initialized[this.series][no] = true;
            RandomAccessInputStream tmp = new RandomAccessInputStream(this.currentId);
            if (tmp.length() == 0L) {
                this.tiffSaver.writeHeader();
            }
            tmp.close();
        }
        if ((plane = (width = ((Integer)retrieve.getPixelsSizeX(this.series).getValue()).intValue()) * (height = ((Integer)retrieve.getPixelsSizeY(this.series).getValue()).intValue()) * (c = this.getSamplesPerPixel()) * (bytesPerPixel = FormatTools.getBytesPerPixel(type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString())))) > buf.length) {
            c = buf.length / (width * height * bytesPerPixel);
            plane = width * height * c * bytesPerPixel;
        }
        if (bytesPerPixel > 1 && c != 1 && c != 3) {
            this.checkParams = false;
            if (no == 0) {
                this.initialized[this.series] = new boolean[this.initialized[this.series].length * c];
            }
            for (int i = 0; i < c; ++i) {
                byte[] b = ImageTools.splitChannels(buf, i, c, bytesPerPixel, false, this.interleaved);
                this.saveBytes(no + i, b, ifd, x, y, w, h);
            }
            this.checkParams = true;
            return;
        }
        byte[][] lut = AWTImageTools.get8BitLookupTable(this.cm);
        if (lut != null) {
            int[] colorMap = new int[lut.length * lut[0].length];
            for (int i = 0; i < lut.length; ++i) {
                for (int j = 0; j < lut[0].length; ++j) {
                    colorMap[i * lut[0].length + j] = (lut[i][j] & 0xFF) << 8;
                }
            }
            ifd.putIFDValue(320, colorMap);
        }
        ifd.put(new Integer(256), new Integer(width));
        ifd.put(new Integer(257), new Integer(height));
        Double physicalSizeX = retrieve.getPixelsPhysicalSizeX(this.series);
        physicalSizeX = physicalSizeX == null ? Double.valueOf(0.0) : Double.valueOf(1.0 / physicalSizeX);
        Double physicalSizeY = retrieve.getPixelsPhysicalSizeY(this.series);
        physicalSizeY = physicalSizeY == null ? Double.valueOf(0.0) : Double.valueOf(1.0 / physicalSizeY);
        ifd.put(296, 3);
        ifd.put(282, new TiffRational((long)(physicalSizeX * 1000.0 * 10000.0), 1000L));
        ifd.put(283, new TiffRational((long)(physicalSizeY * 1000.0 * 10000.0), 1000L));
        if (!this.isBigTiff) {
            boolean bl = this.isBigTiff = this.out.length() + (long)(2 * plane) >= 0x100000000L;
            if (this.isBigTiff) {
                throw new FormatException("File is too large; call setBigTiff(true)");
            }
        }
        ifd.put(new Integer(0), new Boolean(littleEndian));
        this.out.seek(this.out.length());
        ifd.putIFDValue(284, this.interleaved ? 1 : 2);
        int sampleFormat = 1;
        if (FormatTools.isSigned(type)) {
            sampleFormat = 2;
        }
        if (FormatTools.isFloatingPoint(type)) {
            sampleFormat = 3;
        }
        ifd.putIFDValue(339, sampleFormat);
        RandomAccessInputStream in = new RandomAccessInputStream(this.currentId);
        in.order(littleEndian);
        this.tiffSaver.setInputStream(in);
        int index = no;
        int realSeries = this.getSeries();
        for (int i = 0; i < realSeries; ++i) {
            this.setSeries(i);
            index += this.getPlaneCount();
        }
        this.setSeries(realSeries);
        this.tiffSaver.writeImage(buf, ifd, index, type, x, y, w, h, no == this.getPlaneCount() - 1 && this.getSeries() == retrieve.getImageCount() - 1);
        this.tiffSaver.setInputStream(null);
        in.close();
    }

    protected int getPlaneCount() {
        int c = this.getSamplesPerPixel();
        if (c == 1 || c == 3) {
            return super.getPlaneCount();
        }
        return c * super.getPlaneCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        IFD ifd = new IFD();
        TiffParser parser = new TiffParser(this.currentId);
        try {
            long[] ifdOffsets = parser.getIFDOffsets();
            if (no < ifdOffsets.length) {
                ifd = parser.getIFD(ifdOffsets[no]);
            }
        }
        finally {
            RandomAccessInputStream tiffParserStream = parser.getStream();
            if (tiffParserStream != null) {
                tiffParserStream.close();
            }
        }
        if (this.compression == null) {
            this.compression = "";
        }
        TiffCompression compressType = TiffCompression.UNCOMPRESSED;
        if (this.compression.equals(COMPRESSION_LZW)) {
            compressType = TiffCompression.LZW;
        } else if (this.compression.equals(COMPRESSION_J2K)) {
            compressType = TiffCompression.JPEG_2000;
        } else if (this.compression.equals(COMPRESSION_J2K_LOSSY)) {
            compressType = TiffCompression.JPEG_2000_LOSSY;
        } else if (this.compression.equals(COMPRESSION_JPEG)) {
            compressType = TiffCompression.JPEG;
        }
        if (ifd.getCompression() == null) {
            ifd.put(new Integer(259), compressType.getCode());
        }
        this.saveBytes(no, buf, ifd, x, y, w, h);
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes(String codec) {
        if (codec != null && (codec.startsWith(COMPRESSION_J2K) || codec.equals(COMPRESSION_JPEG))) {
            return new int[]{0, 1};
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    public void setBigTiff(boolean bigTiff) {
        FormatTools.assertId(this.currentId, false, 1);
        this.isBigTiff = bigTiff;
    }

    public void setWriteSequentially(boolean sequential) {
        this.sequential = sequential;
    }
}

