/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.AbstractNIOHandle;

public class ByteArrayHandle
extends AbstractNIOHandle {
    protected static final int INITIAL_LENGTH = 1000000;
    protected ByteBuffer buffer;

    public ByteArrayHandle(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
    }

    public ByteArrayHandle(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity);
        this.buffer.limit(capacity);
    }

    public ByteArrayHandle() {
        this.buffer = ByteBuffer.allocate(1000000);
        this.buffer.limit(0);
    }

    public byte[] getBytes() {
        return this.buffer.array();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public void setLength(long length) throws IOException {
        if (length > (long)this.buffer.capacity()) {
            long fp = this.getFilePointer();
            ByteBuffer tmp = ByteBuffer.allocate((int)(length * 2L));
            ByteOrder order = this.buffer == null ? null : this.getOrder();
            this.seek(0L);
            this.buffer = tmp.put(this.buffer);
            if (order != null) {
                this.setOrder(order);
            }
            this.seek(fp);
        }
        this.buffer.limit((int)length);
    }

    public void close() {
    }

    public long getFilePointer() {
        return this.buffer.position();
    }

    public long length() {
        return this.buffer.limit();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.getFilePointer() + (long)len > this.length()) {
            len = (int)(this.length() - this.getFilePointer());
        }
        this.buffer.get(b, off, len);
        return len;
    }

    public int read(ByteBuffer buf) throws IOException {
        return this.read(buf, 0, buf.capacity());
    }

    public int read(ByteBuffer buf, int off, int len) throws IOException {
        if (buf.hasArray()) {
            this.buffer.get(buf.array(), off, len);
            return len;
        }
        byte[] b = new byte[len];
        this.read(b);
        buf.put(b, 0, len);
        return len;
    }

    public void seek(long pos) throws IOException {
        if (pos > this.length()) {
            this.setLength(pos);
        }
        this.buffer.position((int)pos);
    }

    public ByteOrder getOrder() {
        return this.buffer.order();
    }

    public void setOrder(ByteOrder order) {
        this.buffer.order(order);
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        if (this.getFilePointer() + 1L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    public char readChar() throws IOException {
        if (this.getFilePointer() + 2L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getChar();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    public double readDouble() throws IOException {
        if (this.getFilePointer() + 8L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getDouble();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    public float readFloat() throws IOException {
        if (this.getFilePointer() + 4L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getFloat();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.getFilePointer() + (long)len > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            this.buffer.get(b, off, len);
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    public int readInt() throws IOException {
        if (this.getFilePointer() + 4L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    public String readLine() throws IOException {
        throw new IOException("Unimplemented");
    }

    public long readLong() throws IOException {
        if (this.getFilePointer() + 8L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    public short readShort() throws IOException {
        if (this.getFilePointer() + 2L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public String readUTF() throws IOException {
        int length = this.readUnsignedShort();
        byte[] b = new byte[length];
        this.read(b);
        return new String(b, "UTF-8");
    }

    public int skipBytes(int n) throws IOException {
        int skipped = (int)Math.min((long)n, this.length() - this.getFilePointer());
        if (skipped < 0) {
            return 0;
        }
        this.seek(this.getFilePointer() + (long)skipped);
        return skipped;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.validateLength(len);
        this.buffer.put(b, off, len);
    }

    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    public void write(ByteBuffer buf, int off, int len) throws IOException {
        this.validateLength(len);
        buf.position(off);
        buf.limit(off + len);
        this.buffer.put(buf);
    }

    public void write(int b) throws IOException {
        this.validateLength(1);
        this.buffer.put((byte)b);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    public void writeChar(int v) throws IOException {
        this.validateLength(2);
        this.buffer.putChar((char)v);
    }

    public void writeChars(String s) throws IOException {
        int len = 2 * s.length();
        this.validateLength(len);
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            this.writeChar(c[i]);
        }
    }

    public void writeDouble(double v) throws IOException {
        this.validateLength(8);
        this.buffer.putDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.validateLength(4);
        this.buffer.putFloat(v);
    }

    public void writeInt(int v) throws IOException {
        this.validateLength(4);
        this.buffer.putInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.validateLength(8);
        this.buffer.putLong(v);
    }

    public void writeShort(int v) throws IOException {
        this.validateLength(2);
        this.buffer.putShort((short)v);
    }

    public void writeUTF(String str) throws IOException {
        byte[] b = str.getBytes("UTF-8");
        this.writeShort(b.length);
        this.write(b);
    }
}

