/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.GKeyFile;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SortOrder;

public class GtkFileChooserSettings {
    private static final Logger LOG = Logger.getLogger(GtkFileChooserSettings.class.getName());
    private static final String SETTINGS_GROUP = "Filechooser Settings";
    private static final String LOCATION_MODE_KEY = "LocationMode";
    private static final String SHOW_HIDDEN_KEY = "ShowHidden";
    private static final String EXPAND_FOLDERS_KEY = "ExpandFolders";
    private static final String SHOW_SIZE_COLUMN_KEY = "ShowSizeColumn";
    private static final String GEOMETRY_X_KEY = "GeometryX";
    private static final String GEOMETRY_Y_KEY = "GeometryY";
    private static final String GEOMETRY_WIDTH_KEY = "GeometryWidth";
    private static final String GEOMETRY_HEIGHT_KEY = "GeometryHeight";
    private static final String SORT_COLUMN_KEY = "SortColumn";
    private static final String SORT_ORDER_KEY = "SortOrder";
    private GKeyFile settings;
    private static GtkFileChooserSettings instance;

    public static GtkFileChooserSettings get() {
        if (instance == null) {
            instance = new GtkFileChooserSettings();
        }
        return instance;
    }

    private GtkFileChooserSettings() {
        try {
            File iniFile = new File(System.getProperty("user.home") + File.separator + ".config/gtk-2.0/gtkfilechooser.ini");
            this.settings = new GKeyFile(iniFile);
            if (this.settings.getGroup(SETTINGS_GROUP) == null) {
                this.settings.createGroup(SETTINGS_GROUP);
                this.settings.save();
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not find settings.", e);
        }
    }

    public Rectangle getBound() {
        Integer x = this.settings.getGroup(SETTINGS_GROUP).getInteger(GEOMETRY_X_KEY);
        Integer y = this.settings.getGroup(SETTINGS_GROUP).getInteger(GEOMETRY_Y_KEY);
        Integer width = this.settings.getGroup(SETTINGS_GROUP).getInteger(GEOMETRY_WIDTH_KEY);
        Integer height = this.settings.getGroup(SETTINGS_GROUP).getInteger(GEOMETRY_HEIGHT_KEY);
        if (x == null || y == null || width == null || height == null) {
            return null;
        }
        return new Rectangle(x, y, width, height);
    }

    public void setBound(Rectangle bound) {
        this.settings.getGroup(SETTINGS_GROUP).setInteger(GEOMETRY_X_KEY, bound.x);
        this.settings.getGroup(SETTINGS_GROUP).setInteger(GEOMETRY_Y_KEY, bound.y);
        this.settings.getGroup(SETTINGS_GROUP).setInteger(GEOMETRY_WIDTH_KEY, bound.width);
        this.settings.getGroup(SETTINGS_GROUP).setInteger(GEOMETRY_HEIGHT_KEY, bound.height);
        this.save("boundaries");
    }

    private void save(final String propertyname) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GtkFileChooserSettings.this.settings.save();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Could not persist '" + propertyname + "' in " + GtkFileChooserSettings.this.settings.getGkeyfile() + ".", e);
                }
            }
        }).start();
    }

    public Mode getLocationMode() {
        String string = this.settings.getGroup(SETTINGS_GROUP).getString(LOCATION_MODE_KEY, Mode.PATH_BAR.toString());
        return Mode.valueOf(string.toUpperCase().replace('-', '_'));
    }

    public void setLocationMode(Mode mode) {
        this.settings.getGroup(SETTINGS_GROUP).setString(LOCATION_MODE_KEY, mode.toString().toLowerCase().replace('_', '-'));
        this.save(LOCATION_MODE_KEY);
    }

    public Boolean getShowHidden() {
        return this.settings.getGroup(SETTINGS_GROUP).getBoolean(SHOW_HIDDEN_KEY);
    }

    public void setShowHidden(boolean showHidden) {
        this.settings.getGroup(SETTINGS_GROUP).setBoolean(SHOW_HIDDEN_KEY, showHidden);
        this.save(SHOW_HIDDEN_KEY);
    }

    public Boolean getExpandFolders() {
        return this.settings.getGroup(SETTINGS_GROUP).getBoolean(EXPAND_FOLDERS_KEY);
    }

    public void setExpandFolders(boolean expandFolders) {
        this.settings.getGroup(SETTINGS_GROUP).setBoolean(EXPAND_FOLDERS_KEY, expandFolders);
        this.save(EXPAND_FOLDERS_KEY);
    }

    public Boolean getShowSizeColumn() {
        return this.settings.getGroup(SETTINGS_GROUP).getBoolean(SHOW_SIZE_COLUMN_KEY);
    }

    public void setShowSizeColumn(boolean showSize) {
        this.settings.getGroup(SETTINGS_GROUP).setBoolean(SHOW_SIZE_COLUMN_KEY, showSize);
        this.save(SHOW_SIZE_COLUMN_KEY);
    }

    public Column getSortColumn() {
        String value = this.settings.getGroup(SETTINGS_GROUP).getString(SORT_COLUMN_KEY);
        if (value == null) {
            return null;
        }
        return Column.valueOf(value.toUpperCase());
    }

    public SortOrder getSortOrder() {
        String value = this.settings.getGroup(SETTINGS_GROUP).getString(SORT_ORDER_KEY);
        if (value == null) {
            return SortOrder.UNSORTED;
        }
        return SortOrder.valueOf(value.toUpperCase());
    }

    public void setSortBy(Column column, SortOrder order) {
        this.settings.getGroup(SETTINGS_GROUP).setString(SORT_COLUMN_KEY, column.toString().toLowerCase());
        this.settings.getGroup(SETTINGS_GROUP).setString(SORT_ORDER_KEY, order.toString().toLowerCase());
        this.save("sorting");
    }

    public static enum Mode {
        PATH_BAR,
        FILENAME_ENTRY;

    }

    public static enum Column {
        NAME,
        SIZE,
        MODIFIED;

    }
}

