/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import java.io.File;
import java.io.FileReader;
import java.util.Properties;

public class Platform {
    public static PlatformEnum getPlatform() {
        if (Platform.isRedhat()) {
            return PlatformEnum.REDHAT;
        }
        if (Platform.isSuSE()) {
            return PlatformEnum.SUSE;
        }
        if (Platform.isUbuntu()) {
            return PlatformEnum.UBUNTU;
        }
        if (Platform.isSolaris()) {
            return PlatformEnum.SOLARIS;
        }
        return PlatformEnum.UNKNOWN;
    }

    public static boolean isRedhat() {
        if (new File("/etc/fedora-release").exists()) {
            return true;
        }
        if (new File("/etc/redhat-release").exists()) {
            return true;
        }
        if (System.getProperty("os.version").indexOf(".fc") != -1) {
            return true;
        }
        return System.getProperty("os.version").indexOf(".el") != -1;
    }

    public static boolean isSuSE() {
        return new File("/etc/SuSE-release").exists();
    }

    public static boolean isUbuntu() {
        if (new File("/etc/lsb-release").exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileReader(new File("/etc/lsb-release")));
            }
            catch (Exception e) {
                return false;
            }
            if ("Ubuntu".equals(props.getProperty("DISTRIB_ID"))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSolaris() {
        return System.getProperty("os.name").indexOf("SunOS") != -1;
    }

    public static void main(String[] args) {
        System.out.println((Object)Platform.getPlatform());
    }

    public static enum PlatformEnum {
        REDHAT,
        SUSE,
        UBUNTU,
        SOLARIS,
        UNKNOWN;

    }
}

