/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.filewatcher;

import eu.kostia.gtkjfilechooser.filewatcher.FileEvent;
import eu.kostia.gtkjfilechooser.filewatcher.FileListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class FileWatcher {
    private Map<File, Long> timeStamps;
    private List<File> filesToWatch;
    private List<FileListener> listeners;
    private Timer timer;

    private FileWatcher() {
        this.init();
    }

    public static FileWatcher theFileWatcher() {
        return SingletonHolder.INSTANCE;
    }

    private void init() {
        this.filesToWatch = new ArrayList<File>();
        this.timeStamps = new HashMap<File, Long>();
        this.listeners = new ArrayList<FileListener>();
    }

    public void register(File file) {
        this.filesToWatch.add(file);
        this.timeStamps.put(file, file.lastModified());
    }

    public void unregister(File file) {
        this.filesToWatch.remove(file);
        this.timeStamps.remove(file);
    }

    private void notifyEvent(FileEvent evt) {
        for (FileListener l : this.listeners) {
            l.fileChanged(evt);
        }
    }

    public void addFileListener(FileListener l) {
        this.listeners.add(l);
    }

    public void removeFileListener(FileListener l) {
        this.listeners.remove(l);
    }

    public List<FileListener> getAllFileListeners() {
        return this.listeners;
    }

    private void watch() {
        for (File file : this.filesToWatch) {
            FileEvent evt;
            long currentTimeStamp = file.lastModified();
            long previousTimeStamp = this.timeStamps.get(file);
            if (file.exists()) {
                if (previousTimeStamp == currentTimeStamp) continue;
                this.timeStamps.put(file, currentTimeStamp);
                evt = new FileEvent(this, file, previousTimeStamp == 0L ? FileEvent.FileEventType.CREATED : FileEvent.FileEventType.MODIFIED);
                this.notifyEvent(evt);
                continue;
            }
            if (previousTimeStamp == 0L) continue;
            evt = new FileEvent(this, file, FileEvent.FileEventType.DELETED);
            this.notifyEvent(evt);
            this.timeStamps.put(file, 0L);
        }
    }

    public void start() {
        if (this.timer != null) {
            this.stop();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                FileWatcher.this.watch();
            }
        }, new Date(), 1000L);
    }

    public boolean isWatching() {
        return this.timer != null;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private static class SingletonHolder {
        private static final FileWatcher INSTANCE = new FileWatcher();

        private SingletonHolder() {
        }
    }
}

