/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.ActionPath;
import eu.kostia.gtkjfilechooser.BasicPath;
import eu.kostia.gtkjfilechooser.BookmarkManager;
import eu.kostia.gtkjfilechooser.FreeDesktopUtil;
import eu.kostia.gtkjfilechooser.GtkStockIcon;
import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.Path;
import eu.kostia.gtkjfilechooser.ui.LowerBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class GtkLocationsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final BookmarkManager manager;
    JTable bookmarksTable;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private int augend;

    public GtkLocationsPane() {
        if (UIManager.getLookAndFeel().getName().indexOf("GTK") == -1) {
            throw new IllegalStateException("GtkLocationsPane requires the GTK look and feel. Current LAF: " + UIManager.getLookAndFeel());
        }
        this.manager = new BookmarkManager();
        this.setLayout(new BorderLayout());
        this.bookmarksTable = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.bookmarksTable.setRowHeight(22);
        this.bookmarksTable.setAutoResizeMode(2);
        this.bookmarksTable.setModel(new GtkBookmarksTableModel(this.manager.getAll()));
        this.bookmarksTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.bookmarksTable.setBackground(UIManager.getColor("TextPane.background"));
        this.bookmarksTable.setShowGrid(false);
        this.bookmarksTable.setDefaultRenderer(Object.class, new GtkBookmarksTableCellRenderer());
        GtkBookmarksTableCellEditor defaultCellEditor = new GtkBookmarksTableCellEditor(this.bookmarksTable);
        defaultCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                TableCellEditor editor = (TableCellEditor)e.getSource();
                String newName = (String)editor.getCellEditorValue();
                String oldName = GtkLocationsPane.this.getCurrentPath().getName();
                GtkLocationsPane.this.manager.rename(oldName, newName);
                GtkLocationsPane.this.refreshLocations();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.bookmarksTable.setDefaultEditor(Object.class, defaultCellEditor);
        this.bookmarksTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JTable table = (JTable)evt.getSource();
                Point p = evt.getPoint();
                int rowIndex = table.rowAtPoint(p);
                table.setRowSelectionInterval(rowIndex, rowIndex);
                Path path = (Path)table.getModel().getValueAt(rowIndex, 0);
                ActionEvent actionEvent = new ActionEvent(GtkLocationsPane.this, 1, "location_selected");
                GtkLocationsPane.this.fireActionPerformed(actionEvent);
                if (SwingUtilities.isRightMouseButton(evt)) {
                    GtkLocationsPane.this.onRightMouseButtonClick(evt, path);
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.bookmarksTable);
        scrollpane.setPreferredSize(new Dimension(200, 300));
        this.add((Component)scrollpane, "Center");
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public Object getCurrentSelection() {
        int row = this.bookmarksTable.getSelectedRow();
        return row != -1 ? this.bookmarksTable.getValueAt(row, 0) : null;
    }

    public void selectBookmark(int id) {
        int index = id + this.augend;
        if (id == 0) {
            index = this.bookmarksTable.getRowCount() - 1;
        }
        this.bookmarksTable.getSelectionModel().setSelectionInterval(index, index);
    }

    public void refreshLocations() {
        Dimension previousSize = this.bookmarksTable.getSize();
        this.bookmarksTable.setModel(new GtkBookmarksTableModel(this.manager.getAll()));
        this.bookmarksTable.setPreferredSize(previousSize);
        ActionEvent actionEvent = new ActionEvent(this, 1, "refresh");
        this.fireActionPerformed(actionEvent);
    }

    public Path getCurrentPath() {
        int row = this.bookmarksTable.getSelectedRow();
        return row != -1 ? (Path)this.bookmarksTable.getValueAt(row, 0) : null;
    }

    protected void onRightMouseButtonClick(MouseEvent evt, Path path) {
        if (path instanceof BookmarkManager.GtkBookmark) {
            BookmarkManager.GtkBookmark bookmark = (BookmarkManager.GtkBookmark)path;
            JPopupMenu editPopup = this.createEditPopup(evt, bookmark);
            editPopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private JPopupMenu createEditPopup(final MouseEvent evt, final BookmarkManager.GtkBookmark bookmark) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem removeItem = new JMenuItem(I18N._("_Remove"));
        removeItem.setMnemonic(I18N.getMnemonic("_Remove"));
        removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GtkLocationsPane.this.remove(bookmark);
            }
        });
        removeItem.setIcon(GtkStockIcon.get("gtk-remove", GtkStockIcon.Size.GTK_ICON_SIZE_MENU));
        popup.add(removeItem);
        JMenuItem renameItem = new JMenuItem(I18N._("Rename..."));
        renameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable)evt.getSource();
                Point p = evt.getPoint();
                int row = table.rowAtPoint(p);
                table.editCellAt(row, 0);
            }
        });
        popup.add(renameItem);
        return popup;
    }

    public void remove(BookmarkManager.GtkBookmark bookmark) {
        this.manager.delete(bookmark.getName());
        this.refreshLocations();
    }

    public void addBookmark(File dir) {
        BookmarkManager.GtkBookmark newBookmark = this.manager.add(dir, null);
        GtkBookmarksTableModel model = (GtkBookmarksTableModel)this.bookmarksTable.getModel();
        model.addBookmark(newBookmark);
        this.bookmarksTable.setModel(new GtkBookmarksTableModel(model));
        ActionEvent actionEvent = new ActionEvent(this, 2, "bookmark_added");
        this.fireActionPerformed(actionEvent);
    }

    public void removeSelectedBookmark() {
        Object selection = this.getCurrentSelection();
        if (selection instanceof BookmarkManager.GtkBookmark) {
            BookmarkManager.GtkBookmark bookmark = (BookmarkManager.GtkBookmark)selection;
            this.remove(bookmark);
            ActionEvent actionEvent = new ActionEvent(this, 2, "bookmark_removed");
            this.fireActionPerformed(actionEvent);
        }
    }

    private void fireActionPerformed(ActionEvent actionEvent) {
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(actionEvent);
        }
    }

    class GtkBookmarksTableModel
    implements TableModel {
        private static final long serialVersionUID = 1L;
        private List<Path> locations = new ArrayList<Path>();
        private List<TableModelListener> tableModelListeners;

        public GtkBookmarksTableModel(List<BookmarkManager.GtkBookmark> bookmarks) {
            this.locations = new ArrayList<Path>();
            this.tableModelListeners = new ArrayList<TableModelListener>();
            this.locations.add(ActionPath.SEARCH);
            this.locations.add(ActionPath.RECENTLY_USED);
            this.locations.addAll(FreeDesktopUtil.getBasicLocations());
            this.locations.addAll(FreeDesktopUtil.getRemovableDevices());
            GtkLocationsPane.this.augend = this.locations.size() - 1;
            this.locations.addAll(bookmarks);
        }

        public GtkBookmarksTableModel(GtkBookmarksTableModel model) {
            this.locations = model.locations;
            this.tableModelListeners = model.tableModelListeners;
        }

        private void addBookmark(BookmarkManager.GtkBookmark bookmark) {
            this.locations.add(bookmark);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return I18N._("Places");
        }

        @Override
        public int getRowCount() {
            return this.locations.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.locations.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.getValueAt(rowIndex, columnIndex) instanceof BookmarkManager.GtkBookmark;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.tableModelListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.tableModelListeners.remove(l);
        }
    }

    class GtkBookmarksTableCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private TableCellEditor delegate;

        public GtkBookmarksTableCellEditor(JTable table) {
            this.delegate = table.getDefaultEditor(Object.class);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Path path = (Path)value;
            return this.delegate.getTableCellEditorComponent(table, path.getName(), isSelected, row, column);
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.delegate.addCellEditorListener(l);
        }

        @Override
        public void cancelCellEditing() {
            this.delegate.cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.delegate.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.delegate.isCellEditable(anEvent);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.delegate.removeCellEditorListener(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.delegate.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.delegate.stopCellEditing();
        }
    }

    class GtkBookmarksTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        GtkBookmarksTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Path path = (Path)value;
            this.setText(path.getName());
            this.setToolTipText(value instanceof BookmarkManager.GtkBookmark ? path.getLocation() : null);
            this.setText(path.getName());
            this.setIcon(GtkStockIcon.get(path.getIconName(), GtkStockIcon.Size.GTK_ICON_SIZE_MENU));
            if (isSelected) {
                this.setForeground(UIManager.getColor("List.selectionForeground"));
                this.setBackground(UIManager.getColor("List.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("List.foreground"));
                this.setBackground(UIManager.getColor("TextPane.background"));
            }
            if (row + 1 < table.getRowCount()) {
                Object nextValue = table.getValueAt(row + 1, 0);
                LowerBorder border = new LowerBorder(Color.GRAY, 1){

                    @Override
                    protected Insets getBorderInsets() {
                        return new Insets(1, 1, 1, 1);
                    }
                };
                if (!(value instanceof BasicPath) && nextValue instanceof BasicPath) {
                    this.setBorder(border);
                }
                if (!(value instanceof BookmarkManager.GtkBookmark) && nextValue instanceof BookmarkManager.GtkBookmark) {
                    this.setBorder(border);
                }
            }
            return this;
        }
    }
}

