/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.ActionDispatcher;
import eu.kostia.gtkjfilechooser.BasicActionDispatcher;
import eu.kostia.gtkjfilechooser.BookmarkManager;
import eu.kostia.gtkjfilechooser.FreeDesktopUtil;
import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.Path;
import eu.kostia.gtkjfilechooser.SpringLayoutUtil;
import eu.kostia.gtkjfilechooser.ui.Expander;
import eu.kostia.gtkjfilechooser.ui.FileComboBoxRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class SaveDialogPanel
extends JPanel
implements PropertyChangeListener,
ActionDispatcher {
    public static final String ACTION_SAVE = "Action Save";
    private JTextField nameTextField;
    private JLabel saveFolderLabel;
    private JComboBox foldersComboBox;
    private Expander expander;
    private String externalPath;
    private ActionDispatcher actionDispatcher = new BasicActionDispatcher();

    public SaveDialogPanel(JComponent fileExplorerPanel) {
        super(new BorderLayout());
        JPanel saveTopPanel = new JPanel();
        SpringLayout layout = new SpringLayout();
        saveTopPanel.setLayout(layout);
        JLabel nameLabel = new JLabel(I18N._("_Name:"));
        this.nameTextField = new JTextField();
        this.nameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(SaveDialogPanel.this, -1, SaveDialogPanel.ACTION_SAVE);
                SaveDialogPanel.this.fireActionEvent(evt);
            }
        });
        this.saveFolderLabel = new JLabel(I18N._("Save in _folder:"));
        this.initFoldersComboBox();
        saveTopPanel.add(nameLabel);
        saveTopPanel.add(this.nameTextField);
        saveTopPanel.add(this.saveFolderLabel);
        saveTopPanel.add(this.foldersComboBox);
        SpringLayoutUtil.makeCompactGrid(saveTopPanel, 2, 2, 6, 6, 6, 6);
        Dimension size = saveTopPanel.getPreferredSize();
        size.width = 600;
        saveTopPanel.setPreferredSize(size);
        this.add((Component)saveTopPanel, "First");
        this.expander = new Expander(I18N._("_Browse for other folders"), fileExplorerPanel);
        this.expander.addPropertyChangeListener(this);
        this.add((Component)this.expander, "Center");
    }

    private void initFoldersComboBox() {
        this.foldersComboBox = new JComboBox();
        this.foldersComboBox.setMaximumRowCount(30);
        this.foldersComboBox.setRenderer(new FileComboBoxRenderer(this.foldersComboBox));
        List<Path> locations = this.getLocations();
        this.foldersComboBox.setModel(new DefaultComboBoxModel<Object>(locations.toArray()));
    }

    private List<Path> getLocations() {
        ArrayList<Path> locations = new ArrayList<Path>();
        locations.addAll(FreeDesktopUtil.getBasicLocations());
        locations.addAll(FreeDesktopUtil.getRemovableDevices());
        locations.addAll(new BookmarkManager().getAll());
        return locations;
    }

    public boolean isExpanded() {
        return this.expander.isExpanded();
    }

    public void setExpanded(boolean expanded) {
        this.expander.setExpanded(expanded);
    }

    public void setExternalPath(String externalPath) {
        this.externalPath = externalPath;
    }

    public File getFilename() {
        String name = this.nameTextField.getText();
        if (name == null || name.isEmpty()) {
            return null;
        }
        String path = this.isExpanded() ? this.externalPath : ((Path)this.foldersComboBox.getSelectedItem()).getLocation();
        return new File(path + File.separator + name);
    }

    public void setFilenameText(String simplyname) {
        this.nameTextField.setText(simplyname);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("expanded_status_changed".equals(property)) {
            this.saveFolderLabel.setEnabled(!this.expander.isExpanded());
            this.foldersComboBox.setEnabled(!this.expander.isExpanded());
        }
        this.firePropertyChange(property, evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionDispatcher.addActionListener(l);
    }

    @Override
    public void fireActionEvent(ActionEvent e) {
        this.actionDispatcher.fireActionEvent(e);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionDispatcher.removeActionListener(l);
    }

    @Override
    public void removeAllActionListeners() {
        this.actionDispatcher.removeAllActionListeners();
    }
}

