/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.ConnectionLostException;
import Ice.DatagramLimitException;
import Ice.LocalException;
import Ice.Logger;
import Ice.MemoryLimitException;
import Ice.SocketException;
import Ice.Stats;
import IceInternal.Buffer;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.SocketStatus;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.DatagramSocketImpl;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;

final class UdpTransceiver
implements Transceiver {
    private TraceLevels _traceLevels;
    private Logger _logger;
    private Stats _stats;
    private boolean _connect;
    private final boolean _warn;
    private int _rcvSize;
    private int _sndSize;
    private DatagramChannel _fd;
    private InetSocketAddress _addr;
    private InetSocketAddress _mcastAddr = null;
    private static final int _udpOverhead = 28;
    private static final int _maxPacketSize = 65507;

    public SelectableChannel fd() {
        assert (this._fd != null);
        return this._fd;
    }

    public SocketStatus initialize() {
        return SocketStatus.Finished;
    }

    public void close() {
        assert (this._fd != null);
        if (this._traceLevels.network >= 1) {
            String s = "closing udp connection\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        try {
            this._fd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._fd = null;
    }

    public boolean write(Buffer buf) {
        assert (buf.b.position() == 0);
        int packetSize = Math.min(65507, this._sndSize - 28);
        if (packetSize < buf.size()) {
            throw new DatagramLimitException();
        }
        while (buf.b.hasRemaining()) {
            try {
                assert (this._fd != null);
                int ret = this._fd.write(buf.b);
                if (ret == 0) {
                    return false;
                }
                if (this._traceLevels.network >= 3) {
                    String s = "sent " + ret + " bytes via udp\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, s);
                }
                if (this._stats != null) {
                    this._stats.bytesSent(this.type(), ret);
                }
                assert (ret == buf.b.limit());
                break;
            }
            catch (AsynchronousCloseException ex) {
                ConnectionLostException se = new ConnectionLostException();
                se.initCause(ex);
                throw se;
            }
            catch (PortUnreachableException ex) {
                ConnectionLostException se = new ConnectionLostException();
                se.initCause(ex);
                throw se;
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        return true;
    }

    public boolean read(Buffer buf, BooleanHolder moreData) {
        assert (buf.b.position() == 0);
        moreData.value = false;
        int packetSize = Math.min(65507, this._rcvSize - 28);
        if (packetSize < buf.size()) {
            if (this._warn) {
                this._logger.warning("DatagramLimitException: maximum size of " + packetSize + " exceeded");
            }
            throw new DatagramLimitException();
        }
        buf.resize(packetSize, true);
        buf.b.position(0);
        int ret = 0;
        while (true) {
            try {
                InetSocketAddress sender = (InetSocketAddress)this._fd.receive(buf.b);
                if (sender == null || buf.b.position() == 0) {
                    return false;
                }
                ret = buf.b.position();
                if (!this._connect) break;
                Network.doConnect(this._fd, sender);
                this._connect = false;
                if (this._traceLevels.network < 1) break;
                String s = "connected udp socket\n" + this.toString();
                this._logger.trace(this._traceLevels.networkCat, s);
            }
            catch (AsynchronousCloseException ex) {
                ConnectionLostException se = new ConnectionLostException();
                se.initCause(ex);
                throw se;
            }
            catch (PortUnreachableException ex) {
                ConnectionLostException se = new ConnectionLostException();
                se.initCause(ex);
                throw se;
            }
            catch (InterruptedIOException ex) {
                continue;
            }
            catch (IOException ex) {
                if (Network.connectionLost(ex)) {
                    ConnectionLostException se = new ConnectionLostException();
                    se.initCause(ex);
                    throw se;
                }
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
            break;
        }
        if (this._traceLevels.network >= 3) {
            String s = "received " + ret + " bytes via udp\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        if (this._stats != null) {
            this._stats.bytesReceived(this.type(), ret);
        }
        buf.resize(ret, true);
        buf.b.position(ret);
        return true;
    }

    public String type() {
        return "udp";
    }

    public String toString() {
        if (this._mcastAddr != null && this._fd != null) {
            return Network.fdToString(this._fd) + "\nmulticast address = " + Network.addrToString(this._mcastAddr);
        }
        return Network.fdToString(this._fd);
    }

    public void checkSendSize(Buffer buf, int messageSizeMax) {
        if (buf.size() > messageSizeMax) {
            throw new MemoryLimitException();
        }
        int packetSize = Math.min(65507, this._sndSize - 28);
        if (packetSize < buf.size()) {
            throw new DatagramLimitException();
        }
    }

    public final int effectivePort() {
        return this._addr.getPort();
    }

    UdpTransceiver(Instance instance, InetSocketAddress addr, String mcastInterface, int mcastTtl) {
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._stats = instance.initializationData().stats;
        this._connect = true;
        this._warn = instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Datagrams") > 0;
        this._addr = addr;
        try {
            this._fd = Network.createUdpSocket();
            this.setBufSize(instance);
            Network.setBlock(this._fd, false);
            Network.doConnect(this._fd, this._addr);
            this._connect = false;
            if (this._addr.getAddress().isMulticastAddress()) {
                this.configureMulticast(null, mcastInterface, mcastTtl);
            }
            if (this._traceLevels.network >= 1) {
                String s = "starting to send udp packets\n" + this.toString();
                this._logger.trace(this._traceLevels.networkCat, s);
            }
        }
        catch (LocalException ex) {
            this._fd = null;
            throw ex;
        }
    }

    UdpTransceiver(Instance instance, String host, int port, String mcastInterface, boolean connect) {
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._stats = instance.initializationData().stats;
        this._connect = connect;
        this._warn = instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Datagrams") > 0;
        try {
            String s;
            this._fd = Network.createUdpSocket();
            this.setBufSize(instance);
            Network.setBlock(this._fd, false);
            this._addr = Network.getAddressForServer(host, port, instance.protocolSupport());
            if (this._traceLevels.network >= 2) {
                s = "attempting to bind to udp socket " + Network.addrToString(this._addr);
                this._logger.trace(this._traceLevels.networkCat, s);
            }
            if (this._addr.getAddress().isMulticastAddress()) {
                Network.setReuseAddress(this._fd, true);
                this._mcastAddr = this._addr;
                this._addr = Network.doBind(this._fd, Network.getAddress("0.0.0.0", port, 0));
                if (port == 0) {
                    this._mcastAddr = new InetSocketAddress(this._mcastAddr.getAddress(), this._addr.getPort());
                }
                this.configureMulticast(this._mcastAddr, mcastInterface, -1);
            } else {
                if (!System.getProperty("os.name").startsWith("Windows")) {
                    Network.setReuseAddress(this._fd, true);
                }
                this._addr = Network.doBind(this._fd, this._addr);
            }
            if (this._traceLevels.network >= 1) {
                s = "starting to receive udp packets\n" + this.toString();
                this._logger.trace(this._traceLevels.networkCat, s);
            }
        }
        catch (LocalException ex) {
            this._fd = null;
            throw ex;
        }
    }

    private synchronized void setBufSize(Instance instance) {
        assert (this._fd != null);
        for (int i = 0; i < 2; ++i) {
            int sizeSet;
            int dfltSize;
            String prop;
            String direction;
            if (i == 0) {
                direction = "receive";
                prop = "Ice.UDP.RcvSize";
                this._rcvSize = dfltSize = Network.getRecvBufferSize(this._fd);
            } else {
                direction = "send";
                prop = "Ice.UDP.SndSize";
                this._sndSize = dfltSize = Network.getSendBufferSize(this._fd);
            }
            int sizeRequested = instance.initializationData().properties.getPropertyAsIntWithDefault(prop, dfltSize);
            if (sizeRequested < 28) {
                this._logger.warning("Invalid " + prop + " value of " + sizeRequested + " adjusted to " + dfltSize);
                sizeRequested = dfltSize;
            }
            if (sizeRequested == dfltSize) continue;
            if (i == 0) {
                Network.setRecvBufferSize(this._fd, sizeRequested);
                sizeSet = this._rcvSize = Network.getRecvBufferSize(this._fd);
            } else {
                Network.setSendBufferSize(this._fd, sizeRequested);
                sizeSet = this._sndSize = Network.getSendBufferSize(this._fd);
            }
            if (sizeSet >= sizeRequested) continue;
            this._logger.warning("UDP " + direction + " buffer size: requested size of " + sizeRequested + " adjusted to " + sizeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureMulticast(SocketAddress group, String interfaceAddr, int ttl) {
        try {
            Constructor<?> c = Class.forName("java.net.PlainDatagramSocketImpl").getDeclaredConstructor(null);
            c.setAccessible(true);
            DatagramSocketImpl socketImpl = (DatagramSocketImpl)c.newInstance(null);
            Method m = Class.forName("java.net.PlainDatagramSocketImpl").getDeclaredMethod("create", null);
            m.setAccessible(true);
            m.invoke((Object)socketImpl, new Object[0]);
            Field channelFd = Class.forName("sun.nio.ch.DatagramChannelImpl").getDeclaredField("fd");
            channelFd.setAccessible(true);
            Field socketFd = DatagramSocketImpl.class.getDeclaredField("fd");
            socketFd.setAccessible(true);
            socketFd.set(socketImpl, channelFd.get(this._fd));
            try {
                Object[] args;
                Class[] types;
                NetworkInterface intf = null;
                if (interfaceAddr.length() != 0 && (intf = NetworkInterface.getByName(interfaceAddr)) == null) {
                    InetSocketAddress addr = Network.getAddress(interfaceAddr, 0, 0);
                    intf = NetworkInterface.getByInetAddress(addr.getAddress());
                }
                if (group != null) {
                    types = new Class[]{SocketAddress.class, NetworkInterface.class};
                    m = socketImpl.getClass().getDeclaredMethod("joinGroup", types);
                    m.setAccessible(true);
                    args = new Object[]{group, intf};
                    m.invoke((Object)socketImpl, args);
                } else if (intf != null) {
                    types = new Class[]{Integer.TYPE, Object.class};
                    m = socketImpl.getClass().getDeclaredMethod("setOption", types);
                    m.setAccessible(true);
                    args = new Object[]{new Integer(31), intf};
                    m.invoke((Object)socketImpl, args);
                }
                if (ttl != -1) {
                    types = new Class[]{Integer.TYPE};
                    m = DatagramSocketImpl.class.getDeclaredMethod("setTimeToLive", types);
                    m.setAccessible(true);
                    args = new Object[]{new Integer(ttl)};
                    m.invoke((Object)socketImpl, args);
                }
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                socketFd.set(socketImpl, null);
                throw throwable;
            }
            socketFd.set(socketImpl, null);
            {
            }
        }
        catch (Exception ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._fd == null);
        super.finalize();
    }
}

