/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class TempFileManager {
    private static final Log log = LogFactory.getLog(TempFileManager.class);
    private static final TempFileManager manager;
    private final File userDir;
    private final File dir;
    private final RandomAccessFile raf;
    private final FileLock lock;

    public TempFileManager() {
        this("omero");
    }

    public TempFileManager(String prefix) {
        File tmp = this.tmpdir();
        File userDir = new File(tmp, String.format("%s_%s", prefix, this.username()));
        if (!this.create(userDir) && !this.access(userDir)) {
            int i = 0;
            while (i < 10) {
                File t = new File(userDir.getAbsolutePath() + "_" + i);
                if (!this.create(t) && !this.access(t)) continue;
                userDir = t;
                break;
            }
            throw new RuntimeException("Failed to create temporary directory: " + userDir.getAbsolutePath());
        }
        this.userDir = userDir;
        this.dir = new File(this.userDir, this.pid());
        boolean created = false;
        if (!this.dir.exists()) {
            this.dir.mkdirs();
            created = true;
        }
        try {
            try {
                this.raf = new RandomAccessFile(new File(this.dir, ".lock"), "rw");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to open lock file", e);
            }
            try {
                this.lock = this.raf.getChannel().tryLock();
                if (this.lock == null) {
                    throw new RuntimeException("Failed to acquire lock");
                }
            }
            catch (Exception e) {
                try {
                    this.raf.close();
                }
                catch (Exception e2) {
                    log.warn("Exception on lock file close", e2);
                }
                throw new RuntimeException("Failed to lock file", e);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        TempFileManager.this.cleanup();
                    }
                    catch (IOException io) {
                        log.error("Failed to cleanup TempFileManager", io);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (created) {
                try {
                    this.cleanup();
                }
                catch (Exception e2) {
                    log.warn("Error on cleanup after error", e2);
                }
            }
            throw e;
        }
    }

    protected void cleanup() throws IOException {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (Exception e) {
            log.error("Failed to release lock", e);
        }
        this.cleanTempDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File tmpdir() {
        File locktest = null;
        String omerotmp = System.getenv().get("OMERO_TEMPDIR");
        String homeprop = System.getProperty("user.home", null);
        String tempprop = System.getProperty("java.io.tmpdir", null);
        List<String> targets = Arrays.asList(omerotmp, homeprop, tempprop);
        for (String target : targets) {
            if (target == null) continue;
            RandomAccessFile raftest = null;
            try {
                File testdir = new File(target);
                locktest = File.createTempFile("._omero_util_TempFileManager_lock_test", ".tmp", testdir);
                locktest.delete();
                raftest = new RandomAccessFile(locktest, "rw");
                FileLock channeltest = raftest.getChannel().tryLock();
                channeltest.release();
            }
            catch (Exception e) {
                if ("Operation not permitted".equals(e.getMessage()) || "Operation not supported".equals(e.getMessage())) {
                    log.debug(target + " does not support locking.");
                    continue;
                }
                log.warn("Invalid tmp dir: " + target, e);
                continue;
            }
            finally {
                if (locktest == null || raftest == null) continue;
                try {
                    raftest.close();
                    locktest.delete();
                }
                catch (Exception e) {
                    log.warn("Failed to close/delete lock file: " + locktest);
                }
                continue;
            }
            log.debug("Chose global tmpdir:  " + locktest.getParent());
            break;
        }
        if (locktest == null) {
            throw new RuntimeException("Could not find lockable tmp dir");
        }
        File omero = new File(locktest.getParentFile(), "omero");
        File tmp = new File(omero, "tmp");
        return tmp;
    }

    protected String username() {
        return System.getProperty("user.name");
    }

    protected String pid() {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        return pid;
    }

    protected boolean access(File dir) {
        return dir.canWrite();
    }

    protected boolean create(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
            return true;
        }
        return false;
    }

    public File getTempDir() {
        return this.dir;
    }

    public File createPath(String prefix, String suffix, boolean folder) throws IOException {
        File file = File.createTempFile(prefix, suffix, this.dir);
        if (folder) {
            file.delete();
            file.mkdirs();
            log.debug("Added folder " + file.getAbsolutePath());
        } else {
            log.debug("Added file " + file.getAbsolutePath());
        }
        return file;
    }

    public void removePath(File file) throws IOException {
        String d;
        String f = file.getAbsolutePath();
        if (!f.startsWith(d = this.dir.getAbsolutePath())) {
            throw new RuntimeException(d + " is not in " + f);
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                FileUtils.deleteDirectory(file);
                log.debug("Removed folder " + f);
            } else {
                file.delete();
                log.debug("Removed file " + f);
            }
        }
    }

    protected void cleanTempDir() throws IOException {
        log.debug("Removing tree: " + this.dir.getAbsolutePath());
        FileUtils.deleteDirectory(this.dir);
    }

    protected void cleanUserDir() throws IOException {
        log.debug("Cleaning user dir: " + this.userDir.getAbsolutePath());
        List<File> files = Arrays.asList(this.userDir.listFiles());
        String d = this.dir.getCanonicalPath();
        for (File file : files) {
            String f;
            block5: {
                f = file.getCanonicalPath();
                if (f.equals(d)) {
                    log.debug("Skipping self: " + d);
                    continue;
                }
                File lock = new File(file, ".lock");
                RandomAccessFile raf = new RandomAccessFile(lock, "rw");
                try {
                    FileLock fl = raf.getChannel().tryLock();
                    if (fl == null) {
                        System.out.println("Locked: " + f);
                    }
                    break block5;
                }
                catch (Exception e) {
                    System.out.println("Locked: " + f);
                }
                continue;
            }
            FileUtils.deleteDirectory(file);
            System.out.println("Deleted: " + f);
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return TempFileManager.create_path(prefix, suffix);
    }

    public static File create_path() throws IOException {
        return manager.createPath("omero", ".tmp", false);
    }

    public static File create_path(String prefix) throws IOException {
        return manager.createPath(prefix, ".tmp", false);
    }

    public static File create_path(String prefix, String suffix) throws IOException {
        return manager.createPath(prefix, suffix, false);
    }

    public static File create_path(String prefix, String suffix, boolean folder) throws IOException {
        return manager.createPath(prefix, suffix, folder);
    }

    public static void remove_path(File file) throws IOException {
        manager.removePath(file);
    }

    public static void gettempdir() {
        manager.getTempDir();
    }

    public static void main(String[] _args) throws IOException {
        List<String> args = Arrays.asList(_args);
        if (args.size() > 0) {
            if (args.contains("--debug") && !System.getenv().containsKey("DEBUG")) {
                ConsoleAppender console = new ConsoleAppender();
                console.setName("System.err");
                console.setTarget("System.err");
                console.setLayout(new SimpleLayout());
                console.activateOptions();
                Logger logger = Logger.getLogger("omero");
                logger.addAppender(console);
                logger.setLevel(Level.DEBUG);
                logger.addAppender(console);
            }
            if (args.contains("clean")) {
                manager.cleanUserDir();
                System.exit(0);
            } else if (args.contains("dir")) {
                System.out.println(manager.getTempDir().getAbsolutePath());
                System.exit(0);
            } else if (args.contains("lock")) {
                System.out.println("Locking " + manager.getTempDir().getAbsolutePath());
                System.out.println("Waiting on user input...");
                System.in.read();
                System.exit(0);
            }
        }
        System.err.println("Usage: TempFileManager clean");
        System.err.println("   or: TempFileManager dir");
        System.exit(2);
    }

    static {
        if (System.getenv().containsKey("DEBUG")) {
            ConsoleAppender console = new ConsoleAppender();
            console.setName("System.err");
            console.setTarget("System.err");
            console.setLayout(new SimpleLayout());
            console.activateOptions();
            Logger logger = Logger.getLogger("omero");
            logger.addAppender(console);
            logger.setLevel(Level.DEBUG);
            logger.addAppender(console);
        }
        manager = new TempFileManager();
    }
}

