/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application;

import application.ResourceMap;
import ch.randelshofer.quaqua.QuaquaManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.roydesign.app.Application;
import org.jhotdraw.application.AbstractDocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.OSXPaletteHandler;
import org.jhotdraw.application.action.AboutAction;
import org.jhotdraw.application.action.Actions;
import org.jhotdraw.application.action.ClearRecentFilesAction;
import org.jhotdraw.application.action.CloseAction;
import org.jhotdraw.application.action.CopyAction;
import org.jhotdraw.application.action.CutAction;
import org.jhotdraw.application.action.DeleteAction;
import org.jhotdraw.application.action.DuplicateAction;
import org.jhotdraw.application.action.ExitAction;
import org.jhotdraw.application.action.FocusAction;
import org.jhotdraw.application.action.MaximizeAction;
import org.jhotdraw.application.action.MinimizeAction;
import org.jhotdraw.application.action.NewAction;
import org.jhotdraw.application.action.OSXDropOnDockAction;
import org.jhotdraw.application.action.OSXTogglePaletteAction;
import org.jhotdraw.application.action.OpenAction;
import org.jhotdraw.application.action.PasteAction;
import org.jhotdraw.application.action.PrintAction;
import org.jhotdraw.application.action.RedoAction;
import org.jhotdraw.application.action.SaveAction;
import org.jhotdraw.application.action.SaveAsAction;
import org.jhotdraw.application.action.SelectAllAction;
import org.jhotdraw.application.action.UndoAction;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOSXApplication
extends AbstractDocumentOrientedApplication {
    private OSXPaletteHandler paletteHandler;
    private DocumentView currentView;
    private LinkedList<Action> paletteActions;

    @Override
    public void initialize(String[] args) {
        super.initialize(null);
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        this.initLookAndFeel();
        this.paletteHandler = new OSXPaletteHandler(this);
        this.createActionMap();
        this.paletteActions = new LinkedList();
        this.initPalettes(this.paletteActions);
        this.initScreenMenuBar();
    }

    public static void initAWT(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
    }

    @Override
    protected void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected ActionMap createActionMap() {
        ActionMap m = new ActionMap();
        m.put("Application.about", new AboutAction());
        m.put("Application.exit", new ExitAction());
        m.put("Application.dropOnDock", new OSXDropOnDockAction());
        m.put("File.new", new NewAction());
        m.put("File.open", new OpenAction());
        m.put("File.clearRecentFiles", new ClearRecentFilesAction());
        m.put("File.save", new SaveAction());
        m.put("File.saveAs", new SaveAsAction());
        m.put("File.print", new PrintAction());
        m.put("File.close", new CloseAction());
        m.put("Edit.undo", new UndoAction());
        m.put("Edit.redo", new RedoAction());
        m.put("Edit.cut", new CutAction());
        m.put("Edit.copy", new CopyAction());
        m.put("Edit.paste", new PasteAction());
        m.put("Edit.delete", new DeleteAction());
        m.put("Edit.duplicate", new DuplicateAction());
        m.put("Edit.selectAll", new SelectAllAction());
        m.put("View.maximize", new MaximizeAction());
        m.put("View.minimize", new MinimizeAction());
        return m;
    }

    @Override
    protected void initView(DocumentView v) {
        super.initView(v);
        v.putAction("View.focus", new FocusAction(v));
    }

    @Override
    public void addPalette(Window palette) {
        this.paletteHandler.addPalette(palette);
    }

    @Override
    public void removePalette(Window palette) {
        this.paletteHandler.removePalette(palette);
    }

    @Override
    public void show(final DocumentView p) {
        boolean moved;
        ResourceMap labels = this.getResourceMap();
        this.updateName(p);
        final JFrame f = new JFrame();
        f.setTitle(labels.getString("internalFrameTitle", new Object[]{labels.getString("Application.title", new Object[0]), p.getName()}));
        f.setDefaultCloseOperation(0);
        f.setPreferredSize(new Dimension(400, 400));
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        PreferencesUtil.installFramePrefsHandler(prefs, "documentView", f);
        Point loc = f.getLocation();
        block0: do {
            moved = false;
            for (DocumentView aProject : this.getViews()) {
                if (aProject == p || !SwingUtilities.getWindowAncestor(aProject.getComponent()).getLocation().equals(loc)) continue;
                loc.x += 22;
                loc.y += 22;
                moved = true;
                continue block0;
            }
        } while (moved);
        f.setLocation(loc);
        this.paletteHandler.add(f, p);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AbstractOSXApplication.this.setCurrentView(p);
                AbstractOSXApplication.this.getAction("File.close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
            }
        });
        p.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals("hasUnsavedChanges")) {
                    f.getRootPane().putClientProperty("windowModified", new Boolean(p.isModified()));
                } else if (name.equals("file")) {
                    f.setTitle(p.getFile() == null ? "Unnamed" : p.getFile().getName());
                }
            }
        });
        f.setJMenuBar(this.createMenuBar(p));
        f.getContentPane().add(p.getComponent());
        f.setVisible(true);
    }

    @Override
    public void hide(DocumentView p) {
        JFrame f = (JFrame)SwingUtilities.getWindowAncestor(p.getComponent());
        f.setVisible(false);
        f.remove(p.getComponent());
        this.paletteHandler.remove(f, p);
        f.dispose();
    }

    protected JMenuBar createMenuBar(DocumentView p) {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu(p));
        for (JMenu mm : this.createMenus(p)) {
            mb.add(mm);
        }
        mb.add(this.createWindowMenu(p));
        return mb;
    }

    @Override
    protected JMenu createWindowMenu(final DocumentView p) {
        JMenu m;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.application.Labels");
        JMenuBar mb = new JMenuBar();
        final JMenu windowMenu = m = new JMenu();
        labels.configureMenu(m, "window");
        JMenuItem mi = m.add(this.getAction("View.minimize"));
        mi.setIcon(null);
        mi = m.add(this.getAction("View.maximize"));
        mi.setIcon(null);
        m.addSeparator();
        for (DocumentView pr : this.getViews()) {
            if (pr.getAction("View.focus") == null) continue;
            windowMenu.add(pr.getAction("View.focus"));
        }
        if (this.paletteActions.size() > 0) {
            m.addSeparator();
            for (Action a : this.paletteActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                cbmi.setIcon(null);
                m.add(cbmi);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "viewCount" || name == "paletteCount") {
                    if (p == null || AbstractOSXApplication.this.getViews().contains(p)) {
                        JMenu m = windowMenu;
                        m.removeAll();
                        m.add(AbstractOSXApplication.this.getAction("View.minimize"));
                        m.add(AbstractOSXApplication.this.getAction("View.maximize"));
                        m.addSeparator();
                        for (DocumentView pr : AbstractOSXApplication.this.getViews()) {
                            if (pr.getAction("View.focus") == null) continue;
                            m.add(pr.getAction("View.focus"));
                        }
                        if (AbstractOSXApplication.this.paletteActions.size() > 0) {
                            m.addSeparator();
                            for (Action a : AbstractOSXApplication.this.paletteActions) {
                                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                                Actions.configureJCheckBoxMenuItem(cbmi, a);
                                cbmi.setIcon(null);
                                m.add(cbmi);
                            }
                        }
                    } else {
                        AbstractOSXApplication.this.removePropertyChangeListener(this);
                    }
                }
            }
        });
        return m;
    }

    @Override
    protected JMenu createFileMenu(DocumentView p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.application.Labels");
        JMenu m = new JMenu();
        labels.configureMenu(m, "file");
        JMenuItem mi = m.add(this.getAction("File.new"));
        mi.setIcon(null);
        mi = m.add(this.getAction("File.open"));
        mi.setIcon(null);
        final JMenu openRecentMenu = new JMenu();
        labels.configureMenu(openRecentMenu, "openRecent");
        openRecentMenu.setIcon(null);
        openRecentMenu.add(this.getAction("File.clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        mi = m.add(this.getAction("File.close"));
        mi.setIcon(null);
        mi = m.add(this.getAction("File.save"));
        mi.setIcon(null);
        mi = m.add(this.getAction("File.saveAs"));
        mi.setIcon(null);
        if (this.getAction("File.export") != null) {
            mi = m.add(this.getAction("File.export"));
            mi.setIcon(null);
        }
        if (this.getAction("File.print") != null) {
            m.addSeparator();
            mi = m.add(this.getAction("File.print"));
            mi.setIcon(null);
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "recentFiles") {
                    AbstractOSXApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return m;
    }

    @Override
    public DocumentView getCurrentView() {
        return this.currentView;
    }

    public void setCurrentView(DocumentView newValue) {
        DocumentView oldValue = this.currentView;
        this.currentView = newValue;
        this.firePropertyChange("currentView", oldValue, newValue);
    }

    protected void initScreenMenuBar() {
        Application mrjapp = Application.getInstance();
        mrjapp.setFramelessJMenuBar(this.createMenuBar(null));
        this.paletteHandler.add(SwingUtilities.getWindowAncestor(mrjapp.getFramelessJMenuBar()), null);
        mrjapp.getAboutJMenuItem().setAction(this.getAction("Application.about"));
        mrjapp.getQuitJMenuItem().setAction(this.getAction("Application.exit"));
        mrjapp.addOpenDocumentListener((ActionListener)this.getAction("Application.dropOnDock"));
    }

    protected void initPalettes(final LinkedList<Action> paletteActions) {
        SwingUtilities.invokeLater(new Worker(){

            public Object construct() {
                LinkedList<JFrame> palettes = new LinkedList<JFrame>();
                LinkedList<JToolBar> toolBars = new LinkedList<JToolBar>(AbstractOSXApplication.this.createToolBars(null));
                Preferences prefs = Preferences.userNodeForPackage(this.getClass());
                int i = 0;
                int x = 0;
                for (JToolBar tb : toolBars) {
                    ++i;
                    tb.setFloatable(false);
                    tb.setOrientation(1);
                    tb.setFocusable(false);
                    JFrame d = new JFrame();
                    d.setFocusable(false);
                    d.setResizable(false);
                    d.getContentPane().setLayout(new BorderLayout());
                    d.getContentPane().add((Component)tb, "Center");
                    d.setAlwaysOnTop(true);
                    d.setUndecorated(true);
                    d.getRootPane().setWindowDecorationStyle(1);
                    d.getRootPane().setFont(new Font("Lucida Grande", 0, 11));
                    d.getRootPane().putClientProperty("Quaqua.RootPane.isVertical", Boolean.FALSE);
                    d.getRootPane().putClientProperty("Quaqua.RootPane.isPalette", Boolean.TRUE);
                    d.setJMenuBar(AbstractOSXApplication.this.createMenuBar(null));
                    d.pack();
                    d.setFocusableWindowState(false);
                    PreferencesUtil.installPalettePrefsHandler(prefs, "toolbar." + i, d, x);
                    x += d.getWidth();
                    paletteActions.add(new OSXTogglePaletteAction(d, tb.getName()));
                    palettes.add(d);
                }
                return palettes;
            }

            public void finished(Object result) {
                LinkedList palettes = (LinkedList)result;
                if (palettes != null) {
                    for (JFrame p : palettes) {
                        AbstractOSXApplication.this.addPalette(p);
                    }
                    AbstractOSXApplication.this.firePropertyChange("paletteCount", 0, palettes.size());
                }
            }
        });
    }

    @Override
    public boolean isEditorShared() {
        return true;
    }

    @Override
    public Component getComponent() {
        return null;
    }
}

