/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.geom.BezierPath;

class BezierNodeEdit
extends AbstractUndoableEdit {
    private BezierFigure owner;
    private int index;
    private BezierPath.Node oldValue;
    private BezierPath.Node newValue;

    public BezierNodeEdit(BezierFigure owner, int index, BezierPath.Node oldValue, BezierPath.Node newValue) {
        this.owner = owner;
        this.index = index;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getPresentationName() {
        return "Punkt verschieben";
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.owner.willChange();
        this.owner.setNode(this.index, this.newValue);
        this.owner.changed();
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.owner.willChange();
        this.owner.setNode(this.index, this.oldValue);
        this.owner.changed();
    }

    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof BezierNodeEdit) {
            BezierNodeEdit that = (BezierNodeEdit)anEdit;
            if (that.owner == this.owner && that.index == this.index) {
                this.newValue = that.newValue;
                that.die();
                return true;
            }
        }
        return false;
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        if (anEdit instanceof BezierNodeEdit) {
            BezierNodeEdit that = (BezierNodeEdit)anEdit;
            if (that.owner == this.owner && that.index == this.index) {
                that.oldValue = this.oldValue;
                this.die();
                return true;
            }
        }
        return false;
    }
}

