/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidirectionalConnectionTool
extends AbstractTool
implements FigureListener {
    private Map<AttributeKey, Object> attributes;
    private Connector startConnector;
    private Connector endConnector;
    private Connector targetConnector;
    private Figure target;
    private ConnectionFigure connection;
    private int splitPoint;
    private ConnectionFigure editedConnection;
    private Figure createdFigure;
    private ConnectionFigure prototype;

    public BidirectionalConnectionTool(ConnectionFigure prototype) {
        this.prototype = prototype;
    }

    public BidirectionalConnectionTool(ConnectionFigure prototype, Map<AttributeKey, Object> attributes) {
        this.prototype = prototype;
        this.attributes = attributes;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.trackConnectors(evt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        Point2D.Double ap = this.viewToDrawing(this.anchor);
        this.setTargetFigure(this.findConnectionStart(ap, this.getDrawing()));
        if (this.getTargetFigure() != null) {
            this.setStartConnector(this.findConnector(ap, this.target, this.prototype));
            if (this.getStartConnector() != null && this.prototype.canConnect(this.getTargetConnector())) {
                Point2D.Double p = this.getStartConnector().getAnchor();
                this.setConnection(this.createFigure());
                ConnectionFigure cf = this.getConnection();
                cf.setBounds(p, p);
                cf.addFigureListener(this);
                this.setCreatedFigure(cf);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point2D.Double p = this.viewToDrawing(new Point(e.getX(), e.getY()));
        if (this.getConnection() != null) {
            this.trackConnectors(e);
            if (this.getTargetConnector() != null) {
                p = this.getTargetConnector().getAnchor();
            }
            this.getConnection().setEndPoint(p);
        } else if (this.editedConnection != null) {
            this.editedConnection.setPoint(this.splitPoint, p);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Figure c = null;
        Point2D.Double p = this.viewToDrawing(new Point(e.getX(), e.getY()));
        if (this.getStartConnector() != null) {
            c = this.findTarget(p, this.getDrawing());
        }
        if (c != null) {
            this.setEndConnector(this.findConnector(p, c, this.prototype));
            if (this.getEndConnector() != null) {
                CompositeEdit creationEdit = new CompositeEdit("Verbindung erstellen");
                this.getDrawing().fireUndoableEditHappened(creationEdit);
                this.getDrawing().add(this.getConnection());
                if (this.getConnection().canConnect(this.getStartConnector(), this.getEndConnector())) {
                    this.getConnection().setStartConnector(this.getStartConnector());
                    this.getConnection().setEndConnector(this.getEndConnector());
                } else {
                    this.getConnection().setStartConnector(this.getEndConnector());
                    this.getConnection().setEndConnector(this.getStartConnector());
                }
                this.getConnection().updateConnection();
                this.getConnection().removeFigureListener(this);
                this.getDrawing().fireUndoableEditHappened(creationEdit);
            }
        } else if (this.getConnection() != null) {
            this.getDrawing().remove(this.getConnection());
        }
        this.setConnection(null);
        this.setStartConnector(null);
        this.setEndConnector(null);
        this.setCreatedFigure(null);
        this.fireToolDone();
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.getView().clearSelection();
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
    }

    protected ConnectionFigure createFigure() {
        ConnectionFigure f = (ConnectionFigure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                f.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected Figure findSource(Point2D.Double p, Drawing drawing) {
        return this.findConnectableFigure(p, drawing);
    }

    protected Figure findTarget(Point2D.Double p, Drawing drawing) {
        Figure target = this.findConnectableFigure(p, drawing);
        Connector targetConnector = target == null ? null : target.findConnector(p, this.prototype);
        Connector startConnector = this.getStartConnector();
        if (targetConnector != null && this.getConnection() != null && target.canConnect() && (this.getConnection().canConnect(startConnector, targetConnector) || this.getConnection().canConnect(targetConnector, startConnector))) {
            return target;
        }
        return null;
    }

    protected ConnectionFigure findConnection(Point2D.Double p, Drawing drawing) {
        for (Figure f : drawing.getFiguresFrontToBack()) {
            Figure fInside = f.findFigureInside(p);
            if (fInside == null || !(fInside instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)fInside;
        }
        return null;
    }

    private void setConnection(ConnectionFigure newConnection) {
        this.connection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.connection;
    }

    protected void trackConnectors(MouseEvent e) {
        Point2D.Double p = this.viewToDrawing(new Point(e.getX(), e.getY()));
        Figure c = null;
        c = this.getStartConnector() == null ? this.findSource(p, this.getDrawing()) : this.findTarget(p, this.getDrawing());
        Connector cc = null;
        if (c != null) {
            cc = this.findConnector(p, c, this.prototype);
        }
        if (cc != this.getTargetConnector()) {
            this.setTargetConnector(cc);
        }
        if (c != this.getTargetFigure()) {
            this.setTargetFigure(c);
            Connector targetConnector = this.getTargetConnector();
        }
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.createdFigure != null) {
            this.createdFigure.draw(g);
        }
    }

    private Connector findConnector(Point2D.Double p, Figure target, ConnectionFigure f) {
        return target.findConnector(p, f);
    }

    protected Figure findConnectionStart(Point2D.Double p, Drawing drawing) {
        Figure target = this.findConnectableFigure(p, drawing);
        if (target != null && target.canConnect()) {
            return target;
        }
        return null;
    }

    private Figure findConnectableFigure(Point2D.Double p, Drawing drawing) {
        return drawing.findFigureExcept(p, this.createdFigure);
    }

    private void setStartConnector(Connector newStartConnector) {
        this.startConnector = newStartConnector;
    }

    protected Connector getStartConnector() {
        return this.startConnector;
    }

    private void setEndConnector(Connector newEndConnector) {
        this.endConnector = newEndConnector;
    }

    protected Connector getEndConnector() {
        return this.endConnector;
    }

    private void setTargetConnector(Connector newTargetConnector) {
        this.targetConnector = newTargetConnector;
    }

    protected Connector getTargetConnector() {
        return this.targetConnector;
    }

    private void setTargetFigure(Figure newTarget) {
        this.target = newTarget;
    }

    protected Figure getTargetFigure() {
        return this.target;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    private void setCreatedFigure(Figure newCreatedFigure) {
        this.createdFigure = newCreatedFigure;
    }

    @Override
    public void figureAreaInvalidated(FigureEvent evt) {
        this.fireAreaInvalidated(evt.getInvalidatedArea());
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureChanged(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
    }

    @Override
    public void figureAttributeChanged(FigureEvent e) {
    }

    @Override
    public void figureHandlesChanged(FigureEvent e) {
    }
}

