/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.DecoratedFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.RelativeLocator;

public class RelativeDecoratorLocator
extends RelativeLocator {
    private boolean isQuadratic;

    public RelativeDecoratorLocator() {
    }

    public RelativeDecoratorLocator(double relativeX, double relativeY) {
        super(relativeX, relativeY);
    }

    public RelativeDecoratorLocator(double relativeX, double relativeY, boolean isQuadratic) {
        super(relativeX, relativeY);
        this.isQuadratic = isQuadratic;
    }

    public Point2D.Double locate(Figure owner) {
        Rectangle2D.Double r = owner instanceof DecoratedFigure && ((DecoratedFigure)((Object)owner)).getDecorator() != null ? ((DecoratedFigure)((Object)owner)).getDecorator().getBounds() : owner.getBounds();
        if (this.isQuadratic) {
            double side = Math.max(r.width, r.height);
            r.x -= (side - r.width) / 2.0;
            r.y -= (side - r.height) / 2.0;
            r.width = r.height = side;
        }
        return new Point2D.Double(r.x + r.width * this.relativeX, r.y + r.height * this.relativeY);
    }

    public static Locator east() {
        return new RelativeDecoratorLocator(1.0, 0.5);
    }

    public static Locator north() {
        return new RelativeDecoratorLocator(0.5, 0.0);
    }

    public static Locator west() {
        return new RelativeDecoratorLocator(0.0, 0.5);
    }

    public static Locator northEast() {
        return new RelativeDecoratorLocator(1.0, 0.0);
    }

    public static Locator northWest() {
        return new RelativeDecoratorLocator(0.0, 0.0);
    }

    public static Locator south() {
        return new RelativeDecoratorLocator(0.5, 1.0);
    }

    public static Locator southEast() {
        return new RelativeDecoratorLocator(1.0, 1.0);
    }

    public static Locator southWest() {
        return new RelativeDecoratorLocator(0.0, 1.0);
    }

    public static Locator center() {
        return new RelativeDecoratorLocator(0.5, 0.5);
    }
}

