/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextOverflowHandle
extends AbstractHandle {
    public TextOverflowHandle(TextHolderFigure owner) {
        super(owner);
    }

    public TextHolderFigure getOwner() {
        return (TextHolderFigure)super.getOwner();
    }

    public void draw(Graphics2D g) {
        if (this.getOwner().isTextOverflow()) {
            g.setColor(Color.RED);
            Rectangle r = this.basicGetBounds();
            g.draw(r);
            g.drawLine(r.x, r.y, r.x + r.width, r.y + r.height);
            g.drawLine(r.x + r.width, r.y, r.x, r.y + r.height);
        }
    }

    protected Rectangle basicGetBounds() {
        Rectangle2D.Double b = this.getOwner().getBounds();
        Point2D.Double p = new Point2D.Double(b.x + b.width, b.y + b.height);
        if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
            AttributeKeys.TRANSFORM.get(this.getOwner()).transform(p, p);
        }
        Rectangle r = new Rectangle(this.view.drawingToView(p));
        r.x -= 6;
        r.y -= 6;
        r.height = 6;
        r.width = 6;
        return r;
    }

    public void trackStart(Point anchor, int modifiersEx) {
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    public String getToolTipText(Point p) {
        return this.getOwner().isTextOverflow() ? ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels").getString("textOverflowHandle.tip") : null;
    }
}

