/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.helpers;

import java.util.Calendar;

public class MiscUtils {
    public static final String NEWLINE = System.getProperty("line.separator");

    public static StringBuilder escapeStringForCsv(String string, StringBuilder toAppend) {
        toAppend.append('\"');
        int lastQuoteIndex = 0;
        for (int i = 0; i < string.length(); ++i) {
            char charAtIndex = string.charAt(i);
            if ('\"' != charAtIndex) continue;
            toAppend.append(string.substring(lastQuoteIndex, i)).append("\"\"");
            lastQuoteIndex = i + 1;
        }
        toAppend.append(string.substring(lastQuoteIndex));
        return toAppend.append('\"');
    }

    public static StringBuilder padIntToTwoDigits(int i, StringBuilder toAppend) {
        if (i < 10) {
            toAppend.append("0");
        }
        return toAppend.append(i);
    }

    public static String formatDateIso8601(long timeInMillis) {
        StringBuilder retVal = new StringBuilder(19);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeInMillis);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        retVal.append(year).append('-');
        MiscUtils.padIntToTwoDigits(month + 1, retVal).append('-');
        MiscUtils.padIntToTwoDigits(day, retVal).append(' ');
        MiscUtils.padIntToTwoDigits(hour, retVal).append(':');
        MiscUtils.padIntToTwoDigits(minute, retVal).append(':');
        return MiscUtils.padIntToTwoDigits(second, retVal).toString();
    }
}

