/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import ucar.grib.GribResourceReader;
import ucar.grib.NotSupportedException;
import ucar.grib.Parameter;
import ucar.grib.grib1.SmartStringArray;

public final class GribPDSParamTable {
    private int center_id;
    private int subcenter_id;
    private int table_number;
    private String filename = null;
    private String path = null;
    private HashMap parameters = null;
    private static GribPDSParamTable[] paramTables = null;
    private static final String RESOURCE_PATH = "resources/grib/tables";
    private static final String TABLE_LIST = "tablelookup.lst";
    private static Hashtable tableMap = new Hashtable();

    private GribPDSParamTable() {
    }

    public static void addParameterUserLookup(InputStream is) throws IOException {
        ArrayList tables = new ArrayList();
        if (!GribPDSParamTable.readTableEntries(is, null, tables)) {
            return;
        }
        GribPDSParamTable[] tmp = new GribPDSParamTable[paramTables.length + tables.size()];
        for (int idx = 0; idx < paramTables.length + tables.size(); ++idx) {
            tmp[idx] = idx < tables.size() ? (GribPDSParamTable)tables.get(idx) : paramTables[idx - tables.size()];
        }
        paramTables = tmp;
    }

    public static void addParameterUserLookup(String userGribTabList) throws IOException {
        ArrayList tables = new ArrayList();
        if (!GribPDSParamTable.readTableEntries(userGribTabList, tables)) {
            return;
        }
        GribPDSParamTable[] tmp = new GribPDSParamTable[paramTables.length + tables.size()];
        for (int idx = 0; idx < paramTables.length + tables.size(); ++idx) {
            tmp[idx] = idx < tables.size() ? (GribPDSParamTable)tables.get(idx) : paramTables[idx - tables.size()];
        }
        paramTables = tmp;
    }

    private static void initFromJAR(ArrayList aTables) throws IOException {
        String resourceName = "resources/grib/tables/tablelookup.lst";
        GribPDSParamTable.readTableEntries(resourceName, aTables);
    }

    private static InputStream getInputStream(String resourceName) {
        return GribResourceReader.getInputStream(resourceName);
    }

    private static boolean readTableEntries(String aTableList, ArrayList aTables) throws IOException {
        InputStream inputStream = GribPDSParamTable.getInputStream(aTableList);
        if (inputStream == null) {
            return false;
        }
        return GribPDSParamTable.readTableEntries(inputStream, aTableList, aTables);
    }

    private static boolean readTableEntries(InputStream is, String aTableList, ArrayList aTables) throws IOException {
        String line;
        if (is == null) {
            return false;
        }
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            GribPDSParamTable table = new GribPDSParamTable();
            String[] tableDefArr = SmartStringArray.split(":", line);
            table.center_id = Integer.parseInt(tableDefArr[0].trim());
            table.subcenter_id = Integer.parseInt(tableDefArr[1].trim());
            table.table_number = Integer.parseInt(tableDefArr[2].trim());
            table.filename = tableDefArr[3].trim();
            if (table.filename.startsWith("/") || table.filename.startsWith("\\") || table.filename.startsWith("file:") || table.filename.startsWith("http://")) {
                table.path = table.filename;
            } else if (aTableList != null) {
                table.path = GribResourceReader.getFileRoot(aTableList);
                table.path = table.path.equals(aTableList) ? table.filename : table.path + "/" + table.filename;
                table.path = table.path.replace('\\', '/');
            }
            aTables.add(table);
        }
        is.close();
        return true;
    }

    public static GribPDSParamTable getParameterTable(int center, int subcenter, int number) throws NotSupportedException {
        String key = center + "_" + subcenter + "_" + number;
        GribPDSParamTable table = (GribPDSParamTable)tableMap.get(key);
        if (table != null) {
            return table;
        }
        table = GribPDSParamTable.findParameterTable(center, subcenter, number, true);
        if (table == null) {
            throw new NotSupportedException("Could not find a table entry for GRIB file with center: " + center + " subCenter: " + subcenter + " number: " + number);
        }
        tableMap.put(key, table);
        return table;
    }

    private static GribPDSParamTable findParameterTable(int center, int subcenter, int number, boolean firstTry) {
        for (int i = 0; i < paramTables.length; ++i) {
            GribPDSParamTable table = paramTables[i];
            if (center != table.center_id || table.subcenter_id != -1 && subcenter != table.subcenter_id || number != table.table_number) continue;
            if (table.parameters == null) {
                if (!firstTry) {
                    System.err.println("Using default table:" + table.path + " (" + table.center_id + ":" + table.subcenter_id + ":" + table.table_number + ")");
                }
                table.parameters = new HashMap();
                table.readParameterTable();
                if (table.parameters.size() == 0) continue;
                for (int j = 0; j < paramTables.length; ++j) {
                    GribPDSParamTable tab = paramTables[j];
                    if (!tab.path.equals(table.path)) continue;
                    tab.parameters = table.parameters;
                }
            }
            return table;
        }
        if (number != -1) {
            return GribPDSParamTable.findParameterTable(center, subcenter, -1, false);
        }
        if (subcenter != -1) {
            System.err.println("Could not find table for center:" + center + " subcenter:" + subcenter + " number:" + number);
            return GribPDSParamTable.findParameterTable(center, -1, -1, false);
        }
        if (center != -1) {
            return GribPDSParamTable.findParameterTable(-1, -1, -1, false);
        }
        return null;
    }

    public final Parameter getParameter(int aPar) {
        if (this.parameters.containsKey(Integer.toString(aPar))) {
            return (Parameter)this.parameters.get(Integer.toString(aPar));
        }
        return new Parameter(aPar, "Unknown", "Unknown", "Unknown");
    }

    private void readParameterTable() {
        try {
            InputStream is;
            if (this.path != null) {
                is = GribPDSParamTable.getInputStream(this.path);
                if (is == null) {
                    return;
                }
            } else {
                return;
            }
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            String[] tableDefArr = SmartStringArray.split(":", line);
            while ((line = br.readLine()) != null && line.length() != 0) {
                Parameter parameter = new Parameter();
                tableDefArr = SmartStringArray.split(":", line);
                parameter.setNumber(Integer.parseInt(tableDefArr[0].trim()));
                parameter.setName(tableDefArr[1].trim());
                if (tableDefArr[2].indexOf(91) == -1) {
                    parameter.setDescription(tableDefArr[2].trim());
                    parameter.setUnit(tableDefArr[2].trim());
                } else {
                    String[] arr2 = SmartStringArray.split("[", tableDefArr[2]);
                    parameter.setDescription(arr2[0].trim());
                    parameter.setUnit(arr2[1].substring(0, arr2[1].lastIndexOf(93)).trim());
                }
                this.parameters.put(Integer.toString(parameter.getNumber()), parameter);
            }
        }
        catch (IOException ioError) {
            System.err.println("An error occurred in GribPDSParamTable while trying to open the parameter table " + this.filename + " : " + ioError);
        }
    }

    public final String toString() {
        String str = "-1:" + this.center_id + ":" + this.subcenter_id + ":" + this.table_number + "\n";
        return str;
    }

    static {
        try {
            ArrayList tables = new ArrayList();
            GribPDSParamTable.initFromJAR(tables);
            paramTables = tables.toArray(new GribPDSParamTable[tables.size()]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

